#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"

#if 0
____CAudioWin___()
#endif

class CAudioWin : public CWindow
{
private:
	int nMTSCount;
public:
	CAudioWin(SWinEventMsg event):CWindow(event)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_banner_mute_back);
		rect.h = DST_GetImageHeight(newcon2_gui_banner_mute_back);
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = DST_GetScreenHeight()*9/10 - rect.h;

		SetTimeOut(3);
	}
	virtual ~CAudioWin()
	{
	}
	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
		}
	}
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			//case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				Close();
				break;
			default:
				break;
		}
	}
	
	DS_U16* GetString(int nPos)
	{
		switch (nPos)
		{
			case  0: return pz_MTS_Main[OSD_Lang];
			case  1: return pz_MTS_Sub[OSD_Lang];
		}
		return 0;
	}		
	virtual void Show()
	{

		nMTSCount = 2;
		DrawImage(0, 0, newcon2_gui_banner_mute_back);
		setFontStyle(25, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);
		DrawTextUni(0, 0, rect.w, rect.h, GetString(DST_UI_GetMTS()), &font);
		
		RegisterKey(VK_AUDIO, true);
		RegisterKey(VK_CANCEL, true);
	}

	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_AUDIO:
				DST_UI_SetMTS((DST_UI_GetMTS() == nMTSCount - 1) ? 0 : DST_UI_GetMTS()+1);
				Show();

				break;
			case VK_CANCEL:
				Close();
				break;
		}
	}
};

void DST_CreateAudioWindow(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CAudioWin(event));
}


class CClosedCaptionWin : public CWindow
{
private:
	int nCCPos;
public:
	CClosedCaptionWin(SWinEventMsg event):CWindow(event)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_banner_mute_back);
		rect.h = DST_GetImageHeight(newcon2_gui_banner_mute_back);
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = DST_GetScreenHeight()*9/10 - rect.h;

		SetTimeOut(3);
		nCCPos = 0;

	}
	virtual ~CClosedCaptionWin()
	{
	}
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
//			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				Close();
				break;
			default:
				break;
		}
	}

	DS_U16* GetString(int nPos)
	{
		switch (nPos)
		{
			case  0: return pz_Off[OSD_Lang];
			case  1: return pz_Language1[OSD_Lang];
			case  2: return pz_Language2[OSD_Lang];
			default : return 0;
		}
	}
	
	virtual void Show()
	{
		nCCPos = DST_EEPROM_GetCC();

		DrawImage(0, 0, newcon2_gui_banner_mute_back);
		setFontStyle(25, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);
		DrawTextUni(0, 0, rect.w, rect.h, GetString(nCCPos), &font);
		
		RegisterKey(VK_CC, true);
		RegisterKey(VK_CANCEL, true);
	}

	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_CC:
				nCCPos = (nCCPos == 3 - 1) ? 0 : nCCPos+1;
				DST_UI_SetCloseCaption(nCCPos);
				Show();
				break;
			case VK_CANCEL:
				Close();
				break;
		}
	}
};

void DST_CreateClosedCaptionHotWindow(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CClosedCaptionWin(event));
}


class CDisplayModeWin : public CWindow
{
private:
	int nDMPos;
public:
	CDisplayModeWin(SWinEventMsg event):CWindow(event)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_banner_mute_back);
		rect.h = DST_GetImageHeight(newcon2_gui_banner_mute_back);
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = DST_GetScreenHeight()*9/10 - rect.h;

		SetTimeOut(3);
		nDMPos = 0;

	}
	virtual ~CDisplayModeWin()
	{
	}
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
//			case WIN_DISPLAY_MODE_HOT:	
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				Close();
				break;
			default:
				break;
		}
	}

	DS_U16* GetString(int nPos)
	{
		switch (nPos)
		{
			case DISPLAY_MODE_WIDE: return pz_Wide[OSD_Lang]; break;
			case DISPLAY_MODE_NORMAL: return pz_Normal[OSD_Lang]; break;
			case DISPLAY_MODE_ZOOM: return pz_Zoom[OSD_Lang]; break;
			default : return 0;
		}
	}
	
	virtual void Show()
	{
		nDMPos = DST_UI_GetAspect();

		DrawImage(0, 0, newcon2_gui_banner_mute_back);
		setFontStyle(25, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);
		DrawTextUni(0, 0, rect.w, rect.h, GetString(nDMPos), &font);
		
		RegisterKey(VK_ZOOM, true);
		RegisterKey(VK_CANCEL, true);
	}

	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_ZOOM:
				DST_UI_SetAspect(DST_UI_GetAspect() < 2 ? DST_UI_GetAspect()+1 : 0);
				Show();
				break;
			case VK_CANCEL:
				Close();
				break;
		}
	}
};

void DST_CreateDisplayModeWindow(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CDisplayModeWin(event));
}


