#include "DST_Window.h"
#include "DST_WinManager.h"
#include "DST_CommonAPI.h"
#include "DST_DataStrings.h"
#include "DST_UserInterface.h"
#include "DST_CCTask.h"
#include "DST_ChannelTune.h"
#include "DST_DB.h"
#include "DST_OSDImage.h"
#include "DST_SignalMonitor.h"

#define ICON_DEFAULT 0
#define ICON_CURSOR 1
#define ICON_SELECT 2

char* DST_GetAppShortVersion();

struct MAIN_MENU
{
	MainMenuLists menu;
	bool bEnable;
};

struct CH_SUB_MENU
{
	ChannelSubMenuLists menu;
	bool bEnable;
};

struct SETUP_SUB_MENU
{
	SetupSubMenuLists menu;
	bool bEnable;
};

struct PROGRAM_SUB_MENU
{
	ProgramSubMenuLists menu;
	bool bEnable;
};

struct FUNCTION_SUB_MENU
{
	FunctionSubMenuLists menu;
	bool bEnable;
};


static MAIN_MENU tv_menu[] = {
	{	MN_CHANNEL,	true	},
	{	MN_SETUP, true	},
	{	MN_PROGRAM, true	},
	{	MN_FUNCTION,	true	},
	{ MN_MAX_NUM, false}
};

static CH_SUB_MENU ch_sub_menu[] = {
	{	CH_SUB_INPUT,	false	},
	{	CH_SUB_AUTO_SCAN,	true	},
	{	CH_SUB_MANUAL_SCAN,	true	},
	{	CH_SUB_CHANNEL_EDIT, true	},
	{	CH_SUB_SIGNAL_METER,	true	},
	{ CH_SUB_MAX_NUM, false}
};

static SETUP_SUB_MENU setup_sub_menu[] = {
	{	SETUP_SUB_AV_DISPLAY_MODE,	true	},
	{	SETUP_SUB_AV_AUDIO_PREF, true	},
	{	SETUP_SUB_AV_VI,	true	},
	{	SETUP_SUB_CC_DISPLAY,	true	},
	{ SETUP_SUB_MAX_NUM, false}
};

static PROGRAM_SUB_MENU program_sub_menu[] = {
	{	PROGRAM_INFORMATION,	false	},
	{ PROGRAM_SUB_MAX_NUM, false}
};

static FUNCTION_SUB_MENU function_sub_menu[] = {
	{	FUNCTION_SUB_SLEEP_TIMER,	true	},
	{	FUNCTION_SUB_AV_PREFERRED_CONN, true	},
	{	FUNCTION_SUB_FACTORY_RESET,	true	},
	{ FUNCTION_SUB_MAX_NUM, false}
};


class CMainMenu: public CWindow
{
private:
	DS_U16 g_nPos;
	DS_U16 g_nTop;
	DS_U16 mainSelect;
	DS_U16 mainListNum;
	DS_U16 mainItemNum;
	DS_U16 userSavedValue;
	int  MenuIdx;
public:
	CMainMenu(SWinEventMsg event):CWindow(event)
	{
		InitValues();
		setSize();
		DoFocus(true);
		SetTimeOut(30);
	}
	virtual ~CMainMenu()
	{
	}
	
	void InitValues(void)
	{
		DST_g_Focus_menu = 0;
		MenuIdx = 0;/*DST_UI_GetSource();*/
		mainItemNum = GetCount();
		g_nTop = MenuTop[MenuIdx];
		g_nPos = MenuPos[MenuIdx];
		mainSelect = MenuSelect[MenuIdx];
		mainListNum = 4;
		if (mainItemNum < mainListNum) mainListNum = mainItemNum;
		
		
	}

	int GetCount()
	{
		int MenuCount = 0;
		
		for (int i = 0; i < 20; i++)
		{
			if (tv_menu[i].menu == MN_MAX_NUM) break;
			if (tv_menu[i].bEnable) MenuCount++;
		}
		return MenuCount;
	}
	
	MainMenuLists Index2MenuLists(int index)
	{
		int nPos = -1;
		MainMenuLists menu = MN_CHANNEL;
		if (index < mainItemNum)
		{
			for (int i = 0; i < 20; i++)
			{
				if (tv_menu[i].bEnable) nPos++;
				if (nPos != index) continue;
				menu = tv_menu[i].menu;
				break;
			}
		}
		return menu;
	}
	

	void setSize(void)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_main_back_720x480_1);
		rect.h = DST_GetImageHeight(newcon2_gui_main_back_720x480_1);
		rect.x = (DST_GetScreenWidth() - DST_GetImageWidth(newcon2_gui_main_back_720x480))/2;
		rect.y = (DST_GetScreenHeight() - rect.h)/2;
	}

	virtual void Focus(bool bVal)
	{
		RegisterKey(VK_MENU, bVal);
		RegisterKey(VK_CANCEL, bVal);
		RegisterKey(VK_LEFT, bVal);
		RegisterKey(VK_RIGHT, bVal);
		RegisterKey(VK_UP, bVal);
		RegisterKey(VK_DN, bVal);
		RegisterKey(VK_OK, bVal);
		RegisterKey(VK_CH_UP, bVal);
		RegisterKey(VK_CH_DN, bVal);
		RegisterKey(VK_PREV, bVal);
		RegisterKey(VK_PREV_MENU, true);
	}
	
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			//case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_POWER_DOWN_CAUTION:
			//case WIN_MAIN_MENU:
			//case WIN_SUB_MENU_2DEPTH:
			//case WIN_SUB_MENU_3DEPTH:
			//case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
//			case WIN_PASSWD_CHANGE:
//			case WIN_PASSWD_CHECK:
//			case WIN_PASSWD_CONFIRM:
			case WIN_AGE_RATING:
				Close();
				break;
			default:
				break;
		}
	}
	virtual void Show(void)
	{
		SetTimeOut(30);
		DrawImage(0 , 0, newcon2_gui_main_back_720x480_1);
		Draw();
		DrawSubWin(mainSelect, false);
	}

	void DrawIcons(int menu, int selector)
	{
#if DESIGN_TYPE == 1
		switch(menu)
		{
			case MN_CHANNEL:
				DrawImage(19, 16, selector == ICON_DEFAULT ? newcon2_gui_main_ch_default_720x480 : selector == ICON_CURSOR ? newcon2_gui_main_ch_cursor_720x480 : newcon2_gui_main_ch_selected_720x480);
				break;
			case MN_SETUP:
				DrawImage(19, 93, selector == ICON_DEFAULT ? newcon2_gui_main_cc_default_720x480 : selector == ICON_CURSOR ? newcon2_gui_main_cc_cursor_720x480 : newcon2_gui_main_cc_selected_720x480);
				break;
			case MN_PROGRAM:
				DrawImage(19, 170, selector == ICON_DEFAULT ? newcon2_gui_main_lock_default_720x480 : selector == ICON_CURSOR ? newcon2_gui_main_lock_cursor_720x480 : newcon2_gui_main_lock_selected_720x480);
				break;
			case MN_FUNCTION:
				DrawImage(19, 247, selector == ICON_DEFAULT ? newcon2_gui_main_setting_default_720x480 : selector == ICON_CURSOR ? newcon2_gui_main_setting_cursor_720x480 : newcon2_gui_main_setting_selected_720x480);
				break;
		}
#else
		switch(menu)
		{
			case MN_CHANNEL:
				DrawImage(10, 16, selector == ICON_DEFAULT ? newcon2_gui_main_ch_default_720x480 : selector == ICON_CURSOR ? newcon2_gui_main_ch_cursor_720x480 : newcon2_gui_main_ch_selected_720x480);
				break;
			case MN_SETUP:
				DrawImage(10, 93, selector == ICON_DEFAULT ? newcon2_gui_main_cc_default_720x480 : selector == ICON_CURSOR ? newcon2_gui_main_cc_cursor_720x480 : newcon2_gui_main_cc_selected_720x480);
				break;
			case MN_PROGRAM:
				DrawImage(10, 170, selector == ICON_DEFAULT ? newcon2_gui_main_lock_default_720x480 : selector == ICON_CURSOR ? newcon2_gui_main_lock_cursor_720x480 : newcon2_gui_main_lock_selected_720x480);
				break;
			case MN_FUNCTION:
				DrawImage(10, 247, selector == ICON_DEFAULT ? newcon2_gui_main_setting_default_720x480 : selector == ICON_CURSOR ? newcon2_gui_main_setting_cursor_720x480 : newcon2_gui_main_setting_selected_720x480);
				break;
		}
#endif


	}
		
	void Draw(void)
	{
		for(int i=0;i<mainListNum;i++)
		{
			DrawIcons(i,ICON_DEFAULT);
			if(g_nPos == i)
			{
				if(bFocus)
					DrawIcons(i+g_nTop,ICON_CURSOR);
				else
					DrawIcons(i+g_nTop,ICON_SELECT);
			}
		}


		UpdateScreen();
	}

	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
				
			case WM_MENU_LANGUAGE_CHANGE:
				Draw();
				break;
		}
	}

	void DrawSubWin(int index, bool Execute)
	{
		if (Execute == false)
		{
			CWindow *pSubWin = DST_GetWin(WIN_SUB_MENU_2DEPTH);
			if (pSubWin) pSubWin->Close();
		}

		if (Execute == false)
		{
			DST_CreateWin(WIN_SUB_MENU_2DEPTH, GetWinID(), Index2MenuLists(index), true);
		}
		else
		{
			DST_g_Focus_menu = 1;
			FocusToChild(WIN_SUB_MENU_2DEPTH);
			SetTimeOut(0);
		}
			
	}
	

	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		CWindow *pSubWin = DST_GetWin(WIN_SUB_MENU_2DEPTH);

		switch (key)
		{
			case VK_UP:
			case VK_DN:
				if(key == VK_DN)
					ItemIncrease(mainItemNum, mainListNum, &g_nTop, &mainSelect, &g_nPos);
				else
					ItemDecrease(mainItemNum, mainListNum, &g_nTop, &mainSelect, &g_nPos);
				MenuTop[MenuIdx] = g_nTop;
				MenuPos[MenuIdx] = g_nPos;
				MenuSelect[MenuIdx] = mainSelect;


				Draw();
				DrawSubWin(mainSelect, false);
				break;

			case VK_RIGHT:
			case VK_OK:
					DoFocus(false);
					T();
					if(Index2MenuLists(mainSelect)== MN_PROGRAM)
					{
						T();
						DST_CreateWin(WIN_PROGRAM_GUIDE,WIN_MAIN_MENU); 
						Close();
						break;
					}	

					DrawSubWin(mainSelect, true);
					Draw();
					if(pSubWin) pSubWin->Show();
				break;
			default:
//				if(pSubWin) pSubWin->Close();
				Close();
				break;
		}
	}

	
};

void DST_CreateMainMenu(SWinEventMsg event)
{
  DST_AddWin((WinID)(event.data[0]), new CMainMenu(event));
}

class CMenu2Depth: public CWindow
{
private:
	DS_U16 g_nPos;
	DS_U16 g_nTop;
	DS_U16 mainSelect;
	DS_U16 mainListNum;
	DS_U16 mainItemNum;

	DS_U16 userSavedValue;

	int  MenuIdx;
	int MainMenuIndex;

public:
	CMenu2Depth(SWinEventMsg event):CWindow(event)
	{
		MainMenuIndex = event.data[2];
		InitValues();
		setSize();
		SetTimeOut(30);

	}
	virtual ~CMenu2Depth()
	{
	}
	
	void InitValues(void)
	{
		MenuIdx = 0;/*DST_UI_GetSource();*/
		mainItemNum = GetCount();
		g_nTop = 0;
		g_nPos = 0;
		mainSelect = 0;
		mainListNum = 5;
		if (mainItemNum < mainListNum) mainListNum = mainItemNum;
		
		
	}

	int GetCount()
	{
		int MenuCount = 0;
		switch(MainMenuIndex)
		{
			case MN_CHANNEL:
				for (int i = 0; i < 20; i++)
				{
					if (ch_sub_menu[i].menu == CH_SUB_MAX_NUM) break;
					if (ch_sub_menu[i].bEnable) MenuCount++;
				}
				break;
			case MN_SETUP:
				for (int i = 0; i < 20; i++)
				{
					if (setup_sub_menu[i].menu == SETUP_SUB_MAX_NUM) break;
					if (setup_sub_menu[i].bEnable) MenuCount++;
				}
				break;
			case MN_PROGRAM:
				for (int i = 0; i < 20; i++)
				{
					if (program_sub_menu[i].menu == PROGRAM_SUB_MAX_NUM) break;
					if (program_sub_menu[i].bEnable) MenuCount++;
				}
				break;
			case MN_FUNCTION:
				for (int i = 0; i < 20; i++)
				{
					if (function_sub_menu[i].menu == FUNCTION_SUB_MAX_NUM) break;
					if (function_sub_menu[i].bEnable) MenuCount++;
				}
				break;
		}

		return MenuCount;
	}
	
	int Index2MenuLists(int index)
	{
		int nPos = -1;
		int menu = 0;
		if (index < mainItemNum)
		{
			switch(MainMenuIndex)
			{
				case MN_CHANNEL:
//					T();
					for (int i = 0; i < 20; i++)
					{
						if (ch_sub_menu[i].bEnable) nPos++;
						if (nPos != index) continue;
						menu = ch_sub_menu[i].menu;
						break;
					}
					break;
				case MN_SETUP:
					for (int i = 0; i < 20; i++)
					{
						if (setup_sub_menu[i].bEnable) nPos++;
						if (nPos != index) continue;
						menu = setup_sub_menu[i].menu;
						break;
					}
					break;
				case MN_PROGRAM:
					for (int i = 0; i < 20; i++)
					{
						if (program_sub_menu[i].bEnable) nPos++;
						if (nPos != index) continue;
						menu = program_sub_menu[i].menu;
						break;
					}
					break;
				case MN_FUNCTION:
					for (int i = 0; i < 20; i++)
					{
						if (function_sub_menu[i].bEnable) nPos++;
						if (nPos != index) continue;
						menu = function_sub_menu[i].menu;
						break;
					}
					break;
			}
		}
		return menu;
	}

	DS_U16* GetParentString(int nPos)
	{
		switch (nPos)
		{
			case MN_CHANNEL: return pz_Menu_Channel[OSD_Lang]; break;
			case MN_SETUP: return pz_Menu_Setup[OSD_Lang]; break;
			case MN_PROGRAM: return pz_Menu_Program[OSD_Lang]; break;
			case MN_FUNCTION: return pz_Menu_Function[OSD_Lang]; break;
			default: break;
		}
		return 0;
	}	
	bool HasMoreDepth(int menu)
	{
		bool ret = false;
		switch(MainMenuIndex)
		{
			case MN_CHANNEL:
				
//				T();
//				DST_Printf("menu=%d Index2MenuLists(menu)=%d\n\n",menu,Index2MenuLists(menu));
				switch(Index2MenuLists(menu))
				{
					case CH_SUB_AUTO_SCAN: ret = false; break;
					case CH_SUB_MANUAL_SCAN: ret = false; break;
					case CH_SUB_CHANNEL_EDIT: ret = false; break;
					case CH_SUB_SIGNAL_METER: ret = false; break;
				}
				break;
			case MN_SETUP:
				switch(Index2MenuLists(menu))
				{
					case SETUP_SUB_AV_DISPLAY_MODE: ret = true; break;
					case SETUP_SUB_AV_AUDIO_PREF: ret = true; break;
					case SETUP_SUB_AV_VI: ret = true; break;
					case SETUP_SUB_CC_DISPLAY: ret = true; break;
				}
				break;
			case MN_PROGRAM:
				switch(Index2MenuLists(menu))
				{
					case PROGRAM_INFORMATION: ret = false; break;
				}
				break;
			case MN_FUNCTION:
				switch(Index2MenuLists(menu))
				{
					case FUNCTION_SUB_SLEEP_TIMER: ret = true; break;
					case FUNCTION_SUB_AV_PREFERRED_CONN: ret = true; break;
					case FUNCTION_SUB_FACTORY_RESET: ret = false; break;
				}
				break;

			default: break;

		}
		return ret;
	}
	
	DS_U16* GetString(int menu)
	{
		switch(MainMenuIndex)
		{
			case MN_CHANNEL:
				
//				T();
//				DST_Printf("menu=%d Index2MenuLists(menu)=%d\n\n",menu,Index2MenuLists(menu));
				switch(Index2MenuLists(menu))
				{
					case CH_SUB_AUTO_SCAN: return pz_Sub_AutoScan[OSD_Lang]; break;
					case CH_SUB_MANUAL_SCAN: return pz_ManualSearch[OSD_Lang]; break;
					case CH_SUB_CHANNEL_EDIT: return pz_Sub_ChannelEdit[OSD_Lang]; break;
					case CH_SUB_SIGNAL_METER: return pz_Sub_SignalMeter[OSD_Lang]; break;
				}
				break;
			case MN_SETUP:
				switch(Index2MenuLists(menu))
				{
					case SETUP_SUB_AV_DISPLAY_MODE: return pz_Sub_DisplayMode[OSD_Lang]; break;
					case SETUP_SUB_AV_AUDIO_PREF: return pz_Sub_AudioPref[OSD_Lang]; break;
					case SETUP_SUB_AV_VI: return pz_Sub_DVS[OSD_Lang]; break;
					case SETUP_SUB_CC_DISPLAY: return pz_Sub_CC[OSD_Lang]; break;
				}
				break;
			case MN_PROGRAM:
				switch(Index2MenuLists(menu))
				{
				}
				break;
			case MN_FUNCTION:
				switch(Index2MenuLists(menu))
				{
					case FUNCTION_SUB_SLEEP_TIMER: return pz_Sub_SleepTime[OSD_Lang]; break;
					case FUNCTION_SUB_AV_PREFERRED_CONN: return pz_Sub_PrefConn[OSD_Lang]; break;
					case FUNCTION_SUB_FACTORY_RESET: return pz_Sub_Factory[OSD_Lang]; break;
				}
				break;

			default: break;

		}
		return 0;
	}


	void setSize(void)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_main_back_720x480_2);
		rect.h = DST_GetImageHeight(newcon2_gui_main_back_720x480_2);
		rect.x = 106+(DST_GetScreenWidth() - DST_GetImageWidth(newcon2_gui_main_back_720x480))/2;
		rect.y = (DST_GetScreenHeight() - rect.h)/2;
	}

	virtual void Focus(bool bVal)
	{
		RegisterKey(VK_MENU, bVal);
		RegisterKey(VK_CANCEL, bVal);
		RegisterKey(VK_LEFT, bVal);
		RegisterKey(VK_RIGHT, bVal);
		RegisterKey(VK_UP, bVal);
		RegisterKey(VK_DN, bVal);
		RegisterKey(VK_OK, bVal);
		RegisterKey(VK_CH_UP, bVal);
		RegisterKey(VK_CH_DN, bVal);
		RegisterKey(VK_PREV, bVal);
		RegisterKey(VK_PREV_MENU, true);
	}
	
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			//case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_POWER_DOWN_CAUTION:
			//case WIN_MAIN_MENU:
			//case WIN_SUB_MENU_2DEPTH:
			//case WIN_SUB_MENU_3DEPTH:
			//case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
//			case WIN_PASSWD_CHANGE:
//			case WIN_PASSWD_CHECK:
//			case WIN_PASSWD_CONFIRM:
			case WIN_AGE_RATING:
				Close();
				break;
			default:
				break;
		}
	}
	virtual void Show(void)
	{
		SetTimeOut(30);
//		DrawBox(0, 0, rect.w, rect.h, CONV32_16(0x00000000));
		Draw();
		DrawSubWin(mainSelect, false);
	}

	void Draw(void)
	{
		DrawImage(0 , 0, newcon2_gui_main_back_720x480_2);
		setFontStyle(24, 0xFFD8D8D8, ALIGN_MIDDLE, ALIGN_CENTER);
		DrawTextUni(6, 17, 226, 22, GetParentString(MainMenuIndex), &font);

		if(MainMenuIndex == MN_PROGRAM)
		{
			setFontStyle(24,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
			int center_pos =  DST_GetImageHeight(newcon2_gui_main_back_720x480_2) / 2; 
			int line_spacing = DST_GetFontHeight(font.GetSize()) * 125 / 100;
			int width = DST_GetImageWidth(newcon2_gui_main_back_720x480_2);
			DrawTextUni(0, center_pos-line_spacing/2-line_spacing, width, line_spacing, pz_ProgramGuide_E1[OSD_Lang], &font);
			DrawTextUni(0, center_pos-line_spacing/2, width, line_spacing, pz_ProgramGuide_E2[OSD_Lang], &font);
			DrawTextUni(0, center_pos+line_spacing/2, width, line_spacing, pz_ProgramGuide_E3[OSD_Lang], &font);
			DrawTextUni(0, center_pos+line_spacing/2+line_spacing, width, line_spacing, pz_ProgramGuide_E4[OSD_Lang], &font);		
			UpdateScreen();
			return;
		}
		for(int i=0;i<mainListNum;i++)
		{
			setFontStyle(24,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
			if(DST_g_Focus_menu != 0 && g_nPos == i)
			{
				if(bFocus)
				{
					DrawImage(16 , 72 + i*50, newcon2_gui_depth3_button_cursor,true);
					if(HasMoreDepth(i)) DrawImage(206 , 72 + i*50, newcon2_gui_depth3_button_cursor_arrow_right,true);
#if DESIGN_TYPE == 1
#else
					setFontStyle(24,0xFF000000,ALIGN_MIDDLE,ALIGN_CENTER);
#endif	

				}
				else
				{
					DrawImage(16 , 72 + i*50, newcon2_gui_depth3_button_selected,true);
					if(HasMoreDepth(i)) DrawImage(206 , 72 + i*50, newcon2_gui_depth3_button_selected_arrow_right,true);
				}
			}

			DrawTextUni(16, 72 + i*50, 205, 38, GetString(g_nTop+i), &font);
		}
		

		UpdateScreen();
	}

	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
				
			case WM_MENU_LANGUAGE_CHANGE:
				Draw();
				break;
		}
	}

	void DrawSubWin(int index, bool Execute)
	{
		if (Execute == false)
		{
			CWindow *pSubWin = DST_GetWin(WIN_SUB_MENU_3DEPTH);
			if (pSubWin) pSubWin->Close();
		}

		if (Execute == false)
		{
			DST_CreateWin(WIN_SUB_MENU_3DEPTH, GetWinID(), MainMenuIndex, Index2MenuLists(index));
		}
		else
		{
			DST_g_Focus_menu = 2;
			FocusToChild(WIN_SUB_MENU_3DEPTH);
			SetTimeOut(0);
		}
	}
	void DrawWin(int menu)
	{
		switch(MainMenuIndex)
		{
			case MN_CHANNEL:
				switch(Index2MenuLists(menu))
				{
					case CH_SUB_AUTO_SCAN: 
						DST_CreateWin(WIN_AUTO_SEARCH, WIN_MAIN_MENU); 
						break;
					case CH_SUB_MANUAL_SCAN:
						DST_CreateWin(WIN_MANUAL_SEARCH, WIN_MAIN_MENU);
						break;
					case CH_SUB_CHANNEL_EDIT: 
						DST_CreateWin(WIN_CHANNEL_LIST,WIN_MAIN_MENU); 
						break;
					case CH_SUB_SIGNAL_METER: break;
				}
				break;
			case MN_FUNCTION:
				switch(Index2MenuLists(menu))
				{
					case FUNCTION_SUB_FACTORY_RESET:
						DST_CreateWin(WIN_FACTORY_RESET_ASK);
//						DST_CreateWin(WIN_PASSWD_CHECK,WIN_MAIN_MENU,MN_FUNCTION,FUNCTION_SUB_FACTORY_RESET);
						break;
				}
				break;

			default: break;

		}
	}	
	

	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		CWindow *pParentWin = DST_GetWin(WIN_MAIN_MENU);
		CWindow *pSubWin = DST_GetWin(WIN_SUB_MENU_3DEPTH);
		switch (key)
		{
			case VK_UP:
			case VK_DN:
				if(key == VK_DN)
				{
					ItemIncrease(mainItemNum, mainListNum, &g_nTop, &mainSelect, &g_nPos);
				}
				else
				{
					ItemDecrease(mainItemNum, mainListNum, &g_nTop, &mainSelect, &g_nPos);
				}
				Draw();
				DrawSubWin(mainSelect, false);
				break;

			case VK_RIGHT:
			case VK_OK:
				if(HasMoreDepth(mainSelect))
				{
					DoFocus(false);
					DrawSubWin(mainSelect, true);
					Draw();
					if(pSubWin) pSubWin->Show();
				}
				else
				{
					DrawWin(mainSelect);
					if(MainMenuIndex == MN_CHANNEL && Index2MenuLists(mainSelect) == CH_SUB_SIGNAL_METER) break;
					if(pParentWin) pParentWin->Close();
					Close();
				}
				
				break;
			case VK_CANCEL:
			case VK_MENU:
				if(pParentWin) pParentWin->Close();
				break;

			default:
				DST_g_Focus_menu = 0;
				FocusToParent();
				if(pParentWin) pParentWin ->Show();
				else DST_Printf("[Depth3] No Parent Win!!!\n");
				Close();
				break;
		}
	}

	
};

void DST_CreateMenu2Depth(SWinEventMsg event)
{
  DST_AddWin((WinID)(event.data[0]), new CMenu2Depth(event));
}

class CMenu3Depth: public CWindow
{
private:
	DS_U16 g_nPos;
	DS_U16 g_nTop;
	DS_U16 mainSelect;
	DS_U16 mainListNum;
	DS_U16 mainItemNum;
	DS_U16 userSavedValue;

	int  MenuIdx;
	int MainMenuIndex;
	int SubMenuIndex;

public:
	CMenu3Depth(SWinEventMsg event):CWindow(event)
	{
		MainMenuIndex = event.data[2];
		SubMenuIndex = event.data[3];
		InitValues();
		setSize();
		SetTimeOut(30);
	}
	virtual ~CMenu3Depth()
	{
	}
	
	void InitValues(void)
	{
		MenuIdx = 0;/*DST_UI_GetSource();*/
		mainItemNum = GetCount();
		g_nTop = 0;
		g_nPos = 0;
		mainSelect = 0;
		GetValuse(&mainSelect);
		userSavedValue = mainSelect;
		
		mainListNum = 5;
		if (mainItemNum < mainListNum) mainListNum = mainItemNum;
		
		InitItemValues(mainListNum, mainSelect, &g_nTop, &g_nPos);
		
	}

	int GetCount()
	{
		int ret = 0;
		switch(MainMenuIndex)
		{
			case MN_CHANNEL:
				switch(SubMenuIndex)
				{
					case CH_SUB_AUTO_SCAN: ret = 0; break;
					case CH_SUB_MANUAL_SCAN: ret = 0; break;
					case CH_SUB_CHANNEL_EDIT: ret = 0; break;
					case CH_SUB_SIGNAL_METER: ret = 0; break;
				}
				break;
			case MN_SETUP:
				switch(SubMenuIndex)
				{
					case SETUP_SUB_AV_DISPLAY_MODE: ret = getAspectRatioIndex(); break;
					case SETUP_SUB_AV_AUDIO_PREF: ret = 2; break;
					case SETUP_SUB_AV_VI: ret = 2; break;
					case SETUP_SUB_CC_DISPLAY: ret = 2; break;
				}
				break;
			case MN_PROGRAM:
				switch(SubMenuIndex)
				{
				}
				break;
			case MN_FUNCTION:
				switch(SubMenuIndex)
				{
					case FUNCTION_SUB_SLEEP_TIMER: ret = SLEEP_TIMER_MAX_NUM;  break;
					case FUNCTION_SUB_AV_PREFERRED_CONN: ret = PREFERRED_CONN_MAX_NUM; ; break;
					case FUNCTION_SUB_FACTORY_RESET: ret = 0; break;
				}
				break;

			default: break;
		}
		return ret;
	}
	
	bool getTR_AspectRatio()
	{
		DS_U16 w = 0, h = 0, fps = 0;
		bool bWide = false, bInterlace = false;
		DST_GetVideoSize(&w, &h, &fps, &bInterlace, &bWide);
		
		return (!bWide);
	}

	DS_U8 getAspectRatioIndex()
	{
		if(getTR_AspectRatio()) return 1;
		else return 3;
	}	
	void GetItemInfo(bool* bRadio, bool* bNeedPopUp)
	{
		switch(MainMenuIndex)
		{
			case MN_CHANNEL:
				switch(SubMenuIndex)
				{
					case CH_SUB_AUTO_SCAN: *bRadio = false; *bNeedPopUp = true; break;
					case CH_SUB_MANUAL_SCAN: *bRadio = false; *bNeedPopUp = true; break;
					case CH_SUB_CHANNEL_EDIT: *bRadio = false; *bNeedPopUp = true; break;
					case CH_SUB_SIGNAL_METER: *bRadio = false; *bNeedPopUp = true; break;
				}
				break;
			case MN_SETUP:
				switch(SubMenuIndex)
				{
					case SETUP_SUB_AV_DISPLAY_MODE: *bRadio = true; *bNeedPopUp = false; break;
					case SETUP_SUB_AV_AUDIO_PREF: *bRadio = true; *bNeedPopUp = false; break;
					case SETUP_SUB_AV_VI: *bRadio = true; *bNeedPopUp = false; break;
					case SETUP_SUB_CC_DISPLAY: *bRadio = true; *bNeedPopUp = false; break;
				}
				break;
			case MN_PROGRAM:
				switch(SubMenuIndex)
				{
				}
				break;
			case MN_FUNCTION:
				switch(SubMenuIndex)
				{
					case FUNCTION_SUB_SLEEP_TIMER: *bRadio = true; *bNeedPopUp = false; break;
					case FUNCTION_SUB_AV_PREFERRED_CONN: *bRadio = true; *bNeedPopUp = false; break;
					case FUNCTION_SUB_FACTORY_RESET: *bRadio = false; *bNeedPopUp = true; break;
				}
				break;

			default: break;
		}
	}

	void GetValuse(DS_U16 *value)
	{
		switch(MainMenuIndex)
		{
			case MN_CHANNEL:
				switch(SubMenuIndex)
				{
					case CH_SUB_AUTO_SCAN: *value = 0; break;
					case CH_SUB_MANUAL_SCAN: *value = 0; break;
					case CH_SUB_CHANNEL_EDIT: *value = 0; break;
					case CH_SUB_SIGNAL_METER: *value = 0; break;
				}
				break;
			case MN_SETUP:
				switch(SubMenuIndex)
				{
					case SETUP_SUB_AV_DISPLAY_MODE: *value =DST_UI_GetAspect(); break;
					case SETUP_SUB_AV_AUDIO_PREF: *value =DST_UI_GetMTS(); break;
					case SETUP_SUB_AV_VI: *value =DST_UI_GetVI(); break;
					case SETUP_SUB_CC_DISPLAY: *value =DST_EEPROM_GetCC(); break;
				}
				break;
			case MN_PROGRAM:
				switch(SubMenuIndex)
				{
				}
				break;
			case MN_FUNCTION:
				switch(SubMenuIndex)
				{
					case FUNCTION_SUB_SLEEP_TIMER:  *value = DST_GetSleepTimer(); break;
					case FUNCTION_SUB_AV_PREFERRED_CONN: *value =DST_UI_GetCh34(); break;
					case FUNCTION_SUB_FACTORY_RESET: *value = 0; break;
				}
				break;

			default: break;
		}
	}

	void SetValuse(DS_U16 value)
	{
		switch(MainMenuIndex)
		{
			case MN_CHANNEL:
				switch(SubMenuIndex)
				{
					case CH_SUB_AUTO_SCAN: break;
					case CH_SUB_MANUAL_SCAN: break;
					case CH_SUB_CHANNEL_EDIT: break;
					case CH_SUB_SIGNAL_METER: break;
				}
				break;
			case MN_SETUP:
				switch(SubMenuIndex)
				{
					case SETUP_SUB_AV_DISPLAY_MODE: DST_UI_SetAspect(value); break;
					case SETUP_SUB_AV_AUDIO_PREF: DST_UI_SetMTS(value);  break;
					case SETUP_SUB_AV_VI: DST_UI_SetVI(value); break;
					case SETUP_SUB_CC_DISPLAY: DST_UI_SetCloseCaption(value); break;
				}
				break;
			case MN_PROGRAM:
				switch(SubMenuIndex)
				{
				}
				break;
			case MN_FUNCTION:
				switch(SubMenuIndex)
				{
					case FUNCTION_SUB_SLEEP_TIMER: 
						if(0 < value && value < 5 )DST_g_sleepTimercheckTime = DST_OS_GetTickCount(); 
						DST_SetSleepTimer(value); 
						break;
					case FUNCTION_SUB_AV_PREFERRED_CONN: DST_UI_SetCh34(value); break;
					case FUNCTION_SUB_FACTORY_RESET: break;
				}
				break;

			default: break;

		}

	}

	DS_U16* GetString(int nPos)
	{
		static DS_U16 strText[32];
		// ⺻..̰ ٸ 
		for (unsigned i = 0; i < 40; i++)
		{
			strText[i] = pz_Unknown[OSD_Lang][i];
			if (strText[i] == 0) break;
		}
		switch(MainMenuIndex)
		{
			case MN_CHANNEL:
				switch(SubMenuIndex)
				{
					case CH_SUB_AUTO_SCAN:
					case CH_SUB_MANUAL_SCAN:
					case CH_SUB_CHANNEL_EDIT: 
					case CH_SUB_SIGNAL_METER: 
						return pz_Empty[OSD_Lang];
						break;
				}
				break;
			case MN_SETUP:
				switch(SubMenuIndex)
				{
					case SETUP_SUB_AV_DISPLAY_MODE: 
						switch(nPos)
						{
							case DISPLAY_MODE_WIDE: return pz_Wide[OSD_Lang]; break;
							case DISPLAY_MODE_NORMAL: return pz_Normal[OSD_Lang]; break;
							case DISPLAY_MODE_ZOOM: return pz_Zoom[OSD_Lang]; break;
						}
						break;
					case SETUP_SUB_AV_AUDIO_PREF: 
						switch (nPos)
						{
							case  0: return pz_MTS_Main[OSD_Lang];
							case  1: return pz_MTS_Sub[OSD_Lang];
						}
						break;
					case SETUP_SUB_AV_VI: 
						switch (nPos)
						{
							case  0: return pz_VI_Off[OSD_Lang];
							case  1: return pz_VI_On[OSD_Lang];

						}
						break;
					case SETUP_SUB_CC_DISPLAY: 
						switch (nPos)
						{
							case  0: return pz_Off[OSD_Lang]; break;
							case  1: return pz_On[OSD_Lang]; break;
						}
						break;
				}
				break;
			case MN_PROGRAM:
				switch(SubMenuIndex)
				{
				}
				break;
			case MN_FUNCTION:
				switch(SubMenuIndex)
				{
					case FUNCTION_SUB_SLEEP_TIMER:
						switch(nPos)
						{
							case SLEEP_TIMER_OFF: return pz_Off[OSD_Lang]; break;
							case SLEEP_TIMER_15M: return pz_Sub_SleepTime_15[OSD_Lang]; break;
							case SLEEP_TIMER_30M: return pz_Sub_SleepTime_30[OSD_Lang]; break;
							case SLEEP_TIMER_60M: return pz_Sub_SleepTime_60[OSD_Lang]; break;
							case SLEEP_TIMER_120M: return pz_Sub_SleepTime_120[OSD_Lang]; break;
						}
						break;
					case FUNCTION_SUB_AV_PREFERRED_CONN: 
						switch(nPos)
						{
							case PREFERRED_CONN_LINE_OUT: return pz_Sub_LineOut[OSD_Lang]; break;
							case PREFERRED_CONN_CH34: return pz_Sub_CH34[OSD_Lang]; break;
						}
						break;

					case FUNCTION_SUB_FACTORY_RESET: return pz_Empty[OSD_Lang]; break;
				}
				break;

			default: break;

		}
		return 0;
	}


	void setSize(void)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_main_back_720x480_3);
		rect.h = DST_GetImageHeight(newcon2_gui_main_back_720x480_3);
		rect.x = 237+106+(DST_GetScreenWidth() - DST_GetImageWidth(newcon2_gui_main_back_720x480))/2;
		rect.y = (DST_GetScreenHeight() - rect.h)/2;
	}

	virtual void Focus(bool bVal)
	{
		RegisterKey(VK_MENU, bVal);
		RegisterKey(VK_CANCEL, bVal);
		RegisterKey(VK_LEFT, bVal);
		RegisterKey(VK_RIGHT, bVal);
		RegisterKey(VK_UP, bVal);
		RegisterKey(VK_DN, bVal);
		RegisterKey(VK_OK, bVal);
		RegisterKey(VK_CH_UP, bVal);
		RegisterKey(VK_CH_DN, bVal);
		RegisterKey(VK_PREV, bVal);
		RegisterKey(VK_PREV_MENU, true);
	}
	
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			//case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_POWER_DOWN_CAUTION:
			//case WIN_MAIN_MENU:
			//case WIN_SUB_MENU_2DEPTH:
			//case WIN_SUB_MENU_3DEPTH:
			//case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
//			case WIN_PASSWD_CHANGE:
//			case WIN_PASSWD_CHECK:
//			case WIN_PASSWD_CONFIRM:
			case WIN_AGE_RATING:
				Close();
				break;
			default:
				break;
		}
	}
	virtual void Show(void)
	{
//		DrawBox(0, 0, rect.w, rect.h, CONV32_16(0x00000000));
		Draw();
	}

	void DrawExplanation()
	{
		setFontStyle(24, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_CENTER);
		int center_pos =  DST_GetImageHeight(newcon2_gui_main_back_720x480_3) / 2; 
		int line_spacing = DST_GetFontHeight(font.GetSize()) * 125 / 100;
		switch(MainMenuIndex)
		{
			case MN_CHANNEL:
				switch(SubMenuIndex)
				{
					case CH_SUB_AUTO_SCAN: 
						DrawTextUni(8, center_pos-line_spacing/2-line_spacing, 205, line_spacing, pz_Sub_AutoScan_E1[OSD_Lang], &font);
						DrawTextUni(8, center_pos-line_spacing/2, 205, line_spacing, pz_Sub_AutoScan_E2[OSD_Lang], &font);
						DrawTextUni(8, center_pos-line_spacing/2+line_spacing, 205, line_spacing, pz_Sub_AutoScan_E3[OSD_Lang], &font);
						break;
					case CH_SUB_MANUAL_SCAN:
						DrawTextUni(8, center_pos-line_spacing/2-line_spacing, 205, line_spacing, pz_ManualSearch[OSD_Lang], &font);
						DrawTextUni(8, center_pos-line_spacing/2, 205, line_spacing, pz_Sub_AutoScan_E2[OSD_Lang], &font);
						DrawTextUni(8, center_pos-line_spacing/2+line_spacing, 205, line_spacing, pz_Sub_AutoScan_E3[OSD_Lang], &font);
						break;
					case CH_SUB_CHANNEL_EDIT: 
						DrawTextUni(8, center_pos-line_spacing/2-line_spacing, 205, line_spacing, pz_Sub_ChannelEdit_E1[OSD_Lang], &font);
						DrawTextUni(8, center_pos-line_spacing/2, 205, line_spacing, pz_Sub_ChannelEdit_E2[OSD_Lang], &font);
						DrawTextUni(8, center_pos-line_spacing/2+line_spacing, 205, line_spacing, pz_Sub_ChannelEdit_E3[OSD_Lang], &font);
						break;
					case CH_SUB_SIGNAL_METER: 
						DrawTextUni(8, center_pos-line_spacing/2-2*line_spacing, 205, line_spacing, pz_Sub_SignalMeter_E1[OSD_Lang], &font);
						DrawTextUni(8, center_pos-line_spacing/2-line_spacing, 205, line_spacing, pz_Sub_SignalMeter_E2[OSD_Lang], &font);
						DrawTextUni(8, center_pos-line_spacing/2, 205, line_spacing, pz_Sub_SignalMeter_E3[OSD_Lang], &font);
						DrawSignalBar();
						break;
				}
				break;
			case MN_PROGRAM:
				switch(SubMenuIndex)
				{
				}
				break;
			case MN_FUNCTION:
				switch(SubMenuIndex)
				{
					case FUNCTION_SUB_FACTORY_RESET: 
						{
							
							setFontStyle(20, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_CENTER);
							char tmpTxt[100] = {0,};
							sprintf(tmpTxt, "S/W : %s ",DST_GetAppShortVersion());
							DrawText(8, center_pos-3*line_spacing-line_spacing/2, 205, line_spacing, tmpTxt, &font);
						}
					
						setFontStyle(24, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_CENTER);
						DrawTextUni(8, center_pos-2*line_spacing, 205, line_spacing, pz_Sub_FactoryReset_E1[OSD_Lang], &font);
						DrawTextUni(8, center_pos-line_spacing, 205, line_spacing, pz_Sub_FactoryReset_E2[OSD_Lang], &font);
						DrawTextUni(8, center_pos, 205, line_spacing, pz_Sub_FactoryReset_E3[OSD_Lang], &font);
						DrawTextUni(8, center_pos+line_spacing, 205, line_spacing, pz_Sub_FactoryReset_E4[OSD_Lang], &font);
						break;
				}
				break;

			default: break;

		}			
	}
	
	void DrawSignalBar(void)
	{
		int xPos 	= 20;
		int yPos 	= 270;
		int width   = 166;
		int range	= 100;
		int signal	= DST_GetSignalStrength();

		//background
		DrawImage(19 , 269,newcon2_gui_main_signalmeter_back_720x480,true);

		//signal text
		setFontStyle(24, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_CENTER);
		char tmp[5]={0};
		sprintf(tmp, "%d", signal);
		DrawText(8, 231, 205, 38, tmp, &font);

		int division =	width/3;
		int position = (width*signal)/(range);

		//signal meter
		for (int i=xPos; i < xPos+position; i++)
		{
			if ((i-xPos) <= division)
				DrawImage(i, yPos, newcon2_gui_progress_red);
			else if ((i-xPos) <= (division*2))
				DrawImage(i, yPos, newcon2_gui_progress_yellow);
			else
				DrawImage(i, yPos, newcon2_gui_progress_green);
		}
		

	}
	
	void Draw(void)
	{
		T();
		DrawImage(0 , 0, newcon2_gui_main_back_720x480_3);
		setFontStyle(24, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_LEFT);
		
		
		if(DST_g_Focus_menu != 0)
		{
			
			bool bRadio, bNeedPopUp = false;
			GetItemInfo(&bRadio, &bNeedPopUp);
			if(bNeedPopUp) 
			{
				DrawExplanation();
				UpdateScreen();
				
				if(MainMenuIndex == MN_CHANNEL && SubMenuIndex == CH_SUB_SIGNAL_METER) SetTimer(1, 500);
				return;
			}

			if(bRadio)
			{
				for(int i=0;i<mainListNum;i++)
				{
					setFontStyle(24,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);
					bool cursor = false;
					if(bFocus && g_nPos == i)
					{
						cursor = true;
						DrawImage(8 , 31+i*51,newcon2_gui_depth3_button_cursor,true);
#if DESIGN_TYPE == 1
#else
						setFontStyle(24,0xFF000000,ALIGN_MIDDLE,ALIGN_LEFT);
#endif	

					}
					
					if(userSavedValue == i)
					{
						if(cursor == false)DrawImage(8 , 31+i*51,newcon2_gui_depth3_button_selected,true);
	
						DrawImage(17 , 39+i*51, newcon2_gui_depth3_button_chech_cursor,true);
					}

					DrawTextUni(46, 31+i*51, 167, 38, GetString(g_nTop+i), &font);
				}
			}
			else
			{
				for(int i=0;i<mainListNum;i++)
				{
					setFontStyle(24,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);
					if(bFocus && g_nPos == i)
					{
						DrawImage(8 , 31+i*51, newcon2_gui_depth3_button_cursor,true);
						if(bNeedPopUp == false) DrawImage(198 , 31+i*51, newcon2_gui_depth3_button_cursor_arrow_right,true);
#if DESIGN_TYPE == 1
#else
						setFontStyle(24,0xFF000000,ALIGN_MIDDLE,ALIGN_LEFT);
#endif	

					}
					if(userSavedValue == i && DST_g_Focus_menu == 3 )
					{
						if(bFocus == false) DrawImage(8 , 31+i*51,newcon2_gui_depth3_button_selected,true);
					}
					
					DrawTextUni(8, 31+i*51, 205, 38, GetString(g_nTop+i), &font);
	
				}
			}

		}

		UpdateScreen();
	}
	
	virtual void OnTimer(char nID)
	{
		switch(nID)
		{
			case 1:
				KillTimer(1);
				Draw();
				break;
			default:
				break;
		}
	}


	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
				
			case WM_MENU_LANGUAGE_CHANGE:
				Draw();
				break;
		}
	}

	void DrawSubWin(int index)
	{
		bool bRadio, bNeedPopUp = false;
		GetItemInfo(&bRadio, &bNeedPopUp);
		if(bRadio == false && bNeedPopUp == false)
		{
			DST_g_Focus_menu = 3;
			DoFocus(false);
			DST_CreateWin(WIN_SUB_MENU_4DEPTH, GetWinID(), MainMenuIndex, SubMenuIndex, index);
		}
	}
	

	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		CWindow *pRootWin = DST_GetWin(WIN_MAIN_MENU);
		CWindow *pParentWin = DST_GetWin(WIN_SUB_MENU_2DEPTH);
		switch (key)
		{
			case VK_UP:
			case VK_DN:
				if(key == VK_DN)
					ItemIncrease(mainItemNum, mainListNum, &g_nTop, &mainSelect, &g_nPos);
				else
					ItemDecrease(mainItemNum, mainListNum, &g_nTop, &mainSelect, &g_nPos);
				Draw();
				break;

			case VK_RIGHT:
			case VK_OK:
				//DrawSubWin(mainSelect);
				userSavedValue = mainSelect;
				SetValuse(mainSelect);
				Draw();
//				if(pSubWin) pSubWin->Show();
				break;
			case VK_CANCEL:
			case VK_MENU:
				if(pRootWin) pRootWin->Close();
				break;

			default:
				DST_g_Focus_menu = 1;
				FocusToParent();
				if(pParentWin) pParentWin ->Show();
				else DST_Printf("[Depth3] No Parent Win!!!\n");
				Close();
				break;
		}
	}

	
};

void DST_CreateMenu3Depth(SWinEventMsg event)
{
  DST_AddWin((WinID)(event.data[0]), new CMenu3Depth(event));
}





