#include "DST_WinList.h"
#include "DST_Window.h"
#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_CommonAPI.h"
#include "DST_SignalMonitor.h"

static int gWinEventMsgQ = 0;
static int gWinEventMsgQ_Count = 0;

void DST_CreateBaseSystemWindow(SWinEventMsg event);

void DST_CreateTestOSDWin(SWinEventMsg event);
void DST_CreateEAWindow(SWinEventMsg event);

void DST_CreateCaptionWin(SWinEventMsg event);
void DST_CreateSuperImposeWin(SWinEventMsg event);
// Muon2  OSD
void DST_CreateSignalMeterWin(SWinEventMsg event);
void DST_CreateChannelEditWin(SWinEventMsg event);
void DST_CreateLowBatteryWindow(SWinEventMsg event);
void DST_CreateSplashScreenWindow(SWinEventMsg event);

// Maya 
void DST_CreateFMWin(SWinEventMsg event);
void DST_CreateMayaMain(SWinEventMsg event);
void DST_CreateMayaSub(SWinEventMsg event);
void DST_CreateSetUpWizard(SWinEventMsg event);

// miru
void DST_CreateErrorWin(SWinEventMsg event);
void DST_CreateAudioWindow(SWinEventMsg event);
void DST_CreateEWSWin(SWinEventMsg event);
void DST_CreateFactoryResetWin(SWinEventMsg event);
void DST_CreateFactoryResetAskWin(SWinEventMsg event);

void DST_CreateStationSearchWin(SWinEventMsg event);
void DST_CreateLowBattery(SWinEventMsg event);
void DST_CreateSplashWindow(SWinEventMsg event);

void DST_CreateWinPasswordCheck(SWinEventMsg event);
void DST_CreateWinPasswordChange(SWinEventMsg event);
void DST_CreateWinPasswordConfirm(SWinEventMsg event);
void DST_CreateAgeRating(SWinEventMsg event);
void DST_CreateMainMenu(SWinEventMsg event);
void DST_CreateMenu2Depth(SWinEventMsg event);
void DST_CreateMenu3Depth(SWinEventMsg event);
void DST_CreateMenu4Depth(SWinEventMsg event);
void DST_CreateVolumeMuteWindow(SWinEventMsg event);
void DST_CreateDirectTuneWindow(SWinEventMsg event);
void DST_CreateSignalMeterWindow(SWinEventMsg event);
void DST_CreateClosedCaptionHotWindow(SWinEventMsg event);
void DST_CreatePowerDownCautionWin(SWinEventMsg event);
void DST_CreateRFUpdateWindow(SWinEventMsg event);
void DST_CreateDebugSQLWin(SWinEventMsg event);
void DST_CreateDebugSQLSubWin(SWinEventMsg event);
void DST_CreateFactoryWin(SWinEventMsg event);
void DST_CreateDisplayModeWindow(SWinEventMsg event);;
void DST_CreateEngineerMenuWin(SWinEventMsg event);
void DST_CreateManualSearchWin(SWinEventMsg event);
void DST_CreateCC708Win(SWinEventMsg event);
void DST_CreateOTCDownloadFailResetWin(SWinEventMsg event);
void DST_CreateOTCDownLoadingWin(SWinEventMsg event);
void DST_CreateUpdateResetWin(SWinEventMsg event);
void DST_CreateUpdateWin(SWinEventMsg event);

DS_U8 DST_GetKeyCode();
void DST_ResetKeyCode();

// CC  Plane ϱ  ӽ÷ static Ǯ
// ½ũ  ٽ static ؾ 

static void DST_BlockCopy(OSD_PIXEL_T *src, int x, int y, int w, int h)
{
	static bool bInit = false;
	if (bInit == false)
	{
		DHL_GFX_Open();
		bInit = true;
	}
	DHL_GFX_Draw(src,x,y,w,h);
}

//  ڽ   Ѵ.
static bool MakeCommonRect(DST_RECT A, DST_RECT B, DST_RECT *C)
{
	C->x= (A.x > B.x) ? A.x : B.x;
	C->y= (A.y > B.y) ? A.y : B.y;
	C->w= (A.x + A.w < B.x + B.w) ? (A.x + A.w - C->x) : (B.x + B.w - C->x);
	C->h= (A.y + A.h < B.y + B.h) ? (A.y + A.h - C->y) : (B.y + B.h - C->y);
	if (C->w <= 0 || C->h <= 0) return false;
	return true;
}
static void WinMgrWinCreate(SWinEventMsg event)
{
	switch (event.data[0])
	{
		case WIN_ENGINEER_MODE:
			DST_CreateEngineerMenuWin(event);
			break;
			
		case WIN_FACTORY_MODE:
			DST_CreateFactoryWin(event);
			break;
			
		case WIN_DEBUG_SQL_SUB:
			DST_CreateDebugSQLSubWin(event);
			break;
			
		case WIN_DEBUG_SQL:
			DST_CreateDebugSQLWin(event);
			break;

		case WIN_RF_UPDATE:
			DST_CreateRFUpdateWindow(event);
			break;
			
		case WIN_CLOSED_CAPTION_HOT:
			DST_CreateClosedCaptionHotWindow(event);
			break;
			
		case WIN_SIGNAL_METER:
			DST_CreateSignalMeterWindow(event);
			break;
			
		case WIN_MAIN_MENU:
			DST_CreateMainMenu(event);
			break;

		case WIN_POWER_DOWN_CAUTION:
			DST_CreatePowerDownCautionWin(event);
			break;

		case WIN_SUB_MENU_2DEPTH:
			DST_CreateMenu2Depth(event);
			break;

		case WIN_SUB_MENU_3DEPTH:
			DST_CreateMenu3Depth(event);
			break;

		case WIN_OTC_DOWNLOAD:
			DST_CreateOTCDownLoadingWin(event);
			break;

		case WIN_OTC_DOWNLOAD_FAIL:
			DST_CreateOTCDownloadFailResetWin(event);
			break;
			
		case WIN_UPDATE:
			DST_CreateUpdateWin(event);
			break;
		case WIN_UPDATE_RESET:
			DST_CreateUpdateResetWin(event);
			break;

		case WIN_BASIC:
			DST_CreateBaseSystemWindow(event);
			break;

		case WIN_AUTO_SEARCH:
			DST_CreateAutoSearchWin(event);
			break;

		case WIN_MANUAL_SEARCH:
			DST_CreateManualSearchWin(event);
			break;
			
		case WIN_PROGRAM_GUIDE:
			DST_CreateProgramGuideWin(event);
			break;

		case WIN_CHANNEL_LIST:
			DST_CreateChannelEditWin(event);
			break;

		case WIN_CHANNEL_BANNER:
			DST_CloseWin(WIN_VOLUME);
			DST_CreateChannelBannerWindow(event);
			break;
		
		case WIN_DIRECT_TUNE:
			DST_CreateDirectTuneWindow(event);
			break;

		case WIN_INFOR_BANNER:
			DST_CreateInforbannerWindow(event);
			break;

		case WIN_FACTORY_RESET:
			DST_CreateFactoryResetWin(event);
			break;

		case WIN_FACTORY_RESET_ASK:
			DST_CreateFactoryResetAskWin(event);
			break;

		case WIN_VOLUME:
			DST_CreateVolumeWindow(event);
			break;

		case WIN_VOLUME_MUTE:
			DST_CreateVolumeMuteWindow(event);
			break;

		case WIN_AUDIO_HOT:
			DST_CreateAudioWindow(event);
			break;

		case WIN_DISPLAY_MODE_HOT:
			DST_CreateDisplayModeWindow(event);
			break;
			
		case WIN_CAPTION:
			DST_CreateCC708Win(event);
			break;

		case WIN_ERROR:
			DST_CreateErrorWin(event);
			break;
			
	}
}

static void WinMgrKeyProcess()
{
	static CWindow *pPrevWin = 0;
	static DS_U8 ucPrevKey = 0;
	static DS_U32 nPrevKeyTime = 0;
	static bool bRepeat = false;
	DS_U8 nKeyCode = DST_GetKeyCode();

	if (nKeyCode == 0)  //Ű  Ǹ 0 ȴ.
	{
		pPrevWin = 0;
		ucPrevKey = 0;
		nPrevKeyTime = 0;
		bRepeat = false;
		return;
	}

	for (int i = 1; i < WIN_ID_MAX; i++)
	{
		CWindow *pWin = DST_GetWin((WinID)i);
		if (pWin == 0) continue;
		if (pWin->IsRegisterKey(nKeyCode) == false) continue;
		pWin->ResetTimer(0);
		// Repeat Ű ƴ Ű
		if (pWin->GetKeyDelay(nKeyCode)==0 || pWin->GetKeyRepeat(nKeyCode)==0)
		{
			DST_ResetKeyCode();
			pWin->KeyInput(nKeyCode, false);
			nKeyCode = 0;
			break;
		}
		// Repeat Ű ó  
		if (pPrevWin != pWin || ucPrevKey != nKeyCode)
		{
			pWin->KeyInput(nKeyCode, false);
			pPrevWin = pWin;
			ucPrevKey = nKeyCode;
			nPrevKeyTime = DST_OS_GetTickCount();
			bRepeat = false;
			break;
		}
		if (bRepeat == false)
		{
			// Repeat Ű ι°  
			if (nPrevKeyTime > DST_OS_GetTickCount()) nPrevKeyTime = DST_OS_GetTickCount();
			if (DST_OS_GetTickCount() - nPrevKeyTime < pWin->GetKeyDelay(nKeyCode)) break;
			pWin->KeyInput(nKeyCode, true);
			nPrevKeyTime = DST_OS_GetTickCount();
			bRepeat = true;
		}
		else
		{
			// Repeat Ű °   
			if (nPrevKeyTime > DST_OS_GetTickCount()) nPrevKeyTime = DST_OS_GetTickCount();
			if (DST_OS_GetTickCount() - nPrevKeyTime < pWin->GetKeyRepeat(nKeyCode)) break;
			nPrevKeyTime = DST_OS_GetTickCount();
			pWin->KeyInput(nKeyCode, true);
		}
		break;
	}
}

static void WinMgrMessageProcess(SWinEventMsg event)
{
	switch (event.cmd)
	{
		case WM_WIN_CREATE:
			WinMgrWinCreate(event);
			break;

		case WM_WIN_DELETE:
			{
				CWindow *pWin = DST_GetWin((WinID)event.data[0]);
				if (pWin) pWin->Close();
			}
			break;

		default:
			for (int i= 1; i < WIN_ID_MAX; i++)
			{
				CWindow *pWin = DST_GetWin((WinID)i);
				if (pWin) pWin->DoOnMessage(event);
				}
			break;
	}
}
static bool WinMgrSub()
{
	SWinEventMsg event;
	DS_U32 retLen;
	if (DST_OS_ReceiveMessage_Wait(gWinEventMsgQ, (DS_U32*)&event, sizeof(SWinEventMsg), &retLen, DST_OS_GetTicksPerSecond()/25) == noError) // ޽   ޽ ó
	{
		gWinEventMsgQ_Count--;
		if (event.cmd == WM_MANAGER_CLOSE) return false;
		WinMgrMessageProcess(event);
	}
	WinMgrKeyProcess();

	for (int i= 1; i < WIN_ID_MAX; i++)
	{
		CWindow *pWin = DST_GetWin((WinID)i);
		if (pWin == 0) continue;
		switch (pWin->GetState())
		{
			case 0: // Before Create
				pWin->DoShow();
				pWin->SetState(1);
				for (int j= 1; j < WIN_ID_MAX; j++)
				{
					CWindow *pWin1 = DST_GetWin((WinID)j);
					if (pWin1) pWin1->Show((WinID)i);
				}
				break;

			case 2: // Before Close
				pWin->UpdateScreen();
				for (int j= 1; j < WIN_ID_MAX; j++)
				{
					CWindow *pWin1 = DST_GetWin((WinID)j);
					if (pWin1) pWin1->Hide((WinID)i);
				}
				DST_RemoveWin((WinID)i);
				break;
		}
	}
	// Ÿ̸ ó
	for (int i= 1; i < WIN_ID_MAX; i++)
	{
		CWindow *pWin = DST_GetWin((WinID)i);
		if (pWin == 0) continue;
		// Ÿ̸ ó ׸ ȭ?
		if (pWin->ProcessTimer() == true) continue;
	}

	DST_RECT rectTemp =	DST_GetUpdateRegion();
	if (rectTemp.w != 0 && rectTemp.h != 0)
	{
		static int imgBuffSize = 0;
		static OSD_PIXEL_T *imgBuff = 0;
		if (rectTemp.w * rectTemp.h > imgBuffSize)
		{
			DST_OS_Free(&imgBuff);
			imgBuffSize = rectTemp.w * rectTemp.h;
			imgBuff = (OSD_PIXEL_T*)DST_OS_Malloc(imgBuffSize*sizeof(OSD_PIXEL_T));
		}
		memset(imgBuff,0, rectTemp.w * rectTemp.h*sizeof(OSD_PIXEL_T));
		for (int i= WIN_ID_MAX - 2; i >=0 ; i--)
		{
			CWindow *pWin = DST_GetWin((WinID)i);
			if (pWin== 0) continue;
			if (pWin->GetVisible() == false) continue;
			OSD_PIXEL_T *srcBuff = pWin->GetImgBuff();
			if (srcBuff == 0) continue;
			DST_RECT rectCommon;
			DST_RECT rectSrc = pWin->GetSize();
			if (MakeCommonRect(rectTemp, rectSrc, &rectCommon ) == false) continue;
			int srcStartX = rectCommon.x - rectSrc.x;
			if (srcStartX < 0) srcStartX = 0;
			int srcStartY = rectCommon.y - rectSrc.y;
			if (srcStartY < 0) srcStartY = 0;
			int desStartX = rectCommon.x - rectTemp.x;
			if (desStartX < 0) desStartX = 0;
			int desStartY = rectCommon.y - rectTemp.y;
			if (desStartY < 0) desStartY = 0;

			OSD_PIXEL_T *des = imgBuff + desStartY * rectTemp.w + desStartX;
			OSD_PIXEL_T *src = srcBuff + srcStartY * rectSrc.w + srcStartX;
			if (pWin->GetTransparent())
				{
					for (int y = 0; y <	rectCommon.h; y++)
					{
						OSD_PIXEL_T* des1 = des;
						OSD_PIXEL_T* src1 = src;
						for (int x = 0; x < rectCommon.w; x++)
						{
							OSD_PIXEL_T max = (sizeof(OSD_PIXEL_T) == 2) ? 0x0F : 0xFF;
				 			OSD_PIXEL_T sa,sr,sg,sb;
							DST_GetColor(*src1, &sa, &sr, &sg, &sb);
							OSD_PIXEL_T da,dr,dg,db;
							DST_GetColor(*des1, &da, &dr, &dg, &db);
							if (sa != 0) //  ƴ 츸 ׸.
							{
								if (sa == max || da == 0) // ҽ ̰ų  ΰ
								{
								 	*des1 = *src1;
								}
								else // 
								{
									// http://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending
									OSD_PIXEL_T t = (da * (max-sa) + (max/2)) / max;
									OSD_PIXEL_T a = sa + t;
									if (a > max) a = max;
									OSD_PIXEL_T r = ((sr * sa + dr * t) + (a/2)) / a;
									OSD_PIXEL_T g = ((sg * sa + dg * t) + (a/2)) / a;
									OSD_PIXEL_T b = ((sb * sa + db * t) + (a/2)) / a;
									*des1 = DST_SetColor(a, r, g, b);
								}
							}
							des1++;
							src1++;
						}
						des += rectTemp.w;
						src += rectSrc.w;
					}
				}
			else
			{
				int yy = rectCommon.h;
				int nDataLength = rectCommon.w*sizeof(OSD_PIXEL_T);
				if (rectTemp.w == rectSrc.w)
				{
					memcpy(des, src, nDataLength * yy);
				}
				else
				{
					while (yy--)
					{
						memcpy(des, src, nDataLength);
						des += rectTemp.w;
						src += rectSrc.w;
					}
				}
			}
		}
		DST_BlockCopy(imgBuff, rectTemp.x, rectTemp.y, rectTemp.w, rectTemp.h);
		DST_ResetUpdateRegion();
	}
	return true;
}


bool bWinManagerReady = false;
bool DST_IsWinManagerReady()
{
	return bWinManagerReady;
}

static void tWinMgr()
{
	OSD_PIXEL_T tmp=0;
	DST_BlockCopy(&tmp, 0,0,1,1);
	DST_CreateWin(WIN_BASIC);
	bWinManagerReady = true;
	while (1) WinMgrSub();
}

//  Ŵ  Լ
static void PrintWindowMsg(SWinEventMsg event)
{
#if 0
	switch (event.cmd)
	{
		case WM_WIN_CREATE: DST_Printf("WM_WIN_CREATE\n"); break;
		case WM_WIN_DELETE: DST_Printf("WM_WIN_DELETE\n"); break;
		case WM_POWER_DOWN_ENTER: DST_Printf("WM_POWER_DOWN_ENTER\n"); break;
		case WM_SOURCE_FORMAT_DONE: DST_Printf("WM_SOURCE_FORMAT_DONE\n"); break;
		case WM_MANAGER_CLOSE: DST_Printf("WM_MANAGER_CLOSE\n"); break;
		case WM_SIGNAL_STATE: DST_Printf("WM_SIGNAL_STATE\n"); break;
		case WM_MTS_UPDATE: DST_Printf("WM_MTS_UPDATE\n"); break;
		case WM_MENU_LANGUAGE_CHANGE: DST_Printf("WM_MENU_LANGUAGE_CHANGE\n"); break;
		case WM_CT_MSG: DST_Printf("WM_CT_MSG\n"); break;
		case WM_FACTORY_KEYPAD: DST_Printf("WM_FACTORY_KEYPAD\n"); break;
	}
#endif
}

void DST_SendWindowEventWithOnlyCmd(int command)
{
	SWinEventMsg event;
	memset(&event, 0, sizeof(SWinEventMsg));
	event.cmd=command;
	DST_SendWindowEvent(event);
}

void DST_SendWindowEvent(SWinEventMsg event)
{
	if (!gWinEventMsgQ) return;
	PrintWindowMsg(event);
	if (gWinEventMsgQ_Count > 100)
	{
		DST_Printf("gWinEventMsgQ_Count = %d\n", gWinEventMsgQ_Count);
		return;
	}
	gWinEventMsgQ_Count++;

#if 0
	if (gWinEventMsgQ_Count > 100)
	{
		DST_Printf("DST_SendWindowEvent - event.cmd = %ld gWinEventMsg Q_Count = %d\n", event.cmd, gWinEventMsgQ_Count);
		DST_Reset((char*)__func__);
	}
#endif

	DST_OS_SendMessage(gWinEventMsgQ, (DS_U32 *)&event, sizeof(SWinEventMsg));
}

void DST_CreateWin(WinID nID, WinID nParentID, unsigned char nParameter1 , unsigned char nParameter2, unsigned char nParameter3, unsigned char nParameter4)
{
	if (nID == WIN_NULL) return;
	SWinEventMsg event;
	memset(&event, 0, sizeof(SWinEventMsg));
	event.cmd = WM_WIN_CREATE;
	event.data[0] = nID;
	event.data[1] = nParentID;
	event.data[2] = nParameter1;
	event.data[3] = nParameter2;
	event.data[4] = nParameter3;
	event.data[5] = nParameter4;
	DST_SendWindowEvent(event);
}

void DST_CreateWin2(WinID nID, WinID nParentID, unsigned long nParameter1)
{
	SWinEventMsg event;
	memset(&event, 0, sizeof(SWinEventMsg));
	event.cmd = WM_WIN_CREATE;
	event.data[0] = nID;
	event.data[1] = nParentID;
	event.data32[1] = nParameter1;
	DST_SendWindowEvent(event);
}

void DST_CloseWin(WinID nID)
{
	SWinEventMsg event;
	memset(&event, 0, sizeof(SWinEventMsg));
	event.cmd = WM_WIN_DELETE;
	event.data[0] = nID;
	DST_SendWindowEvent(event);
}

void DST_WinManagerInit(void)
{
	static int WinMngTaskID = 0;
	if (WinMngTaskID != 0) return;
	DST_RemoveAllWindows();
	DST_ResetUpdateRegion();
	gWinEventMsgQ = DST_OS_CreateMessageQueue("gWinEventMsgQ", 0/*OS_MSGQ_FIFO*/, 300/*100*/, sizeof(SWinEventMsg));
	WinMngTaskID = DST_OS_SpawnTask((void(*)(void *))tWinMgr, (char*)"tWinMgr", APP_TASK_PRIO_WIN_MGR, WIN_MGR_TASK_STACKSIZE,  0);
	T();
}
