#ifndef __DST_WINMANAGER_TASK_H__
#define __DST_WINMANAGER_TASK_H__

#include "DST_WindowType.h"

#define MAX_WIN_EVENT_MSG_LEN		32  // ݵ 4   

struct SWinEventMsg {
	unsigned long	cmd;
	union {
		unsigned char data[MAX_WIN_EVENT_MSG_LEN];
		unsigned short data16[MAX_WIN_EVENT_MSG_LEN/2];
		unsigned long data32[MAX_WIN_EVENT_MSG_LEN/4];
	};
};

int DST_GetScreenWidth();
int DST_GetScreenHeight();
bool DST_IsWinManagerReady();
void DST_WinManagerInit();
void DST_CreateWin(WinID nID, WinID nParentID = WIN_NULL, unsigned char nParameter1 = 0, unsigned char nParameter2 = 0, unsigned char nParameter3 = 0, unsigned char nParameter4 = 0);
void DST_CreateWin2(WinID nID, WinID nParentID = WIN_NULL, unsigned long nParameter1 = 0);
void DST_CloseWin(WinID nID);
void DST_SendWindowEvent(SWinEventMsg event);
void DST_SendWindowEventWithOnlyCmd(int command);
void DST_RfUpdateStart(void);
#endif
