#include "DST_WinManager.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"

#include "DST_DataStrings.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"

#include "DST_ISDBT_ChannelTask.h"
#include "DST_ChannelTune.h"
#include "DST_DB.h"
#include "DST_DB_Engine.h"

#define AS_RF_W			77
#define AS_CH_NO_W		111
#define AS_CH_NAME_W	364

#define PROGRESS_BAR_X	33
#define PROGRESS_BAR_Y	266
#define PROGRESS_BAR_W	333


class CManualSearchWin : public CWindow
{
private:
	CHANNEL_DISPLAY ch[4];
	int m_nRF; // ȭ鿡 ǥõ RF ε ȣ
	bool m_bReceiveSI; 
public:
	CManualSearchWin(SWinEventMsg event):CWindow(event)
	{
		m_nRF = DST_EEPROM_GetRF();
		m_bReceiveSI = true;
		
		rect.w = DST_GetImageWidth(newcon2_gui_autoscan_back);
		rect.h = DST_GetImageHeight(newcon2_gui_autoscan_back);
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight()- rect.h) / 2;
		
		RegisterAllKey();
		RegisterKey(VK_PWR, false);
		DST_UI_ChannelTune(m_nRF, 0);	
	}

	virtual ~CManualSearchWin()
	{
		DST_UI_ChannelTune(m_nRF, 0);	
	}
	
	void ClearChList()
	{		
		memset(ch, 0, sizeof(ch));
	}
	
	void AddChList(int rf, int major, int minor, char* name)
	{
		int nPos = 4;
		for (int i = 0; i < 4; i++)
		{
			if (strlen(ch[i].num) != 0) continue;
			nPos = i;
			break;
		}
		if (nPos > 3) 
		{
			nPos = 3;
			memcpy(&ch[0], &ch[1], sizeof(CHANNEL_DISPLAY)* 3);
		}
		if (minor == 0)
		{
			sprintf(ch[nPos].num, "%d(%d)", major, DST_GetFrequencyNumberbyIndex(rf));
		}
		else
		{
			sprintf(ch[nPos].num, "%d-%d(%d)", major, minor, DST_GetFrequencyNumberbyIndex(rf));
		}
		strcpy((char*)ch[nPos].name, (char*)name);
	}
	
	void AddChList(int RF)
	{
		CDB db;
		db.GetTable("select major, minor, name from channel_db where rf =%d order by major,minor", RF);
		if (db.GetRow() < 1) return;
		for (int i = 0; i < db.GetRow(); i++)
		{
			AddChList(RF, 
				atoi(db.GetResult((i+1)*db.GetCol()+0)), 
				atoi(db.GetResult((i+1)*db.GetCol()+1)), 
				db.GetResult((i+1)*db.GetCol()+2));
		}
	}
	
	virtual void OnTimer(char nID)
	{
		switch (nID)
		{
			case 1:
				KillTimer(1);
				ClearChList();
				AddChList(m_nRF);
				Show();
				break;
			default:
				break;
		}
	}
	
	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
				
			case WM_CT_MSG:
				switch (event.data32[0])
				{
					case CT_RECEIVE_TVCT:
					case CT_RECEIVE_CVCT:
					case CT_RECEIVE_PMT:
						m_bReceiveSI = true;
						SetTimer(1,100);
						T();
						break;
					case CT_SCAN_START:
						T();
						DST_UI_ChannelTune(m_nRF, 0);	
						break;
				}
				break;
		}
	}
	
	virtual void Show(void)
	{
		// 
		DrawImage(0, 0, newcon2_gui_manulscan_back);
		// ŸƲ
		setFontStyle(20,0xC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		// ׸ ̸  äιȣ RF ä̸ 
#if DESIGN_TYPE == 1
		DrawTextUni( 27, 10,  118, 29, pz_Scan_ChannelNumber[OSD_Lang], &font);
		DrawTextUni(174, 10, 176, 29, pz_chName[OSD_Lang], &font);
#else
		DrawTextUni( 15, 10,  160, 29, pz_Scan_ChannelNumber[OSD_Lang], &font);
		DrawTextUni(187, 10, 160, 29, pz_chName[OSD_Lang], &font);
#endif

		// ư ׸ 
		char rfNumberStr[10] = {0,};
		sprintf(rfNumberStr,"%d",DST_GetFrequencyNumberbyIndex(m_nRF));
		setFontStyle(19,0xC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		DrawTextUni(367, 18, 137, 35, pz_Scan_NoRF[OSD_Lang], &font);
		DrawText(400, 57, 69, 35, rfNumberStr, &font);
		
		DrawImage(384, 122, newcon2_gui_depth3_button_small_selected,true);
		DrawTextUni(384, 122, DST_GetImageWidth(newcon2_gui_depth3_button_small_selected), DST_GetImageHeight(newcon2_gui_depth3_button_small_selected), pz_Scan_ChannelSearch[OSD_Lang], &font);
#if DESIGN_TYPE == 1
#else
		setFontStyle(19,0x000000,ALIGN_MIDDLE,ALIGN_CENTER);
#endif

		DrawImage(384, 122, newcon2_gui_depth3_button_small_cursor,true);
		DrawTextUni(384, 122,
			DST_GetImageWidth(newcon2_gui_depth3_button_small_selected),  
			DST_GetImageHeight(newcon2_gui_depth3_button_small_selected), 
			m_bReceiveSI ? pz_Scan_ChannelSearch[OSD_Lang] : pz_Scan_Searching[OSD_Lang], 
			&font);
		setFontStyle(20,0xC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		// ׸ ǥ
		for (int i=0; i < 4; i++)
		{
			if (strlen(ch[i].num) == 0) continue;
			DS_U32* strText32 = DST_UTF82Uni((DS_U8*)ch[i].name); // ȣ ʿ ޸ 
			// ä ȣ , RF
#if DESIGN_TYPE == 1
			DrawText( 27, 10+(i+1)*36,	118, 29,  ch[i].num, &font);
			// ä ̸
			DrawText32(174, 10+(i+1)*36, 174, 29, strText32, &font);
#else
			DrawText( 15, 10+(i+1)*36,	160, 29,  ch[i].num, &font);
			// ä ̸
			DrawText32(187, 10+(i+1)*36, 160, 29, strText32, &font);
#endif
		}
	}


	virtual void KeyInput(unsigned char key, bool /*bRepeat*/)
	{
		switch(key)
		{
			case VK_UP:
				m_bReceiveSI = true;
				m_nRF+=10;
				if (m_nRF > DST_MaxRF()) m_nRF = DST_MinRF();
				ClearChList();	
				AddChList(m_nRF);
				Show();
				DST_UI_ChannelTune(m_nRF, 0);		
				break;
			case VK_DN:
				m_bReceiveSI = true;
				m_nRF-=10;
				if(m_nRF < DST_MinRF()) m_nRF = DST_MaxRF();
				ClearChList();	
				AddChList(m_nRF);
				Show();	
				DST_UI_ChannelTune(m_nRF, 0);	
				break;
			case VK_RIGHT:
				//JST_Stop();
				m_bReceiveSI = true;
				m_nRF++;
				if (m_nRF > DST_MaxRF()) m_nRF = DST_MinRF();
				ClearChList();	
				AddChList(m_nRF);
				Show();	
				DST_UI_ChannelTune(m_nRF, 0);	
				break;
			case VK_LEFT:
				//JST_Stop();
				m_bReceiveSI = true;
				m_nRF--;
				if(m_nRF < DST_MinRF()) m_nRF = DST_MaxRF();
				ClearChList();	
				AddChList(m_nRF);
				Show();	
				DST_UI_ChannelTune(m_nRF, 0);	
				break;
		case VK_OK:
				JST_Stop();
				m_bReceiveSI = false;
				JST_DB_Del(m_nRF);
				ClearChList();
				Show();	
				//DST_UI_ChannelTune(m_nRF, 0);
				// DST_UI_ChannelTune ϸ  äο   õ   ʴ´.
				// 켱 ĵ ȣϰ ĵ  ݹ鿡 Ʃ Ѵ.
				JST_Scan(m_nRF);	
				break;
			case VK_CANCEL:
			case VK_MENU:
				Close();
				break;
		}
	}
};

void DST_CreateManualSearchWin(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CManualSearchWin(event));
}

