#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"

#if 0
____CPowerDownCautionWin___()
#endif

#define MAX_SECONDS 60
class CPowerDownCautionWin : public CWindow
{
private:
	bool needShutDown;
	int nMaxWidth;
	int nCoundDown;
public:
	CPowerDownCautionWin(SWinEventMsg event):CWindow(event)
	{
		setFontStyle(20, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_LEFT);
		needShutDown = false;
		nMaxWidth = 0;
		nCoundDown = MAX_SECONDS;
		GetTextNWidth(&nMaxWidth,nCoundDown,font.GetSize());

		rect.w = 9+DST_GetImageWidth(bracon_gui_caution)+10+nMaxWidth+10;
		rect.h = 92;
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = DST_GetScreenHeight()*9/10 - rect.h;

		SetTimeOut(0);
	}
	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
		}
	}
	virtual ~CPowerDownCautionWin()
	{
		if(needShutDown) DST_SendWindowEventWithOnlyCmd(WM_POWER_OFF);
	}
	
	DS_U16* GetTextNWidth(int *textWidth, int countDown, int fontSize)
	{
		static DS_U16	final[100];
		memset(final,0,sizeof(final));
		strcpy16(final, (countDown>1)?pz_PowerDownCountDown_P1[OSD_Lang]:pz_PowerDownCountDown_S1[OSD_Lang]);
		char  tmpStr[10];
		memset(tmpStr,0,sizeof(tmpStr));
		sprintf(tmpStr," %d ", countDown);
		str2uni(&final[strlen16(final)], (char *)tmpStr);
		strcpy16(&final[strlen16(final)], (countDown>1)?pz_PowerDownCountDown_P2[OSD_Lang]:pz_PowerDownCountDown_S2[OSD_Lang]);

		*textWidth = DST_GetTextWidthUni(final,fontSize);

		int nStrLen = 0;
		for(int i=0;i<100;i++)
		{
			if(final[i]==0) break;
			nStrLen++;
		}
		DS_U16* fianlStr = (DS_U16*)DST_OS_Malloc((nStrLen+1) * sizeof(DS_U16));
		memset(fianlStr, 0, (nStrLen+1) * sizeof(DS_U16));
		memcpy(fianlStr,final,(nStrLen+1) * sizeof(DS_U16));
		return fianlStr;
	
	}
	
	virtual void Show(WinID id)
	{
		DST_Printf("id=%d\n",id);
		switch(id)
		{
			case WIN_ERROR:
			case WIN_POWER_DOWN_CAUTION:
				break;
			default:
				KillTimer(1);
				Close();
				break;
		}
	}

	virtual void Show()
	{

		DrawBox32(0, 0, rect.w, rect.h, CONV32_16(0xFF262626));
		DrawImage(9, 9, bracon_gui_caution,true);
		
		int nWidth = 0;
		DS_U16* str = GetTextNWidth(&nWidth, nCoundDown, font.GetSize());		
		DrawTextUni(9+DST_GetImageWidth(bracon_gui_caution)+10, 0, nMaxWidth, rect.h, str, &font); 
		DST_OS_Free(&str);
		SetTimer(1, 1000);

	}	

	virtual void OnTimer(char nID)
	{
		switch(nID)
		{
			case 1:
				KillTimer(1);
				UpdateScreen();
				nCoundDown--;
				if(nCoundDown == 0)
				{
					needShutDown = true;
					Close();
					return;
				}
				Show();
				UpdateScreen();
				break;
		}
	}	

};


void DST_CreatePowerDownCautionWin(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CPowerDownCautionWin(event));
}

