#include "DST_WinManager.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"
#include "DST_DataStrings.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DB.h"

DS_U32* DST_UTF82Uni(DS_U8 *utf);

static DS_U32 g_StartTime = 0; //  EPG  Detail â ٰ   Ŀ Ű 
static int    g_Pos = 0; // EPG  Detail â ٰ   Ŀ ġ Ű 
static EPG_DB g_Event; // EPG â  â ѱ 

#define MAX_LINES (100) // ִ 100 

class CProgramGuideDetailWin : public CWindow
{
private:
	int cursor;
	int nLines;
	bool bTitle[MAX_LINES]; //  
	DS_U32* MultiLine[MAX_LINES]; // 
	STime_t st;
public:
	CProgramGuideDetailWin(SWinEventMsg event):CWindow(event)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_detailedinfo_back);
		rect.h = DST_GetImageHeight(newcon2_gui_detailedinfo_back);
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight()- rect.h) / 2;
		cursor = 0;
		nLines = 0;
		for (int i = 0; i < MAX_LINES; i++) MultiLine[i] = 0;
//		if (g_Event.title > 0) //  bold
//		{
//			DS_U32* strTemp = DST_UTF82Uni((DS_U8*)g_Event.title);
			//DST_Printf("len: %d, cal len: %d, %s\n",g_Event.title_name_length,strlen((char*)g_Event.title),g_Event.title);
//			SetMultiLineText(strTemp, strlen32(strTemp), 528, fontItemSize, true);
//			DST_OS_Free(&strTemp);
//		}
		if (g_Event.text > 0) // ֳ normal
		{
			DS_U32* strTemp = DST_UTF82Uni((DS_U8*)g_Event.text);
//			DST_Printf("len: %d, cal len: %d, %s\n",g_Event.title_text_length,strlen((char*)g_Event.text),g_Event.text);
			if(strlen32(strTemp) > 0)
			{
				SetMultiLineText(strTemp, strlen32(strTemp), 528, fontItemSize, false);
			}
			else
			{
				DS_U32 strTemp1[200] = {0,};
				uni232(strTemp1,pz_ProgramGuide_No[OSD_Lang]);
				SetMultiLineText(strTemp1, strlen32(strTemp1), 528, fontItemSize, false);
			}
			//DST_OS_Free(&strTemp);
		}
		

	}
	//   Ͽ پ ߶ ͸ Ѵ.
	void InsertMultiLineText(DS_U32 *strBuff, DS_U16 nStrLen, bool bBold)
	{
		if (nLines >= MAX_LINES-1) return;
		if (nStrLen > 0)
		{
			MultiLine[nLines] = (DS_U32*)DST_OS_Malloc((nStrLen+1) * sizeof(DS_U32));
			memcpy(MultiLine[nLines], strBuff, nStrLen * sizeof(DS_U32));
			MultiLine[nLines][nStrLen] = 0;
		}
		bTitle[nLines] = bBold;
		nLines++;
	}
	//  ڿ  ߶󳽴.
	int SetMultiLineText(DS_U32 *strBuff, DS_U16 nStrLen, int width, DS_U8 nSize, bool bBold)
	{
		if (nStrLen < 1) return 0;
		int nSpacePos = -1;
		
		for (int i = 0; i < nStrLen; i++)
		{
			if (strBuff[i] == 0x0D)
			{
				if (((i+1) < nStrLen) && strBuff[i+1] == 0x0A)
				{
					InsertMultiLineText(strBuff,i, bBold);
					return SetMultiLineText(strBuff+(i+2), nStrLen-(i+2), width, nSize, bBold) + 1;
				}
				InsertMultiLineText(strBuff,i, bBold); 
				return SetMultiLineText(strBuff+(i+1), nStrLen-(i+1), width, nSize, bBold) + 1;
			}
			if ((strBuff[i] == 0x0A))
			{
				InsertMultiLineText(strBuff,i, bBold); 
				return SetMultiLineText(strBuff+(i+1), nStrLen-(i+1), width, nSize, bBold) + 1;
			}
		
			if (DST_GetTextWidth32(strBuff, i + 1, nSize) > width)
			{
				if (strBuff[i-1] == 0x20 ||nSpacePos == -1)
				{
					InsertMultiLineText(strBuff,i, bBold);
					return SetMultiLineText(strBuff+(i), nStrLen-(i), width, nSize, bBold) + 1;
				}
				InsertMultiLineText(strBuff, nSpacePos + 1, bBold);
				return SetMultiLineText(strBuff+(nSpacePos + 1), nStrLen-(nSpacePos + 1), width, nSize, bBold) + 1;
			}
			if (strBuff[i] == 0x20) nSpacePos = i;
		}
		InsertMultiLineText(strBuff, nStrLen, bBold);
		return 1;
	}
	
	virtual ~CProgramGuideDetailWin()
	{
		for (int i = 0; i < MAX_LINES; i++) if (MultiLine[i]) DST_OS_Free(&MultiLine[i]);
	}
	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
		}
	}
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:	
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_OTC_DOWNLOAD:
			case WIN_OTC_DOWNLOAD_FAIL:
			case WIN_UPDATE:
			case WIN_UPDATE_RESET:				
//			case WIN_PROGRAM_GUIDE:
				Close();
				break;
			default:
				break;
		}
	}
	void DrawScrollBar3(int x, int y, int h, int total_count, int page_count, int page_start)
	{
		if (total_count <= page_count) return;
		int nScrollPosition = total_count - page_count;
		int ScrollHeight = h/nScrollPosition;
		DST_Printf("nScrollPosition : %d h/nScrollPosition : %d/%d == %d y+page_start*ScrollHeight = %d\n",nScrollPosition,h,nScrollPosition ,ScrollHeight,y+page_start*ScrollHeight);
		DrawImage(x,y+page_start*ScrollHeight,newcon2_gui_scroll_button,true);
	}

	virtual void Show()
	{
		// 
		DrawImage(0, 0, newcon2_gui_detailedinfo_back);
		// window title
		// program title
		setFontStyle(20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);

		int rf = DST_EEPROM_GetRF();
		if (g_Event.title != 0)
		{
			if (g_Event.title) DrawTextUTF8(15, 43, 528, 29, (DS_U8*)g_Event.title, &font);

		}
		// ä ̸ ǥ			
		DS_U32 ChInfo[40]={0};
		DST_UI_GetCurrentChannelInfo(ChInfo);
		setFontStyle(20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);
		DrawText32(15, 11, 365, 29, ChInfo,  &font);
		
		// ð ǥ
		setFontStyle(20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_RIGHT);
		DS_U32 curTime = DST_GetCurrentUTCTime();
		DS_U16 CurrTime[50] = {0,};
		strcpy16(CurrTime, DST_GetTimeString(curTime,DATE_NO_YEAR_TIME_NO_SEC_DETAIL,true,DST_g_TimeOffset[rf]));
		DrawTextUni(0, 11, 536, 29,  CurrTime, &font);		

		
		setFontStyle(20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);

		//program time
		DS_U32 endTime = g_Event.start_time +g_Event.duration;
		DS_U16 time[110] = {0,};
		strcpy16(time, DST_GetTimeString(g_Event.start_time,DATE_NO_YEAR_TIME_NO_SEC_DETAIL,true,DST_g_TimeOffset[rf]));
		strcat16(time, (char *)" - ");
		strcat16(time, DST_GetTimeString(endTime,TIME_NO_SEC,true,DST_g_TimeOffset[rf]));
		DrawTextUni(15, 80, 482, 29, time, &font); 

		
		// program text
		for (int i=0; i < 6; i++)
		{
			if (MultiLine[cursor+i] == 0) continue;
			DrawText32(15, 117+36*i, 528, 29, MultiLine[cursor+i], &font);
		}
		// ũѹ
		if (nLines > 6) DrawScrollBar3(560, 103, 213, nLines, 6, cursor);
		// Ű ̵
		setFontStyle(20,0xFF8C8C8C,ALIGN_MIDDLE,ALIGN_CENTER);
		DS_U16	final[20];
		memset(final,0,sizeof(final));
		strcpy16(final, pz_Edit_Menu[OSD_Lang]);
		str2uni(&final[strlen16(final)], (char *)" : ");
		strcpy16(&final[strlen16(final)], pz_Edit_Exit[OSD_Lang]);
		DrawTextUni(17, 340, 142, 29, final, &font);

		UpdateScreen();
		
		RegisterKey(VK_MENU, true);
		RegisterKey(VK_UP, true);
		RegisterKey(VK_DN, true);
		RegisterKey(VK_LEFT, true);
		RegisterKey(VK_RIGHT, true);
		RegisterKey(VK_OK, true);
		RegisterKey(VK_EPG, true);
		RegisterKey(VK_CANCEL, true);
		RegisterKey(VK_PREV, true);
		RegisterKey(VK_PREV_MENU, true);
	}
	
	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_UP:
				if (nLines <= 6) break;
				if (cursor == 0) break;
				cursor--;
				Show();
				break;
				
			case VK_DN:
				if (nLines <= 6) break;
				if (cursor == nLines-6) break;
				cursor++;
				Show();
				break;

			case VK_RIGHT:
			case VK_OK:
				// ڰ 2̸  ġ ϸ鼭 EPG ׸  
				DST_CreateWin(WIN_PROGRAM_GUIDE, GetParentWinID(), 2); 
				Close();
				break;
				
			default:
				DST_CreateWin(WIN_PROGRAM_GUIDE, GetParentWinID(), 2); 
				Close();
				break;
		}    
	}
};

class CProgramGuideWin : public CWindow
{
private:
	int start;
	int cursor;
	int EventNum;
	EPG_DB *Events;
	DS_U8 event_parameter2;
public:
	CProgramGuideWin(SWinEventMsg event):CWindow(event)
	{
		
		rect.w = DST_GetImageWidth(newcon2_gui_epg_back);
		rect.h = DST_GetImageHeight(newcon2_gui_epg_back);
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight()- rect.h) / 2;
		start  = 0;
		cursor = 0;
		event_parameter2 = event.data[2];
		EventNum = 0;
		Events = 0;
		InitEPG();
	}

	virtual ~CProgramGuideWin()
	{
		if (Events) DST_EPG_DB_Free(Events, EventNum);
	}
	
	virtual void OnTimer(char /*nID*/)
	{
		// úд ǥ ð ŵǸ ȭ Ѵ.
		InitEPG();
		Show();
	}

	void InitEPG()
	{

		if (Events) 
		{
			DST_EPG_DB_Free(Events, EventNum);
			Events = 0;
		}
		Events = DST_EPG_DB_Get(&EventNum);
		int tmpEventNum = 0;
		for (int i = 0; i < EventNum; i++) if (strlen((char *)Events[i].title) == 0 && strlen((char *)Events[i].text) == 0) tmpEventNum--;

		if(EventNum != tmpEventNum)
		{
			tmpEventNum = EventNum;
			EPG_DB *tmpEvents = (EPG_DB*)DST_OS_Calloc(tmpEventNum, sizeof(EPG_DB));
			int nPos = 0;
			for (int i = 0; i < EventNum; i++)
			{
				if (strlen((char *)Events[i].title) == 0 && strlen((char *)Events[i].text) == 0) continue;
//				memcpy(&tmpEvents[nPos], &Events[i],sizeof(EPG_DB));
				tmpEvents[nPos].source_id= Events[i].source_id;
				tmpEvents[nPos].event_id= Events[i].event_id;
				tmpEvents[nPos].start_time= Events[i].start_time;
				tmpEvents[nPos].duration= Events[i].duration;
				strcpy((char*)tmpEvents[nPos].title, (char*)Events[i].title);
				tmpEvents[nPos].text = (char*)DST_OS_Calloc(strlen(Events[i].text)+1, 1);
				strcpy((char*)tmpEvents[nPos].text, (char*)Events[i].text);
				nPos++;
			}		
			if (EventNum > 0) DST_EPG_DB_Free(Events, EventNum);
			Events = (EPG_DB*)DST_OS_Calloc(tmpEventNum, sizeof(EPG_DB));
			memcpy(Events, tmpEvents,tmpEventNum*sizeof(EPG_DB));
			EventNum = tmpEventNum;

		}

		DST_Printf("CProgramGuideWin EventNum = %d\n", EventNum);
		if (event_parameter2 == 2) //  ġ 
		{
			for (int i = 0; i < EventNum; i++)
			{
				if (Events[i].start_time != g_StartTime) continue;
				cursor = i;
				start = cursor - g_Pos;
				if (start < 0) start = 0;
				event_parameter2 = 0;
				break;
			}
		}
		
	}
	
	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
		}
	}
	
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_OTC_DOWNLOAD:
			case WIN_OTC_DOWNLOAD_FAIL:
			case WIN_UPDATE:
			case WIN_UPDATE_RESET:

//			case WIN_PROGRAM_GUIDE:
				Close();
				break;
			default:
				break;
		}
	}
	void DrawScrollBar3(int x, int y, int h, int total_count, int page_count, int page_start)
	{
		if (total_count <= page_count) return;
		int nScrollPosition = total_count - page_count;
		int ScrollHeight = h/nScrollPosition;
		DST_Printf("nScrollPosition : %d h/nScrollPosition : %d/%d == %d y+page_start*ScrollHeight = %d\n",nScrollPosition,h,nScrollPosition ,ScrollHeight,y+page_start*ScrollHeight);
		DrawImage(x,y+page_start*ScrollHeight,newcon2_gui_scroll_button,true);
	}
	virtual void Show()
	{
		// 
		DrawImage(0, 0, newcon2_gui_epg_back);
		// ŸƲ ä
		// ΰ ǥ
		//DS_U8 pImage[72*36];
		//char strLogo[6] = "";
		//DS_U8 nWidth = 0;
		//DS_U8 nHeight = 0;
		int xPos = 0;
		//int yPos = 0;
		
		DS_U8  RF= 0;
		DS_U16 sID = 0;
		DST_GetAVState(&RF, 0, &sID);
		// ä ̸ ǥ			
		DS_U32 ChInfo[40]={0};
		DST_UI_GetCurrentChannelInfo(ChInfo);
		setFontStyle(20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);
		int nTextWidth = DST_GetTextWidth32(ChInfo, strlen32(ChInfo), fontTitleSize);
		xPos = (rect.w - nTextWidth) / 2;
		DrawText32(15, 43, 365, 29, ChInfo,  &font);
		// ð ǥ
		setFontStyle(20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_RIGHT);
		DS_U32 curTime = DST_GetCurrentUTCTime();
		DS_U16 time[50] = {0,};
		strcpy16(time, DST_GetTimeString(curTime,DATE_NO_YEAR_TIME_NO_SEC_DETAIL,true,DST_g_TimeOffset[RF]));
		DrawTextUni(0, 11, 536, 29, time, &font);		
		// EPG ̺Ʈ ǥ
		
		if (EventNum > 0)
		{
			int listNum = EventNum > 7 ? 7 : EventNum;
			int listPos = cursor - start;
#if DESIGN_TYPE == 1
			DrawBox32(7, 79+36*listPos, 221, 33, CONV32_16(0xFF234B9C));
			DrawBox32(232, 79+36*listPos, 319, 33, CONV32_16(0xFF234B9C));
#else
			DrawBox32(12, 79+36*listPos, 217, 33, CONV32_16(0xFF234B9C));
			DrawBox32(232, 79+36*listPos, 319, 33, CONV32_16(0xFF234B9C));
#endif

			for (int i=0; i < listNum; i++)
			{
				setFontStyle(20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
				DS_U32 endTime = Events[start+i].start_time + Events[start+i].duration;
				DS_U16 time[110] = {0,};
				strcpy16(time, DST_GetTimeString(endTime,AMPM,true,DST_g_TimeOffset[RF]));
				strcat16(time, (char *)" ");
				strcat16(time, DST_GetTimeString(Events[start+i].start_time,TIME_NO_SEC_NO_AMPM,true,DST_g_TimeOffset[RF]));
				strcat16(time, (char *)" - ");
				strcat16(time, DST_GetTimeString(endTime,TIME_NO_SEC_NO_AMPM,true,DST_g_TimeOffset[RF]));
				DrawTextUni(15, 81+36*i, 205, 29, time, &font); 

				setFontStyle(20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);
				if (Events[start+i].title) DrawTextUTF8(238, 81+36*i, 315, 29, (DS_U8*)Events[start+i].title, &font);
			}
		}
		// ũѹ
		if (EventNum > 7) DrawScrollBar3(560, 76, 250, EventNum, 7, start);
		// Ű ̵
		setFontStyle(20,0xFF8C8C8C,ALIGN_MIDDLE,ALIGN_CENTER);
		DS_U16	final[20];
		memset(final,0,sizeof(final));
		strcpy16(final, pz_Edit_Menu[OSD_Lang]);
		str2uni(&final[strlen16(final)], (char *)" : ");
		strcpy16(&final[strlen16(final)], pz_Edit_Exit[OSD_Lang]);
		DrawTextUni(17, 340, 142, 29, final, &font);

		memset(final,0,sizeof(final));
		strcpy16(final, pz_Edit_OK[OSD_Lang]);
		str2uni(&final[strlen16(final)], (char *)" : ");
		strcpy16(&final[strlen16(final)], pz_EPG_Detail[OSD_Lang]);
		DrawTextUni(170, 340, 200, 29, final, &font);
		
		UpdateScreen();
		
		RegisterKey(VK_MENU, true);
		RegisterKey(VK_UP, true);
		RegisterKey(VK_DN, true);
		RegisterKey(VK_LEFT, true);
		RegisterKey(VK_RIGHT, true);
		RegisterKey(VK_OK, true);
		RegisterKey(VK_EPG, true);
		RegisterKey(VK_CANCEL, true);
		RegisterKey(VK_PREV, true);
		RegisterKey(VK_PREV_MENU, true);
		SetTimer(1,1000); // ð  Ȯϴٰ д Ǹ ð踦 ٽ ׸
	}

	//  â ѱ Ŀ ͸  Ѵ.
	void SetEPGDetail()
	{
		g_Event.source_id= Events[cursor].source_id;
		g_Event.event_id= Events[cursor].event_id;
		g_Event.start_time = Events[cursor].start_time;
		g_Event.duration = Events[cursor].duration;
		
		strcpy((char*)g_Event.title, (char*)Events[cursor].title);
		if (g_Event.text) DST_OS_Free(&g_Event.text);
		g_Event.text = (char*)DST_OS_Calloc(strlen(Events[cursor].text)+1,1);
		strcpy(g_Event.text, Events[cursor].text);

		g_StartTime = Events[cursor].start_time; // ƿö  ġ Ѵ.
		g_Pos = cursor - start; // ƿö  ġ Ѵ.
	}
	
	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_UP:
				if (cursor == 0) break;
				cursor--;
				if (start > cursor) start = cursor;
				Show();
				break;
				
			case VK_DN:
				if (cursor >= EventNum - 1) break;
				cursor++;
				if (start < cursor - 6) start = cursor - 6;
				Show();
				break;
				
			case VK_OK:
			case VK_RIGHT:
				if (EventNum < 1) break;
				//  â ѱ Ŀ ͸  Ѵ.
				SetEPGDetail();
				DST_CreateWin(WIN_PROGRAM_GUIDE, GetParentWinID(), 1); 
				Close();
				break;
				
			default:
				if (GetParentWinID()) DST_CreateWin(GetParentWinID());
				Close();
				break;
		}    
	}
};

void DST_CreateProgramGuideWin(SWinEventMsg event)
{
	if (DST_DB_PresentChMap() == false) return; 
	
	if (event.data[2] == 1)
	{
		DST_AddWin((WinID)(event.data[0]), new CProgramGuideDetailWin(event));
	}
	else
	{
		DST_AddWin((WinID)(event.data[0]), new CProgramGuideWin(event));
	}
}
