#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"

#if 0
____CMovingBannerWin___()
#endif


class CErrorWin : public CWindow
{
private:
	DS_U8 nErrorNumber;
	DS_U8 nParameter;
	int nWidth;
public:
 	CErrorWin(SWinEventMsg event):CWindow(event)
	{
		nErrorNumber 	= event.data[2];
		nParameter 	= event.data[3];
		nWidth = 0;
		switch(nErrorNumber)
		{
			case SM_AUDIO_ONLY:
			case SM_NO_PROGRAM:
			case SM_WEAK_SIGNAL:
				{
					
					switch(nErrorNumber)
					{
						case SM_AUDIO_ONLY: nWidth = DST_GetTextWidthUni(pz_AudioChannel[OSD_Lang],30); break;
						case SM_NO_PROGRAM: nWidth = DST_GetTextWidthUni(pz_NoProgram[OSD_Lang],30); break;
						case SM_WEAK_SIGNAL: nWidth = DST_GetTextWidthUni(pz_WeakSignal[OSD_Lang],30); break;
					}
					
					rect.w = 9+DST_GetImageWidth(bracon_gui_caution)+10+nWidth+10;
					rect.h = 92;
					GetPos();
				}
				break;
		}

		SetTimeOut(0);
	}
	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
		}
	}
	virtual ~CErrorWin()
	{
	}
	
	virtual void OnTimer(char /*nID*/)
	{
		UpdateScreen();
		GetPos();
		UpdateScreen();
	}	
	void GetPos()
	{
		static DS_U8 nPos = 0;
		int x = 0, y = 0;
		int sw = DST_GetScreenWidth();
		int sh = DST_GetScreenHeight();
		int iw = rect.w;
		int ih = rect.h;
		switch (nPos)
		{
			case 0: x = sw*2/4; y = sh*2/4; break;
			case 1: x = sw*1/4; y = sh*1/4; break;
			case 2: x = sw*3/4; y = sh*1/4; break;
			case 3: x = sw*1/4; y = sh*3/4; break;
			case 4: x = sw*3/4; y = sh*3/4; break;
		}
		x-=(iw / 2);
		y-=(ih / 2);
		int min_x = sw/10;
		int min_y = sh/10;
		int max_x = (sw*9/10) - iw;
		int max_y = (sh*9/10) - ih;
		if (x < min_x) x = min_x;
		if (y < min_y) y = min_y;
		if (x > max_x) x = max_x;
		if (y > max_y) y = max_y;
		nPos = (nPos >= 4) ? 0 : nPos + 1;
		rect.x=x; rect.y=y;
	}


	virtual void Show()
	{
		// 
		switch (nErrorNumber)
		{
			case SM_AUDIO_ONLY:
			case SM_NO_PROGRAM:
			case SM_WEAK_SIGNAL:
			DrawBox32(0, 0, rect.w, rect.h, CONV32_16(0x00FFFFFF));
				DrawImage(9, 9, bracon_gui_caution,true);
				break;

		}
		
		setFontStyle(25,0xFF000000,ALIGN_MIDDLE,ALIGN_CENTER);
		// ڿ
		DST_Printf("nWidth = %d\n",nWidth);
		switch (nErrorNumber)
		{
			case SM_AUDIO_ONLY: 
				DrawTextUni(11+DST_GetImageWidth(bracon_gui_caution)+10, 2, nWidth, rect.h-2, pz_AudioChannel[OSD_Lang], &font); 
				setFontStyle(25,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
				DrawTextUni(9+DST_GetImageWidth(bracon_gui_caution)+10, 0, nWidth, rect.h-2, pz_AudioChannel[OSD_Lang], &font);
				SetTimer(1, 1000);

				break;
			case SM_NO_PROGRAM: 
				DrawTextUni(11+DST_GetImageWidth(bracon_gui_caution)+10, 2, nWidth, rect.h-2, pz_NoProgram[OSD_Lang], &font);
				setFontStyle(25,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
				DrawTextUni(9+DST_GetImageWidth(bracon_gui_caution)+10, 0, nWidth, rect.h-2, pz_NoProgram[OSD_Lang], &font);
				SetTimer(1, 1000);
				break;
			case SM_WEAK_SIGNAL: 
				DrawTextUni(11+DST_GetImageWidth(bracon_gui_caution)+10, 2, nWidth, rect.h-2, pz_WeakSignal[OSD_Lang], &font);
				setFontStyle(25,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
				DrawTextUni(9+DST_GetImageWidth(bracon_gui_caution)+10, 0, nWidth, rect.h-2, pz_WeakSignal[OSD_Lang], &font);
				SetTimer(1, 1000);

				break;
		}
		
	}

	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
		//			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
			case WIN_STATION_SEARCH:
			case WIN_PASSWD_CHANGE:
		//			case WIN_PASSWD_CHECK:
		//			case WIN_PASSWD_CONFIRM:
				Close();
				break;
			case WIN_PASSWD_CHECK:
			case WIN_PASSWD_CONFIRM:
				SetVisible(false);
				break;
			default:
				break;
		}
	}
};

void DST_CreateErrorWin(SWinEventMsg event)
{
	static DS_U8 nState = 0;
//	DST_Printf("DST_GetWin(WIN_ERROR)=%d nState=%d  event.data[2]=%d\n",DST_GetWin(WIN_ERROR),nState, event.data[2]);
	if (DST_GetWin(WIN_ERROR) != 0  && nState == event.data[2]) return; // ̹ ó̶ 
	
	if (DST_GetWin(WIN_EWS)) return;
	if (DST_GetWin(WIN_CHANNEL_BANNER)) return;
	if (DST_GetWin(WIN_DIRECT_TUNE)) return;
	if (DST_GetWin(WIN_VOLUME)) return;
	if (DST_GetWin(WIN_VOLUME_MUTE)) return;
	if (DST_GetWin(WIN_SIGNAL_METER)) return;
	if (DST_GetWin(WIN_CLOSED_CAPTION_HOT)) return;
	if (DST_GetWin(WIN_AUDIO_HOT)) return;
	if (DST_GetWin(WIN_DISPLAY_MODE_HOT)) return;
	if (DST_GetWin(WIN_FACTORY_RESET)) return;
	if (DST_GetWin(WIN_FACTORY_RESET_ASK)) return;
//	if (DST_GetWin(WIN_INFOR_BANNER)) return;
	if (DST_GetWin(WIN_MAIN_MENU)) return;
	if (DST_GetWin(WIN_POWER_DOWN_CAUTION)) return;
	if (DST_GetWin(WIN_SUB_MENU_2DEPTH)) return;
	if (DST_GetWin(WIN_SUB_MENU_3DEPTH)) return;
	if (DST_GetWin(WIN_AUTO_SEARCH)) return;
	if (DST_GetWin(WIN_MANUAL_SEARCH)) return;
	if (DST_GetWin(WIN_CHANNEL_LIST)) return;
	if (DST_GetWin(WIN_PROGRAM_GUIDE)) return;
	if (DST_GetWin(WIN_PASSWD_CHANGE)) return;
	if (DST_GetWin(WIN_PASSWD_CHECK)) return;
	if (DST_GetWin(WIN_PASSWD_CONFIRM)) return;
	if (DST_GetWin(WIN_AGE_RATING)) return;
//	T();
	nState = event.data[2];
	DST_AddWin((WinID)(event.data[0]), new CErrorWin(event));
}
