#include "DST_Window.h"
#include "DST_WinManager.h"
#include "DST_DataStrings.h"
#include "DST_CommonAPI.h"
#include "DST_EEPROM.h"
#include "DST_ChannelTune.h"
#include "DST_UserInterface.h"
#include "DST_Updates.h"
#include "DST_OSDImage.h"

#if 0
____CMessageWin___()
#endif

extern unsigned char imgpin_change_back[]; 

class CUpdateWin : public CWindow
{
private:
	bool bDone;
	bool bNeedLine;
	int progress;
	int center_pos;
	int line_spacing;	

	int nBlock;
	int nErr;
	int ErrCategory;
	int category;
	
public:
	CUpdateWin(SWinEventMsg event):CWindow(event)
	{
	
		DST_g_RFUpdateState = 0;
		rect.w = 382; 
		rect.h = 241;  
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight()- rect.h) / 2;

		DST_Printf("\n\n--------------------------WIN_UPDATE----------------------------------\n\n");
		

		center_pos =  rect.h / 2; 
		line_spacing = DST_GetFontHeight(fontItemSize) * 150 / 100;

		nErr = 0;
		ErrCategory = 0;
		category = 0;
		bNeedLine = false;
//		RegisterAllKey();
		SetTimeOut(0);
		bDone = false;
		progress = 0;
	}
	virtual void OnTimer(char nID)
	{
		switch(nID)
		{
			case 1:
				DST_Printf("nErr : %d \n",nErr);
				KillTimer(1);
				DrawBox32(0, 0, rect.w, rect.h, CONV32_16(0xff24435e));
				switch(ErrCategory)
				{
					case UPDATE_BOOTLOADER:
						DrawTextUni(0, center_pos-line_spacing, rect.w, line_spacing, pz_Updating_Cat_1[OSD_Lang], &font); 
						break;
					case UPDATE_APPLICATION:
						DrawTextUni(0, center_pos-line_spacing, rect.w, line_spacing, pz_Updating_Cat_4[OSD_Lang], &font); 
						break;
					case UPDATE_APPLICATION0:
						DrawTextUni(0, center_pos-line_spacing, rect.w, line_spacing, pz_Updating_Cat_4_1[OSD_Lang], &font); 
						break;
					case UPDATE_APPLICATION1:
						DrawTextUni(0, center_pos-line_spacing, rect.w, line_spacing, pz_Updating_Cat_4_2[OSD_Lang], &font); 
						break;
					case UPDATE_VERSION_READ:
						DrawTextUni(0, center_pos-line_spacing, rect.w, line_spacing, pz_Updating_Cat_5[OSD_Lang], &font); 
						break;
					default:
						break;
				}
				
				switch(nErr)
				{
					case WRITE_FLASH_FAIL:
						DrawTextUni(0, (bNeedLine?center_pos:0), rect.w, (bNeedLine?line_spacing:rect.h), pz_Update_Err_301[OSD_Lang], &font);
						break;
					case CRC_FLASH_BOOTLOADER_FAIL:
						DrawTextUni(0, (bNeedLine?center_pos:0), rect.w, (bNeedLine?line_spacing:rect.h), pz_Update_Err_401[OSD_Lang], &font);
						break;
					case CRC_FLASH_APPLICATION_FAIL:
						DrawTextUni(0, (bNeedLine?center_pos:0), rect.w, (bNeedLine?line_spacing:rect.h), pz_Update_Err_402[OSD_Lang], &font);
						break;
					case CRC_READ_BOOTLOADER_FAIL:
						DrawTextUni(0, (bNeedLine?center_pos:0), rect.w, (bNeedLine?line_spacing:rect.h), pz_Update_Err_403[OSD_Lang], &font);
						break;
					case CRC_READ_APPLICATION_FAIL:
						DrawTextUni(0, (bNeedLine?center_pos:0), rect.w, (bNeedLine?line_spacing:rect.h), pz_Update_Err_404[OSD_Lang], &font);
						break;
					case CRC_READ_TOTAL_FAIL:
						DrawTextUni(0, (bNeedLine?center_pos:0), rect.w, (bNeedLine?line_spacing:rect.h), pz_Update_Err_405[OSD_Lang], &font);
						break;
						break;
					case UPDATE_CHECKING_CRC:
						DrawTextUni(0, center_pos-line_spacing, rect.w, line_spacing, pz_Updating_4[OSD_Lang], &font); 
						DrawTextUni(0, center_pos, rect.w, line_spacing, pz_Updating_5[OSD_Lang], &font); 
						break;
					case UPDATE_FINISHED:
						DrawTextUni(0, center_pos-line_spacing-line_spacing/2, rect.w, line_spacing, pz_Updating_6[OSD_Lang], &font);
						DrawTextUni(0, center_pos-line_spacing/2, rect.w, line_spacing, pz_finished2[OSD_Lang], &font);
						DrawTextUni(0, center_pos+line_spacing-line_spacing/2, rect.w, line_spacing, pz_finished[OSD_Lang], &font);
						break;
					default:
						break;
				}
				if(nErr == UPDATE_FINISHED || nErr == UPDATE_CHECKING_CRC)
				{
					DST_g_LED_PowerState = 2;
					
					SetTimer(2,5000);
				}
				else
				{
					DST_g_LED_PowerState = 1;
				}
				UpdateScreen();	
				break;
			case 2:
				Close();
				DST_CreateWin(WIN_UPDATE_RESET);
				break;
			default:
				break;
		}
	}

	void DrawProgressBar(DS_U32 nPos, DS_U32 nTotal, int x, int y, DS_U32 width)
	{
		DrawBox32(x, y, width, 10, CONV32_16(0xffe5e5ff));
		if(nPos == nTotal)
			DrawBox32(x, y, width, 10, CONV32_16(0xff65a5cc));
		else
			DrawBox32(x, y, (nPos*width)/nTotal, 10, CONV32_16(0xff65a5cc));
		UpdateScreen();
	}
	
	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_RF_UPDATE:
				switch(event.data32[0])
				{
					case FLASH_WRITING: // FLASH WRITING
						if(category != (int)event.data32[2])
						{
							category = event.data32[2];
							switch(category)
							{
								case UPDATE_BOOTLOADER: Draw(pz_Updating_Cat_str_1[OSD_Lang]); break;
								case UPDATE_APPLICATION0: Draw(pz_Updating_Cat_str_4_1[OSD_Lang]); break;
								case UPDATE_APPLICATION1: Draw(pz_Updating_Cat_str_4_2[OSD_Lang]); break;
							}
							
						}
						
						DrawProgressBar(event.data32[1], 100,rect.w/10,center_pos+2*line_spacing-10,rect.w*8/10);		
						
						DST_g_RFUpdateState = 1;
						break;
					case FLASH_WRITING_COMPLETE: // FLASH WRITING COMPLETE
					case FLASH_WRITING_FAIL:
						nErr = event.data32[1];
						ErrCategory = event.data32[2];
						if(ErrCategory != UPDATE_OK) bNeedLine = true;
						else bNeedLine = false;
						if (nErr != 0) SetTimer(1, 500);						
						break;
				}
				break;
		}
	}

	
	virtual void Show(void)
	{
		
		Draw(pz_Updating_Cat_str_system[OSD_Lang]);
		RegisterAllKey();
	}

	void Draw(DS_U16 * category)
	{
		DrawBox32(0, 0, rect.w, rect.h, CONV32_16(0xff24435e));
		
		setFontStyle(fontItemSize,0xFFE1E1E1,ALIGN_MIDDLE,ALIGN_CENTER);

		DrawTextUni(0, center_pos-2*line_spacing-10, rect.w, line_spacing, category, &font); 
		DrawTextUni(0, center_pos-line_spacing-10, rect.w, line_spacing, pz_Updating_1[OSD_Lang], &font); 
		DrawTextUni(0, center_pos-10, rect.w, line_spacing, pz_Updating_2[OSD_Lang], &font); 
		DrawTextUni(0, center_pos+line_spacing-10, rect.w, line_spacing, pz_Updating_3[OSD_Lang], &font); 
	}
	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_PWR:
				if (DST_g_PowerOn) // 
				{
					DST_g_PowerOn = false;// ȭ .
				}
				else // 
				{
					DST_g_PowerOn = true;// ȭ Ҵ
				} 
				DHL_POWER_Display(DST_g_PowerOn);
				break;
		}
	}

};

void DST_CreateUpdateWin(SWinEventMsg event)
{
	if (DST_GetWin(WIN_UPDATE)) return;
	DST_RemoveAllWindowExceptBasicWin();
	DST_AddWin((WinID)(event.data[0]), new CUpdateWin(event));
}


class CUpdateResetWin : public CWindow
{
private:
	DS_U8 winParentID;
	DS_U8 msg;
	
public:
	CUpdateResetWin(SWinEventMsg event):CWindow(event)
	{
		rect.w = 382; 
		rect.h = 241;  

		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight()- rect.h) / 2;
		SetTimeOut(0);
		

	}
	~CUpdateResetWin()
	{
		
		DST_g_bUpdateCompleted = true;
		DST_Reset(__func__); // â 鼭 
	}
	virtual void OnTimer(char nID)
	{
		switch(nID)
		{
			case 1:
				KillTimer(1);
				Close();
				break;
			default:
				break;
		}
	}
	
	virtual void Show(void)
	{
		RegisterAllKey();
		DrawBox32(0, 0, rect.w, rect.h, CONV32_16(0xff24435e));
		setFontStyle(22,0xFFFFFFFF,ALIGN_MIDDLE,ALIGN_CENTER);
		DrawTextUni(0, 0, rect.w, rect.h, pz_sysreset[OSD_Lang], &font);
		UpdateScreen();
		
		SetTimer(1, 1000);
	}
	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_PWR:
				if (DST_g_PowerOn) // 
				{
					DST_g_PowerOn = false; // ȭ .
				}
				else // 
				{
					DST_g_PowerOn = true;// ȭ Ҵ
				} 
				DHL_POWER_Display(DST_g_PowerOn);
				break;
		}
	}

};
void DST_CreateUpdateResetWin(SWinEventMsg event)
{
	DST_RemoveAllWindowExceptBasicWin();
	DST_AddWin((WinID)(event.data[0]), new CUpdateResetWin(event));
}


