#include "DST_WinManager.h"
#include "DST_OSDImage.h"

DS_U32* DST_UTF82Uni(DS_U8 *utf);
// ڱ ڽ   츦  ݴ´.
void CWindow::Close()
{
	for (int i = 0; i < WIN_ID_MAX; i++)
	{
		CWindow *pWin = DST_GetWin((WinID)i);
		if (pWin == 0) continue;
		if (pWin->GetParentWinID() == GetWinID()) {
		    pWin->Close();
		}
	}

	nWinState = 2;
	UpdateScreen();
}

void CWindow::RegisterAllKey()
{
	for (int i = 0; i <= KEY_ID_MAX; i++)
	{
		bRegisterKey[i] = true;
		nKeyDelay[i] = 0;
		nKeyRepeat[i] = 0;
	}
}

void CWindow::UnRegisterAllKey()
{
	for (int i = 0; i <= KEY_ID_MAX; i++)
	{
		bRegisterKey[i] = false;
		nKeyDelay[i] = 0;
		nKeyRepeat[i] = 0;
	}
}

void CWindow::RegisterKey(DS_U8 nKeyCode, bool bState, int nDelay, int nRepeat)
{
	bRegisterKey[nKeyCode] = bState;
	if (nDelay < 10 || nRepeat < 10)
	{
		nKeyDelay[nKeyCode] = 0;
		nKeyRepeat[nKeyCode] = 0;
	}
	nKeyDelay[nKeyCode] = nDelay/10;
	nKeyRepeat[nKeyCode] = nRepeat/10;
}

bool CWindow::IsRegisterKey(DS_U8 nKeyCode)
{
	return bRegisterKey[nKeyCode];
}

void CWindow::SetWinName(const char* strName)
{
	strcpy(strWinName, strName);
}

OSD_PIXEL_T *CWindow::GetImgBuff()
{
	return imgBuff;
}

void CWindow::SetVisible(bool bValue)
{
	bVisible = bValue;
	UpdateScreen();
}

void CWindow::Move(int x, int y)
{
	if (rect.x == x && rect.y == y) return;
	UpdateScreen();
	rect.x = x;
	rect.y = y;
	UpdateScreen();
}

void CWindow::UpdateScreen()
{
	UpdateScreen(0, 0, rect.w, rect.h);
}

void CWindow::UpdateScreen(int x, int y, int w, int h)
{
	DST_RECT rectTemp;
	rectTemp.x = rect.x + x;
	rectTemp.y = rect.y + y;
	rectTemp.w = w;
	rectTemp.h = h;
	DST_AddUpdateRegion(rectTemp);
}

void CWindow::DrawPixel(int x, int y, OSD_PIXEL_T color)
{
	if (imgBuff == 0) return;
	if (x < 0) return;
	if (y < 0) return;
	if (x > rect.w) return;
	if (y > rect.h) return;
	*(imgBuff + y * rect.w + x) = color;
}

void CWindow::DrawBox32(int x, int y, int w, int h, OSD_PIXEL_T color)
{
	if (imgBuff == 0) return;
	if (w == 0 || h == 0) return;
	OSD_PIXEL_T* des = imgBuff + (rect.w*y+x);
	int hh = h;
	while (hh--)
	{
		int ww = w;
		while (ww--) *des++ = color;
		des += (rect.w - w);
	}
	UpdateScreen(x,y,w,h);
}

//   16Ʈ 32 Ʈ ̹
void CWindow::DrawImage4(int x, int y, DS_U8 *image, bool bProcessTransparent)
{
	DS_U16 nWidth = image[1] * 256 + image[2];
	DS_U16 nHeight = image[3] * 256 + image[4];

	if (x+nWidth > rect.w) return;
	if (y+nHeight > rect.h) return;

	UpdateScreen(x, y, nWidth, nHeight);

	if (bProcessTransparent == true)
	{
		int yy = nHeight;
		OSD_PIXEL_T *tmpSrc = (OSD_PIXEL_T *)& image[8];
		OSD_PIXEL_T *tmpDes = imgBuff + y * rect.w + x;
		int nStep = rect.w-nWidth;
		while (yy--)
		{
			int xx = nWidth;
			while (xx--)
			{
				OSD_PIXEL_T max = (sizeof(OSD_PIXEL_T) == 2) ? 0x0F : 0xFF;
	 			OSD_PIXEL_T sa,sr,sg,sb;
				DST_GetColor(*tmpSrc, &sa, &sr, &sg, &sb);
				OSD_PIXEL_T da,dr,dg,db;
				DST_GetColor(*tmpDes, &da, &dr, &dg, &db);

				if (sa != 0) //  ƴ 츸 ׸.
				{
					if (sa == max || da == 0) // ҽ ̰ų  ΰ
					{
					 	*tmpDes = *tmpSrc;
					}
					else // 
					{
						// http://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending
						OSD_PIXEL_T t = (da * (max-sa) + (max/2)) / max;
						OSD_PIXEL_T a = sa + t;
						if (a > max) a = max;
						OSD_PIXEL_T r = ((sr * sa + dr * t) + (a/2)) / a;
						OSD_PIXEL_T g = ((sg * sa + dg * t) + (a/2)) / a;
						OSD_PIXEL_T b = ((sb * sa + db * t) + (a/2)) / a;
						*tmpDes = DST_SetColor(a, r, g, b);
					}
				}
				tmpSrc++;
				tmpDes++;
			}
			tmpDes += nStep;
		}
	}
	else
	{
		int yy = nHeight;
		OSD_PIXEL_T *tmpSrc = (OSD_PIXEL_T *)& image[image[0]==2? 6:8];
		OSD_PIXEL_T *tmpDes = imgBuff + y * rect.w + x;
		while (yy--)
		{
			memcpy(tmpDes, tmpSrc, sizeof(OSD_PIXEL_T) * nWidth);
			tmpSrc += nWidth;
			tmpDes += rect.w;
		}
	}
}

void CWindow::DrawImage5(int x, int y, DS_U8 *image, bool bProcessTransparent)
{
	DS_U16 nWidth = image[1] * 256 + image[2];
	DS_U16 nHeight = image[3] * 256 + image[4];

	if (x+nWidth > rect.w) return;
	if (y+nHeight > rect.h) return;

	UpdateScreen(x, y, nWidth, nHeight);
	
	DS_U16 nPallette = image[6] * 256 + image[7];
	DS_U32 *pPallette = (DS_U32*)&image[8];
	//DST_Printf("nPallette = %d\n", nPallette);
	DS_U32* pDes = (DS_U32*)imgBuff + y * rect.w + x;
	if (bProcessTransparent == true)
	{
		OSD_PIXEL_T max = (sizeof(OSD_PIXEL_T) == 2) ? 0x0F : 0xFF;
		if (nPallette > 256)
		{
			DS_U16* pSrc = (DS_U16*)&image[8 + nPallette*4];
			for (int yy = 0; yy < nHeight; yy++)
			{
				DS_U32* pDes1 = pDes;
				for (int xx =0; xx < nWidth; xx++)
				{
					OSD_PIXEL_T c = pPallette[*pSrc];
		 			OSD_PIXEL_T sa,sr,sg,sb;
					DST_GetColor(c, &sa, &sr, &sg, &sb);
					OSD_PIXEL_T da,dr,dg,db;
					DST_GetColor(*pDes1, &da, &dr, &dg, &db);
	
					if (sa != 0) //  ƴ 츸 ׸.
					{
						if (sa == max || da == 0) // ҽ ̰ų  ΰ
						{
						 	*pDes1 = c;
						}
						else // 
						{
							// http://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending
							OSD_PIXEL_T t = (da * (max-sa) + (max/2)) / max;
							OSD_PIXEL_T a = sa + t;
							if (a > max) a = max;
							OSD_PIXEL_T r = ((sr * sa + dr * t) + (a/2)) / a;
							OSD_PIXEL_T g = ((sg * sa + dg * t) + (a/2)) / a;
							OSD_PIXEL_T b = ((sb * sa + db * t) + (a/2)) / a;
							*pDes1 = DST_SetColor(a, r, g, b);
						}
					}
					pSrc++;
					pDes1++;
				}
				pDes += rect.w;
			}
		}
		else if (nPallette > 1)
		{
			DS_U8* pSrc = (DS_U8*)&image[8 + nPallette*4];
			for (int yy = 0; yy < nHeight; yy++)
			{
				DS_U32* pDes1 = pDes;
				for (int xx =0; xx < nWidth; xx++)
				{
					OSD_PIXEL_T c = pPallette[*pSrc];
		 			OSD_PIXEL_T sa,sr,sg,sb;
					DST_GetColor(c, &sa, &sr, &sg, &sb);
					OSD_PIXEL_T da,dr,dg,db;
					DST_GetColor(*pDes1, &da, &dr, &dg, &db);
	
					if (sa != 0) //  ƴ 츸 ׸.
					{
						if (sa == max || da == 0) // ҽ ̰ų  ΰ
						{
						 	*pDes1 = c;
						}
						else // 
						{
							// http://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending
							OSD_PIXEL_T t = (da * (max-sa) + (max/2)) / max;
							OSD_PIXEL_T a = sa + t;
							if (a > max) a = max;
							OSD_PIXEL_T r = ((sr * sa + dr * t) + (a/2)) / a;
							OSD_PIXEL_T g = ((sg * sa + dg * t) + (a/2)) / a;
							OSD_PIXEL_T b = ((sb * sa + db * t) + (a/2)) / a;
							*pDes1 = DST_SetColor(a, r, g, b);
						}
					}
					pSrc++;
					pDes1++;
				}
				pDes += rect.w;
			}
		}
		else //  
		{
			OSD_PIXEL_T c = pPallette[0];
 			OSD_PIXEL_T sa,sr,sg,sb;
			DST_GetColor(c, &sa, &sr, &sg, &sb);
			for (int yy = 0; yy < nHeight; yy++)
			{
				DS_U32* pDes1 = pDes;
				for (int xx =0; xx < nWidth; xx++)
				{
					OSD_PIXEL_T da,dr,dg,db;
					DST_GetColor(*pDes1, &da, &dr, &dg, &db);
					if (sa != 0) //  ƴ 츸 ׸.
					{
						if (sa == max || da == 0) // ҽ ̰ų  ΰ
						{
						 	*pDes1 = c;
						}
						else // 
						{
							// http://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending
							OSD_PIXEL_T t = (da * (max-sa) + (max/2)) / max;
							OSD_PIXEL_T a = sa + t;
							if (a > max) a = max;
							OSD_PIXEL_T r = ((sr * sa + dr * t) + (a/2)) / a;
							OSD_PIXEL_T g = ((sg * sa + dg * t) + (a/2)) / a;
							OSD_PIXEL_T b = ((sb * sa + db * t) + (a/2)) / a;
							*pDes1 = DST_SetColor(a, r, g, b);
						}
					}
					pDes1++;
				}
				pDes += rect.w;
			}
		}
	}
	else
	{
		if (nPallette > 256)
		{
			DS_U16* pSrc = (DS_U16*)&image[8 + nPallette*4];
			for (int yy = 0; yy < nHeight; yy++)
			{
				DS_U32* pDes1 = pDes;
				for (int xx =0; xx < nWidth; xx++)
				{
					*pDes1 = pPallette[*pSrc];
					pSrc++;
					pDes1++;
				}
				pDes += rect.w;
			}
		}
		else if (nPallette > 1)
		{
			DS_U8* pSrc = (DS_U8*)&image[8 + nPallette*4];
			for (int yy = 0; yy < nHeight; yy++)
			{
				DS_U32* pDes1 = pDes;
				for (int xx =0; xx < nWidth; xx++)
				{
					*pDes1 = pPallette[*pSrc];
					pSrc++;
					pDes1++;
				}
				pDes += rect.w;
			}
		}
		else // ȷƮ  1 
		{
			T();
			DrawBox32(x, y, nWidth, nHeight, pPallette[0]);
		}
	}
}

// 256  ȷƮ  16Ʈ ̹
void CWindow::DrawImage6(int x, int y, DS_U8 *image, bool bProcessTransparent)
{
	DS_U16 nWidth = image[1] * 256 + image[2];
	DS_U16 nHeight = image[3] * 256 + image[4];

	if (x+nWidth > rect.w) return;
	if (y+nHeight > rect.h) return;

	UpdateScreen(x, y, nWidth, nHeight);
	
	DS_U16 nPallette = image[5]+1;
	OSD_PIXEL_T *pPallette = (DS_U16*)&image[6];
	//DST_Printf("nPallette = %d\n", nPallette);
	DS_U8* pSrc = (DS_U8*)&image[6 + nPallette*2];
	OSD_PIXEL_T* pDes = imgBuff + y * rect.w + x;
	if (bProcessTransparent == true)
	{
		OSD_PIXEL_T max = (sizeof(OSD_PIXEL_T) == 2) ? 0x0F : 0xFF;
		if (nPallette <= 16)
		{
			bool bUpper = true;
			for (int yy = 0; yy < nHeight; yy++)
			{
				OSD_PIXEL_T* pDes1 = pDes;
				for (int xx =0; xx < nWidth; xx++)
				{
					OSD_PIXEL_T c = 0;
					if (bUpper)
					{
						c = pPallette[(*pSrc>>4)&0x0F];
						bUpper = false;
					}
					else
					{
						c = pPallette[(*pSrc)&0x0F];
						pSrc++;
						bUpper = true;
					}
		 			OSD_PIXEL_T sa,sr,sg,sb;
					DST_GetColor(c, &sa, &sr, &sg, &sb);
					OSD_PIXEL_T da,dr,dg,db;
					DST_GetColor(*pDes1, &da, &dr, &dg, &db);
	
					if (sa != 0) //  ƴ 츸 ׸.
					{
						if (sa == max || da == 0) // ҽ ̰ų  ΰ
						{
						 	*pDes1 = c;
						}
						else // 
						{
							// http://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending
							OSD_PIXEL_T t = (da * (max-sa) + (max/2)) / max;
							OSD_PIXEL_T a = sa + t;
							if (a > max) a = max;
							OSD_PIXEL_T r = ((sr * sa + dr * t) + (a/2)) / a;
							OSD_PIXEL_T g = ((sg * sa + dg * t) + (a/2)) / a;
							OSD_PIXEL_T b = ((sb * sa + db * t) + (a/2)) / a;
							*pDes1 = DST_SetColor(a, r, g, b);
						}
					}
					//pSrc++;
					pDes1++;
				}
				pDes += rect.w;
			}
		}
		else
		{
			for (int yy = 0; yy < nHeight; yy++)
			{
				OSD_PIXEL_T* pDes1 = pDes;
				for (int xx =0; xx < nWidth; xx++)
				{
					OSD_PIXEL_T c = pPallette[*pSrc];
		 			OSD_PIXEL_T sa,sr,sg,sb;
					DST_GetColor(c, &sa, &sr, &sg, &sb);
					OSD_PIXEL_T da,dr,dg,db;
					DST_GetColor(*pDes1, &da, &dr, &dg, &db);
	
					if (sa != 0) //  ƴ 츸 ׸.
					{
						if (sa == max || da == 0) // ҽ ̰ų  ΰ
						{
						 	*pDes1 = c;
						}
						else // 
						{
							// http://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending
							OSD_PIXEL_T t = (da * (max-sa) + (max/2)) / max;
							OSD_PIXEL_T a = sa + t;
							if (a > max) a = max;
							OSD_PIXEL_T r = ((sr * sa + dr * t) + (a/2)) / a;
							OSD_PIXEL_T g = ((sg * sa + dg * t) + (a/2)) / a;
							OSD_PIXEL_T b = ((sb * sa + db * t) + (a/2)) / a;
							*pDes1 = DST_SetColor(a, r, g, b);
						}
					}
					pSrc++;
					pDes1++;
				}
				pDes += rect.w;
			}		
		}
	}
	else
	{
		if (nPallette <= 16)
		{
			bool bUpper = true;
			for (int yy = 0; yy < nHeight; yy++)
			{
				OSD_PIXEL_T* pDes1 = pDes;
				for (int xx =0; xx < nWidth; xx++)
				{
					if (bUpper)
					{
						*pDes1 = pPallette[(*pSrc>>4)&0x0F];
						bUpper = false;
					}
					else
					{
						*pDes1 = pPallette[(*pSrc)&0x0F];
						pSrc++;
						bUpper = true;
					}
					pDes1++;
				}
				pDes += rect.w;
			}
		}
		else
		{
			for (int yy = 0; yy < nHeight; yy++)
			{
				OSD_PIXEL_T* pDes1 = pDes;
				for (int xx =0; xx < nWidth; xx++)
				{
					*pDes1 = pPallette[*pSrc];
					pSrc++;
					pDes1++;
				}
				pDes += rect.w;
			}
		}
	}
}

void CWindow::DrawImage(int x, int y, DS_U8 *image, bool bProcessTransparent)
{
	if (image == 0) return;
	if (imgBuff == 0) return;
		
	switch (image[0])
	{
		case 2:
		case 4:
			DrawImage4(x,y,image, bProcessTransparent);
			break;
		case 5:
			DrawImage5(x,y,image, bProcessTransparent);
			break;
		case 6: //  16Ʈ ̹
			DrawImage6(x,y,image, bProcessTransparent);
			break;
		default:
			break;
	}	
}


void CWindow::DrawText(int start_x, int start_y, int width, int height, char *strText, CFont* font)
{
	if (strText == 0) return;
	if (strlen(strText) == 0) return;
	DS_U16* strText16 = (DS_U16*)DST_OS_Malloc((strlen(strText)+1) * sizeof(DS_U16));
	memset(strText16, 0,(strlen(strText)+1) * sizeof(DS_U16));
	for (unsigned i= 0; i < strlen(strText); i++) strText16[i] = (DS_U16)(DS_U8)strText[i];
	DrawTextUni(start_x, start_y, width, height, strText16, font);
	DST_OS_Free(&strText16);
}

void CWindow::DrawTextUTF8(int start_x, int start_y, int width, int height, DS_U8* strText, CFont* font)
{
	if (strText == 0) return;
	int nLen = 0;
	for (int i = 0; i < 4096; i++) // 4096Ϸ ѵ
	{
		if (strText[i] == 0) break;
		nLen++;
	}
	DST_Printf("nLen = %d\n", nLen);
	if (nLen == 0) return;
	DS_U32 *strText32 = DST_UTF82Uni(strText); // ȣ ʿ ޸ 
	if (strText32 == 0) return;
	DrawText32(start_x, start_y,width,  height, strText32, font);
	//DST_OS_Free(&strText32);
	T();
}

void CWindow::DrawTextUni(int start_x, int start_y, int width, int height, DS_U16* strText, CFont* font)
{
	// ڿ ̸ Ѵ.
	int nStrLen = 0;
	for (int i = 0; i < 4096; i++) // 4096Ϸ ѵ
	{
		if (strText[i] == 0) break;
		nStrLen++;
	}
	if (nStrLen == 0) return;
	DS_U32* strText32 = (DS_U32*)DST_OS_Malloc((nStrLen+1) * sizeof(DS_U32));
	memset(strText32, 0, (nStrLen+1) * sizeof(DS_U32));
	for (int i = 0; i < nStrLen; i++) strText32[i] = (DS_U32)strText[i];
	DrawText32(start_x, start_y,width,  height, strText32, font);
	DST_OS_Free(&strText32);
}

void CWindow::DrawText32(int start_x, int start_y, int width, int height, DS_U32* strText, CFont* font)
{
	if (strText == 0) return;
	// ڿ ̸ Ѵ.
	int nStrLen = 0;
	for (int i = 0; i < 4096; i++) // 4096Ϸ ѵ
	{
		if (strText[i] == 0) break;
		nStrLen++;
	}
	if (nStrLen == 0) return;
	
	if (GetImgBuff() == 0) return;
	if (width < 1) return;
	if (height < 1) return;
	if (start_x < 0) start_x = 0;
	if (start_y < 0) start_y = 0;
	if (width > rect.w) width = rect.w;
	if (height > rect.h) height = rect.h;
	if (start_x + width > rect.w) start_x = rect.w-width;
	if (start_y + height > rect.h) start_y = rect.h-height;

	// ڿ ؽƮ ڽ ũٸ ... ߰Ѵ.
	if (width < font->GetDot1Width()) return; //   ۾  ʴ´.
	
	static DS_U32 strBuff[4096];
	DS_U16 nBuffLen = 0;
	int iActualStringWidth = DST_GetTextWidth32(strText, nStrLen, font->GetSize());

	if (width >= iActualStringWidth)
	{
		memcpy(strBuff, strText, nStrLen * sizeof(DS_U32));
		nBuffLen = nStrLen;
	}
	else if (width >= font->GetDot3Width())
	{
		for (int i = 1; i < nStrLen; i++)
		{
			memcpy(strBuff, strText, i * sizeof(DS_U32));
			strBuff[i] = (DS_U32)'.';
			strBuff[i + 1] = (DS_U32)'.';
			strBuff[i + 2] = (DS_U32)'.';
			nBuffLen = i + 3;
			if (width < DST_GetTextWidth32(strBuff, nBuffLen, font->GetSize()))
			{
				strBuff[i - 1] = (DS_U32)'.';
				nBuffLen--;
				break;
			}
		}
	}
	else if (rect.w >= font->GetDot2Width())
	{
			strBuff[0] = (DS_U32)'.';
			strBuff[1] = (DS_U32)'.';
			nBuffLen = 2;
	}
	else
	{
			strBuff[0] = (DS_U32)'.';
			nBuffLen = 1;
	}

	int nWidth;

	// Align ó Ѵ.
	if (nBuffLen == nStrLen)
	    nWidth = iActualStringWidth;
	else
    	nWidth = DST_GetTextWidth32(strBuff, nBuffLen, font->GetSize());

  int nHeight = DST_GetTextHeight(font->GetSize());

  if (nWidth > width) width = nWidth;
  if (nHeight > height) 
  {
  	start_y = start_y - (nHeight - height) / 2;
  	if (start_y < 0) start_y =0;
  	height = nHeight;
  }
  if (width > rect.w) return;
  if (height > rect.h) return;
  int x_pos = start_x;
  int y_pos = start_y;
  switch (font->GetHorAlign())
	{
		case ALIGN_CENTER: x_pos = start_x + (width - nWidth) / 2; break;
		case ALIGN_RIGHT: x_pos = start_x + width - nWidth; break;
	}
	switch (font->GetVerAlign())
	{
		case ALIGN_MIDDLE: y_pos = start_y + (height - nHeight) / 2; break;
		case ALIGN_BOTTOM: y_pos = start_y + height - nHeight; break;
	}
	// ۾ ׻  
	OSD_PIXEL_T Color = font->GetColor();
	switch(sizeof(OSD_PIXEL_T))
	{
		case 2:
			Color |= 0xF000;
			break;
		case 4:
			Color |= 0xFF000000; // ۾ ׻  
			break;
	}
	DST_PrintText(GetImgBuff(), rect.w, rect.h, x_pos, y_pos,
		strBuff, nBuffLen, font->GetSize(), Color);
}

CWindow::CWindow(SWinEventMsg event)
{
	eventInit = event;
	rect.x = 0;
	rect.y = 0;
	rect.w = 0;
	rect.h = 0;
	sprintf(strWinName, "No name");
	UnRegisterAllKey();
	imgBuff = 0;
	bVisible = true;
	nWinState = 0;
	m_WinIDParent = (WinID)event.data[1];
	for (int i =0; i < TIMER_ID_MAX; i++)
	{
		TimerTickCount[i] = 0;
		TimerInterval[i] = 0;
	}
	SetTimeOut(30); //  ⺻ ŸӾƿ 30
	bTransparentWindow = true;
	bFocus = false;
//	SetPallette(DST_GetPallette(1));
	Brightness = 100;
}

void CWindow::SetTimeOut(int nSecond)
{
	SetTimer(0, nSecond * 1000);
}

DS_U32 CWindow::GetTimeOut()
{
	if (TimerInterval[0] == 0) return 0;
	return TimerInterval[0] / 1000;
}

void CWindow::SetTimer(char nID, int ms)
{
	ResetTimer(nID);
	TimerInterval[(int)nID] = ms;
}

void CWindow::ResetTimer(char nID)
{
//	if (nID == 0) // ??? м ʿ ڵ
//	{
//		// ڱ ڽ  찡 ִٸ Ÿ ƿ ش.
//		for (int i = 0; i < WIN_ID_MAX; i++)
//		{
//			CWindow *pWin = DST_GetWin((WinID)i);
//			if (pWin == 0) continue;
//			if (pWin->GetParentWinID() == GetWinID()) pWin->ResetTimer(0);
//		}
//	}
	TimerTickCount[(int)nID] = (DST_OS_GetTickCount() * 1000) / DST_OS_GetTicksPerSecond();
}

void CWindow::KillTimer(char nID)
{
	TimerTickCount[(int)nID] = 0;
}

bool CWindow::ProcessTimer()
{
	for (char i =0; i < TIMER_ID_MAX; i++)
	{
		if (i == 0) // ڽ 찡 ִٸ ڱ ڽ ŸӾƿ  ȴ.
		{
			for (int j = 0; j < WIN_ID_MAX; j++)
			{
				CWindow *pWin = DST_GetWin((WinID)j);
				if (pWin == 0) continue;
				if (pWin->GetParentWinID() != GetWinID()) continue;
				TimerTickCount[0] = (DST_OS_GetTickCount() * 1000) / DST_OS_GetTicksPerSecond();
				break;
			}
		}
		if (TimerTickCount[(int)i]== 0) continue;
		if (TimerInterval[(int)i]== 0) continue;
		if (TimerTickCount[(int)i] + TimerInterval[(int)i] > ((DST_OS_GetTickCount()*1000)/DST_OS_GetTicksPerSecond())) continue;
		DoOnTimer(i);
		return true;
	}
	return false;
}

void CWindow::CloseParents(CWindow* pWin)
{
	CWindow *pWinParent = DST_GetWin(pWin->GetParentWinID());
	if (pWinParent)
	{
		CloseParents(pWinParent);
	}
	pWin->Close();
}

void CWindow::DoOnTimer(char nID)
{
	if (nID == 0) //0 Ÿ̸Ӵ  Ÿ ƿ 뵵 Ѵ.
	{
		CloseParents(this);
	}
	else
	{
		OnTimer(nID);
		if (TimerTickCount[(int)nID] != 0) // KillTimer  Ÿ̸Ӹ  ʾҴٸ ½Ų.
		{
			ResetTimer(nID);
		}
	}
}

void CWindow::SetParentWinID(WinID nID)
{
	m_WinIDParent = nID;
}

WinID CWindow::GetParentWinID()
{
	return m_WinIDParent;
}

WinID CWindow::GetWinID()
{
	return (WinID)(eventInit.data[0]);
}

void CWindow::DoFocus(bool bVal)
{
	bFocus = bVal;
	Focus(bVal);
}

void CWindow::SetSize(int x, int y, int w, int h)
{
	rect.x = x;
	rect.y = y;
	rect.w = w;
	rect.h = h;
}

int CWindow::GetState()
{
	return nWinState;
}

void CWindow::SetState(int n)
{
	nWinState = n;
}

void CWindow::DoOnMessage(SWinEventMsg event)
{
	return OnMessage(event);
}

void CWindow::DoShow()
{
	if (rect.w == 0) return;
	if (rect.h == 0) return;
	if (imgBuff != 0) DST_OS_Free(&imgBuff);
	imgBuff = (OSD_PIXEL_T*)DST_OS_Malloc(sizeof(OSD_PIXEL_T) * (rect.w * rect.h));
	memset(imgBuff, 0, rect.w * rect.h*sizeof(OSD_PIXEL_T));
	bVisible = true;
	Show();
	UpdateScreen();
}

bool CWindow::GetVisible()
{
	return bVisible;
}

void CWindow::FocusToParent()
{
	FocusToChild(GetParentWinID());
}

void CWindow::FocusToChild(WinID nID)
{
	CWindow *pWin = DST_GetWin(nID);
	if (pWin == 0) return;
	DoFocus(false);
	pWin->DoFocus(true);
}

void CWindow::setFontStyle(DS_U8 size, DS_U32 color, DS_U8 ver_align, DS_U8 hor_align)
{
	font.SetHorAlign(hor_align);
	font.SetVerAlign(ver_align);
	font.SetSize(size);
	font.SetColor(CONV32_16(color));
}

