#include "DST_Window.h"
#include "DST_Common.h"
#include "DST_CommonAPI.h"

#define UPDATE_OK						0
#define UPDATE_CHECKING_CRC				1
#define UPDATE_FINISHED					2

#define TUNING_FAIL					101
#define OTC_WAIT_TIMEOUT_FAIL		201
#define OTC_COMPLETE_TIMEOUT_FAIL	202
#define WRITE_FLASH_FAIL			301 
#define CRC_FLASH_BOOTLOADER_FAIL	401
#define CRC_FLASH_APPLICATION_FAIL	402
#define CRC_READ_BOOTLOADER_FAIL	403
#define CRC_READ_APPLICATION_FAIL	404
#define CRC_READ_TOTAL_FAIL			405

#define UPDATE_SYSTEM				0
#define UPDATE_BOOTLOADER			1
#define UPDATE_APPLICATION			2
#define UPDATE_APPLICATION0			3
#define UPDATE_APPLICATION1			4
#define UPDATE_VERSION_READ			5

#define DATA_RECEIVING				0
#define DATA_RECEIVING_COMPLETE		1
#define FLASH_WRITING				2
#define FLASH_WRITING_COMPLETE		3
#define FLASH_WRITING_FAIL			4

#define VERSION_ALL_SAME				0
#define HW_VERSION_DIFFERENT			1
#define SW_VERSION_DIFFERENT			2
#define MODEL_ID_DIFFERENT				3

typedef struct _BootHeader 
{
	unsigned long boot_order; 	/* updated by application before storing */
	unsigned long chip_id;
	unsigned long dummy[2];		/* filler to align to 0x10 */
} BootHeader;

typedef struct _ApplicationHeader
{
	unsigned long image_size;	/* size of image, must be multiple of 0x40 */
	unsigned long epoch;		/* epoch number */
	unsigned long chip_id;		/* chip id to recognize image version */
	unsigned long dta_magic;	/* HDTA - 0x41544448 */
	unsigned char version[64];	/* version string */
	unsigned long dummy[12];	/* pad to 0x40 boundary */
} ApplicationHeader;


typedef struct _KernelHeader
{
	unsigned long kernel_length; 
	unsigned long kernel_crc;
	unsigned long appimg_length; 
	unsigned long appimg_crc;
} KernelHeader;

typedef struct _SystemHeader
{
	char project_id[4];
	unsigned long bootloader_length;
	unsigned long splash_length;
	unsigned long kernel_length;
	unsigned long kernel_crc;
	unsigned long app_length;
	unsigned long app_crc;

	char model_id[8];
	char hw_version_id[4];
	char sw_version_id[16];
	unsigned char force_update;
	unsigned char force_reset;
	unsigned char reserved[38];
	
	unsigned long image_crc;
} SystemHeader;



typedef struct _ImageHeader
{
	unsigned long image_length;
	unsigned long image_crc;
	char model_id[8];
	char hw_version_id[2];
	char sw_version_id[6];
	unsigned char force_update;
	unsigned char reserved[3];
	unsigned long header_crc;
} ImageHeader;





