#ifndef __DST_WINDOW_H__
#define __DST_WINDOW_H__

#include "DST_WinManagerTask.h"
#include "DST_HostInterface.h"
#include "DST_WindowEvent.h"
#include "DST_FontEngine.h"

typedef struct 
{
	int       x;
	int       y;
	int       w;
	int       h;
} DST_RECT;

#define ALIGN_LEFT		0
#define ALIGN_CENTER	1
#define ALIGN_RIGHT		2
#define ALIGN_TOP			0
#define ALIGN_MIDDLE	1
#define ALIGN_BOTTOM	2

#define DST_COLOR_BLACK     CONV32_16(0xFF000000)

#if 1
typedef struct
{
	DS_U8 nSize;
	OSD_PIXEL_T Color;
	DS_U8 hor_align; // (0: Left, 1: Center, 2: Right)
	DS_U8 ver_align; // (0: Top, 1: Middle, 2: Bottom)
	int dot1_width;
	int dot2_width;
	int dot3_width;
} CFont;
#else
class CFont
{
private:
	DS_U8 nSize;
	OSD_PIXEL_T Color;
	DS_U8 hor_align; // (0: Left, 1: Center, 2: Right)
	DS_U8 ver_align; // (0: Top, 1: Middle, 2: Bottom)

	int dot1_width;
	int dot2_width;
	int dot3_width;
public:
	CFont(DS_U8 nSize=15, OSD_PIXEL_T Color=DST_COLOR_BLACK, DS_U8 hor_align = ALIGN_CENTER, DS_U8 ver_align = ALIGN_MIDDLE)
	{
		SetSize(nSize);
		SetColor(Color);		//256̻  default : white
		SetHorAlign(hor_align);		//(0: Left, 1: Center, 2: Right)
		SetVerAlign(ver_align);		//(0: Top, 1: Middle, 2: Bottom)
	}
	void SetSize(DS_U8 Size)
	{
	    if (Size == nSize)
	        return;

		nSize = Size;
	    dot1_width = DST_GetTextWidth((char*)".", Size);
	    dot2_width = DST_GetTextWidth((char*)"..", Size);
	    dot3_width = DST_GetTextWidth((char*)"...", Size);
	}
	int GetDot1Width(void)
	{
	    return dot1_width;
	}

	int GetDot2Width(void)
	{
	    return dot2_width;
	}

	int GetDot3Width(void)
	{
	    return dot3_width;
	}

	DS_U8 GetSize()
	{
		if (nSize < 5) return 5;
		return nSize;
	}
	void SetColor(OSD_PIXEL_T nColor)
	{
		Color = nColor;
	}
	OSD_PIXEL_T GetColor()
	{
		return Color;
	}
	void SetHorAlign(DS_U8 hor)
	{
		hor_align = hor;
	}
	DS_U8 GetHorAlign()
	{
		switch (hor_align)
		{
			case ALIGN_LEFT: return ALIGN_LEFT;
			case ALIGN_RIGHT: return ALIGN_RIGHT;
		}
		return ALIGN_CENTER;
	}
	void SetVerAlign(DS_U8 ver)
	{
		ver_align = ver;
	}
	DS_U8 GetVerAlign()
	{
		switch (ver_align)
		{
			case ALIGN_TOP: return ALIGN_TOP;
			case ALIGN_BOTTOM: return ALIGN_BOTTOM;
		}
		return ALIGN_MIDDLE;
	}
};
#endif

#define TIMER_ID_MAX	6 // ִ Ÿ̸  

#if 1

typedef struct _CWINDOW CWindow;

typedef void (*CFONT_CFont)(CWindow* this, DS_U8 nSize, OSD_PIXEL_T Color, DS_U8 hor_align, DS_U8 ver_align);
typedef void (*CFONT_SetSize)(CWindow* this, DS_U8 Size);
typedef int (*CFONT_GetDot1Width)(CWindow* this);
typedef int (*CFONT_GetDot2Width)(CWindow* this);
typedef int (*CFONT_GetDot3Width)(CWindow* this);
typedef DS_U8 (*CFONT_GetSize)(CWindow* this);
typedef void (*CFONT_SetColor)(CWindow* this, OSD_PIXEL_T nColor);
typedef OSD_PIXEL_T (*CFONT_GetColor)(CWindow* this);
typedef void (*CFONT_SetHorAlign)(CWindow* this, DS_U8 hor);
typedef DS_U8 (*CFONT_GetHorAlign)(CWindow* this);
typedef void (*CFONT_SetVerAlign)(CWindow* this, DS_U8 ver);
typedef DS_U8 (*CFONT_GetVerAlign)(CWindow* this);

typedef void (*Window_Constructor) (CWindow* this, SWinEventMsg event);
typedef void (*Window_Destructor) (CWindow* this);		
typedef void (*Window_SetParentWinID) (CWindow* this, WinID nID);
typedef WinID (*Window_GetParentWinID) (CWindow* this);		
typedef WinID (*Window_GetWinID) (CWindow* this);	
typedef void (*Window_SetSize) (CWindow* this, int x, int y, int w, int h);		
typedef int (*Window_GetState)(CWindow* this);
typedef void (*Window_SetState)(CWindow* this, int n);

typedef void (*Window_SetWinName)(CWindow* this, const char* strName);
typedef void (*Window_SetTransparent)(CWindow* this, bool bValue);
typedef bool (*Window_GetTransparent)(CWindow* this);
	// Message
typedef void (*Window_DoOnMessage)(CWindow* this, SWinEventMsg event);
typedef void (*Window_OnMessage)(CWindow* this, SWinEventMsg event);
	// Show
typedef void (*Window_DoShow)(CWindow* this);
typedef void (*Window_Show)(CWindow* this);
typedef void (*Window_ShowWindow)(CWindow* this, WinID);
	// Hide
typedef void (*Window_Hide)(CWindow* this, WinID);
	// Remove
typedef void (*Window_Close)(CWindow* this); //  츦 ݰ   ȣ
typedef void (*Window_CloseParents)(CWindow* this, CWindow* pWin); // ڱ ڽ    츦 ݴ´.

	//  ġ  ̴ Ӽ 
typedef void (*Window_SetVisible)(CWindow* this, bool bValue);
typedef bool (*Window_GetVisible)(CWindow* this);
typedef void (*Window_Move)(CWindow* this, int x, int y);

	// Ŀ 
typedef void (*Window_FocusToParent)(CWindow* this);
typedef void (*Window_FocusToChild)(CWindow* this, WinID nID);
typedef void (*Window_DoFocus)(CWindow* this, bool bFocus);
typedef void (*Window_Focus)(CWindow* this, bool bFocus);

	// ׸
typedef DST_RECT (*Window_GetSize)(CWindow* this);
typedef OSD_PIXEL_T *(*Window_GetImgBuff)(CWindow* this);
typedef void (*Window_UpdateScreen)(CWindow* this);
typedef void (*Window_UpdateScreenEx)(CWindow* this, int x, int y, int w, int h);
typedef void (*Window_DrawPixel)(CWindow* this, int x, int y, OSD_PIXEL_T color);
typedef void (*Window_DrawBox32)(CWindow* this, int x, int y, int w, int h, OSD_PIXEL_T color);
typedef void (*Window_DrawImage)(CWindow* this, int x, int y, DS_U8 *image, bool bProcessTransparent);
//typedef void (*Window_DrawImage1)(CWindow* this, int x, int y, DS_U8 *image, bool bProcessTransparent);
//typedef void (*Window_DrawImage4)(CWindow* this, int x, int y, DS_U8 *image, bool bProcessTransparent);
//typedef void (*Window_DrawImage5)(CWindow* this, int x, int y, DS_U8 *image, bool bProcessTransparent);
//typedef void (*Window_DrawImage6)(CWindow* this, int x, int y, DS_U8 *image, bool bProcessTransparent);
typedef void (*Window_setFontStyle)(CWindow* this, DS_U8 size, DS_U32 color, DS_U8 ver_align, DS_U8 hor_align);
	
	// 
typedef void (*Window_DrawText)(CWindow* this, int x, int y, int w, int h, char *strText, CFont* font);
typedef void (*Window_DrawTextUTF8)(CWindow* this, int start_x, int start_y, int width, int height, DS_U8* strText, CFont* font);
typedef void (*Window_DrawTextUni)(CWindow* this, int x, int y, int w, int h, DS_U16* strText, CFont* font);
typedef void (*Window_DrawText32)(CWindow* this, int start_x, int start_y, int width, int height, DS_U32* strText, CFont* font);

	// Ű
typedef void (*Window_RegisterAllKey)(CWindow* this);
typedef void (*Window_UnRegisterAllKey)(CWindow* this);
typedef void (*Window_RegisterAllNumKey)(CWindow* this);
typedef void (*Window_UnRegisterAllNumKey)(CWindow* this);
typedef void (*Window_RegisterKey)(CWindow* this, DS_U8 nKeyCode, bool bState, int nDelay, int nRepeat);
typedef bool (*Window_IsRegisterKey)(CWindow* this, DS_U8 nKeyCode);
typedef DS_U32 (*Window_GetKeyDelay)(CWindow* this, DS_U8 KeyCode);
typedef DS_U32 (*Window_GetKeyRepeat)(CWindow* this, DS_U8 KeyCode);
typedef void (*Window_KeyInput)(CWindow* this, DS_U8 /*key*/, bool /*bRepeat*/);

	// ŸӾƿ Ÿ̸
typedef void (*Window_SetTimeOut)(CWindow* this, int nSecond);
typedef DS_U32 (*Window_GetTimeOut)(CWindow* this);
typedef void (*Window_SetTimer)(CWindow* this, char nID, int ms);
typedef void (*Window_ResetTimer)(CWindow* this, char nID);
typedef void (*Window_KillTimer)(CWindow* this, char nID);
typedef bool (*Window_ProcessTimer)(CWindow* this);
typedef void (*Window_DoOnTimer)(CWindow* this, char nID);
typedef void (*Window_OnTimer)(CWindow* this, char /*nID*/);


struct _CWINDOW
{
	//  Ŵ 
	char strWinName[32]; //  ̸  뵵
	SWinEventMsg eventInit; //   ޵Ǵ ޽
	int nWinState; //   · Window Manager 
	WinID	m_WinIDParent; // θ  ̵
	bool bVisible; // Visible Ӽ
	bool bTransparentWindow; //  ο .  κ ׸ ʴ´.
	bool bFocus; //  Focus  Ÿ. θ ڽ 찣  뵵
	// ׸ 
	DST_RECT rect; //  ũ
	OSD_PIXEL_T *imgBuff; //  ̹ 
	// Ű
	bool bRegisterKey[KEY_ID_MAX + 1]; // Ư Ű ϵǾ  Ÿ 迭
	DS_U32 nKeyDelay[KEY_ID_MAX + 1]; // Ư Ű   迭
	DS_U32 nKeyRepeat[KEY_ID_MAX + 1]; // Ư Ű   迭
	// Ÿ̸
	DS_U32 TimerTickCount[TIMER_ID_MAX]; // Ÿ̸Ӱ ۵ ð
	DS_U32 TimerInterval[TIMER_ID_MAX]; // Ÿ̸ 
//	OSD_PIXEL_T Pallette[256];
	CFont font;
	
	//struct Class_Window *pParent;
	
	CFONT_CFont FontFont; // ʱȭ 
	CFONT_SetSize FontSetSize;
	CFONT_GetDot1Width FontGetDot1Width;
	CFONT_GetDot2Width FontGetDot2Width;
	CFONT_GetDot3Width FontGetDot3Width;
	CFONT_GetSize FontGetSize;
	CFONT_SetColor FontSetColor;
	CFONT_GetColor FontGetColor;
	CFONT_SetHorAlign FontSetHorAlign;
	CFONT_GetHorAlign FontGetHorAlign;
	CFONT_SetVerAlign FontSetVerAlign;
	CFONT_GetVerAlign FontGetVerAlign;
	
	Window_Constructor Constructor;
	Window_Destructor Destructor; // CWindow Ļ Ŭ Ҹ
	Window_Destructor DestructorMother; // Cwindow Ҹ
	Window_SetParentWinID SetParentWinID;
	Window_GetParentWinID GetParentWinID;
	Window_GetWinID GetWinID;
	Window_SetSize SetSize;
	Window_GetState GetState;
	Window_SetState SetState;
	Window_SetWinName SetWinName;
	Window_SetTransparent SetTransparent;
	Window_GetTransparent GetTransparent;
	Window_DoOnMessage DoOnMessage;
	Window_OnMessage OnMessage;
	Window_DoShow DoShow;
	Window_Show Show;
	Window_ShowWindow ShowWindow;
	Window_Hide Hide;
	Window_Close Close;
	Window_CloseParents CloseParents;
	Window_SetVisible SetVisible;
	Window_GetVisible GetVisible;
	Window_Move Move;
	Window_FocusToParent FocusToParent;
	Window_FocusToChild FocusToChild;
	Window_DoFocus DoFocus;
	Window_Focus Focus;
	Window_GetSize GetSize;
	Window_GetImgBuff GetImgBuff;
	Window_UpdateScreen UpdateScreen;
	Window_UpdateScreenEx UpdateScreenEx;
	Window_DrawPixel DrawPixel;
	Window_DrawBox32 DrawBox32;
	Window_DrawImage DrawImage;
//	Window_DrawImage1 DrawImage1;
//	Window_DrawImage4 DrawImage4;
//	Window_DrawImage5 DrawImage5;
//	Window_DrawImage6 DrawImage6;
	Window_setFontStyle setFontStyle;
	Window_DrawText DrawText;
	Window_DrawTextUTF8 DrawTextUTF8;
	Window_DrawTextUni DrawTextUni;
	Window_DrawText32 DrawText32;
	Window_RegisterAllKey RegisterAllKey;
	Window_UnRegisterAllKey UnRegisterAllKey;
//	Window_RegisterAllNumKey RegisterAllNumKey;
//	Window_UnRegisterAllNumKey UnRegisterAllNumKey;
	Window_RegisterKey RegisterKey;
	Window_IsRegisterKey IsRegisterKey;
	Window_GetKeyDelay GetKeyDelay;
	Window_GetKeyRepeat GetKeyRepeat;
	Window_KeyInput KeyInput;
	Window_SetTimeOut SetTimeOut;
	Window_GetTimeOut GetTimeOut;
	Window_SetTimer SetTimer;
	Window_ResetTimer ResetTimer;
	Window_KillTimer KillTimer;
	Window_ProcessTimer ProcessTimer;
	Window_DoOnTimer DoOnTimer;
	Window_OnTimer OnTimer;
	
}; 

// ⺻ 츦 Ѵ.
CWindow* NewCWindow(SWinEventMsg event);
// 츦 Ѵ.
void DeleteCWindow(CWindow*pWin);

#else
class CWindow
{
protected:
	//  Ŵ 
	char strWinName[32]; //  ̸  뵵
	SWinEventMsg eventInit; //   ޵Ǵ ޽
	int nWinState; //   · Window Manager 
	WinID	m_WinIDParent; // θ  ̵
	bool bVisible; // Visible Ӽ
	bool bTransparentWindow; //  ο .  κ ׸ ʴ´.
	bool bFocus; //  Focus  Ÿ. θ ڽ 찣  뵵
	// ׸ 
	DST_RECT rect; //  ũ
	OSD_PIXEL_T *imgBuff; //  ̹ 
	// Ű
	bool bRegisterKey[KEY_ID_MAX + 1]; // Ư Ű ϵǾ  Ÿ 迭
	DS_U32 nKeyDelay[KEY_ID_MAX + 1]; // Ư Ű   迭
	DS_U32 nKeyRepeat[KEY_ID_MAX + 1]; // Ư Ű   迭
	// Ÿ̸
	DS_U32 TimerTickCount[TIMER_ID_MAX]; // Ÿ̸Ӱ ۵ ð
	DS_U32 TimerInterval[TIMER_ID_MAX]; // Ÿ̸ 
//	OSD_PIXEL_T Pallette[256];
	CFont font;
public:
	//  Ҹ
	CWindow(SWinEventMsg event);
	virtual ~CWindow()
	{
		if (imgBuff) DST_OS_Free(&imgBuff);
		imgBuff = 0;
		UpdateScreen();
	}
	//  Ӽ
	void SetParentWinID(WinID nID);
	WinID GetParentWinID();
	WinID GetWinID();

	void SetSize(int x, int y, int w, int h);
	int GetState();
	void SetState(int n);

	void SetWinName(const char* strName);
	void SetTransparent(bool bValue)
	{
		bTransparentWindow = bValue;
	}
	bool GetTransparent()
	{
		return bTransparentWindow;
	}
	// Message
	void DoOnMessage(SWinEventMsg event);
	virtual void OnMessage(SWinEventMsg /*event*/){}
	// Show
	void DoShow();
	virtual void Show() {}
	virtual void Show(WinID) {}
	// Hide
	virtual void Hide(WinID) {}
	// Remove
	void Close(); //  츦 ݰ   ȣ
	void CloseParents(CWindow* pWin); // ڱ ڽ    츦 ݴ´.

	//  ġ  ̴ Ӽ 
	void SetVisible(bool bValue);
	bool GetVisible();
	void Move(int x, int y);

	// Ŀ 
	void FocusToParent();
	void FocusToChild(WinID nID);
	void DoFocus(bool bFocus);
	virtual void Focus(bool /*bFocus*/){}

	// ׸
	DST_RECT GetSize() { return rect; }
	OSD_PIXEL_T *GetImgBuff();
	void UpdateScreen();
	void UpdateScreen(int x, int y, int w, int h);
	void DrawPixel(int x, int y, OSD_PIXEL_T color);
	void DrawBox32(int x, int y, int w, int h, OSD_PIXEL_T color);
	void DrawImage(int x, int y, DS_U8 *image, bool bProcessTransparent = false);
	void DrawImage1(int x, int y, DS_U8 *image, bool bProcessTransparent);
	void DrawImage4(int x, int y, DS_U8 *image, bool bProcessTransparent);
	void DrawImage5(int x, int y, DS_U8 *image, bool bProcessTransparent);
	void DrawImage6(int x, int y, DS_U8 *image, bool bProcessTransparent);
	void setFontStyle(DS_U8 size, DS_U32 color, DS_U8 ver_align, DS_U8 hor_align);
	
	// 
	void DrawText(int x, int y, int w, int h, char *strText, CFont* font);
	void DrawTextUTF8(int start_x, int start_y, int width, int height, DS_U8* strText, CFont* font);
	void DrawTextUni(int x, int y, int w, int h, DS_U16* strText, CFont* font);
	void DrawText32(int start_x, int start_y, int width, int height, DS_U32* strText, CFont* font);

	// Ű
	void RegisterAllKey();
	void UnRegisterAllKey();
	void RegisterAllNumKey();
  void UnRegisterAllNumKey();
	void RegisterKey(DS_U8 nKeyCode, bool bState, int nDelay = 0, int nRepeat = 0);
	bool IsRegisterKey(DS_U8 nKeyCode);
	DS_U32 GetKeyDelay(DS_U8 KeyCode)
	{
		return nKeyDelay[KeyCode];
	}
	DS_U32 GetKeyRepeat(DS_U8 KeyCode)
	{
		return nKeyRepeat[KeyCode];
	}
	virtual void KeyInput(DS_U8 /*key*/, bool /*bRepeat*/){}

	// ŸӾƿ Ÿ̸
	void SetTimeOut(int nSecond);
	DS_U32 GetTimeOut();
	void SetTimer(char nID, int ms);
	void ResetTimer(char nID);
	void KillTimer(char nID);
	bool ProcessTimer();
	void DoOnTimer(char nID);
	virtual void OnTimer(char /*nID*/) {}
};
#endif

#endif
