/********************************************************************
* DMW_SymTbl.h
*  - symbol structure header
*
*  Copyright (c)2004 Digital STREAM Tech, Inc.
*  All Rights Reserved
*
*  $Id: DMW_SymTbl.h,v 1.1 2011/07/08 03:13:15 megakiss Exp $
*
*
*********************************************************************/

#ifndef __DMW_SYMBOL_TABLE__
#define __DMW_SYMBOL_TABLE__

#ifdef __cplusplus
extern    "C"
{
#endif

/* symbol types */
#define SYM_UNDF        0x0				   /* undefined */
#define SYM_LOCAL       0x0				   /* local */
#define SYM_GLOBAL      0x1				   /* global (external) (ORed) */
#define SYM_ABS         0x2				   /* absolute */
#define SYM_TEXT        0x4				   /* text */
#define SYM_DATA        0x6				   /* data */
#define SYM_BSS         0x8				   /* bss */
#define SYM_COMM        0x12				   /* common symbol */

/* symbol masks */
#define SYM_MASK_TYPE	0x1f				   /* mask for all the type bits */

	typedef struct					   /* SYMBOL - entry in symbol table */
	{
		char     *name;				   /* symbol name */
		char     *value;			   /* symbol pointer */
		unsigned char type;			   /* symbol type */

	} DMW_SYMBOL_T;

//////////////////////////////////////////
// global variable
#ifdef _MAKEFILE_INCLUDE_TSHELL_
	extern DMW_SYMBOL_T DMW_SymbolTbl[];
	extern unsigned int DMW_SymbolTblSize;
#endif

#ifdef __cplusplus
}
#endif

#endif /*__DMW_SYMBOL_TABLE__*/

/*************************************************************
*Change Logs:
*	$Log: DMW_SymTbl.h,v $
*	Revision 1.1  2011/07/08 03:13:15  megakiss
*	*** empty log message ***
*	
*	Revision 1.2  2009/02/14 04:36:46  hwatk
*	MW  .
*	
*	Revision 1.1.4.1  2009/02/12 05:53:44  hwatk
*	Indent Tool .
*	
*	Revision 1.1  2007/12/24 05:04:42  megakiss
*	*** empty log message ***
*	
*	Revision 1.1  2007/02/23 14:01:09  hwatk
*	V0_10
*	
*	Revision 1.1  2005/12/07 06:58:01  leon
*	# BGT Initial version from std dstmw
*	
*	Revision 1.3  2004/12/30 11:26:36  jfet
*	Add includes.
*	
*	Revision 1.1  2004/08/14 08:49:46  leon
*	-newly created!
*	
*
*************************************************************/
