#include "DST_WinManager.h"
#include "DST_ChannelTune.h"
#include "DST_DB.h"
//#include "DST_OTC_Main.h"
#include "DST_ISDBT_ChannelTask.h"

#if 0
____CBasicSystemWin___()
#endif

bool DST_IsTuneMode();

class CBasicSystemWin : public CWindow
{
private:
	int nScanCount;
public:
	virtual ~CBasicSystemWin()
	{
		DST_Printf("\n\n\n\n\n\n\n\n\n\nERROR : Base Window Deleted!!!!\n\n\n\n\n\n\n\n\n\n\n");
	}
	CBasicSystemWin(SWinEventMsg event):CWindow(event)
	{
		RegisterAllKey();
		RegisterKey(VK_LEFT, true, KEY_DELAY_VOLUME, KEY_REPEAT_VOLUME);
		RegisterKey(VK_RIGHT, true, KEY_DELAY_VOLUME, KEY_REPEAT_VOLUME);
		RegisterKey(VK_UP, true, KEY_DELAY_CHANNEL, 400);
		RegisterKey(VK_DN, true, KEY_DELAY_CHANNEL, 400);
		SetTimeOut(0);
		nScanCount = 0;
	}

	virtual void OnMessage(SWinEventMsg event)
	{
		if (event.cmd == WM_CVT)
		{
			KillTimer(1); // Background Scan Ѵ.
			memcpy(&DST_g_strSWVersion[0], &event.data[0], 16);
			DS_U8 download_command = event.data32[4];
			DST_g_OTC_Modulation_type = (event.data32[5]==1)?(DHL_MODULATION_64QAM):(DHL_MODULATION_256QAM);
			DST_g_OTC_RF = event.data32[6];
			DST_g_OTC_PID = event.data32[7];
			
			DST_Printf("WM_CVT\n");
			DST_Printf("strSWVersion = %02X %02X %02X %02X\n", DST_g_strSWVersion[0], DST_g_strSWVersion[1], DST_g_strSWVersion[2], DST_g_strSWVersion[3]); 
			DST_Printf("download_command = %s(%d)\n", download_command==0 ? "Download Now" : download_command==1 ? "Deferred Download" : "No Exception", download_command);
			DST_Printf("modulation_type = %s(%d)\n", event.data32[5]==1 ? "64QAM" : "256QAM", (int)event.data32[5]);
			DST_Printf("rf = %d Hz\n", (int)DST_g_OTC_RF);
			DST_Printf("pid = 0x%X\n", DST_g_OTC_PID);
			
//			if (DST_g_SleepState != 0) // ɵ  ȭ Ѱ ٷ OTC 
//			{
////				DHL_POWER_Display(true); // ȭ Ҵ.
//				download_command = 2; //   Ѵ.			
//			}
////			DST_Printf("OS_GetTickCount : %d\n\n\n\n\n\n",OS_GetTickCount());
//			if (DST_g_FDC_FirstLockTime == 0 || (OS_GetTickCount() - DST_g_FDC_FirstLockTime  < 10*OS_GetTicksPerSecond()))
//			{
//				download_command = 2; //   Ѵ.			
//			}
			download_command = 2; //   Ѵ.			
			switch (download_command)
			{
//				case 0: T();DST_CreateWin(WIN_OTC_DOWNLOAD_ASK);break;
//				case 1: T();DST_g_bNeedOTCDownload= true; break;
//				case 2: T();DST_OTC_Start(); break;
			}
			JST_OTC(DST_g_OTC_RF, (DHL_MODULATION_MODE)DST_g_OTC_Modulation_type, DST_g_OTC_PID);
			
			DST_CreateWin(WIN_OTC_DOWNLOAD);
		}
		
		switch (event.cmd)
		{
			case WM_SIGNAL_STATE:
				if (DST_g_PowerOn == false)
				{
					if (DST_GetWin(WIN_ERROR)) DST_CloseWin(WIN_ERROR);
					break;
				}
				switch (event.data32[0])
				{
					case SM_WAIT_SIGNAL:
					case SM_GOOD_SIGNAL: // Good Signal
						if (DST_GetWin(WIN_ERROR)) DST_CloseWin(WIN_ERROR);
						break;
					case SM_NO_PROGRAM:
					case SM_AUDIO_ONLY:
						if (DST_g_HWTestMode == false && DST_g_bFactoryMode == false) DST_CreateWin(WIN_ERROR, WIN_NULL, event.data32[0]);
						break;
					case SM_WEAK_SIGNAL: // Error 
						if (DST_GetWin(WIN_UPDATE)) break;
						if (DST_GetWin(WIN_POWER_DOWN_CAUTION)) break;
						if (DST_GetWin(WIN_OTC_DOWNLOAD)) break;
						if (DST_GetWin(WIN_CHANNEL_BANNER)) break;
						if (DST_GetWin(WIN_DIRECT_TUNE)) break;
						if (DST_GetWin(WIN_VOLUME)) break;
						if (DST_GetWin(WIN_VOLUME_MUTE)) break;
						if (DST_GetWin(WIN_SIGNAL_METER)) break;
						if (DST_GetWin(WIN_AUDIO_HOT)) break;
						if (DST_GetWin(WIN_DISPLAY_MODE_HOT)) break;
						if (DST_GetWin(WIN_CLOSED_CAPTION_HOT)) break;
						if (DST_GetWin(WIN_AGE_RATING)) break;
						if (DST_GetWin(WIN_FACTORY_RESET)) break;
						if (DST_GetWin(WIN_MAIN_MENU)) break;
						if (DST_GetWin(WIN_PASSWD_CONFIRM)) break;
						if (DST_GetWin(WIN_PASSWD_CHANGE)) break;
						if (DST_GetWin(WIN_PASSWD_CHECK)) break;
						if (DST_GetWin(WIN_AUTO_SEARCH)) break;
						if (DST_GetWin(WIN_MANUAL_SEARCH)) break;
						if (DST_GetWin(WIN_PROGRAM_GUIDE)) break;
						if (DST_GetWin(WIN_CHANNEL_LIST)) break;
						if (DST_g_HWTestMode == false && DST_g_bFactoryMode == false) DST_CreateWin(WIN_ERROR, WIN_NULL, event.data32[0]);
						break;

					default:
						break;
				}
				break;
				
			case WM_POWER_DOWN_ENTER:
				DST_PowerDown();
				break;
				
			case WM_POWER_OFF:
					DHL_INFO_SetLastPowerState(false);
					{
#ifdef DSTAR

					T();
					nScanCount = 0;
					DST_g_PowerOn = false;
					// CMB CVT ļ 639MHz
					JST_CVT(DST_GetIndexByMHzFrequency(639), DHL_MODULATION_256QAM); // CMB OTC üũ
					SetTimer(1, 5000);
#else   // 忡 Ű  ٷ  ӽ 
					DST_PowerDown();
#endif
				}
				break;
				
			case WM_POWER_ON:
				DHL_INFO_SetLastPowerState(true);
				T();
				nScanCount = 0;
				DST_g_PowerOn = true;
				DST_DB_TuneFirstChannel();
				break;
//			case WM_USB_UPDATE_STARTED:
//			case WM_USB_UPDATE_STATUS:
//				if (DST_GetWin(WIN_UPDATE)) break;
//				DST_CreateWin(WIN_UPDATE);
//				break;
//			case WM_OTC_DOWNLOADING_STARTED:
//				if (DST_GetWin(WIN_OTC_DOWNLOAD)) break;
//				DST_CreateWin(WIN_OTC_DOWNLOAD);
//				break;
//			case WM_OTC_DOWNLOADING_STATUS:		
//				if (DST_GetWin(WIN_OTC_DOWNLOAD_FAIL)) break;
//				DST_CreateWin(WIN_OTC_DOWNLOAD_FAIL,WIN_NULL,event.data32[0]);
//				break;
		}
	}
	bool IsTVHotKeyPossible()
	{
		if (DST_g_PowerOn == false) return false;
		if (DST_IsTuneMode() == false) return false;
		if (DST_g_LastTuneTime == 0) return false;
		if (DST_GetWin(WIN_AUTO_SEARCH)) return false;
		if (DST_GetWin(WIN_MANUAL_SEARCH)) return false;
		return true;
	}
	virtual void OnTimer(char nID)
	{
		switch (nID)
		{
			case 1:
				SetTimer(1, 3000);
				if (DST_g_PowerOn == true) break;
				static int nRF = DST_MaxRF();
				// ĵ ߴµ ä ٸ äθʿ Ѵ. 
				if (nScanCount > 0 && CT_ScanFindChannel() == false) JST_DB_Del(nRF);
				
				if (nScanCount > DST_MaxRF() - DST_MinRF()+1)
				{
					DST_SendWindowEventWithOnlyCmd(WM_POWER_DOWN_ENTER);
					return;
				}
				nRF = (nRF >= DST_MaxRF()) ? DST_MinRF() : nRF+1;
				JST_Scan(nRF);
				nScanCount++;
				break;
		}
	}
	virtual void KeyInput(unsigned char key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_0:
			case VK_1:
			case VK_2:
			case VK_3:
			case VK_4:
			case VK_5:
			case VK_6:
			case VK_7:
			case VK_8:
			case VK_9:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_DIGIT, key);
				break;

			case VK_ZOOM:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_DISPLAY_MODE_HOT);
				break;
			case VK_AUDIO:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_AUDIO_HOT);
				break;
				
			case VK_EPG:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_PROGRAM_GUIDE);
				break;

				
			case VK_HYPHEN:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_DIRECT_TUNE);
				break;
			case VK_PWR:
			case VK_KEY_PWR:
				if (DST_g_PowerOn == true)
				{
					DST_SendWindowEventWithOnlyCmd(WM_POWER_OFF);
				}
				else
				{
					DST_SendWindowEventWithOnlyCmd(WM_POWER_ON);
				}
				break;

			case VK_VOL_DN:
				if (IsTVHotKeyPossible() == false) break; 
				if (DST_UI_GetVolume() > 0) DST_UI_SetVolume(DST_EEPROM_GetVolume() - 1);
				if (DST_UI_GetMute()) DST_UI_SetMute(!DST_UI_GetMute());
				DST_CreateWin(WIN_VOLUME);
				break;

			case VK_VOL_UP:
				if (IsTVHotKeyPossible() == false) break; 
				if (DST_UI_GetVolume() < 50) DST_UI_SetVolume(DST_EEPROM_GetVolume() + 1);
				if (DST_UI_GetMute()) DST_UI_SetMute(!DST_UI_GetMute());
				DST_CreateWin(WIN_VOLUME);
				break;
				
			case VK_MUTE:
				if (IsTVHotKeyPossible() == false) break; 
				DST_UI_SetMute(!DST_UI_GetMute());
				DST_CreateWin(WIN_VOLUME_MUTE);
				break;
				
			case VK_SIGNAL_METER:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_SIGNAL_METER);
				break;

			case VK_CC:
//				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_CLOSED_CAPTION_HOT);
				{
					SWinEventMsg event;
					memset(&event, 0, sizeof(SWinEventMsg));
					event.cmd = WM_CVT;
					char swversion[16] = {0,};
					sprintf(swversion, "0.2000");
					memcpy(&event.data[0], swversion, 16);
		//		case 0: DST_Printf("Download Now\n"); break;
		//		case 1: DST_Printf("Deferred Download\n"); break;
		//		case 2: DST_Printf("No Exception\n"); break;
					event.data32[4] = 0;
					event.data32[5] = 1;
					event.data32[6] = 627000000;
					event.data32[7] = 0x66;
					DST_SendWindowEvent(event);
				}

				break;
				
			case VK_CH_UP:
			case VK_CH_DN:
			case VK_KEY_UP:
			case VK_KEY_DN:
				if (IsTVHotKeyPossible() == false) break;
				T();
				if (DST_DB_PresentChMap() == false) // äθ  
				{
				T();
					DST_CreateWin(WIN_AUTO_SEARCH, WIN_NULL, 1); // Rescan
					break;
				}
				T();
				switch (key)
				{
					case VK_CH_UP:
					case VK_KEY_UP:
						DST_UI_ChannelUpDn(true);
						break;
					default:
						DST_UI_ChannelUpDn(false);
						break;
				}
				break;

			case VK_MENU:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_MAIN_MENU);
				break;

			case VK_OK:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_INFOR_BANNER);
			  	break;

			case VK_PREV:
			case VK_PREV_CH:
				if (IsTVHotKeyPossible()) 
				{
					int nCh_Major = DST_DB_GetMajor(DST_g_PrevRF,DST_g_PrevProgramNumber);
					int nCh_Minor = DST_DB_GetMinor(DST_g_PrevRF,DST_g_PrevProgramNumber);
					if(DST_DB_PresentMatchChannel(DST_g_PrevRF, nCh_Major,nCh_Minor ))
					{
						DST_UI_ChannelTune(DST_g_PrevRF, DST_g_PrevProgramNumber);
					}
					else
					{
						DST_g_PrevRF = DST_EEPROM_GetRF();
						DST_g_PrevProgramNumber = DST_EEPROM_GetProgramNumber();
					}
				}
				break;
		}
	}
};

void DST_CreateBaseSystemWindow(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CBasicSystemWin(event));
}
