#include "DST_ChannelTune.h"
#include "DST_HostInterface.h"
#include "DST_GlobalVariables.h"
#include "DST_WindowEvent.h"
#include "DST_WindowType.h"
#include "DST_WinManagerTask.h" //ui
#include "DST_DataStrings.h"
#include "DST_SignalMonitor.h"
#include "DST_UserInterface.h"
#include "DST_FontEngine.h"
#include "DST_CCTask.h"
#include "DST_WinManager.h"
#include "DST_ISDBT_ChannelTask.h"
#include "dst_eroum_interface.h"
#include "DST_DB_Engine.h"
#include "DST_DB.h"
#include "DST_EEPROM.h"
#include "DST_GlobalVariables.h"
#include "DST_Updates.h"

void DST_USBUpdateInit(void);

void DST_DB_Del();
char *DST_GetModelName(void);

static void DST_CT_CallBack(DS_U8 Cmd, DS_U32 p1, DS_U32 p2, DS_U32 p3, DS_U32 p4, DS_U32 p5, DS_U32 p6);

//  ʱȭ    ù° Ҹ Լ
// EEPROM äθ  .
void DST_Factory_Reset()
{
	DST_DB_Del();
	DST_EEPROM_FactoryInit();
}

void DST_Tune(DS_U8 RF, DS_U16 program_number)
{
	if (program_number == 0)
	{
//		CDB db;
//		db.Query("update signal set signal_strength=99 where signal_strength=100");
//		db.Query("delete from signal where rf=%d", RF);
//		db.Query("insert into signal values(%d, %d, %d, %d, %d)", RF, 100, 0, 0, 1);
		//Minor = 1;
	}
	JST_Open(DST_CT_CallBack);
	JST_Tune(RF, DHL_MODULATION_8VSB, program_number);
}

// ä Ʃ Ѵ.
void DST_Scan(DS_U8 RF)
{
	JST_Open(DST_CT_CallBack);
	JST_Scan(RF);
}
	
#if 0
____AV_STATE___()
#endif
static DS_U8  g_AV_RF = 0;
static DS_U16 g_AV_program_number = 0;
static DS_U16 g_AV_source_id = 0;

// ݹ ö AV  Ȳ
void DST_GetAVState(DS_U8 *RF, DS_U16 *program_number, DS_U16 *source_id)
{
	if (RF) *RF = g_AV_RF;
	if (program_number) *program_number = g_AV_program_number;
	if (source_id) *source_id = g_AV_source_id;
}

static DS_U32 g_AV_PCR = 0;
static DS_U32 g_AV_VideoType = 0;
static DS_U32  g_AV_AudioType = 0;
static DS_U32 g_AV_VideoPID = 0;
static DS_U32  g_AV_AudioPID = 0;

void DST_SetAVInfo(DS_U32 PCR, DS_U32 vPid, DS_U32 aPid, DS_U32 vType, DS_U32 aType)
{
	g_AV_PCR = PCR;
	g_AV_VideoPID = vPid;
	g_AV_AudioPID = aPid;
	g_AV_VideoType = vType;
	g_AV_AudioType = aType;

}

// ݹ ö AV  Ȳ
void DST_GetAVInfo(DS_U32 *PCR, DS_U32 *vPid, DS_U32 *aPid, DS_U32 *vType, DS_U32 *aType)
{
	if (PCR) *PCR = g_AV_PCR;
	if (vType) *vPid = g_AV_VideoPID;
	if (aType) *aPid = g_AV_AudioPID;
	if (vType) *vType = g_AV_VideoType;
	if (aType) *aType = g_AV_AudioType;
}


static DS_U16 DST_g_VideoWidthTV = 0;
static DS_U16 DST_g_VideoHeightTV = 0;
static DS_U16 DST_g_RefreshRate = 0;
static bool DST_g_bInterlace = false;
static bool DST_g_Wide = false;
//  ũ⸦ ȯѴ.
// ϰ interlace .
void DST_GetVideoSize(DS_U16* width, DS_U16* height, DS_U16* fps, bool* bInterlace, bool* bWide)
{
#if 0
	*width = DST_g_VideoWidthTV;
	*height = DST_g_VideoHeightTV;
	*fps = DST_g_RefreshRate;
	*bInterlace = DST_g_bInterlace;
	*bWide = DST_g_Wide;
#else
//	//׽Ʈ::  ҽ 4:3϶ 
//	*width = 720;
//	*height = 480;
//	*fps = DST_g_RefreshRate;
//	*bInterlace = DST_g_bInterlace;	
//	*bWide = false; 
	//׽Ʈ::  ҽ 16:9϶ 
	*width = 1920;
	*height = 1080;
	*fps = DST_g_RefreshRate;
	*bInterlace = DST_g_bInterlace;	
	*bWide = true;

#endif
}

void DST_ResetVideoSize()
{
	DST_g_VideoWidthTV = 0;
	DST_g_VideoHeightTV = 0;
	DST_g_RefreshRate = 0;
	DST_g_bInterlace = false;
	DST_g_Wide = false;
}

#if 0
____TIME___()
#endif

#if 0
____STT Set___()
#endif
static DS_U32 g_systemTime = 0;
static DS_U8 g_gpsUtcOffset = 0;
static DS_U32 g_refreshSystemTime = 0;  // system time  ð

void DST_SetTimeBySTT(DS_U32 RF, DS_U32 a_systemTime, DS_U8 a_offset, DS_U32 a_time)
{
//	DST_Printf("RF = %d a_systemTime = %d a_offset = %d a_time=%d\n", RF, a_systemTime, a_offset, a_time);
	g_systemTime = a_systemTime;
	g_gpsUtcOffset = a_offset;
	DST_g_TimeOffset[RF]=g_gpsUtcOffset;
	g_refreshSystemTime = a_time;
}

DS_U32 DST_GetCurrentUTCTime()
{
	DS_U32 systemTime = 0;
	if(g_systemTime)
	{
		if (g_refreshSystemTime > DST_OS_GetTickCount()) g_refreshSystemTime = DST_OS_GetTickCount();
		systemTime = g_systemTime + (DST_OS_GetTickCount() - g_refreshSystemTime) /  DST_OS_GetTicksPerSecond();
	}
	return systemTime;
}

DS_U32 DST_GetCurrentLocalTime()
{
	if(g_systemTime == 0) return 0;

	return DST_GetCurrentUTCTime() + g_gpsUtcOffset + 9 * 3600;
}

DS_U32 DST_UTCTimeToLocalTime(DS_U32 a_systemTime)
{
	if(a_systemTime == 0) return 0;

	DS_U32 localTime = a_systemTime + g_gpsUtcOffset + 9 * 3600;
	DST_Printf("system time -> local time : %ld -> %ld\n", a_systemTime, localTime);
	
	return localTime;
}

DS_U16* DST_GetTimeString(DS_U32 a_time, TIME_MODE a_mode, bool bApplyTimeZone, int a_offset)
{
	DS_U32 year, month, date, day;
	DS_U32 hour, min, sec;
	DS_U32 utc = a_time;
	DS_U32 daytab[2][13] = {
		{365, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
		{366, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
	};
	int acc_day;
	int i, leap;

	utc += a_offset;
	/* timezone    Ѵ. */
	if(bApplyTimeZone)
		utc += (9 * 3600);
	
	/* 1980/1/1  UTC  1980/1/6  ð  
	    1980    ϴ.
	*/
	utc += 432000;	 /* 5ϰ 	*/
	acc_day = -5;
	year = 1980;
	month = 1;
	date = 1;
	day = 2; /* Tuesday: 1980 1 1 ȭ */
	hour = 0;
	min = 0;
	sec = 0;
	leap = 1;	/* 1980 4 ̹Ƿ .. */

	/* year  */
	while (utc >= (daytab[leap][0]*86400))
	{
		utc -= daytab[leap][0]*86400;
		acc_day += daytab[leap][0];
		year ++;
		leap = ((year%4==0)&&(year%100!=0))||(year%400==0);
	}

	/* month  */
	i=1;
	while (utc >= (daytab[leap][i]*86400))
	{
		utc -= daytab[leap][i]*86400;
		acc_day += daytab[leap][i];
		month ++;
		i++;
	}

	date += (utc/86400);
	acc_day += (utc/86400);
	utc = utc%86400;
	
	day = (acc_day + 7) % 7;
	
	hour = (utc/3600);
	utc = utc%3600;
	
	min = (utc/60);		
	sec = utc%60;

	static DS_U16 timeStr[100];
	memset(timeStr, 0, 100);
	char tmpStr[20] = {0, };
	switch(a_mode)
	{
		case DATE_NO_YEAR_TIME_NO_SEC_DETAIL:
		{
			sprintf(tmpStr, "%d", (int)month);
			str2uni(timeStr, tmpStr);
			strcat16(timeStr, pz_Month[OSD_Lang]);
			memset(tmpStr, 0, strlen(tmpStr));
			sprintf(tmpStr, " %d", (int)date);
			str2uni(&timeStr[strlen16(timeStr)], tmpStr);
			strcat16(timeStr, pz_Day[OSD_Lang]);		
			strcat16(timeStr, (char*)"(");
			DS_U16* dayStr = DST_GetDayOfWeakString(day);
			strcat16(timeStr, dayStr);
			strcat16(timeStr, (char*)") ");
			strcat16(timeStr,  (hour>12)?pz_PM[OSD_Lang]:pz_AM[OSD_Lang]);
			sprintf(tmpStr, " %02d:%02d", (hour>12)?(int)hour-12:(int)hour, (int)min);
			strcat16(timeStr, tmpStr);
			break;
		}	
		case DATE_NO_YEAR_TIME_NO_SEC:
		{
			sprintf(tmpStr, "%d/%d(", (int)month, (int)date);
			str2uni(timeStr, tmpStr);
			DS_U16* dayStr = DST_GetDayOfWeakString(day);
			strcat16(timeStr, dayStr);
			strcat16(timeStr, (char*)") ");
			strcat16(timeStr,  (hour>12)?pz_PM[OSD_Lang]:pz_AM[OSD_Lang]);
			sprintf(tmpStr, " %02d:%02d", (hour>12)?(int)hour-12:(int)hour, (int)min);

			strcat16(timeStr, tmpStr);
			break;
		}
		case DATE_TIME_NO_SEC:
		{
			sprintf(tmpStr, "%d.%d.%d(", (int)year, (int)month, (int)date);
			str2uni(timeStr, tmpStr);
			DS_U16* dayStr = DST_GetDayOfWeakString(day);
			strcat16(timeStr, dayStr);
			strcat16(timeStr, (char*)") ");
			strcat16(timeStr,  (hour>12)?pz_PM[OSD_Lang]:pz_AM[OSD_Lang]);
			sprintf(tmpStr, " %02d:%02d", (hour>12)?(int)hour-12:(int)hour, (int)min);

			strcat16(timeStr, tmpStr);
			break;
		}
		case DATE_TIME:
		{
			sprintf(tmpStr, "%d.%d.%d(", (int)year, (int)month, (int)date);
			str2uni(timeStr, tmpStr);
			DS_U16* dayStr = DST_GetDayOfWeakString(day);
			strcat16(timeStr, dayStr);
			strcat16(timeStr, (char*)") ");
			sprintf(tmpStr, "%02d:%02d:%02d", (int)hour, (int)min, (int)sec);
			strcat16(timeStr, tmpStr);
			break;
		}
		case DATE_ONLY:
		{
			sprintf(tmpStr, "%d.%d.%d(", (int)year, (int)month, (int)date);
			str2uni(timeStr, tmpStr);
			DS_U16* dayStr = DST_GetDayOfWeakString(day);
			strcat16(timeStr, dayStr);
			sprintf(tmpStr, ")");
			strcat16(timeStr, tmpStr);
			break;
		}
		case TIME_NO_SEC:
		{
			strcat16(timeStr,  (hour>12)?pz_PM[OSD_Lang]:pz_AM[OSD_Lang]);
			sprintf(tmpStr, "%02d:%02d", (hour>12)?(int)hour-12:(int)hour, (int)min);

			str2uni(&timeStr[strlen16(timeStr)], tmpStr);
			break;
		}
		case TIME_NO_SEC_NO_AMPM:
		{
			sprintf(tmpStr, "%02d:%02d", (hour>12)?(int)hour-12:(int)hour, (int)min);
			str2uni(timeStr, tmpStr);
			break;
		}
		case TIME_ONLY:
		{
			sprintf(tmpStr, "%02d:%02d:%02d", (int)hour, (int)min, (int)sec);
			str2uni(timeStr, tmpStr);
			break;
		}
		case AMPM:
		{			
			strcat16(timeStr,  (hour>12)?pz_PM[OSD_Lang]:pz_AM[OSD_Lang]);
			break;
		}
	}

	return timeStr;
}

// Ʒ  ð  Լ  
struct DATETIME
{
	DS_U16 date;
	DS_U32 time;
	int offset;
	DS_U32 tick;
};

static DATETIME g_time[256];

// MJDð ȯ
static void DST_MJD(int mjd, int *year, int *month, int *day, int *wday)
{
	int y = int((mjd-15078.2f)/365.25f);
	int m = int((mjd-14956.1f - int(y*365.25f)) / 30.6001f);
	int k = (m==14 || m==15) ? 1 : 0;
	*day = mjd-14956-int(y*365.25f)-int(m*30.6001f);
	*year = 1900 + y + k;
	*month = m - 1 - k * 12;
	*wday = ((mjd+3) % 7); // Ͽ 0  1
}

int DST_GetTimeOffset()
{
	DS_U8 RF = 0;
	DST_GetAVState(&RF);
	DATETIME time = g_time[0];
	if (g_time[RF].tick) time = g_time[RF];
	return time.offset;
}

//  ð ´.
bool DST_GetTime(STime_t *t)
{
	DS_U8 RF = 0;
	DST_GetAVState(&RF);
	DATETIME time = g_time[0];
	if (g_time[RF].tick) time = g_time[RF];
	if (time.date == 0 || time.tick == 0) return false;
	int sec = time.time + ((DST_OS_GetTickCount() - time.tick) / DST_OS_GetTicksPerSecond()) + time.offset * (60*60);
	int day = time.date;
	if (sec >= (24*60*60)) // ƽ īƮ    12ø Ѿ Ѵ.
	{
		 sec = sec - (24*60*60);
		 day = day + 1;
	}
	if (sec < 0) // OFFSET ϸ    ִ
	{
		 sec = sec + (24*60*60);
		 day = day - 1;
	}
	DST_MJD(day, &t->year, &t->month, &t->day, &t->wday);
	t->hour = sec / 3600;
	t->min  = (sec % 3600) / 60;
	t->sec  = sec % 60;
	return true;
}

#if 0
____NEW_EPG_DB___()
#endif

EPG_DB* DST_EPG_DB_Get(int *nCount, int limit)
{
	//DST_Printf("DST_EPG_DB_Get\n");
	//    ´
	int count = 0;
	DS_U8  RF = 0;
	DS_U16 sID = 0;
	DST_GetAVState(&RF, 0, &sID);
	EPG_DB *epg_db =0;
	if (RF == 0 || sID == 0) 
	{
		*nCount = count;
		return 0;	
	}

	DS_U32 curTime = DST_GetCurrentUTCTime();
	CDB db;
	db.GetTable("select start_time, length_in_seconds, event_id, title from eit_sub "
			"where rf = %d and source_id = %d "
			"and start_time <= %d "
			"order by start_time DESC", RF,sID, curTime);
//		DST_Printf("### ROW Count : %d   COL Count : %d\n", db.GetRow(), db.GetCol());
	if(db.GetRow() < 1)
	{
		*nCount = count;
		return 0;
	}
//		DST_Printf("\n\n getRow:%d curTime:%d\n\n",db.GetRow(),curTime);
//		DS_U16 eventId = 0;
	DS_U32 eventTime = 0;
	bool bFound = false;
	T();
	for(int i=0 ; i<db.GetRow() ; i++)
	{
		DS_U32 startTime = atoi(db.GetResult((i+1)*db.GetCol()));
		DS_U32 endTime = startTime + atoi(db.GetResult((i+1)*db.GetCol()+1));
		if(startTime <= curTime && curTime < endTime)
		{
//				eventId = atoi(db.GetResult((i+1)*db.GetCol()+2));
			eventTime = atoi(db.GetResult((i+1)*db.GetCol()));
//				DST_Printf("\n\n eventTime:%d\n\n",eventTime);
			bFound = true;
			break;
		}
		
	}
	int nRealCount = 0;
	if(bFound)
	{
		db.GetTable("select source_id, event_id, title, start_time, length_in_seconds from eit_sub "
				"where rf=%d and source_id = %d "
				"and start_time >= %d "
				"group by event_id order by start_time ASC", RF, sID, eventTime);
		
		if(db.GetRow() < 1)
		{
			*nCount = count;
			return 0;
		}
		nRealCount = db.GetRow() ;
		epg_db = (EPG_DB*)DST_OS_Calloc(nRealCount, sizeof(EPG_DB));
		for(int i=0 ; i<nRealCount ; i++)
		{
			
			epg_db[count].source_id = atoi(db.GetResult((i+1)*db.GetCol()));
			epg_db[count].event_id = atoi(db.GetResult((i+1)*db.GetCol()+1));
			strcpy((char*)epg_db[count].title, db.GetResult((i+1)*db.GetCol()+2)); 
			epg_db[count].start_time= atoi(db.GetResult((i+1)*db.GetCol()+3));
			epg_db[count].duration= atoi(db.GetResult((i+1)*db.GetCol()+4));
			CDB db2;
			db2.GetTable("select title from ett "
					"where rf=%d and source_id = %d "
					"and event_id = %d ", RF, epg_db[count].source_id, epg_db[count].event_id);
			
			if(db2.GetRow() < 1)
			{
				if(epg_db[count].text) DST_OS_Free(&epg_db[count].text);
				epg_db[count].text = (char*)DST_OS_Calloc(1, 1);		

			}		
			else
			{
				epg_db[count].text = (char*)DST_OS_Calloc(strlen(db2.GetResult(db2.GetCol()))+1, 1);
				strcpy(epg_db[count].text, (db2.GetResult(db2.GetCol())));	
			}

			count++;
		}

		
		
	}
	*nCount = nRealCount;
	return epg_db;
}
// EPG  ޸𸮸 Ѵ.
void DST_EPG_DB_Free(EPG_DB* db, int nCount)
{
	for (int i = 0; i < nCount; i++)
	{
		if (db[i].text) DST_OS_Free(&db[i].text);	
	}
	DST_OS_Free(&db);
}


#if 0
____SIGNAL MONITOR___()
#endif


static DHL_AUDIO_MODE g_AudioMode = DHL_AUDIO_UNKNOWN;
DHL_AUDIO_MODE DST_AUD_GetMode()
{
	return g_AudioMode;
}

int DST_GetSignalStrength()
{
	DS_U8 RF = 0;
	DST_GetAVState(&RF);
	return DST_g_SignalStrength[RF];
}


static bool g_Lock  = true;
static bool g_Video = true;
static bool g_Audio = true;

bool  DST_IsAVBlock()
{
	return (g_Lock == false || g_Video == false);
}

bool DST_IsWeakSignal()
{
	return (g_Lock == false);
}

bool DST_IsAudioOnly()
{
	return (g_Lock == true && g_Video == false && g_Audio == true);
}

bool DST_IsNoProgram()
{
	return (g_Lock == true && g_Video == false && g_Audio == false);
}

static int TUNE_SCAN_STATE = CT_STOPPED;
bool DST_IsTuneMode()
{
	return (TUNE_SCAN_STATE == CT_TUNE_START);
}




struct DATETIME2
{
	DS_U16 date; // day
	DS_U32 time; // sec
};
bool DST_IsBetweenTime(DATETIME2 compare_time, DATETIME2 conrol_start_time, DATETIME2 conrol_end_time)
{	
	if(compare_time.date == 0 || conrol_start_time.date == 0 || conrol_end_time.date == 0) return false;
	if(conrol_start_time.time <= compare_time.time && compare_time.time < conrol_end_time.time)
	{
		return true;
	}
	else
	{
		if(conrol_start_time.date<= compare_time.date && compare_time.date < conrol_end_time.date) return true;
		else return false;
	}
	
}



#if 0
____RF_UPDATE___()
#endif


static char* g_RFUpdate_data = 0;
static int g_RFUpdate_data_length = 0;

static int DST_CheckCRC(DS_U32 crc_value, char * data, int size)
{
	DS_U32 ulCrc = crc32((DS_U8 *)data, size);

	if (ulCrc != crc_value) 
	{
		DST_Printf("Total image crc error!!!\n");
		DST_Printf("\nFilelength:0x%08x \n", size);
		DST_Printf("Computed crc32:0x%08x, correct crc32:0x%08x\n",(int)ulCrc, (int)crc_value);
		return CRC_READ_TOTAL_FAIL;
	}

	DST_Printf("Total image crc ok...\n");
	return UPDATE_OK;	
}

int write2Flash(int partition, int partition_size, int data_size, int offset, char * data, int category)
{
#ifdef DSTAR
		char filename[64];
		sprintf(filename, "%s", partition ? "kernel.bin" : "boot.bin");
		FILE *fp = fopen(filename,"wb");
#endif

	int ret = 0;
	int old_pos = -1;

	SWinEventMsg event;
	event.cmd = WM_RF_UPDATE;
	
	for (int i = 0; i < data_size; i+=4096)
	{
		int pos = i * 100 / data_size;
		int length = (i+4096 > data_size) ? data_size-i : 4096;
#ifdef DSTAR
		fwrite(&g_RFUpdate_data[i], 1, length, fp);
#endif

		if (i < partition_size)
		{
			/*ret = */DHL_Flash_Write(partition+i, length, (DS_U8*)&data[offset+i]);
		}

		if (ret != 0) return ret;
			
		if (pos != old_pos)
		{
			old_pos = pos;
			event.data32[0] = FLASH_WRITING;
			event.data32[1] = pos;
			event.data32[2] = category;
			DST_SendWindowEvent(event);
			DST_OS_Delay(DST_OS_GetTicksPerSecond()/100);
		}
	}
#ifdef DSTAR
	fclose(fp);
#endif	
	return ret;

}

void sendFinishMessage(int status1, int status2, int category)
{
	SWinEventMsg event;
	event.cmd = WM_RF_UPDATE;
	event.data32[0] = status1;
	event.data32[1] = status2;
	event.data32[2] = category;
	DST_SendWindowEvent(event);
	
	g_RFUpdate_data_length = 0;
	DST_CT_CallBack(CT_FLASH_WRITE_COMPLETE,0,0,0,0,0,0);	
}

static void tFlashWrite()
{
	int err_ret = 0;
	int buf_offset =0;
	DS_U8 nBank = DHL_INFO_GetBankNumber();
	
	// 4KB .
	
	// 
	SystemHeader systemHeader;
	memset(&systemHeader, 0 , sizeof(SystemHeader));
	memcpy(&systemHeader, g_RFUpdate_data, sizeof(SystemHeader));
	DST_Printf("\n");
	DST_Printf("systemHeader.project_id : %s \n",systemHeader.project_id);
	DST_Printf("systemHeader.bootloader_length : 0x%08x \n",(unsigned int)systemHeader.bootloader_length);
	DST_Printf("systemHeader.splash_length : 0x%08x \n",(unsigned int)systemHeader.splash_length);
	DST_Printf("systemHeader.kernel_length : 0x%08x \n",(unsigned int)systemHeader.kernel_length);
	DST_Printf("systemHeader.kernel_crc : 0x%08x \n",(unsigned int)systemHeader.kernel_crc);
	DST_Printf("systemHeader.app_length : 0x%08x \n",(unsigned int)systemHeader.app_length);
	DST_Printf("systemHeader.app_crc : 0x%08x \n",(unsigned int)systemHeader.app_crc);
	DST_Printf("systemHeader.model_id : %s\n",systemHeader.model_id);
	DST_Printf("systemHeader.hw_version_id : %s\n",systemHeader.hw_version_id);
	DST_Printf("systemHeader.sw_version_id : %s\n",systemHeader.sw_version_id);
	DST_Printf("systemHeader.force_update : 0x%02x \n",(unsigned int)systemHeader.force_update);
	DST_Printf("systemHeader.force_reset : 0x%02x \n",(unsigned int)systemHeader.force_reset);
	DST_Printf("systemHeader.image_crc : 0x%08x \n",(unsigned int)systemHeader.image_crc);		

	//Total CRC check
	buf_offset += sizeof(SystemHeader);
	err_ret = DST_CheckCRC(systemHeader.image_crc,&g_RFUpdate_data[buf_offset],g_RFUpdate_data_length-buf_offset);
	if(err_ret != 0)
	{
		sendFinishMessage(FLASH_WRITING_FAIL, CRC_READ_TOTAL_FAIL, UPDATE_BOOTLOADER);
		return;			
	}
//
//	//Bootloader CRC check
//	err_ret = DST_CheckCRC(systemHeader.image_crc,g_RFUpdate_data,g_RFUpdate_data_length-sizeof(SystemHeader));
//	if(err_ret != 0)
//	{
//		finishWriting(FLASH_WRITING_FAIL, CRC_READ_APPLICATION_FAIL, UPDATE_BOOTLOADER);
//		return;		
//	}

	//Bootloader Flash Writing
	err_ret = write2Flash(FLASH_BOOT_POS, FLASH_BOOT_SIZE, systemHeader.bootloader_length, buf_offset, g_RFUpdate_data, UPDATE_BOOTLOADER);
	if(err_ret != 0)
	{
		sendFinishMessage(FLASH_WRITING_FAIL, WRITE_FLASH_FAIL, UPDATE_BOOTLOADER);
		return;		
	}	
	
	//Application CRC check
	buf_offset += systemHeader.bootloader_length + systemHeader.splash_length;
	err_ret = DST_CheckCRC(systemHeader.kernel_crc, &g_RFUpdate_data[buf_offset], systemHeader.kernel_length);
	if(err_ret != 0)
	{
		sendFinishMessage(FLASH_WRITING_FAIL, CRC_READ_APPLICATION_FAIL, nBank ? UPDATE_APPLICATION0 : UPDATE_APPLICATION1);
		return;		
	}


	//Application Flash Writing
	DS_U32 nFlashBaseAddress = nBank ? FLASH_BANK0_POS : FLASH_BANK1_POS;
	err_ret = write2Flash(nFlashBaseAddress, FLASH_BANK_SIZE, systemHeader.kernel_length, buf_offset, g_RFUpdate_data, nBank ? UPDATE_APPLICATION0 : UPDATE_APPLICATION1);
	if(err_ret != 0)
	{
		sendFinishMessage(FLASH_WRITING_FAIL, WRITE_FLASH_FAIL, nBank ? UPDATE_APPLICATION0 : UPDATE_APPLICATION1);
		return;
	}	

//TO DO :  Flash writing CRC 
	
	DHL_INFO_SetBankNumber(nBank ? 0 : 1);


	DST_OS_Delay(DST_OS_GetTicksPerSecond()/100);
	sendFinishMessage(FLASH_WRITING_COMPLETE,UPDATE_FINISHED,UPDATE_OK);
}

static void DST_RFUpdateWrite(char* p, int length)
{
	if (g_RFUpdate_data) return;
	g_RFUpdate_data = p;
	g_RFUpdate_data_length = length;
	/*int taskID = */DST_OS_SpawnTask((void (*)(void *)) tFlashWrite, (char*)"tFlashWrite", APP_TASK_PRIO_RF_UPDATE_WRITE, WIN_MGR_TASK_STACKSIZE, 0);
}

static DS_U32 DST_g_BER_A = 0;
static DS_U32 DST_g_BER_B = 0;
static bool DST_g_vAlive = false;
static bool DST_g_aAlive = false;

void DST_GetAVAliveInfo(bool *vAlive, bool *aAlive)
{
	if(vAlive) *vAlive = DST_g_vAlive;
	if(aAlive) *aAlive = DST_g_aAlive;
}

void DST_GetSignalInfo(bool *bLock, int *ss, DS_U32 *ber_a, DS_U32 *ber_b)
{
	DS_U8 RF = 0;
	DST_GetAVState(&RF);
	if (bLock) *bLock = DST_g_Lock;
	if (ss) *ss = DST_g_SignalStrength[RF];
	if (ber_a) *ber_a = DST_g_BER_A;
	if (ber_b) *ber_b = DST_g_BER_B;
}

class CMemFile
{
private:
	int m_nTotalSize; // ޸  ü 
	int m_nBlockSize; //  
	char* m_data; // Ǵ 
	int m_nMaxBlockNumber; // ū  ȣ. ȣ 0 Ѵ.
	int* m_BlockList; // ̹  ʹ     ȣ Ѵ.
	int m_nReceiveCount; //  ȿ  
public:
	CMemFile(int nTotalSize, int nBlockSize)
	{
		m_nTotalSize = nTotalSize;
		m_nBlockSize = nBlockSize;
		m_data = (char*)malloc(nTotalSize);
		m_nMaxBlockNumber = (nTotalSize-1) / nBlockSize;
		m_BlockList = (int*)malloc((m_nMaxBlockNumber+1)* sizeof(int));
		m_nReceiveCount = 0;
	}
	void SetBlock(int nBlockNumber, char* data, int nDataLength)
	{
		for (int i = 0; i < m_nReceiveCount; i++) if (m_BlockList[i] == nBlockNumber) return; // ̹  ͸ 
		if (nBlockNumber > m_nMaxBlockNumber) return; // ߸ ȣ .
		//printf("m_nBlockSize = %d nBlockNumber = %d\n", m_nBlockSize , nBlockNumber);
		memcpy(m_data + m_nBlockSize * nBlockNumber, data, nDataLength);
		m_BlockList[m_nReceiveCount++] = nBlockNumber; //  ȣ Ͽ ٽ ޴° 
	}
	// 󸶳 ޾Ҵ ǥϱ  뵵
	// ݱ   / ü  3 2 ޾Ҵٸ 2/3 ȯ
	// RecieveCount  TotalCount  ٸ  Ŵ.
	void GetProgress(int *RecieveCount, int *TotalCount)
	{
		*RecieveCount = m_nReceiveCount; 
		*TotalCount = m_nMaxBlockNumber+1;
	}
	//  ͸ ȯѴ.
	char* GetData()
	{
		return m_data;
	}
	int GetLength()
	{
		return m_nTotalSize;
	}
	~CMemFile()
	{
		free(m_data);
		free(m_BlockList);
	}
};

static void DST_CT_CallBack(DS_U8 Cmd, DS_U32 p1, DS_U32 p2, DS_U32 p3, DS_U32 p4, DS_U32 p5, DS_U32 p6)
{
	if (Cmd == CT_RECEIVE_STT)
	{
		//DST_SendWindowEventWithOnlyCmd(WM_RECEIVE_STT);
		DST_SetTimeBySTT(p1, p2, p3, p4);
	}
	
	switch (Cmd)
	{
		case CT_SIGNAL:
		case CT_SIGNAL_INFO:
		case CT_AV_START:
		case CT_OTC_RECEIVE_DDB:
		case CT_RECEIVE_RF_UPDATE:
			break;
			
		default:
			{
				SWinEventMsg event;
				event.cmd = WM_CT_MSG;
				event.data32[0] = Cmd;
				event.data32[1] = p1;
				event.data32[2] = p2;
				event.data32[3] = p3;
				event.data32[4] = p4;	
				event.data32[5] = p5;		
				event.data32[6] = p6;
				DST_SendWindowEvent(event);
			}
			break;
	}
//	if (Cmd != CT_SIGNAL_INFO  && Cmd != CT_AV_START)
//	{
////		DST_Printf(">>Cmd = %s(%d) %x %x %x %x\n", CT_GetMsgName(Cmd), Cmd, (int)p1, (int)p2, (int)p3, (int)p4);
//	}
	static DS_U32 DST_g_WeakSignalStartTime = 0;
	SWinEventMsg event;
	memset(&event, 0, sizeof(SWinEventMsg));

	switch (Cmd)
	{
		case CT_AV_INFO:
			//(CT_AV_INFO, RF, PcrPid, VideoPid, AudioPid, VideoType, AudioType)
			if(g_AV_PCR != p2 || g_AV_VideoPID != p3 || g_AV_AudioPID != p4 || g_AV_VideoType != p5 || g_AV_AudioType != p6)
			{
				DST_SetAVInfo(p2, p3, p4, p5, p6);
				DST_SendWindowEventWithOnlyCmd(WM_SOURCE_FORMAT_DONE);			
			}
			break;

		case CT_SIGNAL_INFO:
			//(CT_SIGNAL_INFO, RF, bLock, ss, ber_a, ber_b)
			DST_g_Lock = p2;
			DST_g_SignalStrength[p1] = p3;
			DST_g_BER_A = p4;
			DST_g_BER_B = p5;
			{
				bool bWeakSignal = false;
				if (DST_g_Lock == false) bWeakSignal = true;
//				if (DST_g_Demod != (DHL_MODULATION_MODE)DHL_MODULATION_8VSB && DST_g_SNR <= 25) bWeakSignal = true;
//				if (DST_g_Demod == (DHL_MODULATION_MODE)DHL_MODULATION_8VSB && DST_g_SNR <= 14) bWeakSignal = true;
				static int old_rf = 0;
				if (old_rf != (int)p1) // ļ   Weak Signal ƴ ɷ 
				{
					bWeakSignal = false;
					old_rf = p1;
				}
				if (bWeakSignal == true)
				{
					if (DST_g_WeakSignalStartTime == 0) DST_g_WeakSignalStartTime = DST_OS_GetTickCount();
				}	
				else
				{
					DST_g_WeakSignalStartTime = 0;
				}
				if (DST_g_WeakSignalStartTime > DST_OS_GetTickCount()) DST_g_WeakSignalStartTime = DST_OS_GetTickCount();
//				CT_WeakSignalMute(bWeakSignal && (DST_OS_GetTickCount() - DST_g_WeakSignalStartTime) > 10*DST_OS_GetTicksPerSecond()); // 10̻ Weak Signal
			}

			break;

		case  CT_SIGNAL:
			{
				//(CT_SIGNAL, RF, sourceID, VideoPid ? DHL_VID_Alive() : 0, AudioPid ? DHL_AUD_Alive() : 0)
				static DS_U32 nLastSendCommand = 0;
				static DS_U32 nLastSendTime = 0;
				static DS_U32 LastSourceID = 0;
				static DS_U32 LastRF = 0;
				static DS_U32 old_nCmd = SM_GOOD_SIGNAL;
				DS_U32 nCmd = SM_GOOD_SIGNAL;
				if ((nCmd == SM_GOOD_SIGNAL)&& DST_OS_GetTickCount() - DST_g_LastTuneTryTime < WAITING_PERIOD && DST_g_VideoHeightTV == 0)
				{
					nCmd = SM_WAIT_SIGNAL;
				}				
				if (DST_g_WeakSignalStartTime > DST_OS_GetTickCount()) DST_g_WeakSignalStartTime = DST_OS_GetTickCount();
				if (nCmd == SM_GOOD_SIGNAL && DST_g_WeakSignalStartTime > 0 && DST_OS_GetTickCount() - DST_g_WeakSignalStartTime > DST_OS_GetTicksPerSecond())
				{
					nCmd = SM_WEAK_SIGNAL;
				}
				if ((nCmd == SM_GOOD_SIGNAL )&& p3 == 0 && p4 == 0 && DST_OS_GetTickCount() - DST_g_LastTuneTryTime > WAITING_PERIOD)
				{
					nCmd = SM_NO_PROGRAM;
				}
				if (nCmd == SM_GOOD_SIGNAL && p3 == 0 && p4 != 0)
				{
					nCmd = SM_AUDIO_ONLY;
				}
				if (nLastSendTime >  DST_OS_GetTickCount()) nLastSendTime = DST_OS_GetTickCount();
//				DST_Printf("LastSourceID:%d, p2:%d++++++++++++++++++++++++++++++++++++++\n",LastSourceID,p2);
				if(LastRF != p1 || LastSourceID != p2 ) 
				{
					nCmd = SM_WAIT_SIGNAL;
					LastRF = p1;
					LastSourceID = p2;
				}

				if (DST_g_BadSignalStartTime > DST_OS_GetTickCount())	DST_g_BadSignalStartTime = DST_OS_GetTickCount();
				if(nCmd == SM_WEAK_SIGNAL || nCmd == SM_NO_PROGRAM)
				{
					if(old_nCmd != nCmd)
					{
						if(!(old_nCmd == SM_WEAK_SIGNAL || old_nCmd == SM_NO_PROGRAM))
						{
							DST_g_BadSignalStartTime = DST_OS_GetTickCount();
						}
						old_nCmd = nCmd;
					}
				}
				else
				{
					DST_g_BadSignalStartTime = 0;
				}
				
				if (nCmd != nLastSendCommand || DST_OS_GetTickCount() - nLastSendTime > DST_OS_GetTicksPerSecond())
				{
					DST_g_vAlive = p3?true:false;
					DST_g_aAlive = p4?true:false;
					DST_g_SignalState = nCmd;
					event.cmd = WM_SIGNAL_STATE;
					event.data32[0] = nCmd;
					DST_SendWindowEvent(event); 	
					nLastSendCommand = nCmd;
					nLastSendTime = DST_OS_GetTickCount();
					
//					DST_g_OldSignalState = event.data32[0];
//					if (DST_g_SignalState == SM_NO_PROGRAM) DST_g_OldSignalState = SM_NO_PROGRAM;
//					DST_Printf("\n\n\nDST_g_SignalState:%d\n\n\n",DST_g_SignalState);
				}
			}		
			break;
		case CT_AUDIO_MODE:
			g_AudioMode = (DHL_AUDIO_MODE)p1;
			break;
		case CT_VIDEO_RESOLUTION:
			//(CT_VIDEO_RESOLUTION: nWidth, nHeight, RefreshRate, bInterlaced, Aspect)
//			DST_Printf("\n\nDST_SignalInfoCallBack %d %d %d\n\n", p1, p2, p3);
			DST_g_VideoWidthTV = (p1 < 2000 && p1 < 2000) ? p1 : 0;
			DST_g_VideoHeightTV = (p2 < 2000 && p2 < 2000) ? p2 : 0;
			DST_g_RefreshRate = p3;
			DST_g_bInterlace = p4 ? true: false;
			switch (p5)
			{
				case DHL_SOURCE_16x9:
					DST_g_Wide = true;
					break;
				case DHL_SOURCE_4x3:
					DST_g_Wide = false;
					break;
				default:
					if (DST_g_VideoWidthTV == 0 || DST_g_VideoHeightTV == 0) break;
					DST_g_Wide = (((DST_g_VideoWidthTV * 100) / DST_g_VideoHeightTV) > 155) ? true : false;
					break;
			}
			DST_SendWindowEventWithOnlyCmd(WM_SOURCE_FORMAT_DONE);
			break;

		case CT_SCAN_LOCK_WAIT:
			DST_g_SignalStrength[p1] = p3;
			break;
			
		case CT_AV_START:
//			if(g_AV_RF != p1 || g_AV_program_number != p2)
//			{
//				DST_ResetVideoSize();
//				DST_CloseWin(WIN_ERROR);
//			}
//			g_AV_RF = p1;
//			g_AV_program_number = p2;
//			g_AV_source_id = p3;
			break;
		case CT_SCAN_START:
			TUNE_SCAN_STATE = CT_SCAN_START;
			break;
		case CT_TUNE_START:
			TUNE_SCAN_STATE = CT_TUNE_START;
			if(g_AV_RF != p1 || g_AV_program_number != p2)
			{
				DST_ResetVideoSize();
				DST_CloseWin(WIN_ERROR);
			}
			g_AV_RF = p1;
			g_AV_program_number = p2;
			g_AV_source_id = p3;
			DST_Printf("\n\n\n");
			DST_Printf("CT_TUNE_START %d %d %d\n", g_AV_RF, g_AV_program_number, g_AV_source_id);
			DST_Printf("\n\n\n");
			break;
		case CT_STOPPED:
			TUNE_SCAN_STATE = CT_STOPPED;
			break;
		case CT_OTC_START:
			DST_g_bOTCMode = true;
//			DST_SendWindowProgressEvent(WM_OTC_DOWNLOADING_STARTED);
			break;
	}
	
	// OTC  ó
	static CMemFile *mf = 0;
	static bool bOTC_Receive_Complete = true;
	switch (Cmd)
	{
		case CT_OTC_RECEIVE_DII:
			if (mf) delete mf;
			mf = new CMemFile(p1, p2);
			bOTC_Receive_Complete = false; 
			break;
			
		case CT_OTC_RECEIVE_DDB:
			{
				if (bOTC_Receive_Complete) break;
				mf->SetBlock(p1, (char*)p2, p3);
				int nReceiveCount = 0;
				int nMaxBlockNumber = 0;
				mf->GetProgress(&nReceiveCount, &nMaxBlockNumber);
				SWinEventMsg event;
				memset(&event, 0, sizeof(SWinEventMsg));
				event.cmd = WM_RF_UPDATE;
				if (nReceiveCount == nMaxBlockNumber)
				{
					bOTC_Receive_Complete = true;
					event.data32[0] = DATA_RECEIVING_COMPLETE; //  Ϸ
					DST_SendWindowEvent(event);
					JST_Stop();
					DST_CreateWin(WIN_UPDATE);
					DST_RFUpdateWrite(mf->GetData(), mf->GetLength());
				}
				else
				{
					static int old_pos = -1;
					int pos =  (nReceiveCount - 1) * 100 / nMaxBlockNumber;
					event.data32[0] = DATA_RECEIVING; // 
					event.data32[1] = pos;
					if (old_pos != pos) 
					{
						DST_SendWindowEvent(event);
						old_pos = pos;
					}
				}
			}
			break;
		case CT_FLASH_WRITE_COMPLETE:
			if (mf) delete mf;
			mf = 0;
			T();DST_Printf("CT_FLASH_WRITE_COMPLETE\n");
			bOTC_Receive_Complete = true;
			break;

		case CT_RF_UPDATE_START:
			bOTC_Receive_Complete = false; 
			break;
			
		case CT_RECEIVE_RF_UPDATE:
			{
				if (bOTC_Receive_Complete == true) break;
				char *p = (char*)p2;
				char *strModelName = &p[3]; //ǰ𵨸
				char *strVersionName = &p[13]; // S/W 
				char *strFileSize = &p[21]; // ü  
//				char *strPosition = &p[29]; //   ġ
				char *strLength = &p[37]; //  
				char *strMaxBlockNumber = &p[45]; //   ȣ
				char *strBlockNumber = &p[53]; // °  0 
				char *pSrc = &p[61];
				
				int nFileSize = atoi(strFileSize);
//				int nPosition = atoi(strPosition);
				int nLength = atoi(strLength);
				int nMaxBlockNumber = atoi(strMaxBlockNumber);
				int nBlockNumber = atoi(strBlockNumber);
			
				// ׽Ʈ   Ȯ   ʿ
				static char* pData = 0;
				static int*   pLength = 0;
				
				SWinEventMsg event;
				event.cmd = WM_RF_UPDATE;
				memcpy(&event.data32[2], strVersionName, 8);
					
				if (strcmp(strModelName, DST_GetModelName()) != 0)
				{
					T();
					DST_Printf("%s %s\n", strModelName, DST_GetModelName());
					bOTC_Receive_Complete = true;
					JST_Stop();
					if (pData) DST_OS_Free(&pData);
					if (pLength) DST_OS_Free(&pLength);
					event.data32[0] = 100; // ٸ 
					DST_SendWindowEvent(event);
					break;
				}
				if (strcmp(strVersionName, DST_GetAppShortVersion()) == 0)
				{
					T();
					bOTC_Receive_Complete = true;
					JST_Stop();
					if (pData) DST_OS_Free(&pData);
					if (pLength) DST_OS_Free(&pLength);
					event.data32[0] = 101; //  
					DST_SendWindowEvent(event);
					break;
				}
				
				if (mf == 0) // ó ޴  
				{
					bOTC_Receive_Complete = false;
					mf = new CMemFile(nFileSize, nLength);
				}
				mf->SetBlock(nBlockNumber, pSrc, nLength);
				
				int nReceiveCount = 0;
				nMaxBlockNumber = 0;
				mf->GetProgress(&nReceiveCount, &nMaxBlockNumber);
				//SWinEventMsg event;
				memset(&event, 0, sizeof(SWinEventMsg));
				event.cmd = WM_RF_UPDATE;
				if (nReceiveCount == nMaxBlockNumber)
				{
					bOTC_Receive_Complete = true;
					event.data32[0] = DATA_RECEIVING_COMPLETE; //  Ϸ
					DST_SendWindowEvent(event);
					JST_Stop();
					DST_RFUpdateWrite(mf->GetData(), mf->GetLength());
				}
				else
				{
					static int old_pos = -1;
					int pos =  (nReceiveCount - 1) * 100 / nMaxBlockNumber;
					event.data32[0] = DATA_RECEIVING; // 
					event.data32[1] = pos;
					if (old_pos != pos) 
					{
						DST_SendWindowEvent(event);
						old_pos = pos;
					}
				}
			}
			break;
	}
}
