#ifndef __DST_CHANNEL_TUNE_H__
#define __DST_CHANNEL_TUNE_H__

#include "DST_Common.h"
//#include "DMW_ChannelAPI.h"
//#include "DMW_Channel.h"
#include "DST_CommonAPI.h"
#include "DST_UserInterface.h"
#include "DST_ISDBT_ChannelTask.h"

#define MAX_EPG_TEXT_CNT 20 // EPG 1   text 迭  Ѵ.
// ù° text 迭 α׷  detail info .
// ι° ʹ  ׸   .
struct EPG_DB
{
	DS_U16 source_id;
	DS_U16 event_id;
	DS_U8 title[100];
	DS_U32 start_time;
	DS_U32 duration;
	char *text;
};

struct CC_DB
{
	DS_U8	RF;
	DS_U16 program_number;
	DS_U16 pid;
	DS_U8  component_tag;
};

//  ʱȭ    ù° Ҹ Լ
// EEPROM äθ  .
void DST_Factory_Reset();

//  ũ⸦ ȯѴ.
void DST_GetVideoSize(DS_U16* width, DS_U16* height, DS_U16* fps, bool* bInterlace, bool* bWide);
void DST_ResetVideoSize();
void DST_SetAVInfo(DS_U32 PCR, DS_U32 vPid, DS_U32 aPid, DS_U32 vType, DS_U32 aType);
void DST_GetAVInfo(DS_U32 *PCR, DS_U32 *vPid, DS_U32 *aPid, DS_U32 *vType, DS_U32 *aType);
void DST_GetSignalInfo(bool *bLock, int *ss, DS_U32 *ber_a, DS_U32 *ber_b);
void DST_GetAVAliveInfo(bool *vAlive, bool *aAlive);

DHL_AUDIO_MODE DST_AUD_GetMode();

#if 0
____NEW_EPG_DB___()
#endif

// app EPG DB 纻 .
// ȯ 
// EPG  ´.
EPG_DB* DST_EPG_DB_Get(int *nCount, int limit=0);

// EPG  ޸𸮸 Ѵ.
void DST_EPG_DB_Free(EPG_DB* db, int nCount);

#if 0
____AUDIO_INFO___()
#endif
//  MTS Ʈ ´.


#if 0
____AV_STATE___()
#endif

// ݹ ö AV  Ȳ
void DST_GetAVState(DS_U8 *RF = 0, DS_U16 *program_number = 0, DS_U16 *source_id = 0);
#if 0
____TIME___()
#endif

//  ð ´.
bool DST_GetTime(STime_t *t); //  

// ؽð  ð ð Ʋ ִ Ѵ.
int DST_GetTimeOffset();//  

// Էµ bcd  ð ȯѴ.
STime_t DST_GetTime(DS_U32 bcd, DS_U32 duration);//  

#if 0
____STT Set___()
#endif
typedef enum _TIME_MODE
{
	DATE_NO_YEAR_TIME_NO_SEC_DETAIL = 1,
	DATE_NO_YEAR_TIME_NO_SEC,
	DATE_TIME_NO_SEC,
	DATE_TIME,
	DATE_ONLY,
	TIME_NO_SEC,
	TIME_NO_SEC_NO_AMPM,
	TIME_ONLY,
	AMPM
} TIME_MODE;

DS_U32 DST_GetCurrentUTCTime();
DS_U32 DST_GetCurrentLocalTime();
DS_U32 DST_UTCTimeToLocalTime(DS_U32 a_systemTime);
DS_U16* DST_GetTimeString(DS_U32 a_time, TIME_MODE a_mode, bool bApplyTimeZone, int a_offset);


#endif
