#ifndef __DST_DB_H__
#define __DST_DB_H__

#include "DST_CommonAPI.h"

#define FLASH_VERSION 1
// äθ   Ǳ  FLASH_DB_SIZEü äθ ũ ̴. 
#define FLASH_DB_SIZE		 (FLASH_CH_MAP_SIZE/2)

struct CHANNEL_DISPLAY
{
	char num[16];
	DS_U8 name[64];
};

struct ChannelMap
{
	int rf;
	char num[10];
	DS_U16 number;
	DS_U8  name[64];
};

struct EPGValue
{
	DS_U16 source_id;
	DS_U16 event_id;
	DS_U8 title[100];
	DS_U32 start_time;
	DS_U32 duration;
	
};

ChannelMap* DST_DB_GetChannelMapForChEdit(int *nChannels);

bool DST_DB_PresentChMap();


int DST_DB_GetMajor(DS_U8 RF, DS_U16 program_number);


int DST_DB_GetMinor(DS_U8 RF, DS_U16 program_number);


void DST_DB_ChannelUpDn(bool bUp);

int DST_DB_GetChannelCount();

bool DST_DB_GetCurrentChannelInfo(char* chNum, DS_U32* chName, int *num);

//   Ȥ  ĵ  ȣ ȴ.
void DST_DB_TuneFirstChannel();

int DST_DB_GetProgramNumber(int major, int minor);

int DST_DB_GetProgramNumber(int rf);

void DST_DB_Del();


void DST_DB_Del(DS_U8 RF);



void DST_DB_Sync();

bool DST_DB_IsSync();

void DST_DB_Open();

void DST_DB_Close();

int DST_DB_GetRF(int major, int minor, bool* bFound);

int DST_DB_AvailableChannelCount(int major);

bool DST_DB_PresentMatchChannel(int rf, int major, int minor);

struct SkipList
{
	int rf;
	int program_number;
};


SkipList* DST_DB_GetSkipChannel(int *size);
int DST_DB_GetSkipChannelCount();

void DST_DB_MakeSkipChannel();


void DST_DB_SetSkipChannel(int rf, int program_number, bool bAdd);

#endif

