#include "DST_DB_Engine.h"
#include "dst_eroum_interface.h"
#include <sqlite3.h>

#define DB_ENGINE_DEBUG 0
sqlite3 *g_db =0;

static void Lock(bool bLock)
{
	static DS_U32 sema4 = 0;
	if (sema4== 0) sema4 = DST_OS_CreateLock((char*)"db");
	bLock ? DST_OS_Lock(sema4) : DST_OS_Unlock(sema4);
}

CDB::CDB()
{
	mRow = 0;
	mCol = 0;
	mResult = 0;
}

CDB::~CDB()
{
	if (mResult)
	{
		for (int i = 0; i < (mRow+1)*mCol; i++) DST_OS_Free(&mResult[i]);
		DST_OS_Free(&mResult);
		mRow = 0;
		mCol = 0;                         
	}
}

int CDB::Query(const char* strSQL, ...)
{
	if (g_db == 0 || strSQL == 0) return 0;
	if (mResult)
	{
		for (int i = 0; i < (mRow+1)*mCol; i++) DST_OS_Free(&mResult[i]);
		DST_OS_Free(&mResult);
		mRow = 0;
		mCol = 0;                         
	}

	Lock(true); 
	va_list ap;
  	char *z;
	va_start(ap, strSQL);
  	z = sqlite3_vmprintf(strSQL, ap);
  	va_end(ap);
#if DB_ENGINE_DEBUG
	DST_Printf("CT_Query|%s\n", z);
#endif
	char *ErrMsg = 0;

	int rc = sqlite3_exec(g_db, z, 0, 0, &ErrMsg);
	
	if (rc)
	{
		DST_Printf("CT_Query|%s\n", z);
		DST_Printf("CT_Query|%d|%s\n", rc, ErrMsg);
		sqlite3_free(ErrMsg);
	}
	sqlite3_free(z);
	Lock(false); 
  return rc;
}

int CDB::GetTable(const char* strSQL, ...)
{
	if (g_db == 0 || strSQL == 0) return 0;
	if (mResult)
	{
		for (int i = 0; i < (mRow+1)*mCol; i++) DST_OS_Free(&mResult[i]);
		DST_OS_Free(&mResult);
		mRow = 0;
		mCol = 0;                         
	}

	Lock(true);

	va_list ap;
  	char *z;
	va_start(ap, strSQL);
  	z = sqlite3_vmprintf(strSQL, ap);
  	va_end(ap);
#if DB_ENGINE_DEBUG
		DST_Printf("CT_GetTable|%s\n", z);
#endif
	char *ErrMsg = 0;
	
	char **mResult1 = 0;    
	int rc = sqlite3_get_table(g_db, z, &mResult1, &mRow, &mCol, &ErrMsg);
	
	if (rc)
	{
		DST_Printf("CT_GetTable|%s\n", z);
		DST_Printf("CT_GetTable|%d|%s\n", rc, ErrMsg);
		sqlite3_free(ErrMsg);
	}
	else
	{
		if (mResult1)
		{
			mResult = (char**)DST_OS_Calloc((mRow+1)*mCol, sizeof(char*));   
			for (int i = 0; i < (mRow+1)*mCol; i++)                          
			{ 
				unsigned nLen = 0;
				if (mResult1[i]) nLen = strlen(mResult1[i]);                                                                 
				if (nLen == 0) continue;                                       
				mResult[i] = (char*)DST_OS_Calloc(nLen+1,1);                     
				strcpy(mResult[i], mResult1[i]);                               
			}
		}                                                                
	}
	if (mResult1) sqlite3_free_table(mResult1); 
	sqlite3_free(z);
	Lock(false); 
  return rc;
}

int CDB::GetRow()
{
	return mRow;
}

int CDB::GetCol()
{
	return mCol;
}

char* CDB::GetResult(int i)
{
	static char* strNull =(char*)"";
	if(i >= (mRow+1)*mCol) 
	{
		DST_Printf("%s|%d|Out of range. mRow:%d ,mCol:%d, i:%d\n", __func__, __LINE__,mRow,mCol,i);
		return (char*)"";
	}
	return mResult[i] == 0 ? strNull : mResult[i];
}

#ifdef SQLITE_OS_OTHER

int dst_sqlite_randomness(sqlite3_vfs*, int nByte, char *zOut)
{
	memset(zOut, 0, nByte);
	return nByte;
}

extern "C" SQLITE_API int sqlite3_os_init(void)
{
  static sqlite3_vfs aVfs = {                        
    3,                    /* iVersion */                    
    0,     /* szOsFile */                    
    255,         /* mxPathname */                  
    0,                    /* pNext */                       
    0,              /* zName */                       
    0,       /* pAppData */                    
    0,             /* xOpen */                       
    0,           /* xDelete */                     
    0,           /* xAccess */                     
    0,     /* xFullPathname */               
    0,           /* xDlOpen */                     
    0,          /* xDlError */                    
    0,            /* xDlSym */                      
    0,          /* xDlClose */                    
    dst_sqlite_randomness,       /* xRandomness */                 
    0,            /* xSleep */                      
    0,      /* xCurrentTime */                
    0,     /* xGetLastError */               
    0, /* xCurrentTimeInt64 */           
    0,    /* xSetSystemCall */              
    0,    /* xGetSystemCall */              
    0   /* xNextSystemCall */             
  };
	sqlite3_vfs_register(&aVfs,1);
	
	
  return SQLITE_OK; 
}

extern "C" SQLITE_API int sqlite3_os_end(void)
{ 
  return SQLITE_OK; 
}

#endif
