#include "DST_HostInterface.h"
#include "DST_CommonAPI.h"
#include "DST_WinManagerTask.h"
#include "DST_UserInterface.h"

void JST_RFUpdate(DS_U8 RF);

int DST_GetScreenHeight()
{
	return 480;
}

int DST_GetScreenWidth()
{
	return 720;
}

static DS_U8 DST_GetKeyCode(DS_U32 Code)
{
	//printf("%s|%X\n", __func__,  (int)Code);
	DS_U8 g_KeyCode = 0;
	switch (Code)
	{
		case 1: g_KeyCode = VK_KEY_PWR;  break;
		case 2: g_KeyCode = VK_KEY_UP;  break;
		case 4: g_KeyCode = VK_KEY_DN; break;
			
#if 1 // DSTAR Ű 
		case 0xCAFE002D: g_KeyCode = VK_HYPHEN; break;// -
		case 0xCAFE0030: g_KeyCode = VK_0; break;
		case 0xCAFE0031: g_KeyCode = VK_1; break;
		case 0xCAFE0032: g_KeyCode = VK_2; break;
		case 0xCAFE0033: g_KeyCode = VK_3; break;
		case 0xCAFE0034: g_KeyCode = VK_4; break;
		case 0xCAFE0035: g_KeyCode = VK_5; break;
		case 0xCAFE0036: g_KeyCode = VK_6; break;
		case 0xCAFE0037: g_KeyCode = VK_7; break;
		case 0xCAFE0038: g_KeyCode = VK_8; break;
		case 0xCAFE0039: g_KeyCode = VK_9; break;
		case 0xCAFE0020: g_KeyCode = VK_MENU; break;// menu : space
		case 0xCAFE0114: g_KeyCode = VK_LEFT; break;// left;
		case 0xCAFE0113: g_KeyCode = VK_RIGHT; break;// right;
		case 0xCAFE0111: g_KeyCode = VK_UP; break;// up;
		case 0xCAFE0112: g_KeyCode = VK_DN; break;// dn;
		case 0xCAFE000D: g_KeyCode = VK_OK; break;// OK : enter 
		case 0xCAFE006D: g_KeyCode = VK_MUTE; break;// mute : m
		case 0xCAFE0065: g_KeyCode = VK_EPG; break;// epg : e
		case 0xCAFE0061: g_KeyCode = VK_AUDIO; break;// audio : a 
		case 0xCAFE0106: g_KeyCode = VK_VOL_UP; break; // volume up : 6
		case 0xCAFE0104: g_KeyCode = VK_VOL_DN; break; // volume down : 4
		case 0xCAFE0117: g_KeyCode = VK_PWR; break; // end
		case 0xCAFE0108: g_KeyCode = VK_CH_UP; break; // channel up : 8
		case 0xCAFE0102: g_KeyCode = VK_CH_DN; break; // channel down : 2
		case 0xCAFE0008: g_KeyCode = VK_PREV; break; // prev : back space
		case 0xCAFE007A: g_KeyCode = VK_ZOOM; break;// zoom : z
		case 0xCAFE0073: g_KeyCode = VK_SIGNAL_METER; break;// signal meter : s
		case 0xCAFE001B: g_KeyCode = VK_CANCEL; break;// back : esc
#endif	 // DSTAR Ű 		
			
#if 1 // DST 
		case 0xE41B3412: g_KeyCode = VK_MENU;  break;
		case 0xFB043412: g_KeyCode = VK_LEFT;  break;
		case 0xFA053412: g_KeyCode = VK_RIGHT;  break;
		case 0xFD023412: g_KeyCode = VK_UP;  break;
		case 0xFC033412: g_KeyCode = VK_DN;  break;
		case 0xFE013412: g_KeyCode = VK_OK;  break;
		case 0xFF003412: g_KeyCode = VK_PWR;  break;
		case 0xE21D3412: g_KeyCode = VK_PREV_MENU;  break;
		case 0xDF203412: g_KeyCode = VK_PREV_CH;  break;	
		case 0xEE113412: g_KeyCode = VK_1;  break;
		case 0xED123412: g_KeyCode = VK_2;  break;
		case 0xEC133412: g_KeyCode = VK_3;  break;
		case 0xEB143412: g_KeyCode = VK_4;  break;
		case 0xEA153412: g_KeyCode = VK_5;  break;
		case 0xE9163412: g_KeyCode = VK_6;  break;
		case 0xE8173412: g_KeyCode = VK_7;  break;
		case 0xE7183412: g_KeyCode = VK_8;  break;
		case 0xE6193412: g_KeyCode = VK_9;  break;
		case 0xEF103412: g_KeyCode = VK_0;  break;
		case 0xDD223412: g_KeyCode = VK_MUTE;  break;
		case 0xDC233412: g_KeyCode = VK_AUDIO;  break;
		case 0xDB243412: g_KeyCode = VK_ZOOM;  break;
		case 0xE51A3412: g_KeyCode = VK_HYPHEN; break;
		case 0xDA253412: g_KeyCode = VK_CC; break;
		case 0xF9063412: g_KeyCode = VK_VOL_UP; break;
		case 0xF8073412: g_KeyCode = VK_VOL_DN; break;
		case 0xF7083412: g_KeyCode = VK_CH_UP; break;
		case 0xF6093412: g_KeyCode = VK_CH_DN; break;
//		case 0xD32C3412: g_KeyCode = VK_STAR; break;
#endif // DST 
			
#if 1 //  HD200K 
		case 0xE21D0204: g_KeyCode = VK_HYPHEN;  break;
		case 0xE9160204: g_KeyCode = VK_FAC_OK;  break;
		case 0xE51A0204: g_KeyCode = VK_FAC_CANCEL;  break;
#endif //  HD200K 

#if 1 //CMB 
		case 0xFF000820: g_KeyCode = VK_PWR;  break;
		case 0xF6090820: g_KeyCode = VK_MENU;  break;
		case 0xF10E0820: g_KeyCode = VK_LEFT;  break;
		case 0xF00F0820: g_KeyCode = VK_RIGHT;  break;
		case 0xF40B0820: g_KeyCode = VK_UP;  break;
		case 0xF30C0820: g_KeyCode = VK_DN;  break;
		case 0xF20D0820: g_KeyCode = VK_OK;  break;	
		case 0xBA450820: g_KeyCode = VK_PREV;  break;
		case 0xF50A0820: g_KeyCode = VK_CANCEL;  break;
		case 0xE11E0820: g_KeyCode = VK_0;  break;	
		case 0xEB140820: g_KeyCode = VK_1;  break;	
		case 0xEA150820: g_KeyCode = VK_2;  break;	
		case 0xE9160820: g_KeyCode = VK_3;  break;	
		case 0xE8170820: g_KeyCode = VK_4;  break;	
		case 0xE7180820: g_KeyCode = VK_5;  break;	
		case 0xE6190820: g_KeyCode = VK_6;  break;	
		case 0xE51A0820: g_KeyCode = VK_7;  break;	
		case 0xE41B0820: g_KeyCode = VK_8;  break;	
		case 0xE31C0820: g_KeyCode = VK_9;  break;	
		case 0xFC030820: g_KeyCode = VK_MUTE;  break;	
		case 0xF8070820: g_KeyCode = VK_CH_UP;  break;	
		case 0xF7080820: g_KeyCode = VK_CH_DN;  break;	
		case 0xFA050820: g_KeyCode = VK_VOL_UP;  break;	
		case 0xF9060820: g_KeyCode = VK_VOL_DN;  break;
		case 0xEF100820: g_KeyCode = VK_RED;  break;	
		case 0xEE110820: g_KeyCode = VK_GREEN;  break;
		case 0xED120820: g_KeyCode = VK_YELLOW;  break;	
		case 0xEC130820: g_KeyCode = VK_BLUE;  break;				
		case 0xB7480820: g_KeyCode = VK_MUTE;  break; // CMB 忡 . ܿ 
		case 0xDD220820: g_KeyCode = VK_CC;  break; //  ߰ ϴ CC ư
		case 0xDC230820: g_KeyCode = VK_HYPHEN; break; // ϴ Ÿư  Ѵ
#endif //CMB 
		default: g_KeyCode = 0;        break;
	}
	return g_KeyCode;	
}

//  ݹ
struct Key_Msg
{
	bool bIsKeyPad;
	DS_U8 key;
	DS_U32 tick;
};

static DS_U32 MsgQ = 0;
static void DST_AddKey(bool bIsKeyPad, DS_U8 key, DS_U32 tick)
{
	if (MsgQ == 0) MsgQ = DST_OS_CreateMessageQueue("qKey", 0, 100, sizeof(Key_Msg));
	Key_Msg msg;
	msg.bIsKeyPad = bIsKeyPad;
	msg.key = key;
	msg.tick = tick;
	DST_OS_SendMessage(MsgQ, (DS_U32 *)&msg, sizeof(Key_Msg));
 	T();
}

static DS_U8 DST_GetKey()
{
	if (MsgQ == 0) return 0;
	Key_Msg msg;
	DS_U32 retLen = 0;
	if (DST_OS_ReceiveMessage_NoWait(MsgQ, (DS_U32*)&msg, sizeof(Key_Msg), &retLen) != noError) return 0;
	if (msg.tick > DST_OS_GetTickCount()) msg.tick = DST_OS_GetTickCount();
	if (DST_OS_GetTickCount() - msg.tick > 600) return DST_GetKey(); // 600ms ̻ Ű .
	if (DHL_GetKeyPadGPIO() > 0) // Űе尡  ִٸ  Ѵ.
	{
		if (msg.bIsKeyPad == false) return DST_GetKey(); 
	}
	return msg.key;
}

//  ݹ
void DST_IrCallBack(DS_U32 key, DS_U32 repeat, DS_U32 tick)
{
	DST_Printf("|%s| key = 0x%02X, repeat = %d\n", __func__, (int)key, (int)repeat);
		static DS_U32 old_repeat = 0;
	static DS_U32 repeat_count = 0;
	DS_U8 KeyCode = DST_GetKeyCode(key);
	//DST_g_LastKeyPressTime = tick;
	if (repeat == 0)
	{
		repeat_count = 0;
		DST_AddKey(false, KeyCode, tick);
	}
	else
	{
		switch (KeyCode)
		{
			case VK_VOL_UP:
			case VK_VOL_DN:
				if (old_repeat == 0 && repeat == 1) repeat_count = 0;
				repeat_count++;
				if (repeat_count > 3 /*&& repeat_count % 3 == 2*/) DST_AddKey(false, KeyCode, tick); // 330ms 
				break;
			case VK_CH_UP:
			case VK_CH_DN:
				if (old_repeat == 0 && repeat == 1) repeat_count = 0;
				repeat_count++;
				if (repeat_count > 6 /*&& repeat_count % 3 == 2*/) DST_AddKey(false, KeyCode, tick); // 330ms 
				break;
			case VK_UP:
			case VK_DN:
				if (old_repeat == 0 && repeat == 1) repeat_count = 0;
				repeat_count++;
				if (repeat_count > 3 /*&& repeat_count % 3 == 2*/) DST_AddKey(false, KeyCode, tick); // 330ms 
				break;
			case VK_LEFT:
			case VK_RIGHT:
				if (old_repeat == 0 && repeat == 1) repeat_count = 0;
				repeat_count++;
				if (repeat_count > 3 && repeat_count % 2 == 1) DST_AddKey(false, KeyCode, tick); // 330ms 
				break;
			default:
				repeat_count = 0;
				break;
		}
	}
	old_repeat = repeat;
}

static void tKeyPad()
{
	DS_U8 PreKeyCode = 0;
	DS_U32 tick = 0;
	while(1)
	{
		DST_OS_Delay(DST_OS_GetTicksPerSecond()/100); // 10ms
		DS_U8 KeyCode = DST_GetKeyCode(DHL_GetKeyPadGPIO());
		//DST_Printf("KeyCode = %d\n", KeyCode);
		switch (KeyCode)
		{
			case VK_KEY_PWR:
				if (PreKeyCode == KeyCode) break;
				DST_AddKey(true, KeyCode, DST_OS_GetTickCount()); 
				PreKeyCode = KeyCode;
				tick = DST_OS_GetTickCount();
				break;
			case VK_KEY_UP:
				if (PreKeyCode == KeyCode) break;
				DST_AddKey(true, KeyCode, DST_OS_GetTickCount()); 
				PreKeyCode = KeyCode;
				tick = DST_OS_GetTickCount();
				break;
			case VK_KEY_DN:
				if (PreKeyCode == KeyCode) break;
				DST_AddKey(true, KeyCode, DST_OS_GetTickCount()); 
				PreKeyCode = KeyCode;
				tick = DST_OS_GetTickCount();
				break;
			default:
				PreKeyCode = KeyCode;
				tick = DST_OS_GetTickCount();
				break;
		}
		switch (KeyCode)
		{
			case VK_KEY_UP:
				if (DST_OS_GetTickCount() - tick < DST_OS_GetTicksPerSecond()/3) break;
				DST_AddKey(true, KeyCode, DST_OS_GetTickCount());
				tick = DST_OS_GetTickCount(); 
				break;
			case VK_KEY_DN:
				if (DST_OS_GetTickCount() - tick < DST_OS_GetTicksPerSecond()/3) break;
				DST_AddKey(true, KeyCode, DST_OS_GetTickCount());
				tick = DST_OS_GetTickCount(); 
				break;
			default:
				break;
		}
	}
}

void DST_ResetKeyCode()
{
	
}

DS_U8 DST_GetKeyCode() //  ޴ ȣ
{
	static bool bFirst = true;
	if (bFirst == true)
	{
		bFirst = false;
		DST_OS_SpawnTask((void(*)(void *))tKeyPad, (char*)"DSTAR_KEY", APP_TASK_PRIO_KEYPAD, WIN_MGR_TASK_STACKSIZE,  0);
	}
	DS_U8 KeyCode = DST_GetKey();
	if (KeyCode == 0) return 0;
	//  Ű ó
	static DS_U8 KeyCodes[7] = {0,0,0,0,0,0,0};
	KeyCodes[0] = KeyCodes[1]; KeyCodes[1] = KeyCodes[2]; KeyCodes[2] = KeyCodes[3];
	KeyCodes[3] = KeyCodes[4]; KeyCodes[4] = KeyCodes[5]; KeyCodes[5] = KeyCodes[6]; KeyCodes[6] = KeyCode;
	// 062596 Mute
	if (KeyCodes[0] == VK_0    && KeyCodes[1] == VK_6   && KeyCodes[2] == VK_2 && 
			KeyCodes[3] == VK_5 && KeyCodes[4] == VK_9 && KeyCodes[5] == VK_6 && KeyCodes[6] == VK_MUTE)
	{
		DST_ResetKeyCode();
		DST_Printf("Enter Engineer Menu\n");
		DST_CreateWin(WIN_ENGINEER_MODE); // Ͼ  
		return 0;
	}
	//  ¿ 
	if (KeyCodes[1] == VK_UP    && KeyCodes[2] == VK_DN   && KeyCodes[3] == VK_LEFT && 
			KeyCodes[4] == VK_RIGHT && KeyCodes[5] == VK_LEFT && KeyCodes[6] == VK_LEFT)
	{
		DST_ResetKeyCode();
		DST_Printf("Enter Engineer Menu\n");
		DST_CreateWin(WIN_ENGINEER_MODE); // Ͼ  
		return 0;
	}
	//  5  1
	if (KeyCodes[1] == VK_YELLOW    && KeyCodes[2] == VK_YELLOW   && KeyCodes[3] == VK_YELLOW && 
			KeyCodes[4] == VK_YELLOW && KeyCodes[5] == VK_YELLOW && KeyCodes[6] == VK_GREEN)
	{
		DST_ResetKeyCode();
		DST_Printf("Enter Engineer Menu\n");
		DST_CreateWin(WIN_ENGINEER_MODE); // Ͼ  
		return 0;
	}
	// 0 Mute 7 Mute
	if (KeyCodes[3] == VK_0 && KeyCodes[4] == VK_MUTE && KeyCodes[5] == VK_7 && KeyCodes[6] == VK_MUTE)
	{
		DST_ResetKeyCode();
		DST_g_bUseAirFreq = true;
		JST_RFUpdate(DST_GetIndexByRFNumber(18)); // RF 18 RF Ʈ ļ
		DST_Printf("Enter RF Update Mode\n");
		DST_CreateWin(WIN_RF_UPDATE); // RF Ʈ  
		return 0;
	}
	// 0 MUTE 3 MUTE
	if (KeyCodes[3] == VK_0 && KeyCodes[4] == VK_MUTE && KeyCodes[5] == VK_3 && KeyCodes[6] == VK_MUTE)
	{
		DST_ResetKeyCode();
		DST_Printf("Enter Factory Mode\n");
		DST_g_bUseAirFreq = true;
		DST_CreateWin(WIN_FACTORY_MODE); //   
		return 0;
	}
	// 0   3 
	if (KeyCodes[3] == VK_0 && KeyCodes[4] == VK_PREV && KeyCodes[5] == VK_3 && KeyCodes[6] == VK_PREV)
	{
		DST_ResetKeyCode();
		DST_Printf("Enter Factory Mode\n");
		DST_g_bUseAirFreq = true;
		DST_CreateWin(WIN_FACTORY_MODE); //   
		return 0;
	}
	// 0 ä  3 ä
	if (KeyCodes[3] == VK_0 && KeyCodes[4] == VK_PREV_CH && KeyCodes[5] == VK_3 && KeyCodes[6] == VK_PREV_CH)
	{
		DST_ResetKeyCode();
		DST_Printf("Enter Factory Mode\n");
		DST_g_bUseAirFreq = true;
		DST_CreateWin(WIN_FACTORY_MODE); //   
		return 0;
	}
	//HD200K okŰ 3  
	if (KeyCodes[4] == VK_FAC_OK&& KeyCodes[5] == VK_FAC_OK && KeyCodes[6] == VK_FAC_OK)
	{
		DST_ResetKeyCode();
		DST_Printf("Enter Factory Mode\n");
		DST_g_bUseAirFreq = true;
		DST_CreateWin(WIN_FACTORY_MODE); //   
		return 0;
	}
	return 	KeyCode;
}
