#ifndef __DST_HOST_INTERFACE_H__
#define __DST_HOST_INTERFACE_H__
#include "DST_Common.h"

#define VK_KEY_PWR		1
#define VK_KEY_UP		2
#define VK_KEY_DN		3
#define VK_PWR 4
#define VK_MENU 5
#define VK_LEFT 6
#define VK_RIGHT 7
#define VK_UP 8
#define VK_DN 9
#define VK_OK 10
#define VK_PREV 11
#define VK_CANCEL 12
#define VK_0 13
#define VK_1 14
#define VK_2 15
#define VK_3 16
#define VK_4 17
#define VK_5 18
#define VK_6 19
#define VK_7 20
#define VK_8 21
#define VK_9 22
#define VK_MUTE 23
#define VK_CH_UP 24
#define VK_CH_DN 25
#define VK_VOL_UP 26
#define VK_VOL_DN 27
#define VK_RED 28
#define VK_GREEN 29
#define VK_YELLOW 30
#define VK_BLUE 31	
#define VK_CC 32
#define VK_HYPHEN 33

#define VK_FAC_OK 34
#define VK_FAC_CANCEL 35

#define VK_ZOOM 36
#define VK_AUDIO 37
#define VK_EPG 38
#define VK_SIGNAL_METER 39
#define VK_PREV_CH 40
#define VK_PREV_MENU 41

#define KEY_ID_MAX	41 //  ū Ű Windows Manager Űó ȴ.

// Common Define
#define DST_OFF	0
#define DST_ON	1
#define DST_DISABLE	0
#define DST_ENABLE	1

// OSD Language
#define OSD_PORTUGUESE 0
#define OSD_SPANISH 1
#define OSD_ENGLISH  2

// Time Zone
#define TZ_ATLANTIC	0 //ATL
#define TZ_EASTERN	1 //EST
#define TZ_CENTRAL	2 //CST
#define TZ_MOUNTAIN	3 //MST
#define TZ_PACIFIC	4 //PST
#define TZ_ALASKA		5 //AKST
#define TZ_HAWAII		6 //HST


//CC Display
#define CC_OFF	0
#define CC_ON	1

//CC DisplayPref
#define CC_AUTO	0
#define CC_DISPLAY_DIGITAL	1
#define CC_DISPLAY_ANALOG	2
// CC
#define CC_CS1	1
#define CC_CS2	2
#define CC_CS3	3
#define CC_CS4	4
#define CC_CS5	5
#define CC_CS6	6
#define CC_CC1	7
#define CC_CC2	8
#define CC_CC3	9
#define CC_CC4	10
#define CC_TXT1	11
#define CC_TXT2	12
#define CC_TXT3	13
#define CC_TXT4	14
#define CC_KCC	15

// CC Size
#define CC_DEFAULT	0
#define CC_SMALL	1
#define CC_STANDARD	2
#define CC_LARGE	3
// CC Style
#define CC_STYLE1	1
#define CC_STYLE2	2
#define CC_STYLE3	3
#define CC_STYLE4	4
#define CC_STYLE5	5
#define CC_STYLE6	6
#define CC_STYLE7	7
// CC Color
#define CC_BLACK	1
#define CC_WHITE	2
#define CC_RED	3
#define CC_GREEN	4
#define CC_BLUE	5
#define CC_YELLOW	6
#define CC_MAGENTA	7
#define CC_CYAN	8
// CC Opacity
#define CC_SOLID	1
#define CC_TRANSPARENT	2
#define CC_TRANSLUCENT	3
#define CC_FLASHING	4
// CC EDGE_STYLE
#define CC_NONE	1
#define CC_RAISED	2
#define CC_DEPRESSED	3
#define CC_UNIFORM	4
#define CC_LEFT_DROP_SHADOW	5
#define CC_RIGHT_DROP_SHADOW	6
// CC FONT ON/OFF
#define CC_FONT_ON	1
#define CC_FONT_OFF	2

//Digital Audio Output
#define AUDIO_OUT_DOLBY	0
#define AUDIO_OUT_PCM	1

// Incredible Surround
#define AUDIO_INCREDIBLE_SURROUND	0
#define AUDIO_VIRTUAL_DOLBY	1

// DTV Source Format
#define SF_NO_SIGNAL	0
#define SF_AUDIO_ONLY	1
#define SF_SD_NORMAL	2
#define SF_SD_WIDE		3
#define SF_HD					4

#ifdef DSTAR
extern "C" void DST_KeyCallBack(int bKeypad, DS_U32 Code, int bPressed); // Ű ݹ
#else
extern "C" void DST_KeyCallBack(bool bRemocon, DS_U8 Code, bool bRepeat);
#endif
void DST_KeyTaskStart();

#endif
