#include "DST_ISDBT_ChannelTask.h"
#include "DST_CommonAPI.h"
#include "DST_HostInterface.h"
#include "DST_WinManagerTask.h" 
#include "sqlite3.h"
#include "dst_eroum_interface.h"
#include "DST_DB_Engine.h"
#include "DST_DB.h"
#include "DST_Parser.h"
#include "DST_MultipleStringStructure.h"
//#include "DST_OTC_Main.h"

DS_U16 DST_GetMHzFrequencybyIndex(int index);
int DST_GetAppShortVersionNumber();

void DST_SignalInfoCallBack(int nWidth, int nHeight, int RefreshRate, bool bInterlaced,	DHL_SOURCE_ASEPCT Aspect);
void DST_VideoFreezeEndProc();
void DST_SBTVDCC_Reset();
DS_U8* JST_Arib2Utf8(DS_U8* strArib, int nLen);

#define MAX_EIT_COUNT 4 
#define MAX_PMT_COUNT 16

#define POS_TVCT 0
#define POS_CVCT (POS_TVCT+1)
#define POS_STT (POS_CVCT+1)
#define POS_MGT (POS_STT+1)
#define POS_EIT (POS_MGT+1)
#define POS_ETT (POS_EIT+MAX_EIT_COUNT)
#define POS_PAT (POS_ETT+MAX_EIT_COUNT)
#define POS_PMT (POS_PAT+1)
#define POS_RFUPDATE (POS_PMT+MAX_PMT_COUNT)
#define POS_CVT (POS_RFUPDATE+1)
#define POS_OTC_DII (POS_CVT+1)
#define POS_OTC_DDB (POS_OTC_DII+1)

#if 0
____FREQUENCY___()
#endif

DS_U8* JST_Uni2Utf8(DS_U16* strUni, int nLen)
{
	if (nLen == 0) return 0;
	if (strUni == 0) return 0;
	DS_U16 strTmp16[4097];
	memset(strTmp16, 0,  sizeof(strTmp16));
	if (nLen > 4096) nLen = 4096;
	memcpy(strTmp16, strUni, nLen * sizeof(DS_U16));
	nLen = strlen16(strTmp16);
	if (nLen == 0) return 0;
	DS_U8* buff = (DS_U8*)DST_OS_Calloc(nLen*4+1,1);
	int nPos = 0;
	for (int i = 0; i < nLen; i++)
	{
		DS_U32 uni = strUni[i];
		if (uni <= 0x7F)
		{ // 0xxxxxxx
			buff[nPos] = uni;
			nPos++;
			continue;
		}
		if (uni <= 0x7FF)
		{ // 110xxxxx 10xxxxxx
			buff[nPos] = 0xC0 | (uni >> 6);
			nPos++;
			buff[nPos] = 0x80 | (uni & 0x3F);
			nPos++;
			continue;			
		}
		if (uni <= 0xFFFF)
		{ // 1110xxxxx 10xxxxxx 10xxxxxx
			buff[nPos] = 0xE0 | (uni >> 12);
			nPos++;
			buff[nPos] = 0x80 | ((uni >> 6) & 0x3F);
			nPos++;
			buff[nPos] = 0x80 | (uni & 0x3F);
			nPos++;
			continue;			
		}
		// 11110zzz 10zzxxxx 10xxxxxx 10xxxxxx
		uni = uni & 0x1FFFFF;
		buff[nPos] = 0xF0 | (uni >> 18);
		nPos++;
		buff[nPos] = 0x80 | ((uni >> 12) & 0x3F);
		nPos++;
		buff[nPos] = 0x80 | ((uni >> 6) & 0x3F);
		nPos++;
		buff[nPos] = 0x80 | (uni & 0x3F);
		nPos++;
	}
	return buff;
}

class mss2utf8
{
private:
	char *strUTF8;
public:
	mss2utf8()
	{
		strUTF8 = 0;
	}
	mss2utf8(DS_U8 nLen, DS_U8 *text)
	{
		strUTF8 = 0;
		set(nLen, text);
	}
	void set(DS_U8 nLen, DS_U8 *text)
	{
		DST_OS_Free(&strUTF8);
		if (nLen == 0 || text == 0) return;
		DS_U16 strUni[4096];
		memset(strUni, 0, 4096*2);
		DMW_Decode_MultipleStringStructure(nLen, text, (char*)"kor",4096-1, strUni);
		strUTF8 = (char*)JST_Uni2Utf8(strUni, 4096-1);
	}
	char* get()
	{
		if (strUTF8) return strUTF8;
		static char *strEmpty = (char*)"";
		return strEmpty;
	}
	~mss2utf8()
	{
		DST_OS_Free(&strUTF8);
	}
};

#if 0
____MUTE___()
#endif

static DS_U32 g_VideoMute = 0;
static DS_U32 g_AudioMute = 0;
static DS_U8  g_AudioVolume = 0;

static void CT_VideoMute(DS_U8 nPos, bool bVal)
{
	DS_U32 nVal = bVal ? (g_VideoMute | (1 << nPos)) : (g_VideoMute & (~(1 << nPos)));
	if (nVal == g_VideoMute) return;
	if (g_VideoMute == 0 || nVal == 0) DHL_VID_Mute(bVal);
	g_VideoMute = nVal;
}

static void CT_AudioMute(DS_U8 nPos, bool bVal)
{
	DS_U32 nVal = bVal ? (g_AudioMute | (1 << nPos)) : (g_AudioMute & (~(1 << nPos)));
	if (nVal == g_AudioMute) return;
	if (g_AudioMute == 0 || nVal == 0) DHL_AUD_Volume(bVal ? g_AudioVolume : 0);
	g_AudioMute = nVal;
}

void CT_AudioVolume(DS_U8 nVal)
{
	g_AudioVolume = nVal;
	CT_AudioMute(0, nVal ? true : false);
}

// mute ó
static void CT_ChannelChangeVideoMute(bool bMute)
{
	CT_VideoMute(1, bMute);
}
static void CT_ChannelChangeAudioMute(bool bMute)
{
	CT_AudioMute(1, bMute);
}

//static void CT_DigitalSignalMute(bool bMute)
//{
//	CT_VideoMute(2, bMute);
//	CT_AudioMute(2, bMute);
//}

void CT_AutoScanMute(bool bMute)
{
	CT_VideoMute(3, bMute);
	CT_AudioMute(3, bMute);
}

void CT_RatingMute(bool bMute)
{
	CT_VideoMute(4, bMute);
	CT_AudioMute(4, bMute);
}


#if 0
____CHANNEL_MAP___()
#endif

class CDBString
{
private:
	char* strText;
public:

	CDBString(const char* strSQL)
	{
		strText = (char*)DST_OS_Calloc(1,1);
		Add("%s", strSQL);
	}
	~CDBString()
	{
		DST_OS_Free(&strText);
	}
	int Add(const char* strSQL, ...)
	{
		if (strSQL == 0) return 0;
		va_list ap;
	  char *z;
		va_start(ap, strSQL);
	  z = sqlite3_vmprintf(strSQL, ap);
	  va_end(ap);
		int nLen = strlen(strText) + strlen(z) + 1;
		char* strTmp = (char*)DST_OS_Calloc(nLen,1);
		sprintf(strTmp, "%s%s",strText, z);
		DST_OS_Free(&strText);
		sqlite3_free(z);
		strText = strTmp;	
		return nLen;
	}
	void Run()
	{
		// insert   óϱ ؼ  ڰ ǥ ̽ ȯ
		int nLen = strlen(strText);
		if (strText[nLen-1] == ',') 
		{
			strText[nLen-1] = ' ';
			CDB db;
			db.Query("%s", strText);
		}
		strText[0] = 0; // clear
	}
};

static DS_U8* GetMpegDescriptor (DS_U8 *descriptors, DS_U16 len, DS_U8 tag, DS_U8& tag_len)
{
	if (descriptors == 0 || len == 0) return 0;
	int nPos = 0;
	while (nPos < len)
	{
		DS_U8 nTag = descriptors[nPos];
		DS_U8 nLen = descriptors[nPos+1];
		if (nPos + nLen + 2 > len) break; // Էµȵ   Ͱ ִ°
		if (nTag == tag)
		{
			tag_len = nLen;
			return &descriptors[nPos];
		}
		nPos += (nLen + 2);
	}
	return 0;
}

static int GetMpegDescriptorCount (DS_U8 *descriptors, DS_U16 len, DS_U8 tag)
{
	if (descriptors == 0 || len == 0) return 0;

	int nCount = 0;
	int nPos = 0;
	while (nPos < len)
	{
		DS_U8 nTag = descriptors[nPos];
		
		DS_U8 nLen = descriptors[nPos+1];
		if (nPos + nLen + 2 > len) break; // Էµȵ   Ͱ ִ°
		if (nTag == tag) nCount++;
		nPos += (nLen + 2);
	}
	return nCount;
}

// ڿ  ' ' 
static void Trim(DS_U16 *strText, int nLen)
{
	for (int i=nLen-1; i >= 0; i--)
	{
		if (strText[i] == ' ')
		{
			strText[i] = 0;
			continue;
		}
		break;
	}
}

static bool CT_ChMapUpdateTVCT(DS_U8 RF, TVCT *tvct, DS_U32 CRC32)
{
	if (tvct == 0) return false;
	if (tvct->numChannels == 0) return false;
	if (tvct->channel == 0) return false;
		
	CDB db;
//	db.Query("create table if not exists tvct(rf int unique, transport_stream_id int, version_number int, crc32)");	
// 	db.Query("create table if not exists tvct_sub("
// 		"rf int, short_name text, long_name text, major_channel_number int, minor_channel_number int, "
// 		"modulation_mode int, carrier_frequency int, channel_TSID int, program_number int, ETM_location int, "
// 		"access_controlled int, hidden int, show_guide int,  service_type int, source_id int)");

  	db.GetTable("select crc32 from tvct where rf = %d and crc32 = %d", RF, CRC32);
	if(db.GetRow() > 0) return false; // ̹  TVCT äθʿ ִ°
	db.Query("insert or replace into tvct values(%d, %d, %d, %d)", 
		RF, tvct->transport_stream_id, tvct->version_number, (int)CRC32);
	CDBString tvct_sub("insert into tvct_sub values");
	tvctChannelPtr_t channel = tvct->channel;
	for (int i = 0; i < tvct->numChannels; i++, channel++)
	{
		Trim(channel->short_name, 7);
		DS_U8* strName = JST_Uni2Utf8(channel->short_name, 7);
		mss2utf8 strExtName;
		if (GetMpegDescriptorCount(channel->descriptors, channel->descriptor_length, extended_channel_name_tag))
		{
			DS_U8 tag_len = 0;
			DS_U8 *p = GetMpegDescriptor(channel->descriptors, channel->descriptor_length, extended_channel_name_tag, tag_len);
			strExtName.set(tag_len, p+2);
		}
		tvct_sub.Add("(%d, %Q, %Q, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d),",
			RF, strName, strExtName.get(),
			channel->major_channel_number, channel->minor_channel_number,
			channel->modulation_mode, channel->carrier_frequency,
			channel->channel_TSID, channel->program_number,
			channel->ETM_location, channel->access_controlled,
			channel->hidden, channel->show_guide,
			channel->service_type, channel->source_id
			);
		DST_OS_Free(&strName);
#if 1
		DST_Printf("tvct descriptor = %x\n",  (int)channel->descriptors);
		DST_Printf("descriptor_length = %d\n", (int)channel->descriptor_length);
		for (int i = 0; i < channel->descriptor_length; i++) DST_Printf("%02X ", channel->descriptors[i]);
		DST_Printf("\n");
#endif
	}
	db.Query("delete from tvct_sub where rf = %d", RF);
	tvct_sub.Run();
	return true;
}

static bool CT_ChMapUpdateCVCT(DS_U32 RF, CVCT *cvct, DS_U32 CRC32)
{
	if (cvct == 0) return false;
	if (cvct->numChannels == 0) return false;
	if (cvct->channel == 0) return false;

	CDB db;
//	db.Query("create table if not exists cvct(rf int unique, transport_stream_id int, version_number int, crc32)");	
// 	db.Query("create table if not exists cvct_sub("
// 		"rf int, short_name text, long_name text, major_channel_number int, minor_channel_number int, "
// 		"modulation_mode int, carrier_frequency int, channel_TSID int, program_number int, ETM_location int, "
// 		"access_controlled int, hidden int, show_guide int, service_type int, source_id int)");

  	db.GetTable("select crc32 from cvct where rf = %d and crc32 = %d", RF, CRC32);
	if(db.GetRow() > 0) return false; // ̹  CVCT äθʿ ִ°
	db.Query("insert or replace into cvct values(%d, %d, %d, %d)", 
		RF, cvct->transport_stream_id, cvct->version_number, (int)CRC32);
	CDBString cvct_sub("insert into cvct_sub values");
	cvctChannelPtr_t channel = cvct->channel;
	int nValidCount = 0;
	for (int i = 0; i < cvct->numChannels; i++, channel++)
	{
		Trim(channel->short_name, 7);
		DS_U8* strName = JST_Uni2Utf8(channel->short_name, 7);
		mss2utf8 strExtName;
		if (GetMpegDescriptorCount(channel->descriptors, channel->descriptor_length, extended_channel_name_tag))
		{
			DS_U8 tag_len = 0;
			DS_U8 *p = GetMpegDescriptor(channel->descriptors, channel->descriptor_length, extended_channel_name_tag, tag_len);
			strExtName.set(tag_len, p+2);
		}
		// ATSC_private_information_descriptor
		// KLabsŬDTV_ۼǥ_-1
		bool bCrear = true;
		if (GetMpegDescriptorCount(channel->descriptors, channel->descriptor_length, 0xAD))
		{
			DS_U8 tag_len = 0;
			DS_U8 *p = GetMpegDescriptor(channel->descriptors, channel->descriptor_length, 0xAD, tag_len);
			if (p[0] == 0xAD) // descriptor_tag
			{
				if (p[1] >= 9) // descriptor_length
				{
					if (p[2] == 0x54 && p[3] == 0x54 && p[4] == 0x41 && p[5] == 0x30) // format_identifier
					{
						if (p[6] >= 1) // private_info_count
						{
							if (p[7] == 0x02) // private_info_type Ŭ DTV 
							{
								if (p[8] == 0x02) // private_info_length
								{
									DS_U8 ch_frequency_version_number = p[9];
									DS_U8 channel_mode = (p[10] >> 4) & 0x0F;
									DS_U8 resolution = p[10] & 0x0F;
									DST_Printf("ch_frequency_version_number = %d channel_mode =%d resolution =%d\n", ch_frequency_version_number, channel_mode, resolution);
									bCrear = (channel_mode == 0) ? true : false;
								}
							}
						}
					}
				}
			}
		}
		
		bool bValidMajorMinor = true;
		int major = channel->major_channel_number;
		int minor = channel->minor_channel_number;
		if (major < 1000)
		{
			bValidMajorMinor = (minor > 0 && minor < 1000);
		}	
		else if (major >= 0x3F0)
		{
			major = (major & 0x0F) * 1024 + minor;
			minor = 0;
		}
		else
		{
			bValidMajorMinor = false;
		}
		bool bIsCurrentRF = true;
		{
			if (channel->carrier_frequency)
			{
				DS_U32 freq = 1000000 * DST_GetMHzFrequencybyIndex(RF);
				//freq = 645000000; // TEST ڵ
				bIsCurrentRF = (freq == channel->carrier_frequency);
			}
		}
		if (bCrear && bValidMajorMinor && channel->hidden==0 && bIsCurrentRF)
		{
			nValidCount++;
			cvct_sub.Add("(%d, %Q, %Q, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d),",
				RF, strName, strExtName.get(),
				major, minor,
				channel->modulation_mode, channel->carrier_frequency,
				channel->channel_TSID, channel->program_number,
				channel->ETM_location, channel->access_controlled,
				channel->hidden, channel->show_guide,
				channel->service_type, channel->source_id
				);
		}
		DST_OS_Free(&strName);
#if 1
		DST_Printf("cvct descriptor = %x\n",  (int)channel->descriptors);
		DST_Printf("descriptor_length = %d\n", (int)channel->descriptor_length);
		for (int i = 0; i < channel->descriptor_length; i++) DST_Printf("%02X ", channel->descriptors[i]);
		DST_Printf("\n");
#endif
	}
	db.Query("delete from cvct_sub where rf = %d", RF);
	if (nValidCount > 0) cvct_sub.Run();
	
#if 1
		DST_Printf("cvct additional_descriptors = %x\n",  (int)cvct->additional_descriptors);
		DST_Printf("cvct additional_descriptor_length = %d\n", (int)cvct->additional_descriptor_length);
		for (int i = 0; i < cvct->additional_descriptor_length; i++) DST_Printf("%02X ", cvct->additional_descriptors[i]);
		DST_Printf("\n");
#endif

	return true;
}

//  PAT Ʈ Ǹ VCT   ޴´
// ȯ ſ̴.
static bool CT_ChMapUpdatePAT(DS_U8 RF, MPEG_PAT *pat, DS_U32 CRC32)
{
	if (pat == 0) return false;
	CDB db;
	db.GetTable("select crc from pat where rf =%d", RF);
	bool bUpdate = false; // ó޴°
	if (db.GetRow() > 0) //  ִ CRC  ˻
	{
		if ((int)CRC32 == atoi(db.GetResult(1))) return false; // Ѱ ִٸ Ʈ  
		bUpdate = true; // ϴ°
	}
	
	CDBString str("insert into pat values");
	for (int i = 0; i < pat->numPrograms; i++)
	{
		DS_U16 program_number = pat->programs[i].program_number;
		DS_U16 pid = pat->programs[i].program_map_PID;
//		if (CT_IsFixedPID(pid) == true) continue;
//		if (CT_CheckServiceID(program_number) == -1) continue;
		str.Add("(%d, %d, %d, %d),", RF, program_number, pid, CRC32);
	}
	db.Query("delete from pat where rf=%d", RF);
	str.Run();
	//  PMT  	
	db.Query("delete from pmt where rf =%d and program_number not in (select program_number from pat where rf =%d)", RF, RF);
	return bUpdate; // Ʈ ƴ ȯ
}


static int g_ChCount = 0;
int CT_ChMapCount()
{
	return g_ChCount;
}

void CT_ChMapUpdate()
{
	// CVCT 켱
	//  CVCT  TVCT Ѵ.
	// TVCT CVCT   RF PMT äη óѴ.
	CDB db;
	db.Query("drop table if exists channel_db;"
	"create table channel_db as " 
	"select tvct_sub.rf as rf, case when (length(long_name)< length(short_name)) then short_name else long_name end as name, major_channel_number as major, minor_channel_number as minor, tvct_sub.program_number, source_id, pcr_pid, video_pid, video_type "
	"from tvct_sub "
	"left join pmt "
	"on tvct_sub.rf = pmt.rf and tvct_sub.program_number = pmt.program_number " 
	"where hidden =0  and tvct_sub.rf not in (select rf from cvct) "
	"union "
	"select cvct_sub.rf, case when (length(long_name)< length(short_name)) then short_name else long_name end, major_channel_number, minor_channel_number, cvct_sub.program_number, source_id, pcr_pid, video_pid, video_type "
	"from cvct_sub "
	"left join pmt "
	"on cvct_sub.rf = pmt.rf and cvct_sub.program_number = pmt.program_number " 
	"where hidden =0 "
	"union "
	"select pmt.rf, '', case when (pmt.rf<96) then pmt.rf+2 else pmt.rf+4 end, minor, pmt.program_number, 0, pcr_pid, video_pid, video_type "
	"from pmt where rf not in "
	"(select rf from cvct union select rf from tvct) "
	"order by major_channel_number, tvct_sub.rf, minor_channel_number;"
	
	"drop table if exists channel_updn;"
	"create table channel_updn as "
	"select major, channel_db.rf, minor, channel_db.program_number "
	"FROM channel_db "
	"LEFT JOIN skip_list "
	"ON channel_db.rf = skip_list.rf and channel_db.program_number = skip_list.program_number "
	"WHERE skip_list.program_number IS NULL;"
	
	);
	
	db.GetTable("select rf from channel_db");
	g_ChCount = db.GetRow();
	
	DST_DB_Sync();
}

static bool g_bReceiveCCDescriptor = false;

#define MAX_PMT_CC_TABLE_COUNT 500
struct PMT_CC_TABLE
{
	int rf;
	int program_number;
	char language[4];
	int cc_type;
	int cc_id;
	int easy_reader;
	int wide_aspect_ratio;
	int korean_code;
};

static PMT_CC_TABLE pmt_cc_table[MAX_PMT_CC_TABLE_COUNT];

static void CT_ChMapUpdatePMTCCDescriptor(DS_U32 RF, DS_U16 prog_num, DS_U8 *descriptors, DS_U16 descriptor_length)
{
	T();
	if(descriptors == 0 || descriptor_length == 0) return;
	DS_U8 tag_len = 0;
	DS_U8 *p = GetMpegDescriptor(descriptors, descriptor_length, caption_service_tag, tag_len );
	if (tag_len == 0)	return;
	DST_Printf("tag_len = %d\n", tag_len); for (int i=0; i < tag_len+2; i++) DST_Printf("0x%02X ", p[i]); DST_Printf("\n");
	captionServiceDescriptorPtr_t descripPtr = 0;
	T();
	if (DHL_PSI_ParseCaptionServiceDescriptor(p, &descripPtr))	return;
	T();
	if (descripPtr == 0)	return;
	CDB db;
	DST_Printf("descripPtr->number_of_services = %d\n", descripPtr->number_of_services);
	captionServicePtr_t captionService = descripPtr->service;
	for(int idx = 0 ; idx < descripPtr->number_of_services ; idx++, captionService++)
	{
		if(captionService == 0) break;
		DS_U8 ccId = (captionService->cc_type == cct_line21) ? captionService->cc_id.line21_field : captionService->cc_id.caption_service_number;
		char strLanguage[4] = "kor";
		strcpy(strLanguage, captionService->language);
		DST_Printf("strLanguage = %s\n", strLanguage);
			
		bool bFind = false;
		for (int i = 0; i < MAX_PMT_CC_TABLE_COUNT; i++)
		{
			if (pmt_cc_table[i].rf == 0 || (pmt_cc_table[i].rf == (int)RF && pmt_cc_table[i].program_number == prog_num))
			{
				pmt_cc_table[i].rf = RF;
				pmt_cc_table[i].program_number = prog_num;
				strcpy(pmt_cc_table[i].language,strLanguage);
				pmt_cc_table[i].cc_type = captionService->cc_type;
				pmt_cc_table[i].cc_id = ccId;
				pmt_cc_table[i].easy_reader = captionService->easy_reader;
				pmt_cc_table[i].wide_aspect_ratio = captionService->wide_aspect_ratio;
				pmt_cc_table[i].korean_code = captionService->korean_code;
				bFind = true;
				DST_Printf("%s|pmt_cc_table|captionService->cc_type = %d\n", __func__, captionService->cc_type);
				DST_Printf("%s|pmt_cc_table|ccId = %d\n", __func__, ccId);
				DST_Printf("%s|pmt_cc_table|captionService->easy_reader = %d\n", __func__, captionService->easy_reader);
				DST_Printf("%s|pmt_cc_table|captionService->wide_aspect_ratio = %d\n", __func__, captionService->wide_aspect_ratio);
				DST_Printf("%s|pmt_cc_table|captionService->korean_code = %d\n", __func__, captionService->korean_code);
				break;
			}
		}
		if (bFind == false)
		{
			T();
			memset(pmt_cc_table, 0, sizeof(pmt_cc_table));
			CT_ChMapUpdatePMTCCDescriptor(RF, prog_num, descriptors, descriptor_length);
		}			
		g_bReceiveCCDescriptor = true;
	}
	DHL_PSI_FreeMpegDescriptor(descripPtr);
}


#define MAX_PMT_AC3_TABLE_COUNT 500
struct PMT_AC3_TABLE
{
	int rf;
	int program_number;
	int pid;
	int bsmod;
	int full_svc;
	int langcod;
	char language[4];
};

static PMT_AC3_TABLE pmt_ac3_table[MAX_PMT_AC3_TABLE_COUNT];

static void CT_ChMapUpdatePMTAC3AudioDescriptor(DS_U32 RF, DS_U16 prog_num, DS_U16 pid, DS_U8 *descriptors, DS_U16 descriptor_length)
{
	T();
	if (descriptors == 0 || descriptor_length == 0) return;
	T();
	DS_U8 tag_len = 0;
	DS_U8 *p = GetMpegDescriptor(descriptors, descriptor_length, AC3_audio_stream_tag, tag_len );
	if (tag_len == 0)	return;
	DST_Printf("tag_len = %d\n", tag_len); for (int i=0; i < tag_len+2; i++) DST_Printf("0x%02X ", p[i]); DST_Printf("\n");
	ac3AudioStreamDescriptorPtr_t descripPtr = 0;
	if (DHL_PSI_ParseAc3AudioStreamDescriptor(p, &descripPtr))	return;
	if (descripPtr == 0)	return;
	CDB db;
	char strLanguage[4] = {0,0,0,0};
	strcpy(strLanguage, descripPtr->language);
	DST_Printf("strLanguage = %s\n", strLanguage);
	
	bool bFind = false;
	for (int i = 0; i < MAX_PMT_AC3_TABLE_COUNT; i++)
	{
		if (pmt_ac3_table[i].program_number == 0 || (pmt_ac3_table[i].rf == (int)RF && pmt_ac3_table[i].program_number == prog_num && pmt_ac3_table[i].pid == pid))
		{
			pmt_ac3_table[i].rf = RF;
			pmt_ac3_table[i].program_number = prog_num;
			pmt_ac3_table[i].pid = pid;
			pmt_ac3_table[i].bsmod = descripPtr->bsmod;
			pmt_ac3_table[i].full_svc = descripPtr->full_svc;
			pmt_ac3_table[i].langcod = descripPtr->langcod;
			strcpy(pmt_ac3_table[i].language, strLanguage);
			bFind = true;
			DST_Printf("%s|pmt_ac3_table|%d\n", __func__, i);
			DST_Printf("%s|pmt_ac3_table|pid = %d\n", __func__, pid);
			DST_Printf("%s|pmt_ac3_table|descripPtr->bsmod = %d\n", __func__, descripPtr->bsmod);
			DST_Printf("%s|pmt_ac3_table|descripPtr->full_svc = %d\n", __func__, descripPtr->full_svc);
			DST_Printf("%s|pmt_ac3_table|descripPtr->langcod = %d\n", __func__, descripPtr->langcod);
			break;
		}
	}
	if (bFind == false)
	{
		T();
		memset(pmt_ac3_table, 0, sizeof(pmt_ac3_table));
		CT_ChMapUpdatePMTAC3AudioDescriptor(RF, prog_num, pid, descriptors, descriptor_length);
	}			
	DHL_PSI_FreeMpegDescriptor(descripPtr);
}

#define MAX_PMT_ISO_TABLE_COUNT 500
struct PMT_ISO_TABLE
{
	int rf;
	int program_number;
	int pid;
	char lang[4];
	int type;
};
static PMT_ISO_TABLE pmt_iso_table[MAX_PMT_ISO_TABLE_COUNT];

static void CT_ChMapUpdatePMTISO639LanguageDescriptor(DS_U32 RF, DS_U16 prog_num, DS_U16 pid, DS_U8 *descriptors, DS_U16 descriptor_length)
{
	T();
	if (descriptors == 0 || descriptor_length == 0) return;
	T();
	DS_U8 tag_len = 0;
	DS_U8 *p =  GetMpegDescriptor(descriptors, descriptor_length, ISO_639_language_tag, tag_len);
	if (tag_len == 0)	return;
	DST_Printf("tag_len = %d\n", tag_len); for (int i=0; i < tag_len+2; i++) DST_Printf("0x%02X ", p[i]); DST_Printf("\n");
	if (p[1] < 4) return;
	char ISO_639_Language_code[4];
	ISO_639_Language_code[0] = (char)p[2];
	ISO_639_Language_code[1] = (char)p[3];
	ISO_639_Language_code[2] = (char)p[4];
	ISO_639_Language_code[3] = 0;
	DS_U8 audio_type = p[5];
	
	bool bFind = false;
	for (int i = 0; i < MAX_PMT_AC3_TABLE_COUNT; i++)
	{
		if (pmt_iso_table[i].program_number == 0 || (pmt_iso_table[i].rf == (int)RF && pmt_iso_table[i].program_number == prog_num && pmt_iso_table[i].pid == pid))
		{
			pmt_iso_table[i].rf = RF;
			pmt_iso_table[i].program_number = prog_num;
			pmt_iso_table[i].pid = pid;
			strcpy(pmt_iso_table[i].lang, ISO_639_Language_code);
			pmt_iso_table[i].type = audio_type;
			bFind = true;
			DST_Printf("%s|pmt_iso_table|%d\n", __func__, i);
			DST_Printf("%s|pmt_iso_table|pid = %d\n", __func__, pid);
			DST_Printf("%s|pmt_iso_table|ISO_639_Language_code = %s\n", __func__, ISO_639_Language_code);
			DST_Printf("%s|pmt_iso_table|audio_type = %d\n", __func__, audio_type);
			break;
		}
	}
	if (bFind == false)
	{
		T();
		memset(pmt_iso_table, 0, sizeof(pmt_iso_table));
		CT_ChMapUpdatePMTISO639LanguageDescriptor(RF, prog_num, pid, descriptors, descriptor_length);
	}			
}

#define MAX_PMT_AUDIO_TABLE_COUNT 500
struct PMT_AUDIO_TABLE
{
	int rf;
	int program_number;
	int pid;
	int type;
	int component_tag;
};
static PMT_AUDIO_TABLE pmt_audio_table[MAX_PMT_AUDIO_TABLE_COUNT];

static void CT_PMT_AudioTableUpdate(int rf, int program_number, int pid, int type, int component_tag)
{
	//   ̹ ִ 
	for (int j = 0; j < MAX_PMT_AUDIO_TABLE_COUNT; j++)
	{
		if (pmt_audio_table[j].rf != rf) continue;
		if (pmt_audio_table[j].program_number != program_number) continue;
		if (pmt_audio_table[j].pid != pid) continue;
		pmt_audio_table[j].rf = rf;
		pmt_audio_table[j].program_number = program_number;
		pmt_audio_table[j].pid = pid;
		pmt_audio_table[j].type = type;
		pmt_audio_table[j].component_tag = component_tag;
		return;
	}
	//  ã ִ´.
	for (int j = 0; j < MAX_PMT_AUDIO_TABLE_COUNT; j++)
	{
		if (pmt_audio_table[j].program_number != 0) continue;
		pmt_audio_table[j].rf = rf;
		pmt_audio_table[j].program_number = program_number;
		pmt_audio_table[j].pid = pid;
		pmt_audio_table[j].type = type;
		pmt_audio_table[j].component_tag = component_tag;
		return;
	}
	//  °  .
	memset(pmt_audio_table, 0, sizeof(pmt_audio_table));
	// ȣ
	CT_PMT_AudioTableUpdate(rf, program_number, pid, type, component_tag);
}

static bool CT_ChMapUpdatePMT(DS_U8 RF, MPEG_PMT *pmt, int minor, DS_U32 CRC32)
{
	if (pmt == 0) return false;
	CDB db;
	db.GetTable("select crc from pmt where rf =%d and crc=%d", RF, CRC32);
	//if (db.GetRow() > 0) return false;
	
	for (int i = 0 ; i < MAX_PMT_AUDIO_TABLE_COUNT; i++) if (pmt_audio_table[i].rf == (int)RF && pmt_audio_table[i].program_number == pmt->program_number) pmt_audio_table[i].rf = 0;
	for (int i = 0 ; i < MAX_PMT_CC_TABLE_COUNT; i++) if (pmt_cc_table[i].rf == (int)RF && pmt_cc_table[i].program_number == pmt->program_number) pmt_cc_table[i].rf = 0;
	for (int i = 0 ; i < MAX_PMT_AC3_TABLE_COUNT; i++) if (pmt_ac3_table[i].rf == (int)RF && pmt_ac3_table[i].program_number == pmt->program_number) pmt_ac3_table[i].rf = 0;	
	for (int i = 0 ; i < MAX_PMT_ISO_TABLE_COUNT; i++) if (pmt_iso_table[i].rf == (int)RF && pmt_iso_table[i].program_number == pmt->program_number) pmt_iso_table[i].rf = 0;

	DS_U16 video_pid = 0;
	DS_U8  video_stream_type = 0;
	for (int i = 0; i < pmt->numStreams; i++)
	{
		DS_U16 pid = pmt->streams[i].elementary_PID;
		if (pid == 0 || pid >= 0x1FFF) continue;
		DS_U8 stream_type = pmt->streams[i].stream_type;
		DS_U8 component_tag = pmt->streams[i].component_tag;
		switch (stream_type)
		{
			case StreamType_MPEG1Video:
			case StreamType_MPEG2Video:
			case StreamType_MPEG4Video:
			case StreamType_DC2Video:
				video_pid = pid;
				video_stream_type = stream_type;
				CT_ChMapUpdatePMTCCDescriptor(RF, pmt->program_number, pmt->streams[i].descriptors, pmt->streams[i].descriptor_length);
				break;
			case StreamType_MPEG1Audio:
			case StreamType_MPEG2Audio:
			case StreamType_MPEG4Audio:
			case StreamType_AACAudio:
			case StreamType_AC3Audio:
				CT_PMT_AudioTableUpdate(RF, pmt->program_number, pid, stream_type, component_tag);
				CT_ChMapUpdatePMTAC3AudioDescriptor(RF, pmt->program_number, pid, pmt->streams[i].descriptors, pmt->streams[i].descriptor_length);
				CT_ChMapUpdatePMTISO639LanguageDescriptor(RF, pmt->program_number, pid, pmt->streams[i].descriptors, pmt->streams[i].descriptor_length);
				break;
		}
	}
	db.Query(	"delete from pmt where rf=%d and program_number=%d;"
						"insert into pmt values(%d, %d, %d, 0, %d, %d,%d, %d)", 
						RF, pmt->program_number,
						RF, pmt->program_number, pmt->PCR_PID, video_pid, video_stream_type, minor, CRC32);
	return true;
}

static bool CT_ChMapUpdateEIT(DS_U8 rf, EIT *eit, DS_U8 id, DS_U32 CRC32)
{
	if (eit == 0) return false;
	CDB db;
	db.GetTable("select crc from eit where rf =%d and id=%d and source_id=%d", rf, id, eit->source_id);
	if(db.GetRow() > 0)
	{
		if ((int)CRC32 == atoi(db.GetResult(1)))
		{
			return false;
		}
		else
		{
			db.Query("delete from eit where rf = %d and id=%d and source_id=%d", rf, id, eit->source_id);
			db.Query("delete from eit_sub where rf = %d and id=%d and source_id=%d", rf, id, eit->source_id);
		}
	}
	db.Query("insert into eit values(%d, %d, %d, %d, %d)", rf, id, eit->source_id, eit->version_number, CRC32);
	CDBString eit_sub("insert into eit_sub values");
	eitEventPtr_t event = eit->event;
	for (int i = 0; i < eit->numEvents; i++, event++)
	{
		mss2utf8 strTitle(event->title_length,event->title);
		eit_sub.Add("(%d, %d, %d, %d, %d, %d, %Q),",
				rf, id, eit->source_id,  event->event_id, event->start_time, event->length_in_seconds, 
				strTitle.get());
	}
	if (eit->numEvents > 0) eit_sub.Run();
	return true;
}

static bool CT_ChMapUpdateETT(DS_U8 rf, ETT *ett, DS_U32 crc)
{
	if (ett == 0) return false;
	CDB db;
	db.GetTable("select crc from ett where rf =%d and crc=%d", rf, crc);
	if(db.GetRow() > 0) return false;
	mss2utf8 strText(ett->extended_text_message_length,ett->extended_text_message);
	db.Query("insert into ett values(%d, %d, %d, %Q, %d)", 
		rf, (ett->ETM_id>>16) & 0xFFFF, (ett->ETM_id>>2) & 0x3FFF, strText.get(), crc);
		
	//ȿ ETT 100  EIT   ETT Ѵ.
	static int nReceiveETTCount = 0;
	nReceiveETTCount++;
	if ((nReceiveETTCount % 100) == 0)
	{
		db.Query("delete from ett where crc in (select crc from ett left join eit_sub on "
			"eit_sub.rf = ett.rf and eit_sub.source_id = ett.source_id and  eit_sub.event_id = ett.event_id "
			"where id is null)");
	}	
	return true;
}


// äνĵ   ش RF 
void JST_DB_Del(DS_U8 nRF)
{
	CDB db;
	db.Query("delete from eit where rf=%d", nRF);
	db.Query("delete from eit_sub where rf=%d", nRF);
	db.Query("delete from ett where rf=%d", nRF);
	db.Query("delete from pat where rf=%d", nRF);
	db.Query("delete from pmt where rf=%d", nRF);
//	db.Query("delete from signal where rf=%d", nRF);
	db.Query("delete from tvct where rf=%d", nRF);
	db.Query("delete from tvct_sub where rf=%d", nRF);
	db.Query("delete from cvct where rf=%d", nRF);
	db.Query("delete from cvct_sub where rf=%d", nRF);
	db.Query("delete from channel_db where rf=%d", nRF);
	db.Query("delete from channel_updn where rf=%d", nRF);
}

#if 0
____CHANNEL_TASK___()
#endif

static int gMsgQ = 0;
static int gSIMsgQ = 0;

struct CT_Msg {
	DS_U8	Cmd;
	DHL_MODULATION_MODE demod;
	DS_U8 RF;
	DS_U16 program_number;
};

#define CMD_NULL	       0
#define CMD_TUNE	       1
#define CMD_SCAN	        2
#define CMD_RF_UPDATE 3
#define CMD_CVT              4
#define CMD_OTC             5
#define CMD_OTC_STOP   6
#define CMD_STOP	       8
#define CMD_CLOSE	       8

char* CT_GetMsgName(DS_U8 Cmd)
{
	static char strText[32];
	sprintf(strText, "Unknown");
	switch (Cmd)
	{
		case CT_RECEIVE_PAT:sprintf(strText, "CT_RECEIVE_PAT"); break;
		case CT_RECEIVE_PMT:sprintf(strText, "CT_RECEIVE_PMT"); break;
		case CT_RECEIVE_MGT:sprintf(strText, "CT_RECEIVE_MGT"); break;
		case CT_CHMAP_UPDATE:sprintf(strText, "CT_CHMAP_UPDATE"); break;
		case CT_SIGNAL_INFO:sprintf(strText, "CT_SIGNAL_INFO"); break;
		case CT_AV_START:sprintf(strText, "CT_AV_START"); break;
		case CT_SCAN_PSIP_WAIT:sprintf(strText, "CT_SCAN_PSIP_WAIT"); break;
		case CT_SCAN_LOCK_WAIT:sprintf(strText, "CT_SCAN_LOCK_WAIT"); break;
		case CT_TUNE_START:sprintf(strText, "CT_TUNE_START"); break;
		case CT_SCAN_START:sprintf(strText, "CT_SCAN_START"); break;
		case CT_STOPPED:sprintf(strText, "CT_STOPPED"); break;
		case CT_RECEIVE_PMT_CC:sprintf(strText, "CT_RECEIVE_PMT_CC"); break;
		case CT_RECEIVE_PMT_AUDIO:sprintf(strText, "CT_RECEIVE_PMT_AUDIO"); break;
	}
	return strText;
}

static jst_callback g_callback = 0;

static void CT_CallBack(DS_U8 Cmd = 0, DS_U32 p1 = 0, DS_U32 p2 = 0, DS_U32 p3 = 0, DS_U32 p4 = 0, DS_U32 p5 = 0, DS_U32 p6 = 0)
{
	////DST_Printf("Cmd = %s(%d) %d %d %d\n", CT_GetMsgName(Cmd), Cmd, p1, p2, p3);
	if (g_callback) g_callback(Cmd, p1, p2, p3, p4, p5, p6);
}

static void DST_FreeAtscTable(void *tablePtrPtr)
{
	if (tablePtrPtr == NULL || *(void **) tablePtrPtr == NULL) return;
	DHL_PSI_FreeMpegSection(*(void **) tablePtrPtr);
	*(void **) tablePtrPtr = NULL;
}

struct CT_SI_Msg {
	DS_U32 RF;
	DHL_MODULATION_MODE demod;
	DS_U32 nRequestID;
	DS_U32 *SI;
	DS_U32 CRC32;
};

struct MTS
{
	DS_U16 pid;
	DS_U8  type;
	bool bKorean;
	bool bVI;
};

static int CT_DB_GetAudioPidSub(MTS *mts, int mts_count)
{
//	for (int i = 0; i < mts_count; i++)
//	{
//		DST_Printf("mts[%d].bVI = %d mts[%d].bKorean = %d\n", i, mts[i].bVI, i, mts[i].bKorean);
//	}
	// ȭؼ + ѱ
	if (DST_EEPROM_GetVI() == 1 && DST_EEPROM_GetAudioPref() == 0) // ȭؼ
	{
		// ȭؼ̸鼭 ѱ
		for (int i = 0; i < mts_count; i++) if (mts[i].bVI == true && mts[i].bKorean == true) return i;
		// ù° ѱ
		for (int i = 0; i < mts_count; i++) if (mts[i].bKorean == true) return i;
		// ù Ʈ
		return 0;
	}
	// ȭؼ + ܱ
	if (DST_EEPROM_GetVI() == 1 && DST_EEPROM_GetAudioPref() == 1) // ȭؼ
	{
		// ȭؼ̸鼭 ܱ
		for (int i = 0; i < mts_count; i++) if (mts[i].bVI == true && mts[i].bKorean == false) return i;
		// ù° ܱ
		for (int i = 0; i < mts_count; i++) if (mts[i].bKorean == false) return i;
		// ι Ʈ
		return 1;
	}
	// ȭؼ (x) + ѱ
	if (DST_EEPROM_GetAudioPref() == 0) // ȭؼ
	{
		// ȭؼ۾ƴϸ鼭 ѱ
		for (int i = 0; i < mts_count; i++) if (mts[i].bVI == false && mts[i].bKorean == true) return i;
		// ù° ѱ
		for (int i = 0; i < mts_count; i++) if (mts[i].bKorean == true) return i;
		// ȭؼ۾ƴϸ鼭 ܱ
		for (int i = 0; i < mts_count; i++) if (mts[i].bVI == false && mts[i].bKorean == false) return i;
		// ù Ʈ
		return 0;
	}
	// ȭؼ (x) + ܱ
	// ȭؼ۾ƴϸ鼭 ܱ
	for (int i = 0; i < mts_count; i++) if (mts[i].bVI == false && mts[i].bKorean == false) return i;
	// ù° ܱ
	for (int i = 0; i < mts_count; i++) if (mts[i].bKorean == false) return i;
	// ȭؼ۾ƴϸ鼭 ѱ
	for (int i = 0; i < mts_count; i++) if (mts[i].bVI == false && mts[i].bKorean == true) return i;
	// ι Ʈ
	return 1;
}

// Էµ ڿ "kor" ˻Ѵ.
// -1 unknown 0: ܱ 1: ѱ
static int isKOR(char* strText)
{
	if (strText == 0) return -1;
	int nLen = strlen(strText);
	if (nLen != 3) return -1;
	for (int i= 0; i < nLen; i++) if (strText[i] >='A' || strText[i] <= 'Z') strText[i] -= ('A'-'a'); // tolower
	return (strcmp(strText, "kor") == 0) ? 1 : 0;
}


int CT_GetAudioCount(DS_U8 RF, DS_U16 program_number)
{
	int pmt_audio_count = 0;
	for (int i = 0; i < MAX_PMT_AUDIO_TABLE_COUNT; i++)
	{
		if (pmt_audio_table[i].rf == (int)RF && pmt_audio_table[i].program_number == program_number)
			pmt_audio_count++;
	}
	return pmt_audio_count;
}

static bool g_ReceivePMTAudio = false;
void CT_DB_GetAudioPid(DS_U8 RF, DS_U16 program_number, DS_U16* pid, DS_U8* type)
{
	static DS_U32 old_RF = 0;
	static DS_U16 old_program_number = 0;
	static DS_U16 old_pid = 0;
	static DS_U8 old_type = 0;
	if (g_ReceivePMTAudio == true || DST_g_AudioSettingChanged == true || old_RF != RF || old_program_number != program_number)
	{
		DST_g_AudioSettingChanged = false;
		
		int pmt_audio_count = 0;
		struct PMT_AUDIO
		{
			int pid;
			int type;
		};
		PMT_AUDIO pmt_audio[32];
		memset(pmt_audio, 0, sizeof(pmt_audio));
		for (int i = 0; i < MAX_PMT_AUDIO_TABLE_COUNT; i++)
		{
			if (pmt_audio_table[i].rf == (int)RF && pmt_audio_table[i].program_number == program_number)
			{
				pmt_audio[pmt_audio_count].pid = pmt_audio_table[i].pid;
				pmt_audio[pmt_audio_count].type = pmt_audio_table[i].type;
				pmt_audio_count++;
			}
			if (pmt_audio_count == 32) break;
		}
		if (pmt_audio_count < 1)
		{
			*pid = 0; *type = 0;
		}
		else
		{
			if (pmt_audio_count == 1)
			{
				*pid = pmt_audio[0].pid;
				*type = pmt_audio[0].type;
			}
			else
			{
				int mts_count = pmt_audio_count;
				MTS *mts = (MTS*)DST_OS_Malloc(sizeof(MTS)*mts_count);
				for (int i = 0; i < mts_count; i++)
				{
					mts[i].pid = pmt_audio[i].pid;
					mts[i].type = pmt_audio[i].type;
					mts[i].bKorean = true;
					mts[i].bVI = false;
					int nKorean[3] = {-1, -1, -1}; // unknown
					// AC-3 Audio Descriptor  켱  
					for (int j = 0; j < MAX_PMT_ISO_TABLE_COUNT; j++)
					{
						if (pmt_iso_table[j].rf == (int)RF && pmt_iso_table[j].program_number == program_number && pmt_iso_table[j].pid == mts[i].pid)
						{
						DS_U8 audio_type = pmt_iso_table[j].type;
						mts[i].bVI = (audio_type == 0x03);
						nKorean[0] = isKOR(pmt_iso_table[j].lang);
						break;
					}
					}
					for (int j = 0; j < MAX_PMT_AC3_TABLE_COUNT; j++)
					{
						if (pmt_ac3_table[j].rf == (int)RF && pmt_ac3_table[j].program_number == program_number && pmt_ac3_table[j].pid == mts[i].pid)
						{
							DS_U8 bsmod = pmt_ac3_table[j].bsmod;
							DS_U8 full_svc = pmt_ac3_table[j].full_svc;
							DS_U8 langcod = pmt_ac3_table[j].langcod;
							mts[i].bVI = (bsmod == 0x02 && full_svc == 0x01);
							nKorean[1] = (langcod == 0xFF) ? -1 : (langcod == 0x65) ? 1 : 0;
							nKorean[2] = isKOR(pmt_ac3_table[j].language);
							break;
						}
					}
//					DST_Printf("nKorean[0] = %d nKorean[1] = %d nKorean[2] = %d\n", nKorean[0], nKorean[1], nKorean[2]);
					if (nKorean[0] == 0 || nKorean[1] == 0 || nKorean[2] == 0) mts[i].bKorean = false; //  ϳ ܱ  ܱ 
					if (nKorean[0] == 1 || nKorean[1] == 1 || nKorean[2] == 1) mts[i].bKorean = true; //   ϳ ѱ  ѱ
					//iso  ac3  Ⱦ
					//˼ ˼ ѱ
					//˼ ܱ   ܱ
					//˼ ѱ   ѱ
					//ܱ   ˼ ܱ
					//ܱ   ܱ   ܱ
					//ܱ   ѱ   ѱ
					//ѱ   ˼ ѱ 
					//ѱ   ܱ   ѱ
					//ѱ	 ѱ   ѱ
				}
				int nPos = CT_DB_GetAudioPidSub(mts, mts_count);
				*pid =  mts[nPos].pid;
				*type = mts[nPos].type;
				DST_OS_Free(&mts);				
			}
		}
		g_ReceivePMTAudio = false;
		old_RF = RF;
		old_program_number = program_number;
		old_pid = *pid;
		old_type = *type;
	}
	else
	{
		*pid = old_pid; *type = old_type;
	}
}

//static void CT_DB_GetCCPid(DS_U8 RF, DS_U16 sID,DS_U16 pid[8])
//{
//	CDB db;
//	db.GetTable("select pid from pmt_cc where rf=%d and program_number=%d", RF, sID);
//	memset(pid, 0, sizeof(DS_U16)*8);
//	for (int i = 0; i < db.GetRow(); i++) pid[i] = atoi(db.GetResult(i+1));
//}

void CT_DB_GetVideoPid(DS_U8 RF, DS_U16 sID,DS_U16* pcr, DS_U16* pid, DS_U8* type)
{
	CDB db;
	db.GetTable("select pcr_pid, video_pid, video_type from pmt where rf=%d and program_number=%d", RF, sID);
	if (pcr) *pcr = (db.GetRow() < 1) ? 0 : atoi(db.GetResult(3));
	if (pid) *pid = (db.GetRow() < 1) ? 0 : atoi(db.GetResult(4));
	if (type) *type = (db.GetRow() < 1) ? 0 : atoi(db.GetResult(5));
}

#define MAX_CRC_COUNT 400
class CheckCRC32
{
private:
	int nPos;
	DS_U32 CRC32[MAX_CRC_COUNT];
public:
	CheckCRC32()
	{
		memset(CRC32, 0, sizeof(CRC32));
		nPos = 0;
	}
	void Add(DS_U32 crc32)
	{
		for (int i = 0; i < MAX_CRC_COUNT; i++) if (CRC32[i] == crc32) return;
		CRC32[nPos] =  crc32;
		nPos++;
		if (nPos >= MAX_CRC_COUNT) nPos = 0;
	}
	bool IsDuplicate(DS_U32 crc32)
	{
		for (int i = 0; i < MAX_CRC_COUNT; i++) if (CRC32[i] == crc32) return true;
		return false;
	}
	// CRC LIST  CRC .
	void Clear(DS_U32 *crclist, int nCount)
	{
		for (int i = 0; i < MAX_CRC_COUNT; i++)
		{
			if (CRC32[i] == 0) continue;
			bool bFind = false;
			for (int j=0; j <nCount;j++)
			{
				if (CRC32[i] != crclist[j]) continue;
				bFind = true;
				break;
			}
			if (bFind == false) CRC32[i] = 0;
		}
	}
};

static CheckCRC32 check_crc;

static DS_U32 CalcCRC(DS_U8* buff)
{
	DS_U32 len = (((DS_U32)buff[1]&0x0F) << 8) + (DS_U32)buff[2]-1;
	return ((DS_U32)buff[len] << 24) + ((DS_U32)buff[len+1] << 16) + ((DS_U32)buff[len+2] << 8) + (DS_U32)buff[len+3];
}

static void CT_TunePSIP(DS_U8 RF = 0, DHL_MODULATION_MODE demod = DHL_MODULATION_8VSB, 
			DS_U16 program_number = 0, DS_U16 source_id = 0, bool bOn = false)
{
	static bool bStart = false;

	static DHL_HANDLE hTVCT = 0;
	static DHL_HANDLE hCVCT = 0;
	static DHL_HANDLE hSTT = 0;
	static DHL_HANDLE hMGT = 0;
	static DHL_HANDLE hEIT[MAX_EIT_COUNT];
	static DHL_HANDLE hETT[MAX_EIT_COUNT];
	static DHL_HANDLE hPAT = 0;
	static DHL_HANDLE hPMT[MAX_PMT_COUNT];
	
	static DS_U16 eit_pid[MAX_EIT_COUNT];
	static DS_U16 ett_pid[MAX_EIT_COUNT];
	static DS_U16 pmt_pid[MAX_PMT_COUNT];
	bool g_bReceiveMGT = false;
	if (bOn)
	{
		if (bStart)
		{
			CT_SI_Msg msg;
			DS_U32 retLen = 0;
			while (DST_OS_ReceiveMessage_NoWait(gSIMsgQ, (DS_U32*)&msg, sizeof(CT_SI_Msg), &retLen) == noError)
			{
				if (RF == msg.RF) 
				{
					if (msg.nRequestID == POS_TVCT)
					{
						if (CT_ChMapUpdateTVCT(RF, (TVCT*)msg.SI, msg.CRC32)) CT_ChMapUpdate();
						CT_CallBack(CT_RECEIVE_TVCT, RF);
					}
					if (msg.nRequestID == POS_CVCT)
					{
						if (CT_ChMapUpdateCVCT(RF, (CVCT*)msg.SI, msg.CRC32)) CT_ChMapUpdate();
						CT_CallBack(CT_RECEIVE_CVCT, RF);
					}
					if (msg.nRequestID == POS_MGT)
					{
						g_bReceiveMGT = true;
						MGT *mgt = (MGT*)msg.SI;
						DST_Printf("mgt->tables_defined = %d\n", mgt->tables_defined);
						for(int i = 0 ; i< mgt->tables_defined ; i++)
						{
							DST_Printf("mgt->table[%d].table_type = 0x%X table_type_PID = 0x%X\n", i, mgt->table[i].table_type, mgt->table[i].table_type_PID);
							if (mgt->table[i].table_type >= 0x100 && mgt->table[i].table_type <0x100 + MAX_EIT_COUNT)
							{
								T();
								int pos = mgt->table[i].table_type - 0x100;
								if (eit_pid[pos] == mgt->table[i].table_type_PID) continue;
								eit_pid[pos] = mgt->table[i].table_type_PID;
								//DHL_SI_MonitorStop(&hEIT[pos]);
								//hEIT[pos] = DHL_SI_MonitorEIT(RF, POS_EIT+pos, eit_pid[pos]);
							}
							if (mgt->table[i].table_type >= 0x200 && mgt->table[i].table_type <0x200 + MAX_EIT_COUNT)
							{
								T();
								int pos = mgt->table[i].table_type - 0x200;
								if (ett_pid[pos] == mgt->table[i].table_type_PID) continue;
								ett_pid[pos] = mgt->table[i].table_type_PID;
								//DHL_SI_MonitorStop(&hETT[pos]);
								//hETT[pos] = DHL_SI_MonitorETT(RF, POS_ETT+pos, ett_pid[pos]);
							}
						}
						CT_CallBack(CT_RECEIVE_MGT, RF);
					}
					if (msg.nRequestID >= POS_EIT && msg.nRequestID < POS_EIT+MAX_EIT_COUNT)
					{
						EIT *eit = (EIT*)msg.SI;
						if (eit->source_id == source_id)
						{
							CT_ChMapUpdateEIT(RF, eit, msg.nRequestID - POS_EIT, msg.CRC32);
							CT_CallBack(CT_RECEIVE_EIT, RF);
						}
					}
					if (msg.nRequestID >= POS_ETT && msg.nRequestID < POS_ETT+MAX_EIT_COUNT)
					{
						ETT *ett = (ETT*)msg.SI;
						if ((ett->ETM_id >> 16) == source_id)
						{
							CT_ChMapUpdateETT(RF, ett, msg.CRC32);
							CT_CallBack(CT_RECEIVE_ETT, RF);
						}
					}
					if (msg.nRequestID == POS_PAT)
					{
						MPEG_PAT *pat = (MPEG_PAT*)msg.SI;
						CT_ChMapUpdatePAT(RF, pat, msg.CRC32);
						int nPos = 0;
						for (int i = 0; i < pat->numPrograms; i++)
						{
							if (pat->programs[i].program_map_PID == 0) continue;
							if (pat->programs[i].program_map_PID == 0x1FFF) continue;
							if (pmt_pid[nPos] == pat->programs[i].program_map_PID) continue;
							if (pmt_pid[nPos]) DHL_SI_MonitorStop(&hPMT[i]);
							pmt_pid[nPos] = pat->programs[i].program_map_PID;
							hPMT[nPos] = DHL_SI_MonitorPMT(RF, POS_PMT+nPos, pmt_pid[nPos]);
							nPos++;
							if (nPos >= MAX_PMT_COUNT) break;
						}
						CT_CallBack(CT_RECEIVE_PAT, RF);
					}
					if (msg.nRequestID >= POS_PMT && msg.nRequestID < POS_PMT+MAX_PMT_COUNT)
					{
						MPEG_PMT *pmt = (MPEG_PMT*)msg.SI;
						if (CT_ChMapUpdatePMT(RF, pmt, msg.nRequestID - POS_PMT+1, msg.CRC32))
						{
							CT_ChMapUpdate();
						}
						CT_CallBack(CT_RECEIVE_PMT, RF, pmt->program_number);
						g_ReceivePMTAudio = true;
						CT_CallBack(CT_RECEIVE_PMT, RF);
					}
				}
				DST_FreeAtscTable(&msg.SI); // ޸  ⿡ 
			} // while
			{ // CC ũ ͸
				static DS_U32 old_RF = 0;
				static DS_U16 old_program_number = 0;
				if (old_RF != RF || old_program_number != program_number || g_bReceiveCCDescriptor == true)
				{
					old_RF = RF;
					old_program_number = program_number;
					g_bReceiveCCDescriptor = false;
					bool bFind = false;
					for (int i=0; i < MAX_PMT_CC_TABLE_COUNT; i++)
					{
						if (pmt_cc_table[i].rf == (int)RF && pmt_cc_table[i].program_number == program_number && pmt_cc_table[i].cc_type > 0 && pmt_cc_table[i].cc_id == 1) 
						{
							DST_g_CC_bCCKorean = (strcmp(pmt_cc_table[i].language, "kor") != 0 && strcmp(pmt_cc_table[i].language, "KOR") != 0) ? false : true;
							DST_g_CC_bWideScreen = pmt_cc_table[i].wide_aspect_ratio ? true : false;
							DST_g_CC_bUnicode = pmt_cc_table[i].korean_code ? true : false;
							bFind = true;
							break;
						}
					}
					if (bFind == false)
					{
						DST_g_CC_bCCKorean = true;
						DST_g_CC_bWideScreen = true;
						DST_g_CC_bUnicode = false;
					}
				}
			}
			{ // EIT ETT ͸
				static DS_U8 old_RF = 0;
				static DS_U16 old_source_id = 0;
				if (old_RF != RF || old_source_id != source_id || g_bReceiveMGT == true)
				{
					old_RF = RF;
					old_source_id = source_id;
					for (int i = 0; i < MAX_EIT_COUNT; i++)
					{
						DHL_SI_MonitorStop(&hEIT[i]);
						if (eit_pid[i]) hEIT[i] = DHL_SI_MonitorEIT(RF, POS_EIT+i, eit_pid[i], source_id);
						DHL_SI_MonitorStop(&hETT[i]);
						if (ett_pid[i]) hETT[i] = DHL_SI_MonitorETT(RF, POS_ETT+i, ett_pid[i], source_id);
					}
				}
			}
		}
		else // bStart == false
		{
			CT_TunePSIP();
			bStart = true;
			hTVCT = DHL_SI_MonitorTVCT(RF, POS_TVCT);
			hCVCT = DHL_SI_MonitorCVCT(RF, POS_CVCT);
			hSTT = DHL_SI_MonitorSTT(RF, POS_STT);
			hMGT = DHL_SI_MonitorMGT(RF, POS_MGT);
			hPAT = DHL_SI_MonitorPAT(RF, POS_PAT);
		}
	}
	else
	{
		if (bStart)
		{
			DHL_SI_MonitorStop(&hTVCT);
			DHL_SI_MonitorStop(&hCVCT);
			DHL_SI_MonitorStop(&hSTT);
			DHL_SI_MonitorStop(&hMGT);
			for (int i = 0; i < MAX_EIT_COUNT; i++) 
			{
				DHL_SI_MonitorStop(&hEIT[i]);
				eit_pid[i] = 0;
				DHL_SI_MonitorStop(&hETT[i]);
				ett_pid[i] = 0;
			}
			DHL_SI_MonitorStop(&hPAT);
			for (int i = 0; i < MAX_PMT_COUNT; i++) 
			{
				DHL_SI_MonitorStop(&hPMT[i]);
				pmt_pid[i] = 0;
			}
			CT_SI_Msg msg;
			DS_U32 retLen = 0;
			while (DST_OS_ReceiveMessage_NoWait(gSIMsgQ, (DS_U32*)&msg, sizeof(CT_SI_Msg), &retLen) == noError)
			{
				DST_Printf("Remove msg.nRequestID == %d\n", (int)msg.nRequestID);
				DST_FreeAtscTable(&msg.SI);
			}
			bStart = false;
		}
	}
}

static void CT_VideoAudio(DS_U16 pcr = 0, DS_U16 vpid = 0, DS_U8 vtype = 0, DS_U16 apid = 0, DS_U8 atype = 0)
{
	static DS_U16 _pcr  = 0;
	static DS_U16 _vpid  = 0;
	static DS_U8  _vtype = 0;
	static DS_U16 _apid = 0;
	static DS_U8  _atype = 0;
	if (pcr == _pcr && vpid == _vpid && vtype == _vtype && apid == _apid && atype == _atype) return;
	if (vpid != _vpid)
	{
		if (vpid)
		{
			DHL_VIDEO_TYPE VidStreamType = DHL_VIDEO_NONE;
			switch (vtype) // ABNT NBR 15602-3:2007 Table 5 ? Strem_type
			{
				case 0x01: VidStreamType = DHL_VIDEO_MPEG1; break;
				case 0x02: VidStreamType = DHL_VIDEO_MPEG2; break;
				case 0x1B: VidStreamType = DHL_VIDEO_MPEG4; break;
			};
			DHL_VID_Start(vpid, pcr, VidStreamType);
			DST_g_LastVideoStartTime = DST_OS_GetTickCount();
			_apid = 0; //     ٽ ϱ ؼ   ¸ .
		}
		else
		{
			CT_ChannelChangeVideoMute(true);
			DHL_VID_Stop();
			DST_g_LastVideoStartTime = 0;
		}
	}
	if (apid != _apid)
	{
		if (apid)
		{
			DHL_AUDIO_TYPE AudStreamType = DHL_AUDIO_NONE;
			switch (atype) // ABNT NBR 15602-3:2007 Table 5 ? Strem_type
			{
				case 0x03: AudStreamType = DHL_AUDIO_MPEG1; break;
				case 0x04: AudStreamType = DHL_AUDIO_MPEG2; break;
				case 0x0F: AudStreamType = DHL_AUDIO_AAC_ADTS; break;
				case 0x11: AudStreamType = DHL_AUDIO_AAC_LATM; break;
			};
			DHL_AUD_Start(apid, pcr == 0 ? 0x1FFF : pcr, AudStreamType);
			CT_ChannelChangeAudioMute(false);
			DST_g_LastAudioStartTime = DST_OS_GetTickCount();
		}
		else
		{
			CT_ChannelChangeAudioMute(true);
			DHL_AUD_Stop();
			DST_g_LastAudioStartTime = 0;
		}	
	}
	_pcr  = pcr;
	_vpid  = vpid;
	_vtype = vtype;
	_apid = apid;
	_atype = atype;
}

static void CT_AV(DS_U8 RF = 0, DHL_MODULATION_MODE demod = DHL_MODULATION_8VSB, 
			DS_U16 program_number = 0, DS_U16 source_id = 0, bool bOn = false)
{
	if (bOn)
	{
		// ȣ 
		bool bLock = false;
		int ss = 0;
		DHL_TUNE_Info(RF, &ss, &bLock);
		CT_CallBack(CT_SIGNAL_INFO, RF, bLock, ss);
	
		// ҽ̵  AV Ѵ.
		DS_U16 PcrPid = 0;
		DS_U16 VideoPid = 0;
		DS_U8  VideoType = 0;
		DS_U16 AudioPid = 0;
		DS_U8  AudioType = 0;
		CT_DB_GetVideoPid(RF, program_number, &PcrPid, &VideoPid, &VideoType);
		
		// DST_Printf("VideoPid = %d\n", VideoPid);
		
		CT_DB_GetAudioPid(RF, program_number, &AudioPid, &AudioType);
		
		 //DST_Printf("AudioPid = %d\n", AudioPid);
		
		CT_VideoAudio(PcrPid, VideoPid, VideoType, AudioPid, AudioType);
		CT_CallBack(CT_AV_START, RF, program_number,  source_id);
		CT_CallBack(CT_AV_INFO, RF, PcrPid, VideoPid, AudioPid, VideoType, AudioType);		
		// CC ͸ Ѵ.
		
		// AV   ݹ
		CT_CallBack(CT_SIGNAL, RF, program_number, VideoPid ? DHL_VID_Alive() : 0, AudioPid ? DHL_AUD_Alive() : 0);
		CT_CallBack(CT_AUDIO_MODE, DHL_AUD_GetMode());
		CT_TunePSIP(RF, demod, program_number, source_id, bOn);
	}
	else
	{
		CT_TunePSIP(); // PSIP ͸ 
		CT_VideoAudio();
	}
}

static void CT_Tune(DS_U8 RF=0, DHL_MODULATION_MODE demod = DHL_MODULATION_8VSB, DS_U16 program_number=0, DS_U16 source_id = 0, bool bOn= false)
{
	static bool bStart = false;
	static DS_U8 CurrentRF = 0;
	static DHL_MODULATION_MODE CurrentDemod = DHL_MODULATION_NULL;
	if (bOn)
	{
		if (bStart == false || CurrentRF != RF || CurrentDemod != demod)
		{
			CT_AV();
			DHL_TUN_Start(RF, demod);
			DST_g_LastTuneTime = DST_OS_GetTickCount();
			CurrentRF = RF;
			CurrentDemod = demod;
			bStart = true;
		}
		CT_AV(RF, demod, program_number, source_id, bOn);
	}
	else
	{
		CT_AV();
		if (bStart)
		{
			DST_g_LastTuneTime = 0;
			DHL_TUN_Stop();
			bStart = false;
		}
	}
}

struct AirCodeCVT 
{
	DS_U8  vendor_id[3];
	DS_U8  hardware_version_id[4];
	DS_U8  software_version_id[4];
	DS_U8  so_id[2];
	DS_U8  download_type; /* 4bits */
	DS_U8  download_command; /* 4bits */
	DS_U16 frequency_vector; /* 16bits */
	DS_U8  modulation_type;
	DS_U16 PID;
};

static bool DST_SCTESI_ParseAirCodeCVT(DS_U8 *p, AirCodeCVT *cvt)
{
	if (p == 0 || cvt == 0) return false;
	if (p[0] != 0x90) return false; // invalid table
	memset(cvt, 0, sizeof(AirCodeCVT));
	DS_U8 number_of_descriptor = p[8];
	int nPos = 9;
	DST_Printf("number_of_descriptor = %d", number_of_descriptor);
	for (int i = 0; i < number_of_descriptor; i++)
	{
		DS_U8 tag = p[nPos];
		DS_U8 length = p[nPos+1];
		DST_Printf("tag = %d\n", tag);
		DST_Printf("length = %d\n", length);
		switch (tag)
		{
			case 0: // vendor_id
//				T();
				if (length == 3) memcpy(cvt->vendor_id, &p[nPos+2], length);
				break;
			case 1: // hardware_version_id
//				T();
				if (length == 4) memcpy(cvt->hardware_version_id, &p[nPos+2], length);
				break;
			case 2: // softeware_version_id
//				T();
				if (length == 4) memcpy(cvt->software_version_id, &p[nPos+2], length);
				break;
			case 0x80:
//				T();
				if (length == 2) memcpy(cvt->so_id, &p[nPos+2], length);
				break;
		}
		nPos = nPos + length + 2;		
	}
	cvt->download_type = (p[nPos]&0xF0) >> 4;
	cvt->download_command = (p[nPos]&0x0F);
	cvt->frequency_vector = p[nPos+1]*256 + p[nPos+2];
	cvt->modulation_type = p[nPos+3];
	cvt->PID = (p[nPos+4]&0x1F)*256 + p[nPos+5];
	return true;
}

static void CT_SI_Proc(DS_U32 RF, DS_U32 nRequestID, DS_U8** buff, DS_U32 nBuffLength)
{
//	DST_Printf("%s | RF = %d | nRequestID = %d\n", __func__, (int)RF, (int)nRequestID);
	CT_SI_Msg msg;
	msg.RF = RF;
	msg.nRequestID = nRequestID;
	msg.SI = 0;
	msg.CRC32 =  CalcCRC(buff[0]);

	if (nRequestID == POS_TVCT)
	{
		if (DHL_PSI_ParseTVCT(buff, (TVCT **)&msg.SI)) DST_Printf("%s|%d|TVCT Parse Error\n", __func__, __LINE__);
	}
	if (nRequestID == POS_CVCT)
	{
		if (DHL_PSI_ParseCVCT(buff, (CVCT **)&msg.SI)) DST_Printf("%s|%d|CVCT Parse Error\n", __func__, __LINE__);
	}
	if (nRequestID == POS_STT)
	{
		DS_U8* p = buff[0];
		CT_CallBack(CT_RECEIVE_STT,  RF, p[9] * 0x1000000 + p[10] * 0x10000 + p[11] * 0x100 + p[12] ,  p[13], DST_OS_GetTickCount());
	}
	if (nRequestID == POS_MGT)
	{
		if (DHL_PSI_ParseMGTSection(buff[0], (MGT **)&msg.SI)) DST_Printf("%s|%d|MGT Parse Error\n", __func__, __LINE__);
	}
	if (nRequestID >= POS_EIT && nRequestID < POS_EIT+MAX_EIT_COUNT)
	{
		if (DHL_PSI_ParseEIT(buff, (EIT **)&msg.SI)) DST_Printf("%s|%d|EIT Parse Error\n", __func__, __LINE__);
	}
	if (nRequestID >= POS_ETT && nRequestID < POS_ETT+MAX_EIT_COUNT)
	{
		if (DHL_PSI_ParseETTSection(buff[0], (ETT **)&msg.SI)) DST_Printf("%s|%d|ETT Parse Error\n", __func__, __LINE__);
	}
	if (nRequestID == POS_PAT)
	{
		if (DHL_PSI_ParsePAT(buff, (MPEG_PAT **)&msg.SI)) DST_Printf("%s|%d|PAT Parse Error\n", __func__, __LINE__);
	}
	if (nRequestID >= POS_PMT && msg.nRequestID < POS_PMT+MAX_PMT_COUNT)
	{
		if (DHL_PSI_ParsePMT(buff[0], (MPEG_PMT **)&msg.SI)) DST_Printf("%s|%d|PMT Parse Error\n", __func__, __LINE__); 
	}
	if (nRequestID == POS_RFUPDATE)
	{
		CT_CallBack(CT_RECEIVE_RF_UPDATE, RF, (DS_U32)buff[0]);
	}
		if (nRequestID == POS_CVT) // CVT
	{
//		DST_g_ReceiveCVT++;
		
		// CMB DDBͿ ݺǴ CVT Ƿ´.
		// CVT  Ͽ 0x90 ϴ ̺ ȯѴ.
		// CVT ؼ    CVT Ͽ ξ ߺ ó Ѵ.
		static DS_U8 received_cvt[300]; 
		DS_U8 cvt_new[300];
		DS_U8* p = buff[0];
		DS_U16 section_length = (p[1] & 0x0F) * 256 + p[2];
		bool bFind = false;
		for (int i = 26; i < section_length - 32; i++)  // CVT ̺  26Ʈ  CVT ̺ ּ ũ 32Ʈ
		{
			if (p[i] == 0xD9 && p[i+1] == 0x30 && p[i+3] == 0x9F && p[i+4] == 0x9C && p[i+5] == 0x02)
			{
				if (i+p[i+6] > section_length) return; // Էµ ͱ̺ ū  ó
				memset(cvt_new, 0, 300);
				cvt_new[0] = 0x90;
				memcpy(&cvt_new[1], &p[i], p[i+6] + 3);
				if (!memcmp(cvt_new, received_cvt, 300)) return; // ̹ 
				bFind = true;
				break;
			}
		}

		if (bFind == false) 
		{
			return;
		}
		static bool bReceiveValidCVT = false;
		if (bReceiveValidCVT == true) return;
		AirCodeCVT cvt;
		memset(&cvt, 0, sizeof(AirCodeCVT));
		if (DST_SCTESI_ParseAirCodeCVT(cvt_new, &cvt) == false) return;
#if 1
		DST_Printf("============================================\n");
		DST_Printf("Request ID = POS_CVT\n");
		DST_Printf("vendor_id %02X %02X %02X\n", cvt.vendor_id[0], cvt.vendor_id[1], cvt.vendor_id[2]);
		DST_Printf("hardware_version_id %02X %02X %02X %02X\n", cvt.hardware_version_id[0], cvt.hardware_version_id[1], cvt.hardware_version_id[2], cvt.hardware_version_id[3]);
		DST_Printf("software_version_id %02X %02X %02X %02X\n", cvt.software_version_id[0], cvt.software_version_id[1], cvt.software_version_id[2], cvt.software_version_id[3]);
		DST_Printf("so_id %02X %02X\n", cvt.so_id[0], cvt.so_id[1]);
		DST_Printf("download_type %d\n", cvt.download_type);
		DST_Printf("download_command %d\n", cvt.download_command);
		DST_Printf("frequency_vector %d\n", cvt.frequency_vector);
		DST_Printf("modulation_type %d\n", cvt.modulation_type);
		DST_Printf("PID 0x%X\n", cvt.PID);
		DST_Printf("============================================\n");
#endif
		
		//  ʵ  ȿ ˻		
		if (cvt.vendor_id[0] != 'D') return;
		if (cvt.vendor_id[1] != 'S') return;
		if (cvt.vendor_id[2] != 'T') return;
		if (cvt.hardware_version_id[0] != 'Z') return;
		if (cvt.hardware_version_id[1] != 'A') return;
		if (cvt.hardware_version_id[2] != 'S') return;
		if (cvt.hardware_version_id[3] != 'Q') return;
//		if (cvt.so_id[0] != DST_g_SO_ID/256) return;
//		if (cvt.so_id[1] != DST_g_SO_ID%256) return;
		
		// ̵ H/W  ġ ʴ   PID  ɼ Ͽ  ġ H/W  üũ ķ
		memcpy(received_cvt, cvt_new, 300); //   ͸ 
		
		int major = 0, minor = DST_GetAppShortVersionNumber();	
		DST_Printf("major = %d minor = %d\n", major, minor);
		int new_major = cvt.software_version_id[0]*256+cvt.software_version_id[1];
		int new_minor = cvt.software_version_id[2]*256+cvt.software_version_id[3];
		DST_Printf("new_major = %d new_minor = %d\n", new_major, new_minor);
		if ((major * 0x10000 + minor) >= (new_major * 0x10000 + new_minor))
		{
			DST_Printf("Old or Same version. ignore it.\n");
			return;
		}
		if (cvt.download_command > 2) 
		{
			DST_Printf("download_command invalid(%d)\n", cvt.download_command);
			return;
		}
		if (cvt.frequency_vector == 0)
		{
			DST_Printf("frequency_vector invalid(%d)\n", cvt.frequency_vector);
			return;
		}
		if (cvt.modulation_type < 1 || cvt.modulation_type > 2)
		{
			DST_Printf("modulation_type invalid(%d)\n", cvt.modulation_type);
			 return;
		}
		if (cvt.PID == 0) 
		{
			DST_Printf("PID invalid(%d)\n", cvt.PID);
			return;
		}
		bReceiveValidCVT = true;
#if 1
		switch (cvt.download_command)
		{
			case 0: DST_Printf("Download Now\n"); break;
			case 1: DST_Printf("Deferred Download\n"); break;
			case 2: DST_Printf("No Exception\n"); break;
		}
		DST_Printf("OTC RF = %dHz\n", cvt.frequency_vector * 250000);
		switch (cvt.modulation_type)
		{
			case 1: DST_Printf("64QAM\n"); break;
			case 2: DST_Printf("256QAM\n"); break;
		}
#endif
		SWinEventMsg event;
		memset(&event, 0, sizeof(SWinEventMsg));
		event.cmd = WM_CVT;
		memcpy(&event.data[0], &cvt.software_version_id[0], 16);
		event.data32[4] = cvt.download_command;
		event.data32[5] = cvt.modulation_type;
		event.data32[6] = cvt.frequency_vector * 250000;
		event.data32[7] = cvt.PID;
		DST_SendWindowEvent(event);
#ifdef DSTAR
		DST_g_OTC_Modulation_type = (event.data32[5]==1)?(DHL_MODULATION_64QAM):(DHL_MODULATION_256QAM);
		DST_g_OTC_RF = event.data32[6];
		DST_g_OTC_PID = event.data32[7];
//		DST_OTC_Start();
#endif
	}
	if (nRequestID == POS_OTC_DII) // OTC_DII
	{
		DST_Printf("################## Request ID = POS_OTC_DII\n");
		 // DST_OTC_ParseDsmcc(buff[0]);
		DS_U8 *p = buff[0];
		if (p[0] != 0x3B) return; // TABLE ID
		DS_U16 section_length = ((p[1]&0x0F) * 0x100) + p[2];
		if (section_length < 48) return; // SECTION TOO SHORT
		if (p[10] != 0x10 || p[11] != 0x02) return; // DSMCC_DM_MSG_DII 0x1002
		DS_U8 adaptationLength = p[17];
		if (section_length < 48 + adaptationLength) return; // SECTION TOO SHORT
		p += adaptationLength; // adaptationLength ̸ŭ  ̵
		DS_U16 blockSize = p[24] * 0x100 + p[25];
		DS_U32 moduleSz = p[42]* 0x1000000 + 	p[43]* 0x10000 + p[44]* 0x100 + p[45];
		DST_Printf("blockSize = %d moduleSz = %d\n", blockSize, (int)moduleSz);
		CT_CallBack(CT_OTC_RECEIVE_DII, moduleSz, blockSize);
	}
	if (nRequestID == POS_OTC_DDB) // OTC_DDB
	{
		//DST_Printf("############## Request ID = POS_OTC_DDB\n");
		//DST_OTC_ParseDsmcc(buff[0]);
		DS_U8 *p = buff[0];
		if (p[0] != 0x3C) return; // TABLE ID
		//DS_U16 section_length = ((p[1]&0x0F) * 0x100) + p[2];
		//if (section_length < 48) return; // SECTION TOO SHORT
		if (p[10] != 0x10 || p[11] != 0x03) return; // DSMCC_DM_MSG_DDB 0x1003
		DS_U8 adaptationLength = p[17];
		//if (section_length < 48 + adaptationLength) return; // SECTION TOO SHORT
		p += adaptationLength; // adaptationLength ̸ŭ  ̵
		DS_U16 blockSize = p[18] * 0x100 + p[19];
		DS_U16 blockNumber = p[24]* 0x100 + p[25];
		//DST_Printf("blockSize = %d blockNumber = %d\n", blockSize-6, blockNumber);
		CT_CallBack(CT_OTC_RECEIVE_DDB, blockNumber, (DS_U32)&p[26], blockSize-6);
	}
	if (msg.SI) DST_OS_SendMessage(gSIMsgQ, (DS_U32 *)&msg, sizeof(CT_SI_Msg));
}


//  RF  佺ĵ    äη   RF SI ޾Ҵ θ Ǵؼ 
// äθ  Ѵ.
static bool g_bRemovedOldChannel = false; // PAT/CVCT/TVCT  ϳ   ä .
bool CT_ScanFindChannel()
{
	return g_bRemovedOldChannel;
}

static void CT_ScanPSIP(DS_U8 RF=0, bool bOn=false)
{
	static bool bStart = false;
	static DS_U32 startTick = 0;
	static DHL_HANDLE hTVCT = 0;
	static DHL_HANDLE hCVCT = 0;
	static DHL_HANDLE hPAT = 0;
	static DHL_HANDLE hPMT[MAX_PMT_COUNT];
	static DS_U16 pmt_pid[MAX_PMT_COUNT];
	static int remain_pmt_count = 0;
	
	
	if (bOn)
	{
		if (bStart)
		{
			T();
			CT_SI_Msg msg;
			DS_U32 retLen = 0;
			while (DST_OS_ReceiveMessage_NoWait(gSIMsgQ, (DS_U32*)&msg, sizeof(CT_SI_Msg), &retLen) == noError)
			{
				if (RF == msg.RF) 
				{
					 // PAT/CVCT/TVCT  ϳ   ä .
					if (msg.nRequestID == POS_TVCT || msg.nRequestID == POS_CVCT || msg.nRequestID == POS_PAT)
					{
						if (g_bRemovedOldChannel == false)
						{
							T();
							T();
							T();
							T();
							JST_DB_Del(RF);
							g_bRemovedOldChannel = true;
						}
					}
					if (msg.nRequestID == POS_TVCT)
					{
						T();
						TVCT *tvct = (TVCT*)msg.SI;
						if (CT_ChMapUpdateTVCT(RF, tvct, msg.CRC32))
						{
							CT_ChMapUpdate();
						}
						CT_CallBack(CT_SCAN_RECEIVE_TVCT, msg.RF, (DS_U32)tvct);
					}
					if (msg.nRequestID == POS_CVCT)
					{
						T();
						CVCT *cvct = (CVCT*)msg.SI;
						if (CT_ChMapUpdateCVCT(RF, cvct, msg.CRC32))
						{
							CT_ChMapUpdate();
						}
						CT_CallBack(CT_SCAN_RECEIVE_CVCT, msg.RF, (DS_U32)cvct);
					}
					if (msg.nRequestID == POS_PAT)
					{
						MPEG_PAT *pat = (MPEG_PAT*)msg.SI;
						if (CT_ChMapUpdatePAT(RF, pat, msg.CRC32)) // PAT ŵǾ
						{
							// VCT ִ äο VCT  äη Ʈ   ݿϱ  ڵ
							// VCT  äϼ  VCT    ޾ƺ.
							DHL_SI_MonitorStop(&hTVCT);
							DHL_SI_MonitorStop(&hCVCT);
							// VCT  Ѵ
							CDB db;
							db.Query("delete from tvct where rf = %d", RF);
							db.Query("delete from tvct_sub where rf = %d", RF);
							db.Query("delete from cvct where rf = %d", RF);
							db.Query("delete from cvct_sub where rf = %d", RF);
							// VCT ͸ 
							hTVCT = DHL_SI_MonitorTVCT(RF, POS_TVCT);
							hCVCT = DHL_SI_MonitorCVCT(RF, POS_CVCT);
						}
						int nPos = 0;
						for (int i = 0; i < pat->numPrograms; i++)
						{
							if (pat->programs[i].program_map_PID == 0) continue;
							if (pat->programs[i].program_map_PID == 0x1FFF) continue;
							if (pmt_pid[nPos] == pat->programs[i].program_map_PID) continue;
							if (pmt_pid[nPos]) DHL_SI_MonitorStop(&hPMT[i]);
							pmt_pid[nPos] = pat->programs[i].program_map_PID;
							hPMT[nPos] = DHL_SI_MonitorPMT(RF, POS_PMT+nPos, pmt_pid[nPos]);
							nPos++;
							if (nPos >= MAX_PMT_COUNT) break;
						}
						remain_pmt_count = nPos;
					}
					if (msg.nRequestID >= POS_PMT && msg.nRequestID < POS_PMT+MAX_PMT_COUNT)
					{
						MPEG_PMT *pmt = (MPEG_PMT*)msg.SI;
						if (CT_ChMapUpdatePMT(RF, pmt, msg.nRequestID-POS_PMT+1, msg.CRC32))
						{
							CT_ChMapUpdate();
						}
						remain_pmt_count--;
						CT_CallBack(CT_SCAN_RECEIVE_PMT, RF, pmt->program_number, remain_pmt_count);
						DST_Printf("remain_pmt_count = %d\n", remain_pmt_count);
					}
				}
				DST_FreeAtscTable(&msg.SI); // ޸  ⿡ 
			} // while
			CT_CallBack(CT_SCAN_PSIP_WAIT, RF, (DST_OS_GetTickCount() - startTick) * 1000/DST_OS_GetTicksPerSecond()); // PSIP ͸    ms 
		}
		else // bStart == false
		{
			T();
			CT_ScanPSIP();
			bStart = true;
			g_bRemovedOldChannel = false; 
			startTick = DST_OS_GetTickCount();
			hTVCT = DHL_SI_MonitorTVCT(RF, POS_TVCT);
			hCVCT = DHL_SI_MonitorCVCT(RF, POS_CVCT);
			hPAT = DHL_SI_MonitorPAT(RF, POS_PAT);
		}
	}
	else
	{
		if (bStart)
		{
			T();
			DHL_SI_MonitorStop(&hTVCT);
			DHL_SI_MonitorStop(&hCVCT);
			DHL_SI_MonitorStop(&hPAT);
			for (int i = 0; i < MAX_PMT_COUNT; i++) 
			{
				DHL_SI_MonitorStop(&hPMT[i]);
				pmt_pid[i] = 0;
			}
			bStart = false;
			g_bRemovedOldChannel = false; 
			startTick = 0;
			CT_SI_Msg msg;
			DS_U32 retLen = 0;
			while (DST_OS_ReceiveMessage_NoWait(gSIMsgQ, (DS_U32*)&msg, sizeof(CT_SI_Msg), &retLen) == noError)
			{
				DST_Printf("Remove msg.nRequestID == %d\n", (int)msg.nRequestID);
				DST_FreeAtscTable(&msg.SI);
			}
		}
	}
}

static void CT_Scan(DS_U8 RF=0, bool bOn=false)
{
	static bool bStart = false;
	static DS_U8 CurrentRF = 0;
	static DS_U32 startTick = 0;
	if (bOn)
	{
		if (bStart == false || CurrentRF != RF)
		{
			CT_ScanPSIP();
			DHL_TUN_Start(RF);
			DST_g_LastTuneTime = DST_OS_GetTickCount();
			CurrentRF = RF;
			//bLock = false;
			bStart = true;
			startTick = DST_OS_GetTickCount();
		}
		CT_ScanPSIP(RF, bOn);
		int ss = 0;
		bool bLock = false;
		DHL_TUNE_Info(RF, &ss, &bLock);
		CT_CallBack(CT_SCAN_LOCK_WAIT, RF, (DST_OS_GetTickCount() - startTick) * 1000/DST_OS_GetTicksPerSecond() , bLock ? ss : 0);
	}
	else
	{
		CT_ScanPSIP(); // SCAN PSIP ͸ 
		if (bStart)
		{
			DST_g_LastTuneTime = 0;
			DHL_TUN_Stop();
			bStart = false;
			CurrentRF = 0;
			startTick = 0;
			//bLock = false;
		}
	}
}

static void CT_RF_Update(DS_U8 RF=0, DHL_MODULATION_MODE demod = DHL_MODULATION_256QAM,  bool bOn=false)
{
	static bool bStart = false;
	static DHL_HANDLE hRfUpdate = 0;
	if (bOn)
	{
		if (bStart == false)
		{
			DHL_TUN_Start(RF, demod);
			hRfUpdate = DHL_SI_MonitorRFUpdate(RF,  POS_RFUPDATE);
			bStart = true;
		}
		else
		{
			// ȣ 
			bool bLock = false;
			int ss = 0;
			DHL_TUNE_Info(RF, &ss, &bLock);
			CT_CallBack(CT_SIGNAL_INFO, RF, bLock, ss);
		}
	}
	else
	{
		if (bStart == true)
		{
			DHL_SI_MonitorStop(&hRfUpdate);
			DHL_TUN_Stop();
			bStart = false;
		}
	}
}

// CMB OTC    CVT ȮѴ.
static void CT_CVT(DS_U8 RF=0, DHL_MODULATION_MODE demod = DHL_MODULATION_256QAM,  bool bOn=false)
{
	static bool bStart = false;
	static DHL_HANDLE hCVT = 0;
	if (bOn)
	{
		if (bStart == false)
		{
			DHL_TUN_Start(RF, demod);
			hCVT = DHL_SI_MonitorSCTE_CVT(RF,  POS_CVT);
			bStart = true;
		}
		else
		{
			// ȣ 
			bool bLock = false;
			int ss = 0;
			DHL_TUNE_Info(RF, &ss, &bLock);
			CT_CallBack(CT_SIGNAL_INFO, RF, bLock, ss);
		}
	}
	else
	{
		if (bStart == true)
		{
			DHL_SI_MonitorStop(&hCVT);
			DHL_TUN_Stop();
			bStart = false;
		}
	}
}

static void CT_OTC(DS_U8 RF=0, DHL_MODULATION_MODE demod = DHL_MODULATION_256QAM,  DS_U16 otc_pid = 0, bool bOn=false)
{
	static bool bStart = false;
	static DHL_HANDLE hDII = 0;
	static DHL_HANDLE hDDB = 0;
	if (bOn)
	{
		if (bStart == false)
		{
			DHL_TUN_Start(RF, demod);
			DST_g_LastTuneTime = DST_OS_GetTickCount();
			//CT_CallBack(CT_OTC_START);
			hDII = DHL_SI_MonitorSCTE_DII(RF,  POS_OTC_DII, otc_pid);
			hDDB = DHL_SI_MonitorSCTE_DDB(RF, POS_OTC_DDB, otc_pid);
			bStart = true;
		}
		else
		{
			// ȣ 
			bool bLock = false;
			int ss = 0;
			DHL_TUNE_Info(RF, &ss, &bLock);
			CT_CallBack(CT_SIGNAL_INFO, RF, bLock, ss);
		}
	}
	else
	{
		if (bStart == true)
		{
			DST_g_LastTuneTime = 0;
			DHL_SI_MonitorStop(&hDII);
			DHL_SI_MonitorStop(&hDDB);
			DHL_TUN_Stop();
			bStart = false;
		}
	}
//	if(DST_OTC_GetStatus() == CD_INBAND_DOWNLOAD)
//	{
//		if(hDII)
//		{
//			DHL_SI_MonitorStop(&hDII);
//			hDII = 0;
//		}
//		if(hDDB == 0)
//		{
//			hDDB = DHL_SI_MonitorSCTE_DDB(RF, POS_OTC_DDB, otc_pid);
//		}
//	}
//	if(DST_OTC_GetStatus() == CD_INBAND_DOWNLOAD_UPDATE)
//	{
//		if(hDDB)
//		{
//			DHL_SI_MonitorStop(&hDDB);
//			hDDB = 0;
//		}
//	}	
}


static void CT_VideoFreezeEndProc()
{
	DST_Printf("DST_VideoFreezeEndProc\n");
	CT_ChannelChangeVideoMute(false);
}

static void CT_SignalInfoCallBack(int nWidth, int nHeight, int RefreshRate, bool bInterlaced,	DHL_SOURCE_ASEPCT Aspect)
{
	CT_CallBack(CT_VIDEO_RESOLUTION, nWidth, nHeight, RefreshRate, bInterlaced, Aspect);
}

void DST_708_Callback(DS_U8 *bytearray,int size);
void DST_IrCallBack(DS_U32 key, DS_U32 repeat, DS_U32 tick);

static void tChannel(void)
{
	DHL_SYS_TV_Open(CT_SignalInfoCallBack, CT_VideoFreezeEndProc, 0, 
		CT_SI_Proc, DST_708_Callback, DST_IrCallBack);
	CT_Msg msg = {CMD_NULL, DHL_MODULATION_8VSB, 0,0};
	while (1)
	{
		DS_U32 retLen;
		CT_Msg tmp;
		bool bChanged = false;
		// ׿ִ  ޽ ´.
		while (DST_OS_ReceiveMessage_Wait(gMsgQ, (DS_U32*)&tmp, sizeof(CT_Msg), &retLen, DST_OS_GetTicksPerSecond()/10) == noError)
		{
			DST_Printf("\n\n\n\n\nReceive Cmd = %d RF = %d demod = %d program_number = %d\n\n\n\n\n\n", 
					tmp.Cmd, tmp.RF, tmp.demod, tmp.program_number);
			if (msg.Cmd != tmp.Cmd || msg.RF != tmp.RF || msg.demod != tmp.demod || msg.program_number != tmp.program_number)
			{ 
				msg = tmp;
				bChanged = true;
			}
		}
		////DST_Printf("Current Cmd = %d RF = %d Minor = %d Mode = %d\n", msg.Cmd, msg.RF, msg.Minor, msg.Mode);

		static DS_U16 program_number = 0;
		static DS_U16 source_id = 0;
		if (msg.Cmd == CMD_TUNE)
		{
			DS_U16 new_program_number = 0;
			DS_U16 new_source_id = 0;
			CDB db;
			if (msg.program_number == 0) // RF Ʃ 
			{
				db.GetTable("select program_number, source_id from channel_db where rf = %d order by minor", msg.RF);
				if(db.GetRow() > 0) // ù° Minor ä
				{
					new_program_number = atoi(db.GetResult(2));
					new_source_id = atoi(db.GetResult(3));
				}
			}
			else
			{
				db.GetTable("select program_number, source_id from channel_db where rf = %d and program_number = %d", msg.RF, msg.program_number);
				if(db.GetRow() > 0)
				{
					new_program_number = atoi(db.GetResult(2));
					new_source_id = atoi(db.GetResult(3));
				}
			}
			if (program_number != new_program_number || source_id != new_source_id)
			{
				program_number = new_program_number;
				source_id = new_source_id;
				bChanged = true;
			}
		}
		else
		{
			program_number = 0;
			source_id = 0;
		}
		


		switch (msg.Cmd)
		{
			case CMD_NULL:
				break;
			case CMD_TUNE:
				CT_Scan();
				CT_OTC();
				CT_RF_Update();
				CT_CVT();
				CT_Tune(msg.RF, msg.demod, program_number, source_id, true);
				if (bChanged) CT_CallBack(CT_TUNE_START, msg.RF, program_number, source_id);
				CT_AutoScanMute(false);
				break;
			case CMD_SCAN:
				CT_AutoScanMute(true);
				CT_Tune();
				CT_OTC();
				CT_RF_Update();
				CT_CVT();
				CT_Scan(msg.RF, true);
				if (bChanged) CT_CallBack(CT_SCAN_START, msg.RF);
				break;
			case CMD_RF_UPDATE:
				CT_AutoScanMute(true);
				CT_Tune();
				CT_Scan();
				CT_OTC();
				CT_CVT();
				CT_RF_Update(msg.RF, msg.demod, true);
				if (bChanged) CT_CallBack(CT_RF_UPDATE_START, msg.RF);
				break;
			
			case CMD_CVT:
				CT_AutoScanMute(true);
				CT_Tune();
				CT_Scan();
				CT_RF_Update();
				CT_OTC();
				CT_CVT(msg.RF, msg.demod, true);
//				if (bChanged) CT_CallBack(CT_OTC_START, msg.RF);
				break;
				
			case CMD_OTC:
				CT_AutoScanMute(true);
				CT_Tune();
				CT_Scan();
				CT_RF_Update();
				CT_CVT();
				CT_OTC(msg.RF, msg.demod, msg.program_number, true);
				if (bChanged) CT_CallBack(CT_OTC_START, msg.RF, msg.program_number);
				break;
				
			case CMD_OTC_STOP:
				CT_OTC();
				break;
				
			case CMD_STOP:
				CT_Tune();
				CT_Scan();
				CT_OTC();
				CT_RF_Update();
				if (bChanged) CT_CallBack(CT_STOPPED);
				break;
		}
		if (msg.Cmd == CMD_CLOSE) break;
	}
	CT_Tune();
	CT_Scan();
	DHL_SYS_TV_Close();
	CT_CallBack(CT_CLOSE, 0, 0, 0, 0);
	DST_OS_DeleteMessageQueue(gMsgQ);
	DST_OS_DeleteMessageQueue(gSIMsgQ);
	gMsgQ = 0;
	gSIMsgQ = 0;
	DST_DB_Close();
	g_callback = 0;
}

static void CT_Init()
{
	static int taskID = 0;
	// ½ũ ޽ť 
	if (taskID == 0)
	{
		gMsgQ = DST_OS_CreateMessageQueue("qChannelTask", 0, 100, sizeof(CT_Msg));
		gSIMsgQ = DST_OS_CreateMessageQueue("qChannelTask", 0, 100, sizeof(CT_SI_Msg));
		taskID = DST_OS_SpawnTask((void (*)(void *)) tChannel, (char*)"tChannel", APP_TASK_PRIO_CHANNEL, WIN_MGR_TASK_STACKSIZE, 0);
	}
}

// jstack open
void JST_Open(jst_callback callcack)
{
	g_callback = callcack;
	CT_Init();
}

static void JST_SendMsg(int Cmd = CMD_NULL, DS_U32 RF = 0, 
		DHL_MODULATION_MODE demod = DHL_MODULATION_8VSB, DS_U16 program_number = 0)
{
	switch (demod)
	{
		case 	DHL_MODULATION_64QAM:DST_Printf("%s|Cmd = %d|RF=%ld|64QAM|%d\n", __func__, Cmd, RF, program_number);break;
		case 	DHL_MODULATION_256QAM:DST_Printf("%s|Cmd = %d|RF=%ld|256QAM|%d\n", __func__, Cmd, RF, program_number);break;
		case 	DHL_MODULATION_8VSB:DST_Printf("%s|Cmd = %d|RF=%ld|8VSB|%d\n", __func__, Cmd, RF, program_number);break;
		case 	DHL_MODULATION_16VSB:DST_Printf("%s|Cmd = %d|RF=%ld|16VSB|%d\n", __func__, Cmd, RF, program_number);break;
		default:
			break;
	}
	CT_Init();
	CT_Msg msg;
	msg.Cmd = Cmd;
	msg.RF = RF;
	msg.demod =  demod;
	msg.program_number = program_number;
	if (gMsgQ) DST_OS_SendMessage(gMsgQ, (DS_U32 *)&msg, sizeof(CT_Msg));
} 

// jstack close
void JST_Close()
{
	JST_SendMsg(CMD_CLOSE);
}

// Channel Task Start
void JST_Tune(DS_U8 RF, DHL_MODULATION_MODE demod, DS_U16 program_number)
{
	JST_SendMsg(CMD_TUNE, RF, demod, program_number);
}

// Channel Task Start
void JST_Scan(DS_U8 RF)
{
	JST_SendMsg(CMD_SCAN, RF);
}

void JST_RFUpdate(DS_U8 RF)
{
	T();
	JST_SendMsg(CMD_RF_UPDATE, RF);
}

void JST_CVT(DS_U8 RF, DHL_MODULATION_MODE demod)
{
	JST_SendMsg(CMD_CVT, RF, demod);
}

void JST_OTC(DS_U8 RF, DHL_MODULATION_MODE demod, DS_U16 otc_pid)
{
	JST_SendMsg(CMD_OTC, RF, DHL_MODULATION_256QAM, otc_pid);
}

void JST_OTC_STOP()
{
	JST_SendMsg(CMD_OTC_STOP);
}

// Channel Task Stop
void JST_Stop(void)
{
	JST_SendMsg(CMD_STOP);
}
