#ifndef __DST_USERINTERFACE_H__
#define __DST_USERINTERFACE_H__

#include "DST_Common.h"
#include "DST_CCTask.h"

#define BANNER_NORMAL	 0
#define BANNER_DIGIT	 1

#define ASPECT_RATIO_WIDE    0
#define ASPECT_RATIO_NORMAL 1
#define ASPECT_RATIO_ZOOM    2

#define MTS_MAX_COUNT 9

#define SM_GOOD_SIGNAL  		0
#define SM_WAIT_SIGNAL  		1
#define SM_WEAK_SIGNAL  		2
#define SM_NO_PROGRAM   		3
#define SM_AUDIO_ONLY   		4

//typedef enum
//{
//	MN_AUTO_SEARCH,
//	MN_TUNE_MODE,
//	MN_STATION_SEARCH,
//	MN_CHANNEL_LIST,
//	MN_QUICK_SEARCH,
//	MN_PROGRAM_GUIDE,
//	MN_ASPECT_DIGITAL,
//	MN_MTS,
//	MN_SETUP,
//	MN_SUPER_IMPOSE,
//	MN_MENU_LANGUAGE,
//	MN_AGE_RATING,
//	MN_PASSWD,
//	MN_SYS_INFO,
//	MN_FACTORY_RESET,
//	MN_CABLE_SUPPORT,
//	MN_MAX_NUM
//}	MenuLists;

typedef enum
{
	MN_CHANNEL,
	MN_SETUP,
	MN_PROGRAM,
	MN_FUNCTION,
	MN_MAX_NUM
}	MainMenuLists;

typedef enum
{
	CH_SUB_INPUT,
	CH_SUB_AUTO_SCAN,
	CH_SUB_MANUAL_SCAN,
	CH_SUB_CHANNEL_EDIT,
	CH_SUB_SIGNAL_METER,
	CH_SUB_MAX_NUM
}	ChannelSubMenuLists;

typedef enum
{
	SETUP_SUB_AV_DISPLAY_MODE,
	SETUP_SUB_AV_AUDIO_PREF,
	SETUP_SUB_AV_VI,
	SETUP_SUB_CC_DISPLAY,
	SETUP_SUB_MAX_NUM
}	SetupSubMenuLists;

typedef enum
{
	PROGRAM_INFORMATION,
	PROGRAM_SUB_MAX_NUM
}	ProgramSubMenuLists;

typedef enum
{
	FUNCTION_SUB_SLEEP_TIMER,
	FUNCTION_SUB_AV_PREFERRED_CONN,		
	FUNCTION_SUB_FACTORY_RESET,
	FUNCTION_SUB_MAX_NUM
}	FunctionSubMenuLists;



typedef enum
{
	DISPLAY_MODE_WIDE,
	DISPLAY_MODE_NORMAL,
	DISPLAY_MODE_ZOOM,
	DISPLAY_MODE_MAX_NUM
}	DisplayModeLists;

typedef enum
{
	AUDIO_PREF_PORTUGUESE,
	AUDIO_PREF_SPANISH,
	AUDIO_PREF_ENGLISH,
	AUDIO_PREF_MAX_NUM
}	AudioPrefLists;

typedef enum
{
	PREFERRED_CONN_LINE_OUT,
	PREFERRED_CONN_CH34,
	PREFERRED_CONN_MAX_NUM
}	PreferredConnLists;

typedef enum
{
	SLEEP_TIMER_OFF,
	SLEEP_TIMER_15M,
	SLEEP_TIMER_30M,
	SLEEP_TIMER_60M,
	SLEEP_TIMER_120M,
	SLEEP_TIMER_MAX_NUM,
}	SleepTimerLists;

typedef enum
{
	POWER_DOWN_OFF,
	POWER_DOWN_1H,
	POWER_DOWN_2H,
	POWER_DOWN_4H,
	POWER_DOWN_8H,
	POWER_DOWN_MAX_NUM,
}	PowerDownLists;


#if 0
____Channel_UI___()
#endif

// ޴  佺ĵ 带 Ѵ.
DS_U8 DST_UI_GetAutoSearchMode(void);

void DST_UI_SetAutoSearchMode(DS_U8 value);

// ä ٿ Լ
void DST_UI_ChannelUpDn(bool bUp);

// ä Ʃ Ѵ.TUNE_MODE_AUTO
void DST_UI_ChannelTune(DS_U8 RF, DS_U16 program_number=0);
// ä Ʃ Ѵ.TUNE_MODE_AUTO
void DST_UI_Scan(DS_U8 RF);

#if 0
____Settings_UI___()
#endif

// ҽ  ´. 0:TV 1:CVBS
DS_U8 DST_UI_GetSource(void);

// ҽ Ѵ.
void DST_UI_SetSource(DS_U8 value);

// 0: ڵ 1: Ǯװ 2: 
DS_U8 DST_UI_GetTuneMode(void);

// Ʃ 带 Ѵ.
void DST_UI_SetTuneMode(DS_U8 value);

// 0: Off 1:On
//  Ž
DS_U8 DST_UI_GetStationSearch(void);

//  Ž 
void DST_UI_SetStationSearch(DS_U8 value);

// г  
DS_U8 DST_UI_GetBrightness(void);

// г  // 0(20) 1(40) 2(60) 3(80) 4(100)
void DST_UI_SetBrightness(DS_U8 value);

// Aspect 
DS_U8 DST_UI_GetAspect(void);

// Aspect 
void DST_UI_SetAspect(DS_U8 value);


// MTS Setting (0) ѱ (1) ܱ
DS_U8 DST_UI_GetMTS();


void DST_UI_SetMTS( DS_U8 nVal);

// VI Setting (0) Off (1) On
DS_U8 DST_UI_GetVI();

void DST_UI_SetVI( DS_U8 nVal);
// CC Ʈ 
//void DST_UI_GetCloseCaption(int *nCount, int *nPos, DST_CCList *list);

// CC 
void DST_UI_SetCloseCaption(DS_U8 value);

// Super Impose Ʈ 
//void DST_UI_GetSuperImpose(int *nCount, int *nPos, DST_CCList *list);


// ޴ 
DS_U8 DST_UI_GetMenuLanguage(void);

// ޴ 
void DST_UI_SetMenuLanguage(DS_U8 value);

// ̺ ļ 
DS_U8 DST_UI_GetCableFreqSupport(void);

// ̺ ļ 
void DST_UI_SetCableFreqSupport(DS_U8 value);


// Conserve Battery
DS_U8 DST_UI_GetConserveBattery(void);
// Conserve Battery
void DST_UI_SetConserveBattery(DS_U8 value);

// 0̸ RF3 1̸ RF4
DS_U8 DST_UI_GetCh34(void);
void DST_UI_SetCh34(DS_U8 bVal);
	
#if 0
____Volum_UI___()
#endif

//  
DS_U8 DST_UI_GetVolume(void);

//  
void DST_UI_SetVolume(DS_U8 value);

// Ʈ 
bool DST_UI_GetMute(void);

// Ʈ 
void DST_UI_SetMute(bool bVal);

#if 0
____Raring_UI___()
#endif

void DST_UI_RatingMute(bool bVal);

#if 0
____Info_Banner_UI___()
#endif

	typedef struct
	{
		int       year;				   // xxxx (ex. 2003)
		int       month;			   // 1-12
		int       day;				   // 0-31
		int       wday;				   // Day of Week ->  0: Sunday, 1: Monday, ... 
		int       hour;				   // 0-24
		int       min;				   // 0-59
		int       sec;				   // 0-59
	} STime_t;					   // Struct for Getting & Saving Date/Time Info.
	
//  ð ´.
bool DST_UI_GetLocalTime(STime_t *time);

//    HD ΰ?
bool DST_UI_GetHDInfo(void);

//  CC ֱⰡ Ѱ?
bool DST_UI_GetCCInfo(void);

// äθ  ġ ϸ ΰ  Լ
// return (0)no logo (1)simple logo (2) png logo
// out  ũ 72x36 ̾ Ѵ.
int DST_UI_GetLogo(DS_U8 RF, DS_U16 sID, DS_U8 *p_image, DS_U8 *nWidth, DS_U8 *nHeight, char *p_string);
#if 0
____EPG_UI___()
#endif

//  ä äιȣ ̸ ´.
// ȯ true̸ äθʿ ִ ä false  ä
// chNum ȭ鿡 ǥ ä ȣ
// chName ȭ鿡 ǥ ä ̸
// num ڷ  ä ȣ
// Է 迭  chNum 20 chName 21
bool DST_UI_GetCurrentChannelInfo(char* chNum, DS_U32* chName, int *num);
//bool DST_UI_GetCurrentChannelInfo2(char* chNum, DS_U32* chName, int *num);
int DST_GetCurrentChannelIndex2(void);

//  ä ȣ ڿ ´.
// Է 迭  20
void DST_UI_GetCurrentChannelNumber(char *chNum);

//  äιȣ RF   ´.
// Է 迭 40
void DST_UI_GetCurrentChannelNumberWithRF(char *chNum);

// äιȣ ä̸
// Է 迭  40
int DST_UI_GetCurrentChannelInfo(DS_U32 *chInfo);

// ¥ ڿ ȯѴ.
int DST_UI_GetDateString(int month, int day, int wday, DS_U16* timeInfo);

// ð ڿ ȯѴ.
int DST_UI_GetTimeString(int hour, int min, DS_U16* timeInfo);

// Էµ ð شϴ ð ڿ ȯѴ.
int DST_UI_GetDateTimeString(STime_t st, DS_U16* strDateTime);

DS_U8 DST_UI_GetAgeRating();

void DST_UI_SetAgeRating(DS_U8 nVal);

// ļ ̺ 
int DST_GetFreqCount();
// ε Էϰ ļ ȣ ޴´.
DS_U16 DST_GetFrequencyNumberbyIndex(int index);
// ε Էϰ MHz  ļ ޴´.
DS_U16 DST_GetMHzFrequencybyIndex(int index);
// ļ ȣ Էϰ ε  ޴´.
int DST_GetIndexByRFNumber(int rf_number);
// MHz ļ Էϰ ε  ޴´.
int DST_GetIndexByMHzFrequency(int MHz);

#endif //__DST_USERINTERFACE_H__

