#include "DST_WinManager.h"
#include "DST_ChannelTune.h"

#include "DST_DataStrings.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_ISDBT_ChannelTask.h"
#include "DST_DB_Engine.h"
#include "DST_DB.h"

#if 0
____CChannelBannerWin___()
#endif

static DS_U8* NumToImage(DS_U8 num)
{
	switch(num)
	{
		case 0: return DST_channelbanner_0_480;
		case 1: return DST_channelbanner_1_480;
		case 2: return DST_channelbanner_2_480;
		case 3: return DST_channelbanner_3_480;
		case 4: return DST_channelbanner_4_480;
		case 5: return DST_channelbanner_5_480;
		case 6: return DST_channelbanner_6_480;
		case 7: return DST_channelbanner_7_480;
		case 8: return DST_channelbanner_8_480;
		case 9: return DST_channelbanner_9_480;
	}
	return DST_channelbanner_0_480;
}

static DS_U8* NumToImageSmall(DS_U8 num)
{
	switch(num)
	{
		case 0: return DST_channelbanner_0_s_480;
		case 1: return DST_channelbanner_1_s_480;
		case 2: return DST_channelbanner_2_s_480;
		case 3: return DST_channelbanner_3_s_480;
		case 4: return DST_channelbanner_4_s_480;
		case 5: return DST_channelbanner_5_s_480;
		case 6: return DST_channelbanner_6_s_480;
		case 7: return DST_channelbanner_7_s_480;
		case 8: return DST_channelbanner_8_s_480;
		case 9: return DST_channelbanner_9_s_480;
	}
	return DST_channelbanner_0_s_480;
}

DS_U32* DST_UTF82Uni(DS_U8 *utf);
void DST_Tune(DS_U8 RF, DS_U16 program_number);

class CChannelBannerWin : public CWindow
{
private:
	int nCh_Major;
	int nCh_Minor;
	DS_U8 bannerType;
	DS_U32 *chName;
//	SourceChange sc;
	bool bPrimaryChannel;
	int nChIndex;
	int nStrLen;
	DS_U8 pImage[72*36];
	char strLogo[6];
	DS_U8 nWidth;
	DS_U8 nHeight;
	int nLogoState;
	bool bTuned;
	bool bHyphened;
	bool bNeedBack2CurrentChannel;
	int maxMajorPosition;
	int maxMinorPosition;
public:
	CChannelBannerWin(SWinEventMsg event):CWindow(event)
	{	
		T();
		chName = 0;
		nCh_Major = 0;
		nCh_Minor = 0;
		CDB db;
		db.GetTable("select max(major), max(minor) from channel_db");
		maxMajorPosition = getPositionNumber(atoi(db.GetResult(2)));
		maxMinorPosition = getPositionNumber(atoi(db.GetResult(3)));
//		sc = GetLastSendMsg();
		bNeedBack2CurrentChannel = false;

		bannerType = event.data[2];

		rect.w = DST_GetImageWidth(channel_banner_720480);
		rect.h = DST_GetImageHeight(channel_banner_720480);
		rect.x = DST_GetScreenWidth() - rect.w - (DST_GetScreenWidth() / 20);
		rect.y = DST_GetScreenHeight() / 20;

		SetTimeOut(3);
		bTuned = false;
		bHyphened = false;
		RegisterUnregisterDigitKey(true);
		switch(bannerType)
		{
			case BANNER_NORMAL:
				SetTimeOut(event.data[3]);
				break;
			case BANNER_DIGIT:
				SetTimeOut(3);
				KeyInput(eventInit.data[3], false);
				break;
		}
	}
	virtual ~CChannelBannerWin()
	{
		if (chName) DST_OS_Free(&chName);
		if(bannerType == BANNER_DIGIT && bNeedBack2CurrentChannel == true)
		{
			DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL, 3);
		}		
	}
	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_CT_MSG: // Ʃ  ޽  
				if (event.data32[0] == CT_TUNE_START) 
				{
					T();
					Show();
					SetTimeOut(3);
				}
				break;		
			case WM_POWER_OFF:
				Close();
				break;
		}
	}
	void RegisterUnregisterDigitKey(bool bState)
	{
		switch(bannerType)
		{
			case BANNER_NORMAL:
				RegisterKey(VK_CANCEL, bState);
				break;
			case BANNER_DIGIT:
				RegisterKey(VK_0, bState);
				RegisterKey(VK_1, bState);
				RegisterKey(VK_2, bState);
				RegisterKey(VK_3, bState);
				RegisterKey(VK_4, bState);
				RegisterKey(VK_5, bState);
				RegisterKey(VK_6, bState);
				RegisterKey(VK_7, bState);
				RegisterKey(VK_8, bState);
				RegisterKey(VK_9, bState);
				RegisterKey(VK_OK, bState);
				RegisterKey(VK_CANCEL, bState);
				RegisterKey(VK_HYPHEN, bState);
				break;
		}

	}

	
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_FACTORY_MODE:
			//case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
			case WIN_OTC_DOWNLOAD:
			case WIN_OTC_DOWNLOAD_FAIL:
			case WIN_RF_UPDATE:				
				Close();
				break;
			default:
				break;
		}
	}
	
	virtual void Show()
	{
		Draw();
		RegisterUnregisterDigitKey(true);
	}

	void Draw()
	{
		// ȭ ׸
		int xPos = 0;
		DrawImage(0, 0, channel_banner_720480);
		
		// TV  
		setFontStyle(20, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_CENTER);
		
		CDB db;
		int nPos = -1;
		int nChCount = 0;
		int major =  0;
		int minor = 0;
		int majorPosition = 0;
		int minorPosition = 0;
		char *name = 0;
		if(bannerType == BANNER_NORMAL)
		{
		
			db.GetTable("select major, minor, name from channel_db where rf = %d and program_number = %d order by major, minor, rf", DST_EEPROM_GetRF(), DST_EEPROM_GetProgramNumber());
			if(db.GetRow() < 1)
			{	
				db.GetTable("select major, minor, name from channel_db where rf = %d  order by major, minor, rf", DST_EEPROM_GetRF());
			}

			nChCount = db.GetRow();
			DST_Printf("nChCount = %d\n",nChCount);
			major =  DST_GetFrequencyNumberbyIndex(DST_EEPROM_GetRF());
			minor = 0;
			if (nChCount)
			{
				nPos = 0;
				nChCount = 2; // ̳ ǥõǵ  2 
				major = atoi(db.GetResult(3));
				minor = atoi(db.GetResult(4));
				name = db.GetResult(5);
				bHyphened = true;
			}
		}
		else
		{
			nPos = 0;
			if(nCh_Minor == 0)
			{
				nChCount = 1;
			}
			bool bFound = true;
			db.GetTable("select name from channel_db where rf=%d and program_number=%d  order by major, minor, rf", DST_DB_GetRF(nCh_Major, nCh_Minor, &bFound), DST_DB_GetProgramNumber(nCh_Major,nCh_Minor));
			major = nCh_Major;
			minor = nCh_Minor;
			if(db.GetRow() > 0)
				name = db.GetResult(1);

		}
		majorPosition = getPositionNumber(major);
		minorPosition = getPositionNumber(minor);
		
		// ä̸ ǥ
		if (nPos < 0 || name == 0) // äθʿ  ä 
		{
			bNeedBack2CurrentChannel = true;
			DrawTextUni(0, 0, rect.w, 47, pz_Digital[OSD_Lang], &font); // Digital
			
		}
		else
		{
			bNeedBack2CurrentChannel = false;
			DS_U32* strText32 = DST_UTF82Uni((DS_U8*)name); 
			DrawText32(0, 0, rect.w, 47, strText32, &font);
			
			//DST_OS_Free(&strText32);
		}
		DS_U8 *img[9] = {0,};
		int numberLenth = majorPosition+minorPosition+((bHyphened && minor != 0)?1:0);
		int nTotalWidth = 0;
		int index = 0;
		for(int i=majorPosition;i>0;i--)
		{
			img[index] = NumToImage((major/getPowerOfTen(i-1))%10);
			nTotalWidth += DST_GetImageWidth(img[index]);
			index++;
		}
		
		if(bHyphened && minor != 0)
		{
			img[index] = DST_channelbanner_dash_480;
			nTotalWidth += DST_GetImageWidth(img[majorPosition]);
			index++;
		}
		
		for(int i=minorPosition;i>0;i--)
		{
			img[index] = NumToImageSmall((minor/getPowerOfTen(i-1))%10);
			nTotalWidth += DST_GetImageWidth(img[index]);
			index++;
		}	

		xPos = (rect.w - nTotalWidth) / 2;
		for(int i=0;i<numberLenth;i++)
		{
			int yPos = 0;
			if(i < majorPosition)
			{
				yPos = 68;
			}
			else
			{
				if(i == majorPosition && bHyphened)
					yPos = 86;
				else
					yPos = 79;
			}
			DrawImage(xPos, yPos, img[i], true);
			xPos += DST_GetImageWidth(img[i]);
		}

	}

	virtual void OnTimer(char nID)
	{
		switch (nID)
		{
			case 1:
				{
					KillTimer(1);
					bTuned = true;
					bool bFound = true;
					int RF = DST_DB_GetRF(nCh_Major, nCh_Minor, &bFound);
					T();
					if (DST_DB_PresentMatchChannel(RF, nCh_Major, nCh_Minor ))
						DST_UI_ChannelTune(bFound?RF:DST_MinRF(), DST_DB_GetProgramNumber(nCh_Major,nCh_Minor));
				}
				break;
			default:
				break;
		}
	}

	int getPositionNumber(int number)
	{
		int pos = 0;
		while(number>0)
		{
			number = number/10;
			pos++;
		}
		return pos;
	}

	int getPowerOfTen(int x)
	{
		int ret = 1;
		for(int i=0;i<x;i++)
			ret*= 10;
		return ret;
	}

	int getMaxTuneNumber(int x)
	{
		int ret = 0;
		for(int i=0;i<x;i++)
			ret+= getPowerOfTen(i);

		DST_Printf("ret = %d\n",ret);
		return 9*ret;	
	}
		
	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		bool bMatch = false;
		int nCount = 0;
//		DST_Printf("\n banner  key:%d, key:%d\n",key,key-VK_0);
		switch (key)
		{
			case VK_0:
			case VK_1:
			case VK_2:
			case VK_3:
			case VK_4:
			case VK_5:
			case VK_6:
			case VK_7:
			case VK_8:
			case VK_9:
				{
						
					if(nCh_Minor > (DS_U16)getMaxTuneNumber(maxMinorPosition))
					{
						bTuned = false;
						bHyphened = false;
						nCh_Major = 0;
						nCh_Minor = 0;
					}
					
					if(bHyphened)
						nCh_Minor = (nCh_Minor>0)?( nCh_Minor * 10 + ( key - VK_0)):(key - VK_0);
					else
						nCh_Major = nCh_Major * 10 + ( key - VK_0);

					DST_Printf("nCh_Minor=%d,nCh_Major=%d\n",nCh_Minor,nCh_Major);
					if(bTuned)
					{
						bTuned = false;
						bHyphened = false;
						nCh_Major =  key - VK_0;
						nCh_Minor = 0;
					}

					if(bHyphened)
					{
						if(nCh_Minor > (DS_U16)getMaxTuneNumber(maxMinorPosition))
						{
							bHyphened = false;
							nCh_Major =  key - VK_0;
							nCh_Minor = 0;
						}
					}
					else
					{
						if(nCh_Major > (DS_U16)getMaxTuneNumber(maxMajorPosition))
							nCh_Major =  key - VK_0;
					}


					nCount = DST_DB_AvailableChannelCount(nCh_Major);
					DST_Printf("nCount = %d \n\n",nCount);
					if (nCount == 0) // ġϴ    ٷ ݴ´. 
					{
						Draw();
						KillTimer(1);
						break;
					}
					bool bFound = true;
					bMatch = DST_DB_PresentMatchChannel(DST_DB_GetRF(nCh_Major, nCh_Minor, &bFound), nCh_Major, bFound==true?nCh_Minor:1);
//					if ((bMatch && nCount ==1 && nCh_Minor !=0) || (bMatch && nCh_Minor !=0)) // ġϴ ä    Ʃ
//					{
//						SetTimer(1, 50);
//						Draw();
//						break;
//					}
					if (bMatch) // Ȯ ġϴ ä ִٸ 2Ŀ ƩѴ.
					{
						SetTimer(1, 2000);
						Draw();
						break;
					}
					Draw();
				}
				break;

			case VK_HYPHEN:
				bHyphened = true;
				Draw();
				break;
				
			case VK_OK:
				{
					bool bFound = true;
					int RF = DST_DB_GetRF(nCh_Major, nCh_Minor, &bFound);
					if (DST_DB_PresentMatchChannel(RF, nCh_Major, nCh_Minor ))
						DST_UI_ChannelTune(bFound?RF:DST_MinRF(), DST_DB_GetProgramNumber(nCh_Major,nCh_Minor));
					Close();
				}
				break;
			case VK_CANCEL:
				Close();
				break;
		}
	}

};

bool DST_IsTuneMode();

void DST_CreateChannelBannerWindow(SWinEventMsg event)
{

	if (DST_GetWin(WIN_OTC_DOWNLOAD)) return;
	if (DST_GetWin(WIN_OTC_DOWNLOAD_FAIL)) return;
	if (DST_GetWin(WIN_MANUAL_SEARCH)) return;
	if (DST_GetWin(WIN_AUTO_SEARCH)) return;
	if (DST_GetWin(WIN_CHANNEL_LIST)) return;
	if (DST_GetWin(WIN_PROGRAM_GUIDE)) return;
	if (DST_GetWin(WIN_MAIN_MENU)) return;
	if (DST_GetWin(WIN_INFOR_BANNER) && event.data[2] == BANNER_NORMAL) return;
	if (DST_GetWin(WIN_FACTORY_MODE)) return;
	
//	if (DST_GetWin(WIN_DIRECT_TUNE)) return;
	
//	SourceChange sc=GetLastSendMsg();
//	if(sc.AutoScan) return;
//	if(sc.RF == 0) return;
//	if (DST_IsTuneMode() == false) return;
	DST_AddWin((WinID)(event.data[0]), new CChannelBannerWin(event));
}


class CDirectTuneWin : public CWindow
{
private:
	int nRF;
	int nRFIndex;
	int nRFIndex_Old;
	DS_U32 *chName;
//	SourceChange sc;
	bool bPrimaryChannel;
	int nStrLen;
	DS_U8 pImage[72*36];
	char strLogo[6];
	DS_U8 nWidth;
	DS_U8 nHeight;
	int nLogoState;
	bool bTuned;
	bool bFirst;
	bool bNeedBack2CurrentChannel;
public:
	CDirectTuneWin(SWinEventMsg event):CWindow(event)
	{	
		chName = 0;
//		sc = GetLastSendMsg();

		DS_U8  RF = 0;
		DS_U16 sID = 0;
		DST_GetAVState(&RF, 0, &sID);
		nRFIndex = RF;
		nRFIndex_Old = nRFIndex;
		nRF = DST_GetFrequencyNumberbyIndex(nRFIndex);

		rect.w = DST_GetImageWidth(channel_banner_720480);
		rect.h = DST_GetImageHeight(channel_banner_720480);
		rect.x = DST_GetScreenWidth() - rect.w - (DST_GetScreenWidth() / 20);
		rect.y = DST_GetScreenHeight() / 20;

		SetTimeOut(3);
		bTuned = false;
		bFirst = true;
		bNeedBack2CurrentChannel = false;
		RegisterUnregisterDigitKey(true);
	}
	virtual ~CDirectTuneWin()
	{
		if (chName) DST_OS_Free(&chName);
//		if (bNeedBack2CurrentChannel)
//		{
			if(DST_GetWin(WIN_CHANNEL_BANNER) != 0)
				DST_CloseWin(WIN_CHANNEL_BANNER);
			DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL, 3);
//		}
			
	}
	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
		}
	}
	void RegisterUnregisterDigitKey(bool bState)
	{
				RegisterKey(VK_0, bState);
				RegisterKey(VK_1, bState);
				RegisterKey(VK_2, bState);
				RegisterKey(VK_3, bState);
				RegisterKey(VK_4, bState);
				RegisterKey(VK_5, bState);
				RegisterKey(VK_6, bState);
				RegisterKey(VK_7, bState);
				RegisterKey(VK_8, bState);
				RegisterKey(VK_9, bState);
				RegisterKey(VK_OK, bState);
				RegisterKey(VK_CANCEL, bState);
				RegisterKey(VK_UP, bState);
				RegisterKey(VK_DN, bState);
				RegisterKey(VK_HYPHEN, bState);

	}

	
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_FACTORY_MODE:
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
			case WIN_OTC_DOWNLOAD:
			case WIN_OTC_DOWNLOAD_FAIL:
			case WIN_UPDATE:
			case WIN_UPDATE_RESET:				
				Close();
				break;
			default:
				break;
		}
	}
	
	virtual void Show()
	{
		Draw();
		RegisterUnregisterDigitKey(true);
	}

	void Draw()
	{
		// ȭ ׸
		int xPos = 0;
		DrawImage(0, 0, channel_banner_720480);
		
		// TV  
		setFontStyle(20, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_CENTER);
		
		CDB db;
		char name[3] = {0,};
		sprintf(name,"%s","RF");
		// ä̸ ǥ
		DS_U32* strText32 = DST_UTF82Uni((DS_U8*)name); // ȣ ʿ ޸ 
		DrawText32(0, 0, rect.w, 47, strText32, &font);
		
		// ä  ǥ
		DS_U8 *img[9] = {0,};
		int numberLenth = getPositionNumber(nRF);
		int nTotalWidth = 0;
		int index = 0;
		for(int i=numberLenth;i>0;i--)
		{
			img[index] = NumToImage((nRF/getPowerOfTen(i-1))%10);
			nTotalWidth += DST_GetImageWidth(img[index]);
			index++;
		}
		
		xPos = (rect.w - nTotalWidth) / 2;
		for(int i=0;i<numberLenth;i++)
		{
			DrawImage(xPos, 68, img[i], true);
			xPos += DST_GetImageWidth(img[i]);
		}

		

	}

	int getPositionNumber(int number)
	{
		int pos = 0;
		while(number>0)
		{
			number = number/10;
			pos++;
		}
		return pos;
	}

	int getPowerOfTen(int x)
	{
		int ret = 1;
		for(int i=0;i<x;i++)
			ret*= 10;
		return ret;
	}

	
	virtual void OnTimer(char nID)
	{
		switch (nID)
		{
			case 1:
				{
					KillTimer(1);
					if(nRFIndex > (DS_U16)DST_MaxRF()|| nRFIndex < (DS_U16)DST_MinRF())
						nRFIndex =	nRFIndex_Old;


					Draw();
					if(DST_GetIndexByRFNumber(nRF) != 0)
					{
						nRFIndex = DST_GetIndexByRFNumber(nRF);
						bNeedBack2CurrentChannel = false;
						bTuned = true;
						DST_UI_ChannelTune(nRFIndex, 0);
					}		
					else
					{
						bNeedBack2CurrentChannel = true;
					}
					nRFIndex_Old = nRFIndex;				

					SetTimer(2,1000);
				}
				break;
			case 2:
				Close();
				break;
			default:
				break;
		}
	}

	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
//		bool bMatch = false;
//		int nCount = 0;
//		DST_Printf("\n banner  key:%d, key:%d\n",key,key-VK_0);
		switch (key)
		{
			case VK_UP:
				nRFIndex += 1;
				if(nRFIndex > (DS_U16)DST_MaxRF()) nRFIndex = (DS_U16)DST_MinRF();
				nRF = DST_GetFrequencyNumberbyIndex(nRFIndex);
				SetTimer(1,10);
				break;
			
			case VK_DN:
				nRFIndex -= 1;
				if(nRFIndex < (DS_U16)DST_MinRF()) nRFIndex = (DS_U16)DST_MaxRF();
				nRF = DST_GetFrequencyNumberbyIndex(nRFIndex);
				SetTimer(1,10);

				break;

			case VK_0:
			case VK_1:
			case VK_2:
			case VK_3:
			case VK_4:
			case VK_5:
			case VK_6:
			case VK_7:
			case VK_8:
			case VK_9:
				if(bFirst)  nRF = 0;
				nRF = nRF * 10 + ( key - VK_0);
				
				if(bTuned)
				{
					bTuned = false;
					nRF =  key - VK_0;
				}

				if(DST_GetIndexByRFNumber(nRF) > (DS_U16)DST_MaxRF()|| DST_GetIndexByRFNumber(nRF) < (DS_U16)DST_MinRF())
					nRF =  key - VK_0;

				SetTimer(1, 1000);
				Draw();
				break;

			case VK_HYPHEN:
				break;
				
			case VK_OK:
				if(nRFIndex > (DS_U16)DST_MaxRF()|| nRFIndex < (DS_U16)DST_MinRF())
					nRFIndex =  nRFIndex_Old;
				SetTimer(1,10);
				break;
			case VK_CANCEL:
				Close();
				break;
		}

		bFirst = false;
		
	}


};



void DST_CreateDirectTuneWindow(SWinEventMsg event)
{
//	if (DST_GetWin(WIN_AUTO_SEARCH)) return;
//	if (DST_GetWin(WIN_CHANNEL_LIST)) return;
//	if (DST_GetWin(WIN_PROGRAM_GUIDE)) return;
	if (DST_GetWin(WIN_MAIN_MENU)) return;
	if (DST_GetWin(WIN_FACTORY_MODE)) return;
//	if (DST_GetWin(WIN_INFOR_BANNER)) return;
	
//	SourceChange sc=GetLastSendMsg();
//	if(sc.AutoScan) return;
//	if(sc.RF == 0) return;
	if (DST_IsTuneMode == false) return;
	DST_AddWin((WinID)(event.data[0]), new CDirectTuneWin(event));
}


