#include "DST_WinManager.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"
#include "DST_DataStrings.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DB.h"

#define CE_LIST		5

#define RF_W		30
#define CH_NO_W		61
#define CH_NAME_W	112
#define ADD_W		53

#if 0
____CChannelEditWin___()
#endif


class CChannelEditWin : public CWindow
{
private:
	int totalNum;
	ChannelMap* chMap;
	SkipList*skipProgramNumber;

	DS_U16 g_nPos;
	DS_U16 g_nTop;
	DS_U16 select;
	DS_U16 listNum;
	DS_U16 nSkipCh;	
public:
	CChannelEditWin(SWinEventMsg event):CWindow(event)
	{
		InitValues();

		setSize();
		
		SetTimeOut(60);
		
	}
	virtual ~CChannelEditWin()
	{
		if(chMap) DST_OS_Free(&chMap);
	}
	
	void setSize(void)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_channeledit_back);
		rect.h = DST_GetImageHeight(newcon2_gui_channeledit_back);
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight()- rect.h) / 2;

	}	
	
	void InitValues(void)
	{
		totalNum = 0;
		if(chMap) DST_OS_Free(&chMap);
		chMap = 0;
		skipProgramNumber = 0;
		chMap = DST_DB_GetChannelMapForChEdit(&totalNum);
		g_nTop = 0;
		g_nPos = 0;
		select = 0;
		listNum = 8;
		if (totalNum < listNum) listNum = totalNum;

		for(int i=0;i<totalNum;i++)
		{
			if(DST_EEPROM_GetRF() == chMap[i].rf && DST_EEPROM_GetProgramNumber() == chMap[i].number )
			{
				ItemDecrease(totalNum, listNum, &g_nTop, &select, &g_nPos,totalNum - i );
				DST_UI_ChannelTune(chMap[select].rf,chMap[select].number);
				break;
			}
		}
		
		DST_UI_ChannelTune(chMap[select].rf,chMap[select].number);
		nSkipCh = getValues();
	}

	DS_U16 getValues()
	{
		skipProgramNumber= 0;
		int size = 0;
		
		skipProgramNumber = DST_DB_GetSkipChannel(&size);
		return size;
	}
	
	void SetValues(int rf, DS_U16 sourceID, bool bAdd)
	{
		DST_DB_SetSkipChannel(rf, sourceID, bAdd);
		DST_DB_MakeSkipChannel();
	}

	virtual void Focus(bool bVal)
	{
		RegisterAllKey();
		RegisterKey(VK_PWR, false);
		RegisterKey(VK_SIGNAL_METER, false);
		RegisterKey(VK_ZOOM, false);
		RegisterKey(VK_CC, false);
		RegisterKey(VK_EPG, false);
	}

	
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
//			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
//			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				Close();
				break;
			default:
				break;
		}
	}
	
	virtual void Show(void)
	{
		Draw();
		DoFocus(true);
	}	
		 //׺̼ ׸
		void DrawNavigation()
		{
			setFontStyle(20,0xFF8C8C8C,font.GetVerAlign(),ALIGN_LEFT);
	
			DS_U16	final[20];
			memset(final,0,sizeof(final));
			strcpy16(final, pz_Edit_Menu[OSD_Lang]);
			str2uni(&final[strlen16(final)], (char *)" : ");
			strcpy16(&final[strlen16(final)], pz_Edit_Exit[OSD_Lang]);
			DrawTextUni(17, 340, 142, 29, final, &font);
	
			memset(final,0,sizeof(final));
			strcpy16(final, pz_Edit_OK[OSD_Lang]);
			str2uni(&final[strlen16(final)], (char *)" : ");
			strcpy16(&final[strlen16(final)], pz_Edit_Select[OSD_Lang]);
			DrawTextUni(170, 340, 142, 29, final, &font);

		}
	
		void DrawTitle()
		{
#if DESIGN_TYPE == 1
			setFontStyle(19,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
			DrawTextUni(16, 10, 112, 29, pz_Edit_ChannelNumber[OSD_Lang], &font);
			DrawTextUni(148, 10, 201, 29, pz_Edit_ChannelName[OSD_Lang], &font);
			DrawTextUni(368, 10, 39, 29, pz_Edit_RF[OSD_Lang], &font);
//			setFontStyle(15,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
			DrawTextUni(422, 10, 55, 29, pz_Edit_ADD[OSD_Lang], &font);
			DrawTextUni(491, 10, 55, 29, pz_Edit_FAV[OSD_Lang], &font);
#else
			setFontStyle(19,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
			DrawTextUni(16, 12, 116, 29, pz_Edit_ChannelNumber[OSD_Lang], &font);
			DrawTextUni(142, 12, 212, 29, pz_Edit_ChannelName[OSD_Lang], &font);
			DrawTextUni(364, 12, 47, 29, pz_Edit_RF[OSD_Lang], &font);
//			setFontStyle(15,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
			DrawTextUni(420, 12, 60, 29, pz_Edit_ADD[OSD_Lang], &font);
#endif	

			
		}

#if DESIGN_TYPE == 1
	void DrawItems(int index,int y_Constant=195, int y_Multiplier=36, int width=85, int nFontSize=20)
	{
		setFontStyle(19,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		
		DrawText(16, 46+index*y_Multiplier, 112, 29, chMap[index+g_nTop].num, &font);

		DrawTextUTF8(148, 46+index*y_Multiplier, 201, 29, chMap[index+g_nTop].name, &font);

		char num[5] = {0,};
		sprintf(num, "%d", DST_GetFrequencyNumberbyIndex(chMap[index+g_nTop].rf));

		DrawText(368, 46+index*y_Multiplier, 39, 29, num, &font);


		if(!CompareValues(chMap[index+g_nTop].rf,chMap[index+g_nTop].number))
			DrawImage(417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check);
		else
			DrawImage(417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check_empty);
		if(select == index+g_nTop)
		{
			if(!CompareValues(chMap[index+g_nTop].rf,chMap[index+g_nTop].number))
				DrawImage(417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check_cursor);
			else
				DrawImage(417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check_cursor_empty);
		}

			
		
	}
#else
	void DrawItems(int index,int y_Constant=195, int y_Multiplier=36, int width=85, int nFontSize=20)
	{
		setFontStyle(19,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);

		DrawText(16, 43+index*y_Multiplier, 124, 29, chMap[index+g_nTop].num, &font);

		DrawTextUTF8(142, 43+index*y_Multiplier, 219, 29, chMap[index+g_nTop].name, &font);

		char num[5] = {0,};
		sprintf(num, "%d",DST_GetFrequencyNumberbyIndex(chMap[index+g_nTop].rf));

		DrawText(364, 43+index*y_Multiplier, 53, 29, num, &font);

		DrawImage(417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check_empty);

		if(!CompareValues(chMap[index+g_nTop].rf, chMap[index+g_nTop].number))
			DrawImage(417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check);
		else
			DrawImage(417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check_empty);
		if(select == index+g_nTop)
		{
			if(!CompareValues(chMap[index+g_nTop].rf,chMap[index+g_nTop].number))
				DrawImage(417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check_cursor);
			else
				DrawImage(417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check_cursor_empty);
		}
		
		
	}
#endif	


	bool CompareValues(int rf, DS_U16 target)
	{
		bool result = false;
		for(int i=0;i<nSkipCh;i++)
		{
			if(skipProgramNumber[i].rf == rf && skipProgramNumber[i].program_number == target)
			{
				result = true;
			}
		}
		return result;
	}

	void DrawScrollBar3(int x, int y, int h, int total_count, int page_count, int page_start)
	{
		if (total_count <= page_count) return;
		int nScrollPosition = total_count - page_count;
		int ScrollHeight = h/nScrollPosition;
		DST_Printf("nScrollPosition : %d h/nScrollPosition : %d/%d == %d y+page_start*ScrollHeight = %d\n",nScrollPosition,h,nScrollPosition ,ScrollHeight,y+page_start*ScrollHeight);
		DrawImage(x,y+page_start*ScrollHeight,newcon2_gui_scroll_button,true);
	}
	
	void Draw(void)
	{
		DrawImage(0,0, newcon2_gui_channeledit_back);
		DrawTitle();
		DrawScrollBar3(489, 30, 294, totalNum, listNum, g_nTop);

		DrawNavigation();
		for(int i=0;i<listNum;i++)
			DrawItems(i);
	}
	

	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
				
			case WM_CT_MSG:
				switch (event.data32[0])
				{
					case CT_CHMAP_UPDATE:
						InitValues();
						Show();
						break;					
				}
				break;
		}
	}

	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_MENU:
			case VK_CANCEL:
			case VK_PREV:
			case VK_PREV_MENU:
				if (GetParentWinID()) DST_CreateWin(GetParentWinID());
				Close();
				break;
			case VK_UP:
			case VK_DN:
				if(key == VK_DN)
					ItemIncrease(totalNum, listNum, &g_nTop, &select, &g_nPos);
				else
					ItemDecrease(totalNum, listNum, &g_nTop, &select, &g_nPos);

				DST_UI_ChannelTune(chMap[select].rf,chMap[select].number);
				Draw();
				break;
//			case VK_CH_UP:
//			case VK_CH_DN:
//				if(key == VK_CH_DN)
//					ItemIncrease(mainItemNum, mainListNum, &g_nTop, &mainSelect, &g_nPos, listNum);
//				else
//					ItemDecrease(mainItemNum, mainListNum, &g_nTop, &mainSelect, &g_nPos, listNum);
//				//DST_UI_ChannelTune(chMap[select].number);
//				Draw();
//				break;
			case VK_OK:
				SetValues(chMap[select].rf , chMap[select].number, CompareValues(chMap[select].rf, chMap[select].number)?false:true);
				nSkipCh = getValues();
				Draw();

				break;
			default:
				break;

		}
	}
};

void DST_CreateChannelEditWin(SWinEventMsg event)
{
	if (DST_DB_PresentChMap() == false) return;
	DST_AddWin((WinID)(event.data[0]), new CChannelEditWin(event));
}

