#include "DST_Window.h"
#include "DST_WinManager.h"
#include "DST_DataStrings.h"
#include "DST_CommonAPI.h"
#include "DST_EEPROM.h"
#include "DST_ChannelTune.h"
#include "DST_UserInterface.h"
#include "DST_Updates.h"
#include "DST_ISDBT_ChannelTask.h"
//#include "DST_OTC_Main.h"
#include "DST_OSDImage.h"

#if 0
____CMessageWin___()
#endif


char* DST_GetAppShortVersion();


class COTCDownLoadingWin : public CWindow
{
private:
	bool bDone;
	bool bNeedLine;
	int progress;
	int center_pos;
	int line_spacing;	

	int nBlock;
	int nErr;
	int ErrCategory;
	int category;
public:
	COTCDownLoadingWin(SWinEventMsg event):CWindow(event)
	{
	
		DST_g_RFUpdateState = 0;
		rect.w = 382; 
		rect.h = 241; 
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight()- rect.h) / 2;

		DST_Printf("\n\n--------------------------WIN_OTC_DOWNLOADING----------------------------------\n\n");
		

		center_pos =  rect.h / 2; 
		line_spacing = DST_GetFontHeight(fontItemSize) * 125 / 100;

		nErr = 0;
		ErrCategory = 0;
		category = 0;
		bNeedLine = false;
		SetTimeOut(0);
		bDone = false;
		progress = 0;
		
		SetTimeOut(0);
		SetTimer(1, 5*60*DST_OS_GetTicksPerSecond());

//		DHL_POWER_SetMode(nSleepState ? 2 : 0);
	}
	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_PWR:
				if (DST_g_PowerOn) // 
				{
					DST_g_PowerOn = false;
				}
				else // 
				{
					DST_g_PowerOn = true;
				} 
				DHL_POWER_Display(DST_g_PowerOn);
				break;
		}
	}
	void DrawProgressBar(DS_U32 nPos, DS_U32 nTotal, int x, int y, DS_U32 width)
	{
//		DST_Printf("nPos:%d, x:%d, y:%d, width:%d, p:%d, nTotal:%d\n",nPos,x/10,y,width,(nPos*width)/nTotal, nTotal);

		DrawBox32(x, y, width, 10, CONV32_16(0xffe5e5ff));
		if(nPos == nTotal)
			DrawBox32(x, y, width, 10, CONV32_16(0xff65a5cc));
		else
			DrawBox32(x, y, (nPos*width)/nTotal, 10, CONV32_16(0xff65a5cc));

		setFontStyle(15,0xFFE1E1E1,ALIGN_MIDDLE,ALIGN_CENTER);
		
		int line = DST_GetFontHeight(15);
		int y_str = y+10;
		char tmpProgStr[50] = {0,};
		
		sprintf(tmpProgStr,"(%d%%)",(nPos == nTotal)?(100):(int)((nPos*100)/nTotal));
		DrawBox32(x, y_str, width, line, CONV32_16(0xff24435e));
		DrawTextUTF8(x, y_str, width, line, (DS_U8*)tmpProgStr, &font); 

//		DST_Printf("rect.x:%d,rect.y:%d,rect.w:%d,rect.h:%d\n",rect.x,rect.y,rect.w,rect.h);
//		DST_Printf("x:%d,y:%d,w:%d,h:%d\n",x,y,width,y_str-y+line);

	}
	
	virtual void OnMessage(SWinEventMsg event)
	{
		static int old_count = -1;
		switch (event.cmd)
		{
			case WM_RF_UPDATE:
				switch(event.data32[0])
				{
					case DATA_RECEIVING: // DATA RECEIVING
						KillTimer(1);
						DrawProgressBar(event.data32[1],  100,rect.w/10,center_pos+2*line_spacing-10,rect.w*8/10);
						if(old_count != (int)event.data32[1])
						{
							old_count = event.data32[1];
							KillTimer(2);
							SetTimer(2, 15*60*DST_OS_GetTicksPerSecond());
						}
						break;
				}
				break;		
		}
	}

	virtual void OnTimer(char nID)
	{
		switch(nID)
		{
			case 1:
				DST_CreateWin(WIN_OTC_DOWNLOAD_FAIL,WIN_NULL,(DST_g_Lock == true)?(OTC_WAIT_TIMEOUT_FAIL):(TUNING_FAIL));
				Close();
				break;
			case 2:
				DST_CreateWin(WIN_OTC_DOWNLOAD_FAIL,WIN_NULL,OTC_COMPLETE_TIMEOUT_FAIL);
				Close();
				break;
#if 0  //test code		
			case 3:
				{
					static int count = 0;
					KillTimer(3);
					
					DrawProgressBar(count,  100,rect.w/10,center_pos+2*line_spacing-10,rect.w*8/10);
					count++;
					if(count == 100) count = 0;
					
					SetTimer(3,300);
				}
				break;
#endif				
			case 4:
				{
					static int loading = 0;
					
					loading = loading%6;
					switch(loading)
					{
						case 0:	DrawImage((rect.w-34)/2, 30, newcon2_gui_downaload_Wait1,true); break;
						case 1:	DrawImage((rect.w-34)/2, 30, newcon2_gui_downaload_Wait2,true); break;
						case 2:	DrawImage((rect.w-34)/2, 30, newcon2_gui_downaload_Wait3,true); break;
						case 3:	DrawImage((rect.w-34)/2, 30, newcon2_gui_downaload_Wait4,true); break;
						case 4:	DrawImage((rect.w-34)/2, 30, newcon2_gui_downaload_Wait5,true); break;
						case 5:	DrawImage((rect.w-34)/2, 30, newcon2_gui_downaload_Wait6,true); break;
					}
					loading ++;
					
				}
				break;
		}
	}

	virtual void Show(void)
	{
		Draw();
		
		RegisterAllKey();
	}

	void Draw()
	{
		DrawBox32(0, 0, rect.w, rect.h, CONV32_16(0xff24435e));
		
		setFontStyle(fontItemSize,0xFFE1E1E1,ALIGN_MIDDLE,ALIGN_CENTER);
		
		DrawTextUni(0, center_pos-60+25, rect.w, line_spacing, pz_OTC_Download1[OSD_Lang], &font); 
		DrawTextUni(0, center_pos+line_spacing-50+25, rect.w, line_spacing, pz_OTC_Download2[OSD_Lang], &font); 
//		SetTimer(3,500);
		SetTimer(4,300);

	}
};



class COTCDownloadFailResetWin : public CWindow
{
private:
	DS_U8 winParentID;
	DS_U8 msg;
	int nErr;
public:
	COTCDownloadFailResetWin(SWinEventMsg event):CWindow(event)
	{
		rect.w = 382; 
		rect.h = 241; 
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight()- rect.h) / 2;
		RegisterAllKey();
		SetTimeOut(0);
		DST_g_bOTCMode = false;
		
		DST_g_LED_PowerState = 1;
		nErr = event.data[2];;

	}
	~COTCDownloadFailResetWin()
	{
		DST_Reset(__func__); // â 鼭 
	}
	virtual void OnTimer(char nID)
	{
		switch(nID)
		{
			case 1:
				KillTimer(1);
				SetTimer(2, 1000);
				Show();
				break;
			case 2:
				KillTimer(2);
				Close();
				break;
			default:
				break;
		}
	}
	
	
	virtual void Show(void)
	{
		DrawBox32(0, 0, rect.w, rect.h, CONV32_16(0xff24435e));
		setFontStyle(22,0xFFE1E1E1,ALIGN_MIDDLE,ALIGN_CENTER);
		int	center_pos =  rect.h / 2; 
		int line_spacing = DST_GetFontHeight(fontItemSize) * 150 / 100;

		switch(nErr)
		{
			case TUNING_FAIL:
				DST_Printf("OTCDownloadFail : ERROR %d TUNING_FAIL\n",nErr);
				DrawTextUni(0, center_pos-2*line_spacing, rect.w, line_spacing, pz_Update_Err_101[OSD_Lang], &font); 
				break;
			case OTC_WAIT_TIMEOUT_FAIL:
				DST_Printf("OTCDownloadFail : ERROR %d OTC_WAIT_TIMEOUT_FAIL\n",nErr);
				DrawTextUni(0, center_pos-2*line_spacing, rect.w, line_spacing, pz_Update_Err_201[OSD_Lang], &font); 
				break;
			case OTC_COMPLETE_TIMEOUT_FAIL:
				DST_Printf("OTCDownloadFail : ERROR %d OTC_COMPLETE_TIMEOUT_FAIL\n",nErr);
				DrawTextUni(0, center_pos-2*line_spacing, rect.w, line_spacing, pz_Update_Err_202[OSD_Lang], &font); 
				break;
		}

		DrawTextUni(0, center_pos-line_spacing, rect.w, line_spacing, pz_OTC_Download_Fail1[OSD_Lang], &font); 
		DrawTextUni(0, center_pos, rect.w, line_spacing, pz_OTC_Download_Fail2[OSD_Lang], &font); 
		DrawTextUni(0, center_pos+line_spacing, rect.w, line_spacing, pz_OTC_Download_Fail3[OSD_Lang], &font); 

		UpdateScreen();
		
		RegisterAllKey();
		SetTimer(2, 5000);
	}
};
void DST_CreateOTCDownloadFailResetWin(SWinEventMsg event)
{
	DST_RemoveAllWindowExceptBasicWin();
	DST_AddWin((WinID)(event.data[0]), new COTCDownloadFailResetWin(event));
}


void DST_CreateOTCDownLoadingWin(SWinEventMsg event)
{
	if (DST_GetWin(WIN_UPDATE)) return;
	DST_RemoveAllWindowExceptBasicWin();
	DST_AddWin((WinID)(event.data[0]), new COTCDownLoadingWin(event));
}



