#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_CommonAPI.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"
#include "DST_Updates.h"

void JST_RFUpdate(DS_U8 RF);

#if 0
____CRFUpdateWin___()
#endif

class CRFUpdateWin : public CWindow
{
	int nReceivePos;
	int nWritePos;
	char strVersion[8];
public:
	CRFUpdateWin(SWinEventMsg event):CWindow(event)
	{
		DST_g_RFUpdateState = 0;
		RegisterAllKey();
		rect.w = DST_GetScreenWidth();
		rect.h = DST_GetScreenHeight();
		rect.x = 0;
		rect.y = 0;
		SetTimeOut(0);
//		JST_RFUpdate(10);
		nReceivePos = 0;
		nWritePos = 0;
		strVersion[0] = 0;
	}
	~CRFUpdateWin()
	{
		JST_Stop();	
	}
	
	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_RF_UPDATE:
				switch(event.data32[0])
				{
					case DATA_RECEIVING: // DATA RECEIVING
						memcpy(strVersion, &event.data32[2], 8);
						nReceivePos = event.data32[1];
						nWritePos = 0;
						break;
					case DATA_RECEIVING_COMPLETE: // DATA RECEIVING COMPLETE
						nReceivePos = 100;
						nWritePos = 0;
						break;
					case FLASH_WRITING: // FLASH WRITING
						nReceivePos = 100;
						nWritePos = event.data32[1];
						DST_g_RFUpdateState = 1;
						break;
					case FLASH_WRITING_COMPLETE: // FLASH WRITING COMPLETE
						nReceivePos = 100;
						nWritePos = 100;
						break;
					case FLASH_WRITING_FAIL: // FLASH WRITING FAIL
						nReceivePos = 100;
						nWritePos = 100;
						break;						
					case 100: // Different model
						DST_g_RFUpdateState = 2;
						break;
					case 101: // Same Version
						memcpy(strVersion, &event.data32[2], 8);
						DST_Printf("strVersion = %s\n", strVersion);
						nReceivePos = 100;
						nWritePos = 100;
						DST_g_RFUpdateState = 1;
						break;
				}
				Show();
				break;
		}
	}

	virtual void Show()
	{
		char strText[64];
		DrawBox32(0,0,rect.w, rect.h, CONV32_16(0xFF808080));
		
		setFontStyle(30, 0xFFFFFFF, ALIGN_MIDDLE,ALIGN_CENTER);
		DrawText(0,   60, rect.w, 60, "RF Update", &font);
		
		sprintf(strText, "Data Receiving : %s", strVersion);
		setFontStyle(25, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);
		DrawText(0, 150, rect.w, 40, strText, &font);
		
		DrawBox32(60-1, 200    ,    600+2, 50, CONV32_16(0xFFFFFFFF));
		DrawBox32(  60, 200 + 1, nReceivePos * 6, 48, CONV32_16(0xFF00FF00));
		 
		sprintf(strText, "%d%%", nReceivePos);
		setFontStyle(25, 0xFF000000, ALIGN_MIDDLE,ALIGN_CENTER);
		DrawText(0, 200, rect.w, 50, strText, &font);
		
		setFontStyle(25, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);
		DrawText(0, 300, rect.w, 40, "Flash Writing", &font);
		
		DrawBox32(60-1, 350    ,    600+2, 50, CONV32_16(0xFFFFFFFF));
		DrawBox32(  60, 350 + 1, nWritePos * 6, 48, CONV32_16(0xFF00FF00));
		
//		strText[5];
		sprintf(strText, "%d%%", nWritePos);
		setFontStyle(25, 0xFF000000, ALIGN_MIDDLE,ALIGN_CENTER);
		DrawText(0, 350, rect.w, 50, strText, &font);
	}
};
void DST_CreateRFUpdateWindow(SWinEventMsg event)
{
	if (DST_GetWin(WIN_RF_UPDATE)) return;
	
	DST_RemoveAllWindowExceptBasicWin();
	DST_AddWin((WinID)(event.data[0]), new CRFUpdateWin(event));
}
