#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_CommonAPI.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"
#include "DST_SignalMonitor.h"

#if 0
____CVolumeWin___()
#endif


class CSignalMeterWin : public CWindow
{
public:
	CSignalMeterWin(SWinEventMsg event):CWindow(event)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_signalmeter_back);
		rect.h = DST_GetImageHeight(newcon2_gui_signalmeter_back);
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = DST_GetScreenHeight()*9/10 - rect.h;
		SetTimeOut(30);
	}
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				Close();
				break;
			default:
				break;
		}
	}
	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
		}
	}
	virtual void Show()
	{
		Draw();
	}

	void Draw()
	{
		RegisterKey(VK_CANCEL,true);
		RegisterKey(VK_SIGNAL_METER,true);
		DrawImage(0, 0, newcon2_gui_signalmeter_back);
		setFontStyle(20, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_CENTER);

		DrawTextUni(71 , 0, rect.w, rect.h/2, pz_Sub_SignalMeter[OSD_Lang], &font);
		DrawTextUni(9 , 48, 98, 50, pz_Weak[OSD_Lang], &font);
		DrawTextUni(338 , 48, 98, 50, pz_Good[OSD_Lang], &font);

		
		DrawSignalBar();
		SetTimer(1,500);
	}
	
	void DrawSignalBar(void)
	{
		int xPos 	= 131;
		int yPos 	= 67;
		int width   = 183;
		int range	= 100;
		int signal	= DST_GetSignalStrength();

		int division =	width/3;
		int position = (width*signal)/(range);
		
		//signal text
		setFontStyle(15, 0xFFC8C8C8, ALIGN_TOP, ALIGN_CENTER);
		char tmp[5]={0};
		sprintf(tmp, "%d", signal);
		DrawText(0, rect.h*3/4 +8, rect.w, 15, tmp, &font);

		//signal meter
		for (int i=xPos; i < xPos+position; i++)
		{
			if ((i-xPos) <= division)
				DrawImage(i, yPos, newcon2_gui_progress_red);
			else if ((i-xPos) <= (division*2))
				DrawImage(i, yPos, newcon2_gui_progress_yellow);
			else
				DrawImage(i, yPos, newcon2_gui_progress_green);
		}
		

	}
	virtual void OnTimer(char nID)
	{
		switch(nID)
		{
			case 1:
				KillTimer(1);
				Draw();
				break;
			default:
				break;
		}
	}
	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_SIGNAL_METER:
			case VK_CANCEL:
				Close();
				break;
		}
	}


};
void DST_CreateSignalMeterWindow(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CSignalMeterWin(event));
}



