#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"

#if 0
____CVolumeWin___()
#endif

extern DS_U8 volume_banner_back_mute_800[];

class CVolumeWin : public CWindow
{
public:
	CVolumeWin(SWinEventMsg event):CWindow(event)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_volume_back);
		rect.h = DST_GetImageHeight(newcon2_gui_volume_back);
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = DST_GetScreenHeight()*9/10 - rect.h;
		SetTimeOut(3);
	}
	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
		}
	}
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			//case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				Close();
				break;
			default:
				break;
		}
	}
	virtual void Show()
	{
		RegisterKey(VK_CANCEL,true);
		DrawImage(0, 0, DST_UI_GetMute() ? newcon2_gui_volume_back : newcon2_gui_volume_back);
		setFontStyle(20, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_CENTER);

		DS_U16	final[20];
		memset(final,0,sizeof(final));
		strcpy16(final, pz_Volume[OSD_Lang]);
		char  tmpStr[10];
		memset(tmpStr,0,sizeof(tmpStr));
		sprintf(tmpStr,"  %d", DST_UI_GetVolume());
		str2uni(&final[strlen16(final)], (char *)tmpStr);
		DrawTextUni(7 , 19, 132, 29, final, &font);
		
		DrawProgressBar(138, 28, 291, 50, DST_UI_GetVolume());
	}
	void DrawProgressBar(int x, int y, int w, int range, int pos)
	{
		int position	= (w*pos)/(range);

		if (DST_UI_GetVolume() > 0)
		{
			for (int i = x; i < x+position; i++)
			{
				DrawImage(i, y, newcon2_gui_progress_gray);
			}
		}
	}
	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_CANCEL:
				Close();
				break;
		}
	}

};
void DST_CreateVolumeWindow(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CVolumeWin(event));
}



class CVolumeMuteWin : public CWindow
{
private:
public:
	CVolumeMuteWin(SWinEventMsg event):CWindow(event)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_banner_mute_back);
		rect.h = DST_GetImageHeight(newcon2_gui_banner_mute_back);
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = DST_GetScreenHeight()*9/10 - rect.h;

		SetTimeOut(3);
	}

	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				Close();
				break;
			default:
				break;
		}
	}

	
	virtual void Show()
	{
		RegisterKey(VK_CANCEL,true);
		DrawImage(0, 0, newcon2_gui_banner_mute_back);
		setFontStyle(25, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);
		char muteStr[10];
		if(DST_UI_GetMute()) sprintf(muteStr, "Mute On" );	
		else sprintf(muteStr, "Mute Off" );	
		DrawText(0, 0, rect.w, rect.h, muteStr, &font);

	}
	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_CANCEL:
				Close();
				break;
		}
	}


};


void DST_CreateVolumeMuteWindow(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CVolumeMuteWin(event));
}

