#ifndef __DST_WINDOW_H__
#define __DST_WINDOW_H__

#include "DST_WinManagerTask.h"
#include "DST_HostInterface.h"
#include "DST_WindowEvent.h"
#include "DST_FontEngine.h"

struct DST_RECT
{
	int       x;
	int       y;
	int       w;
	int       h;
};

#define ALIGN_LEFT		0
#define ALIGN_CENTER	1
#define ALIGN_RIGHT		2
#define ALIGN_TOP			0
#define ALIGN_MIDDLE	1
#define ALIGN_BOTTOM	2

#define DST_COLOR_BLACK     CONV32_16(0xFF000000)

class CFont
{
private:
	DS_U8 nSize;
	OSD_PIXEL_T Color;
	DS_U8 hor_align; // (0: Left, 1: Center, 2: Right)
	DS_U8 ver_align; // (0: Top, 1: Middle, 2: Bottom)

	int dot1_width;
	int dot2_width;
	int dot3_width;
public:
	CFont(DS_U8 nSize=15, OSD_PIXEL_T Color=DST_COLOR_BLACK, DS_U8 hor_align = ALIGN_CENTER, DS_U8 ver_align = ALIGN_MIDDLE)
	{
		SetSize(nSize);
		SetColor(Color);		//256̻  default : white
		SetHorAlign(hor_align);		//(0: Left, 1: Center, 2: Right)
		SetVerAlign(ver_align);		//(0: Top, 1: Middle, 2: Bottom)
	}
	void SetSize(DS_U8 Size)
	{
	    if (Size == nSize)
	        return;

		nSize = Size;
	    dot1_width = DST_GetTextWidth((char*)".", Size);
	    dot2_width = DST_GetTextWidth((char*)"..", Size);
	    dot3_width = DST_GetTextWidth((char*)"...", Size);
	}
	int GetDot1Width(void)
	{
	    return dot1_width;
	}

	int GetDot2Width(void)
	{
	    return dot2_width;
	}

	int GetDot3Width(void)
	{
	    return dot3_width;
	}

	DS_U8 GetSize()
	{
		if (nSize < 5) return 5;
		return nSize;
	}
	void SetColor(OSD_PIXEL_T nColor)
	{
		Color = nColor;
	}
	OSD_PIXEL_T GetColor()
	{
		return Color;
	}
	void SetHorAlign(DS_U8 hor)
	{
		hor_align = hor;
	}
	DS_U8 GetHorAlign()
	{
		switch (hor_align)
		{
			case ALIGN_LEFT: return ALIGN_LEFT;
			case ALIGN_RIGHT: return ALIGN_RIGHT;
		}
		return ALIGN_CENTER;
	}
	void SetVerAlign(DS_U8 ver)
	{
		ver_align = ver;
	}
	DS_U8 GetVerAlign()
	{
		switch (ver_align)
		{
			case ALIGN_TOP: return ALIGN_TOP;
			case ALIGN_BOTTOM: return ALIGN_BOTTOM;
		}
		return ALIGN_MIDDLE;
	}
};

#define TIMER_ID_MAX	6 // ִ Ÿ̸  

class CWindow
{
protected:
	//  Ŵ 
	char strWinName[32]; //  ̸  뵵
	SWinEventMsg eventInit; //   ޵Ǵ ޽
	int nWinState; //   · Window Manager 
	WinID	m_WinIDParent; // θ  ̵
	bool bVisible; // Visible Ӽ
	bool bTransparentWindow; //  ο .  κ ׸ ʴ´.
	bool bFocus; //  Focus  Ÿ. θ ڽ 찣  뵵
	// ׸ 
	DST_RECT rect; //  ũ
	OSD_PIXEL_T *imgBuff; //  ̹ 
	// Ű
	bool bRegisterKey[KEY_ID_MAX + 1]; // Ư Ű ϵǾ  Ÿ 迭
	DS_U32 nKeyDelay[KEY_ID_MAX + 1]; // Ư Ű   迭
	DS_U32 nKeyRepeat[KEY_ID_MAX + 1]; // Ư Ű   迭
	// Ÿ̸
	DS_U32 TimerTickCount[TIMER_ID_MAX]; // Ÿ̸Ӱ ۵ ð
	DS_U32 TimerInterval[TIMER_ID_MAX]; // Ÿ̸ 
//	OSD_PIXEL_T Pallette[256];
	DS_U8 Brightness;
	CFont font;
public:
	//  Ҹ
	CWindow(SWinEventMsg event);
	virtual ~CWindow()
	{
		if (imgBuff) DST_OS_Free(&imgBuff);
		imgBuff = 0;
		UpdateScreen();
	}
	//  Ӽ
	void SetParentWinID(WinID nID);
	WinID GetParentWinID();
	WinID GetWinID();

	void SetSize(int x, int y, int w, int h);
	int GetState();
	void SetState(int n);

	void SetWinName(const char* strName);
	void SetTransparent(bool bValue)
	{
		bTransparentWindow = bValue;
	}
	bool GetTransparent()
	{
		return bTransparentWindow;
	}
	// Message
	void DoOnMessage(SWinEventMsg event);
	virtual void OnMessage(SWinEventMsg /*event*/){}
	// Show
	void DoShow();
	virtual void Show() {}
	virtual void Show(WinID) {}
	// Hide
	virtual void Hide(WinID) {}
	// Remove
	void Close(); //  츦 ݰ   ȣ
	void CloseParents(CWindow* pWin); // ڱ ڽ    츦 ݴ´.

	//  ġ  ̴ Ӽ 
	void SetVisible(bool bValue);
	bool GetVisible();
	void Move(int x, int y);

	// Ŀ 
	void FocusToParent();
	void FocusToChild(WinID nID);
	void DoFocus(bool bFocus);
	virtual void Focus(bool /*bFocus*/){}

	// ׸
	DST_RECT GetSize() { return rect; }
	OSD_PIXEL_T *GetImgBuff();
	void UpdateScreen();
	void UpdateScreen(int x, int y, int w, int h);
	void DrawPixel(int x, int y, OSD_PIXEL_T color);
	void DrawBox32(int x, int y, int w, int h, OSD_PIXEL_T color);
	void DrawImage(int x, int y, DS_U8 *image, bool bProcessTransparent = false);
	void DrawImage1(int x, int y, DS_U8 *image, bool bProcessTransparent);
	void DrawImage4(int x, int y, DS_U8 *image, bool bProcessTransparent);
	void DrawImage5(int x, int y, DS_U8 *image, bool bProcessTransparent);
	void DrawImage6(int x, int y, DS_U8 *image, bool bProcessTransparent);
	void setFontStyle(DS_U8 size, DS_U32 color, DS_U8 ver_align, DS_U8 hor_align);
	
	// 
	void DrawText(int x, int y, int w, int h, char *strText, CFont* font);
	void DrawTextUTF8(int start_x, int start_y, int width, int height, DS_U8* strText, CFont* font);
	void DrawTextUni(int x, int y, int w, int h, DS_U16* strText, CFont* font);
	void DrawText32(int start_x, int start_y, int width, int height, DS_U32* strText, CFont* font);

	// Ű
	void RegisterAllKey();
	void UnRegisterAllKey();
	void RegisterAllNumKey();
  void UnRegisterAllNumKey();
	void RegisterKey(DS_U8 nKeyCode, bool bState, int nDelay = 0, int nRepeat = 0);
	bool IsRegisterKey(DS_U8 nKeyCode);
	DS_U32 GetKeyDelay(DS_U8 KeyCode)
	{
		return nKeyDelay[KeyCode];
	}
	DS_U32 GetKeyRepeat(DS_U8 KeyCode)
	{
		return nKeyRepeat[KeyCode];
	}
	virtual void KeyInput(DS_U8 /*key*/, bool /*bRepeat*/){}

	// ŸӾƿ Ÿ̸
	void SetTimeOut(int nSecond);
	DS_U32 GetTimeOut();
	void SetTimer(char nID, int ms);
	void ResetTimer(char nID);
	void KillTimer(char nID);
	bool ProcessTimer();
	void DoOnTimer(char nID);
	virtual void OnTimer(char /*nID*/) {}
	DS_U8 GetBrightness()
	{
		return Brightness;
	}
	void SetBrightness(DS_U8 nVal)
	{
		Brightness = (nVal < 100) ? nVal : 100;
	}
};

#endif
