#include "DST_MemoryDB.h"

struct DB_PAT db_pat[DB_PAT_MAX];
struct DB_PMT db_pmt[DB_PMT_MAX];

#if EPG_SUPPORT
struct DB_EIT db_eit[DB_EIT_MAX];
struct DB_EIT_SUB db_eit_sub[DB_EIT_SUB_MAX];
struct DB_ETT db_ett[DB_ETT_MAX];
#endif

#if CHANNEL_EDIT_SUPPORT
struct DB_SKIP_LIST db_skip_list[DB_SKIP_LIST_MAX];
#endif

#if CVCT_SUPPORT
struct DB_CVCT db_cvct[DB_CVCT_MAX];
struct DB_CVCT_SUB db_cvct_sub[DB_CVCT_SUB_MAX];
#endif

struct DB_TVCT db_tvct[DB_TVCT_MAX];
struct DB_TVCT_SUB db_tvct_sub[DB_TVCT_SUB_MAX];
struct DB_CONFIG db_config[DB_CONFIG_MAX];
struct DB_CHANNEL_DB db_channel_db[DB_CHANNEL_DB_MAX];
struct DB_CHANNEL_UPDN db_channel_updn[DB_CHANNEL_UPDN_MAX];



struct PMT_CC_TABLE pmt_cc_table[MAX_PMT_CC_TABLE_COUNT];
struct PMT_AC3_TABLE pmt_ac3_table[MAX_PMT_AC3_TABLE_COUNT];
struct PMT_ISO_TABLE pmt_iso_table[MAX_PMT_ISO_TABLE_COUNT];
struct PMT_AUDIO_TABLE pmt_audio_table[MAX_PMT_AUDIO_TABLE_COUNT];


DB_LIST db_list[] = {
	{	NO_PAT			, "pat"	},
	{	NO_PMT			, "pmt"	},
#if EPG_SUPPORT
	{	NO_EIT			, "eit"	},
	{	NO_EIT_SUB		, "eit_sub"	},
	{	NO_ETT			, "ett"},
#endif
#if CHANNEL_EDIT_SUPPORT
	{ 	NO_SKIP_LIST	, "skip_list"},
#endif
#if CVCT_SUPPORT
	{ 	NO_CVCT			, "cvct"},
	{ 	NO_CVCT_SUB		, "cvct_sub"},
#endif
	{ 	NO_TVCT			, "tvct"},
	{ 	NO_TVCT_SUB		, "tvct_sub"},
	{ 	NO_CONFIG		, "config"},
	{ 	NO_CHANNEL_DB	, "channel_db"},
	{ 	NO_CHANNEL_UPDN	, "channel_updn"},
	{	NO_PMT_CC_TABLE	, "pmt_cc_table"},
	{	NO_PMT_AC3_TABLE	, "pmt_ac3_table"},
	{	NO_PMT_ISO_TABLE	, "pmt_iso_table"},
	{	NO_PMT_AUDIO_TABLE	, "pmt_audio_table"},
	{ 	NO_DB_MAX		, "max"}
};

void DBLock(bool bLock)
{
	static DS_U32 sema4 = 0;
	if (sema4== 0) 
	{
		sema4 = DST_OS_CreateLock((char*)"db");
	}
	bLock ? DST_OS_Lock(sema4) : DST_OS_Unlock(sema4);
}

