#include "DST_WinManager.h"
#include "DST_ChannelTune.h"

#include "DST_DataStrings.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_ISDBT_ChannelTask.h"
#include "DST_DB_Engine.h"
#include "DST_DB.h"
#include "DST_MemoryDB.h"

#if 0
____CChannelBannerWin___()
#endif

bool DST_IsTuneMode();

static DS_U8* NumToImage(DS_U8 num)
{
	switch(num)
	{
		case 0: return DST_channelbanner_0_480;
		case 1: return DST_channelbanner_1_480;
		case 2: return DST_channelbanner_2_480;
		case 3: return DST_channelbanner_3_480;
		case 4: return DST_channelbanner_4_480;
		case 5: return DST_channelbanner_5_480;
		case 6: return DST_channelbanner_6_480;
		case 7: return DST_channelbanner_7_480;
		case 8: return DST_channelbanner_8_480;
		case 9: return DST_channelbanner_9_480;
	}
	return DST_channelbanner_0_480;
}

static DS_U8* NumToImageSmall(DS_U8 num)
{
	switch(num)
	{
		case 0: return DST_channelbanner_0_s_480;
		case 1: return DST_channelbanner_1_s_480;
		case 2: return DST_channelbanner_2_s_480;
		case 3: return DST_channelbanner_3_s_480;
		case 4: return DST_channelbanner_4_s_480;
		case 5: return DST_channelbanner_5_s_480;
		case 6: return DST_channelbanner_6_s_480;
		case 7: return DST_channelbanner_7_s_480;
		case 8: return DST_channelbanner_8_s_480;
		case 9: return DST_channelbanner_9_s_480;
	}
	return DST_channelbanner_0_s_480;
}

DS_U32* DST_UTF82Uni(DS_U8 *utf);

//class CChannelBannerWin : public CWindow
//{
//private:
	static int CChannelBannerWin_nCh_Major;
	static int CChannelBannerWin_nCh_Minor;
	static DS_U8 CChannelBannerWin_bannerType;
	static DS_U32 *CChannelBannerWin_chName;
	static bool CChannelBannerWin_bTuned;
	static bool CChannelBannerWin_bHyphened;
	static int CChannelBannerWin_maxMajorPosition;
	static int CChannelBannerWin_maxMinorPosition;
//public:
void CChannelBannerWin_RegisterUnregisterDigitKey(CWindow *this, bool bState);
int CChannelBannerWin_getPositionNumber(int number);


//	CChannelBannerWin(SWinEventMsg event):CWindow(event)
	void CChannelBannerWin_Constructor(CWindow *this, SWinEventMsg event)
	{	
		this->SetWinName(this,  "ChBanner");	
		CChannelBannerWin_chName = 0;
		CChannelBannerWin_nCh_Major = 0;
		CChannelBannerWin_nCh_Minor = 0;
		
//		CDB db; NewCDB(&db);
//		db.GetTable(&db, "select max(major), max(minor) from channel_db");
		int i;
		int max_major = 0;
		int max_minor = 0;
		DBLock(true);
		for (i = 0; i < DB_CHANNEL_DB_MAX; i++)
		{
			if (db_channel_db[i].program_number == 0) continue;
			if (db_channel_db[i].major > max_major) max_major = db_channel_db[i].major;
			if (db_channel_db[i].minor > max_minor) max_minor = db_channel_db[i].minor;
		}
		DBLock(false);

		CChannelBannerWin_maxMajorPosition = CChannelBannerWin_getPositionNumber(max_major);
		CChannelBannerWin_maxMinorPosition = CChannelBannerWin_getPositionNumber(max_minor);

		CChannelBannerWin_bannerType = event.data[2];

		this->rect.w = DST_GetScreenWidth()/2;
		this->rect.h = DST_GetImageHeight(channel_banner_720480);
		this->rect.x = DST_GetScreenWidth() - this->rect.w - (DST_GetScreenWidth() / 20);
		this->rect.y = 10+DST_GetScreenHeight() / 20;

		this->SetTimeOut(this, 3);
		CChannelBannerWin_bTuned = false;
		CChannelBannerWin_bHyphened = false;
		CChannelBannerWin_RegisterUnregisterDigitKey(this, true);
		switch(CChannelBannerWin_bannerType)
		{
			case BANNER_NORMAL:
				this->SetTimeOut(this, event.data[3]);
				break;
			case BANNER_DIGIT:
				if(this->eventInit.data[3] == VK_0) this->Close(this);
				this->KeyInput(this, this->eventInit.data[3], false);
				break;
		}
//		DeleteCDB(&db);
	}

	
	void CChannelBannerWin_Destructor(CWindow *this)
	{
		if (CChannelBannerWin_chName) DST_OS_Free(&CChannelBannerWin_chName);
		if(CChannelBannerWin_bannerType == BANNER_DIGIT && this->eventInit.data[3] != VK_0 && CChannelBannerWin_nCh_Major != 0)
			DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL, DST_g_SignalState == SM_AUDIO_ONLY?0:3, 0, 0);
	}
	
	int CChannelBannerWin_getPositionNumber(int number)
	{
		int pos = 0;
		while(number>0)
		{
			number = number/10;
			pos++;
		}
		return pos;
	}

	int CChannelBannerWin_getPowerOfTen(int x)
	{
		int ret = 1;
		int i = 0;
		for( i=0;i<x;i++)
			ret*= 10;
		return ret;
	}

	int CChannelBannerWin_getMaxTuneNumber(int x)
	{
		int ret = 0;
		int i = 0;
		for( i=0;i<x;i++)
			ret+= CChannelBannerWin_getPowerOfTen(i);

		DST_Printf("ret = %d\n",ret);
		return 9*ret;	
	}	
	
	void CChannelBannerWin_RegisterUnregisterDigitKey(CWindow *this, bool bState)
	{
		this->RegisterKey(this, VK_PREV, bState, 0, 0);
		this->RegisterKey(this, VK_PREV_CH, bState, 0, 0);
		this->RegisterKey(this, VK_CH_UP, bState, 0, 0);
		this->RegisterKey(this, VK_CH_DN, bState, 0, 0);
		switch(CChannelBannerWin_bannerType)
		{
			case BANNER_NORMAL:
				this->RegisterKey(this, VK_CANCEL, bState, 0, 0);
				this->RegisterKey(this, VK_OK, bState, 0, 0);
				break;
			case BANNER_DIGIT:
				this->RegisterKey(this, VK_0, bState, 0, 0);
				this->RegisterKey(this, VK_1, bState, 0, 0);
				this->RegisterKey(this, VK_2, bState, 0, 0);
				this->RegisterKey(this, VK_3, bState, 0, 0);
				this->RegisterKey(this, VK_4, bState, 0, 0);
				this->RegisterKey(this, VK_5, bState, 0, 0);
				this->RegisterKey(this, VK_6, bState, 0, 0);
				this->RegisterKey(this, VK_7, bState, 0, 0);
				this->RegisterKey(this, VK_8, bState, 0, 0);
				this->RegisterKey(this, VK_9, bState, 0, 0);
				this->RegisterKey(this, VK_OK, bState, 0, 0);
				this->RegisterKey(this, VK_CANCEL, bState, 0, 0);
				this->RegisterKey(this, VK_HYPHEN, bState, 0, 0);
				break;
		}

	}

//	virtual void Show(WinID id)
	void CChannelBannerWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_ENGINEER_MODE:
			case WIN_FREQUENCY_SETTING:
			case WIN_FACTORY_MODE:
			case WIN_DIRECT_TUNE:
//			case WIN_VOLUME:
//			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
//			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
			case WIN_OTC_DOWNLOAD:
			case WIN_OTC_DOWNLOAD_FAIL:
			case WIN_RF_UPDATE:				
				this->Close(this);
				break;
			default:
				break;
		}
	}

	void CChannelBannerWin_Draw(CWindow *this)
	{
		// ȭ ׸
		int xPos = 0;
//		CDB db; NewCDB(&db);
		int nPos = -1;
		int nChCount = 0;
		int major =  0;
		int minor = 0;
		int majorPosition = 0;
		int minorPosition = 0;
		char name[TEXT_LENGTH_MAX] = { 0,};

		DS_U8 *img[9] = {0,};
		int numberLenth = 0;
		int nTotalWidth = 0;
		int index = 0;
		int i = 0;

		DS_U8 RF = DST_EEPROM_GetRF();
		DS_U16 PROG_ID = DST_EEPROM_GetProgramNumber();
		
//		DST_GetAVState(&RF, &PROG_ID, 0);
//		this->DrawImage(this, 0, 0, channel_banner_720480, false);
		this->DrawBox32(this, 0, 0, this->rect.w, this->rect.h, CONV32_16(0x00000000));

		// TV  
		this->setFontStyle(this, 22, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_RIGHT);
		DBLock(true);
		if(CChannelBannerWin_bannerType == BANNER_NORMAL)
		{
			int max_major = -1;
			int max_minor = -1;
			nChCount = 0;
			for (i=DB_CHANNEL_DB_MAX-1; i >= 0; i--)
			{
				if (db_channel_db[i].program_number == 0) continue;
				if (db_channel_db[i].rf != RF) continue;
				if (db_channel_db[i].program_number != PROG_ID) continue;

				if(max_major < db_channel_db[i].major)
				{
					max_major = db_channel_db[i].major;
					max_minor = db_channel_db[i].minor;
					nPos = i;
				}
				else if(max_major == db_channel_db[i].major)
				{
					if(max_minor < db_channel_db[i].minor)
					{
						max_minor = db_channel_db[i].minor;
						nPos = i;
					}
				}
				
				nChCount++;
			}
			if(nChCount < 1)
			{	
				max_major = -1;
				max_minor = -1;			
				for (i=DB_CHANNEL_DB_MAX-1; i >= 0; i--)
				{
					if (db_channel_db[i].program_number == 0) continue;
					if (db_channel_db[i].rf != RF) continue;
					if(max_major < db_channel_db[i].major)
					{
						max_major = db_channel_db[i].major;
						max_minor = db_channel_db[i].minor;
						nPos = i;
					}
					else if(max_major == db_channel_db[i].major)
					{
						if(max_minor < db_channel_db[i].minor)
						{
							max_minor = db_channel_db[i].minor;
							nPos = i;
						}
					}
					nChCount++;
				}
			}

			major =  DST_GetFrequencyNumberbyIndex(RF);
			minor = 0;
			if (nChCount)
			{
				nChCount = 2; // ̳ ǥõǵ  2 
				major = db_channel_db[nPos].major;
				minor = db_channel_db[nPos].minor;
				strcpy(name , db_channel_db[nPos].name);
				CChannelBannerWin_bHyphened = true;
			}
		}
		else
		{
			if(CChannelBannerWin_nCh_Minor == 0)
			{
				nChCount = 1;
			}
			int max_major = -1;
			int max_minor = -1;
			bool bFound = true;
			int tmp_minor = CChannelBannerWin_nCh_Minor;
			nChCount = 0;
			int rf = DST_DB_GetRF(CChannelBannerWin_nCh_Major, &tmp_minor, &bFound);
			int program_number = DST_DB_GetProgramNumber(CChannelBannerWin_nCh_Major,CChannelBannerWin_nCh_Minor==0?tmp_minor:CChannelBannerWin_nCh_Minor);
			for (i=DB_CHANNEL_DB_MAX-1; i >= 0; i--)
			{
				if (db_channel_db[i].program_number == 0) continue;
				if (db_channel_db[i].rf != rf) continue;
				if (db_channel_db[i].program_number != program_number) continue;
				if(max_major < db_channel_db[i].major)
				{
					max_major = db_channel_db[i].major;
					max_minor = db_channel_db[i].minor;
					nPos = i;
				}
				else if(max_major == db_channel_db[i].major)
				{
					if(max_minor < db_channel_db[i].minor)
					{
						max_minor = db_channel_db[i].minor;
						nPos = i;
					}
				}

				nChCount++;
			}
			major = CChannelBannerWin_nCh_Major;
			minor = CChannelBannerWin_nCh_Minor;
			if(nPos > -1) strcpy(name , db_channel_db[nPos].name);
		}
		DBLock(false);
		majorPosition = CChannelBannerWin_getPositionNumber(major);
		minorPosition = CChannelBannerWin_getPositionNumber(minor);
		
		// ä̸ ǥ
		if (nPos < 0 || strlen(name) == 0) // äθʿ  ä 
		{
			this->FontSetColor(this,CONV32_16(0xFF221F1F));
			this->DrawTextUni(this, 0, DST_GetImageHeight(DST_channelbanner_0_480)+2, this->rect.w, 47, pz_Digital[OSD_Lang], &(this->font)); // Digital
			this->FontSetColor(this,CONV32_16(0xFFC8C8C8));
			this->DrawTextUni(this, 0, DST_GetImageHeight(DST_channelbanner_0_480), this->rect.w -2, 47, pz_Digital[OSD_Lang], &(this->font)); // Digital
		}
		else
		{
			DS_U32* strText32 = DST_UTF82Uni((DS_U8*)name); 
			this->FontSetColor(this,CONV32_16(0xFF221F1F));
			this->DrawText32(this, 0, DST_GetImageHeight(DST_channelbanner_0_480) +2, this->rect.w, 47, strText32, &(this->font));
			this->FontSetColor(this,CONV32_16(0xFFC8C8C8));
			this->DrawText32(this, 0, DST_GetImageHeight(DST_channelbanner_0_480), this->rect.w -2, 47, strText32, &(this->font));
		}
		
		numberLenth = majorPosition+minorPosition+((CChannelBannerWin_bHyphened )?1:0);
		i = 0;
		for( i=majorPosition;i>0;i--)
		{
			img[index] = NumToImage((major/CChannelBannerWin_getPowerOfTen(i-1))%10);
			nTotalWidth += DST_GetImageWidth(img[index]);
			index++;
		}
		
		if(CChannelBannerWin_bHyphened )
		{
			img[index] = DST_channelbanner_dash_480;
			nTotalWidth += DST_GetImageWidth(img[majorPosition]);
			index++;
		}

		i = 0;
		for( i=minorPosition;i>0;i--)
		{
			img[index] = NumToImageSmall((minor/CChannelBannerWin_getPowerOfTen(i-1))%10);
			nTotalWidth += DST_GetImageWidth(img[index]);
			index++;
		}	

		xPos = (this->rect.w - nTotalWidth) - 10;
		i = 0;
		for( i=0;i<numberLenth;i++)
		{
			int yPos = 0;
			if(i < majorPosition)
			{
				yPos = 0;
			}
			else
			{
				if(i == majorPosition && CChannelBannerWin_bHyphened)
					yPos = 18;
				else
					yPos = 11;
			}
			this->DrawImage(this, xPos, yPos, img[i], true);
			xPos += DST_GetImageWidth(img[i]);
		}
//		DeleteCDB(&db);

	}

//	virtual void Show()
	void CChannelBannerWin_Show(CWindow *this)
	{
		CChannelBannerWin_Draw(this);
		CChannelBannerWin_RegisterUnregisterDigitKey(this, true);
	}

//	virtual void OnTimer(char nID)
	void CChannelBannerWin_OnTimer(CWindow *this, char nID)
	{
		switch (nID)
		{
			case 1:
				{
					this->KillTimer(this, 1);
					CChannelBannerWin_bTuned = true;
					bool bFound = true;
					int tmp_minor = CChannelBannerWin_nCh_Minor;
					int RF = DST_DB_GetRF(CChannelBannerWin_nCh_Major, &tmp_minor, &bFound);
//					DST_Printf("RF = %d, CChannelBannerWin_nCh_Major=%d, tmp_minor=%d DST_DB_GetProgramNumber(CChannelBannerWin_nCh_Major,tmp_minor)=%d\n",RF, CChannelBannerWin_nCh_Major, tmp_minor,DST_DB_GetProgramNumber(CChannelBannerWin_nCh_Major,tmp_minor));
					if (DST_DB_PresentMatchChannel(RF, CChannelBannerWin_nCh_Major, CChannelBannerWin_nCh_Minor==0?tmp_minor:CChannelBannerWin_nCh_Minor ))
						DST_UI_ChannelTune(bFound?RF:DST_MinRF(), DST_DB_GetProgramNumber(CChannelBannerWin_nCh_Major,CChannelBannerWin_nCh_Minor==0?tmp_minor:CChannelBannerWin_nCh_Minor));
				}
				break;
			default:
				break;
		}
	}

//	virtual void OnMessage(SWinEventMsg event)
	void CChannelBannerWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_CT_MSG: // Ʃ  ޽  
				if (event.data32[0] == CT_TUNE_START) 
				{
					this->Show(this);
					this->SetTimeOut(this, 3);
				}
				break;		
			case WM_POWER_OFF:
				this->Close(this);
				break;
		}
	}

		
//		virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CChannelBannerWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		bool bMatch = false;
		int nCount = 0;
		switch (key)
		{
			case VK_PREV:
			case VK_PREV_CH:
				if (IsTVHotKeyPossible()) 
				{
					CChannelBannerWin_bTuned = true;
					this->KillTimer(this, 1);
					int nCh_Major = DST_DB_GetMajor(DST_g_PrevRF,DST_g_PrevProgramNumber);
					int nCh_Minor = DST_DB_GetMinor(DST_g_PrevRF,DST_g_PrevProgramNumber);
					if(DST_DB_PresentMatchChannel(DST_g_PrevRF, nCh_Major,nCh_Minor ))
					{
						DST_UI_ChannelTune(DST_g_PrevRF, DST_g_PrevProgramNumber);
					}
					else
					{
						DST_g_PrevRF = DST_EEPROM_GetRF();
						DST_g_PrevProgramNumber = DST_EEPROM_GetProgramNumber();
					}
					CChannelBannerWin_bannerType = BANNER_NORMAL;
					CChannelBannerWin_RegisterUnregisterDigitKey(this, false);
					CChannelBannerWin_RegisterUnregisterDigitKey(this, true);
					this->SetTimeOut(this, 3);
					CChannelBannerWin_Draw(this);
				}
				break;
			case VK_CH_UP:
			case VK_CH_DN:
				CChannelBannerWin_bTuned = true;
				this->KillTimer(this, 1);
				DST_UI_ChannelUpDn(key==VK_CH_UP?true:false);
				CChannelBannerWin_bannerType = BANNER_NORMAL;
				CChannelBannerWin_RegisterUnregisterDigitKey(this, false);
				CChannelBannerWin_RegisterUnregisterDigitKey(this, true);
				this->SetTimeOut(this, 3);
				CChannelBannerWin_Draw(this);
				break;
			case VK_0:
			case VK_1:
			case VK_2:
			case VK_3:
			case VK_4:
			case VK_5:
			case VK_6:
			case VK_7:
			case VK_8:
			case VK_9:
				{
					if(CChannelBannerWin_bannerType == BANNER_NORMAL)
					{
						CChannelBannerWin_bHyphened = false;
						CChannelBannerWin_bannerType = BANNER_DIGIT;
						CChannelBannerWin_RegisterUnregisterDigitKey(this, false);
						CChannelBannerWin_RegisterUnregisterDigitKey(this, true);
					}
					if(CChannelBannerWin_nCh_Minor > (DS_U16)CChannelBannerWin_getMaxTuneNumber(CChannelBannerWin_maxMinorPosition))
					{
						CChannelBannerWin_bTuned = false;
						CChannelBannerWin_bHyphened = false;
						CChannelBannerWin_nCh_Major = 0;
						CChannelBannerWin_nCh_Minor = 0;
					}
					
					if(CChannelBannerWin_bHyphened)
						CChannelBannerWin_nCh_Minor = (CChannelBannerWin_nCh_Minor>0)?( CChannelBannerWin_nCh_Minor * 10 + ( key - VK_0)):(key - VK_0);
					else
						CChannelBannerWin_nCh_Major = CChannelBannerWin_nCh_Major * 10 + ( key - VK_0);

					if(CChannelBannerWin_bTuned)
					{
						CChannelBannerWin_bTuned = false;
						CChannelBannerWin_bHyphened = false;
						CChannelBannerWin_nCh_Major =  key - VK_0;
						CChannelBannerWin_nCh_Minor = 0;
					}

					if(CChannelBannerWin_bHyphened)
					{
						if(CChannelBannerWin_nCh_Minor > (DS_U16)CChannelBannerWin_getMaxTuneNumber(CChannelBannerWin_maxMinorPosition))
						{
							CChannelBannerWin_bHyphened = false;
							CChannelBannerWin_nCh_Major =  key - VK_0;
							CChannelBannerWin_nCh_Minor = 0;
						}
					}
					else
					{
						if(CChannelBannerWin_nCh_Major > (DS_U16)CChannelBannerWin_getMaxTuneNumber(CChannelBannerWin_maxMajorPosition))
							CChannelBannerWin_nCh_Major =  key - VK_0;
					}

					if(CChannelBannerWin_nCh_Major == 0) 
					{
						this->Close(this);
						return;
					}
					nCount = DST_DB_AvailableChannelCount(CChannelBannerWin_nCh_Major);
					if (nCount == 0) // ġϴ    ٷ ݴ´. 
					{
						CChannelBannerWin_Draw(this);
						this->KillTimer(this, 1);
						break;
					}
					bool bFound = true;
					int tmp_minor = CChannelBannerWin_nCh_Minor;
					bMatch = DST_DB_PresentMatchChannel(DST_DB_GetRF(CChannelBannerWin_nCh_Major, &tmp_minor, &bFound), CChannelBannerWin_nCh_Major, CChannelBannerWin_nCh_Minor==0?tmp_minor:CChannelBannerWin_nCh_Minor);
					if (bMatch) // Ȯ ġϴ ä ִٸ 2Ŀ ƩѴ.
					{
						this->SetTimer(this, 1, 2800);
						CChannelBannerWin_Draw(this);
						break;
					}
					CChannelBannerWin_Draw(this);
				}
				break;

			case VK_HYPHEN:
				CChannelBannerWin_bHyphened = true;
				CChannelBannerWin_Draw(this);
				break;
				
			case VK_OK:
				if (CChannelBannerWin_bannerType == BANNER_NORMAL) 
				{
					if(DST_g_SignalState != SM_AUDIO_ONLY)	this->Close(this);
				}	
				else
				{
					bool bFound = true;
					int tmp_minor = CChannelBannerWin_nCh_Minor;
					int RF = DST_DB_GetRF(CChannelBannerWin_nCh_Major, &tmp_minor, &bFound);
					if (DST_DB_PresentMatchChannel(RF, CChannelBannerWin_nCh_Major, CChannelBannerWin_nCh_Minor==0?tmp_minor:CChannelBannerWin_nCh_Minor ))
						DST_UI_ChannelTune(bFound?RF:DST_MinRF(), DST_DB_GetProgramNumber(CChannelBannerWin_nCh_Major,CChannelBannerWin_nCh_Minor==0?tmp_minor:CChannelBannerWin_nCh_Minor));
					this->Close(this);
				}
				break;
			case VK_CANCEL:
				if(DST_g_SignalState != SM_AUDIO_ONLY)	this->Close(this);
				break;
			default: break;
		}
	}

//};


void DST_CreateChannelBannerWindow(SWinEventMsg event)
{
	if (DST_GetWin(WIN_OTC_DOWNLOAD)) return;
	if (DST_GetWin(WIN_OTC_DOWNLOAD_FAIL)) return;
	if (DST_GetWin(WIN_MANUAL_SEARCH)) return;
	if (DST_GetWin(WIN_AUTO_SEARCH)) return;
	if (DST_GetWin(WIN_CHANNEL_LIST)) return;
	if (DST_GetWin(WIN_PROGRAM_GUIDE)) return;
	if (DST_GetWin(WIN_MAIN_MENU)) return;
	if (DST_GetWin(WIN_INFOR_BANNER) && event.data[2] == BANNER_NORMAL) return;
	if (DST_GetWin(WIN_FACTORY_MODE)) return;
	
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor 	= CChannelBannerWin_Destructor;
	pWin->KeyInput 		= CChannelBannerWin_KeyInput;
	pWin->OnMessage		= CChannelBannerWin_OnMessage;
	pWin->OnTimer		= CChannelBannerWin_OnTimer;
	pWin->ShowWindow	= CChannelBannerWin_ShowWindow;
	pWin->Show 			= CChannelBannerWin_Show;
	//  ȣ
	CChannelBannerWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);	
}


//class CDirectTuneWin : public CWindow
//{
//private:
	static int CDirectTuneWin_nRF;
	static int CDirectTuneWin_nRFIndex;
	static int CDirectTuneWin_nRFIndex_Old;
	static bool CDirectTuneWin_bTuned;
	static bool CDirectTuneWin_bFirst;
//public:
void CDirectTuneWin_RegisterUnregisterDigitKey(CWindow *this, bool bState);

//	CDirectTuneWin(SWinEventMsg event):CWindow(event)
	void CDirectTuneWin_Constructor(CWindow *this, SWinEventMsg event)
	{	
		this->SetWinName(this,  "DirectTune");
		DS_U8  RF = 0;
		DS_U16 sID = 0;
		
		DST_GetAVState(&RF, 0, &sID);
		
		CDirectTuneWin_nRFIndex = RF;
		CDirectTuneWin_nRFIndex_Old = CDirectTuneWin_nRFIndex;
		
		CDirectTuneWin_nRF = DST_GetFrequencyNumberbyIndex(CDirectTuneWin_nRFIndex);

		this->rect.w = DST_GetImageWidth(channel_banner_720480);
		this->rect.h = DST_GetImageHeight(channel_banner_720480);
		this->rect.x = DST_GetScreenWidth() - this->rect.w - (DST_GetScreenWidth() / 20);
		this->rect.y = DST_GetScreenHeight() / 20;

		this->SetTimeOut(this, 3);
		CDirectTuneWin_bTuned = false;
		CDirectTuneWin_bFirst = true;
		CDirectTuneWin_RegisterUnregisterDigitKey(this, true);
	}
	
	void CDirectTuneWin_Destructor(CWindow *this)
	{
		if(DST_GetWin(WIN_CHANNEL_BANNER) != 0)
			DST_CloseWin(WIN_CHANNEL_BANNER);
		DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL, 3, 0, 0);
	}

	int CDirectTuneWin_getPositionNumber(int number)
	{
		int pos = 0;
		while(number>0)
		{
			number = number/10;
			pos++;
		}
		return pos;
	}

	int CDirectTuneWin_getPowerOfTen(int x)
	{
		int ret = 1;
		int i = 0;
		for( i=0;i<x;i++)
			ret*= 10;
		return ret;
	}
	
	void CDirectTuneWin_RegisterUnregisterDigitKey(CWindow *this, bool bState)
	{
		this->RegisterKey(this, VK_0, bState, 0, 0);
		this->RegisterKey(this, VK_1, bState, 0, 0);
		this->RegisterKey(this, VK_2, bState, 0, 0);
		this->RegisterKey(this, VK_3, bState, 0, 0);
		this->RegisterKey(this, VK_4, bState, 0, 0);
		this->RegisterKey(this, VK_5, bState, 0, 0);
		this->RegisterKey(this, VK_6, bState, 0, 0);
		this->RegisterKey(this, VK_7, bState, 0, 0);
		this->RegisterKey(this, VK_8, bState, 0, 0);
		this->RegisterKey(this, VK_9, bState, 0, 0);
		this->RegisterKey(this, VK_OK, bState, 0, 0);
		this->RegisterKey(this, VK_CANCEL, bState, 0, 0);
		this->RegisterKey(this, VK_UP, bState, 0, 0);
		this->RegisterKey(this, VK_DN, bState, 0, 0);
		this->RegisterKey(this, VK_HYPHEN, bState, 0, 0);
	}

//	virtual void Show(WinID id)
	void CDirectTuneWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_FACTORY_MODE:
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
			case WIN_OTC_DOWNLOAD:
			case WIN_OTC_DOWNLOAD_FAIL:
			case WIN_UPDATE:
			case WIN_UPDATE_RESET:				
				this->Close(this);
				break;
			default:
				break;
		}
	}

	void CDirectTuneWin_Draw(CWindow *this)
	{
		// ȭ ׸
		int xPos = 0;
		char name[3] = {0,};
		DS_U32* strText32 = 0;
		
		DS_U8 *img[9] = {0,};
		int numberLenth = 0;
		int nTotalWidth = 0;
		int index = 0;
		int i = 0;
		
		this->DrawImage(this, 0, 0, channel_banner_720480, false);
		
		// TV  
		this->setFontStyle(this, 20, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_CENTER);

		sprintf(name,"%s","RF");
		// ä̸ ǥ
		strText32 = DST_UTF82Uni((DS_U8*)name); // ȣ ʿ ޸ 
		this->DrawText32(this, 0, 0, this->rect.w, 47, strText32, &(this->font));
		
		// ä  ǥ
		numberLenth = CDirectTuneWin_getPositionNumber(CDirectTuneWin_nRF);
		i = 0;
		for( i=numberLenth;i>0;i--)
		{
			img[index] = NumToImage((CDirectTuneWin_nRF/CDirectTuneWin_getPowerOfTen(i-1))%10);
			nTotalWidth += DST_GetImageWidth(img[index]);
			index++;
		}
		
		xPos = (this->rect.w - nTotalWidth) / 2;
		i = 0;
		for( i=0;i<numberLenth;i++)
		{
			this->DrawImage(this, xPos, 68, img[i], true);
			xPos += DST_GetImageWidth(img[i]);
		}
	}

	
//	virtual void Show()
	void CDirectTuneWin_Show(CWindow *this)
	{
		CDirectTuneWin_Draw(this);
		CDirectTuneWin_RegisterUnregisterDigitKey(this, true);
	}

//	virtual void OnMessage(SWinEventMsg event)
	void CDirectTuneWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
		}
	}

//	virtual void OnTimer(char nID)
	void CDirectTuneWin_OnTimer(CWindow *this, char nID)
	{
		switch (nID)
		{
			case 1:
				{
					this->KillTimer(this, 1);
					if(CDirectTuneWin_nRFIndex > (DS_U16)DST_MaxRF()|| CDirectTuneWin_nRFIndex < (DS_U16)DST_MinRF())
						CDirectTuneWin_nRFIndex =	CDirectTuneWin_nRFIndex_Old;


					CDirectTuneWin_Draw(this);
					if(DST_GetIndexByRFNumber(CDirectTuneWin_nRF) >= 0)
					{
						CDirectTuneWin_nRFIndex = DST_GetIndexByRFNumber(CDirectTuneWin_nRF);
						CDirectTuneWin_bTuned = true;
						DST_UI_ChannelTune(CDirectTuneWin_nRFIndex, 0);
					}		
					CDirectTuneWin_nRFIndex_Old = CDirectTuneWin_nRFIndex;				

					this->SetTimer(this, 2,1000);
				}
				break;
			case 2:
				this->Close(this);
				break;
			default:
				break;
		}
	}

//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CDirectTuneWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_UP:
				CDirectTuneWin_nRFIndex += 1;
				if(CDirectTuneWin_nRFIndex > (DS_U16)DST_MaxRF()) CDirectTuneWin_nRFIndex = (DS_U16)DST_MinRF();
				CDirectTuneWin_nRF = DST_GetFrequencyNumberbyIndex(CDirectTuneWin_nRFIndex);
				this->SetTimer(this, 1,10);
				break;
			
			case VK_DN:
				CDirectTuneWin_nRFIndex -= 1;
				if(CDirectTuneWin_nRFIndex < (DS_U16)DST_MinRF()) CDirectTuneWin_nRFIndex = (DS_U16)DST_MaxRF();
				CDirectTuneWin_nRF = DST_GetFrequencyNumberbyIndex(CDirectTuneWin_nRFIndex);
				this->SetTimer(this, 1,10);
				break;

			case VK_0:
			case VK_1:
			case VK_2:
			case VK_3:
			case VK_4:
			case VK_5:
			case VK_6:
			case VK_7:
			case VK_8:
			case VK_9:
				if(CDirectTuneWin_bFirst)  CDirectTuneWin_nRF = 0;
				CDirectTuneWin_nRF = CDirectTuneWin_nRF * 10 + ( key - VK_0);
				
				if(CDirectTuneWin_bTuned)
				{
					CDirectTuneWin_bTuned = false;
					CDirectTuneWin_nRF =  key - VK_0;
				}

				if(CDirectTuneWin_nRF/10 != 0 && DST_GetIndexByRFNumber(CDirectTuneWin_nRF) < 0)
					CDirectTuneWin_nRF =  key - VK_0;

				this->SetTimer(this, 1, 1000);
				CDirectTuneWin_Draw(this);
				break;

			case VK_HYPHEN:
				break;
				
			case VK_OK:
				if(CDirectTuneWin_nRFIndex > (DS_U16)DST_MaxRF()|| CDirectTuneWin_nRFIndex < (DS_U16)DST_MinRF())
					CDirectTuneWin_nRFIndex =  CDirectTuneWin_nRFIndex_Old;
				this->SetTimer(this, 1,10);
				break;
			case VK_CANCEL:
				this->Close(this);
				break;
			default: break;
		}

		CDirectTuneWin_bFirst = false;
		
	}
//};

void DST_CreateDirectTuneWindow(SWinEventMsg event)
{
	if (DST_GetWin(WIN_MAIN_MENU)) return;
	if (DST_GetWin(WIN_FACTORY_MODE)) return;
	if (DST_IsTuneMode == false) return;
	
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor 	= CDirectTuneWin_Destructor;
	pWin->KeyInput 		= CDirectTuneWin_KeyInput;
	pWin->OnMessage		= CDirectTuneWin_OnMessage;
	pWin->OnTimer		= CDirectTuneWin_OnTimer;
	pWin->ShowWindow	= CDirectTuneWin_ShowWindow;
	pWin->Show 			= CDirectTuneWin_Show;
	//  ȣ
	CDirectTuneWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);	

}

