#include "DST_WinManager.h"
#include "DST_OSDImage.h"

DS_U32* DST_UTF82Uni(DS_U8 *utf);

void CFont_CFont(CWindow* this, DS_U8 nSize, OSD_PIXEL_T Color, DS_U8 hor_align, DS_U8 ver_align)
{
	this->FontSetSize(this, nSize);
	this->FontSetColor(this, Color);		//256̻  default : white
	this->FontSetHorAlign(this, hor_align);		//(0: Left, 1: Center, 2: Right)
	this->FontSetVerAlign(this, ver_align);		//(0: Top, 1: Middle, 2: Bottom)
}

void CFont_SetSize(CWindow* this, DS_U8 Size)
{
    if (Size == this->font.nSize)
        return;

	this->font.nSize = Size;
    this->font.dot1_width = DST_GetTextWidth((char*)".", Size);
    this->font.dot2_width = DST_GetTextWidth((char*)"..", Size);
    this->font.dot3_width = DST_GetTextWidth((char*)"...", Size);
}

int CFont_GetDot1Width(CWindow* this)
{
    return this->font.dot1_width;
}

int CFont_GetDot2Width(CWindow* this)
{
    return this->font.dot2_width;
}

int CFont_GetDot3Width(CWindow* this)
{
    return this->font.dot3_width;
}

DS_U8 CFont_GetSize(CWindow* this)
{
	if (this->font.nSize < 5) return 5;
	return this->font.nSize;
}

void CFont_SetColor(CWindow* this, OSD_PIXEL_T nColor)
{
	this->font.Color = nColor;
}

OSD_PIXEL_T CFont_GetColor(CWindow* this)
{
	return this->font.Color;
}

void CFont_SetHorAlign(CWindow* this, DS_U8 hor)
{
	this->font.hor_align = hor;
}

DS_U8 CFont_GetHorAlign(CWindow* this)
{
	switch (this->font.hor_align)
	{
		case ALIGN_LEFT: return ALIGN_LEFT;
		case ALIGN_RIGHT: return ALIGN_RIGHT;
	}
	return ALIGN_CENTER;
}

void CFont_SetVerAlign(CWindow* this, DS_U8 ver)
{
	this->font.ver_align = ver;
}

DS_U8 CFont_GetVerAlign(CWindow* this)
{
	switch (this->font.ver_align)
	{
		case ALIGN_TOP: return ALIGN_TOP;
		case ALIGN_BOTTOM: return ALIGN_BOTTOM;
	}
	return ALIGN_MIDDLE;
}
	
// ڱ ڽ   츦  ݴ´.
void CWin_Close(CWindow* this)
{
	int i = 0;
	for (i = 0; i < WIN_ID_MAX; i++)
	{
		CWindow *pWin = DST_GetWin((WinID)i);
		if (pWin == 0) continue;
		if (pWin->GetParentWinID(pWin) == this->GetWinID(this)) {
		    pWin->Close(pWin);
		}
	}

	this->nWinState = 2;
	this->UpdateScreen(this);
}

void CWin_RegisterAllKey(CWindow* this)
{
	int i = 0;
	for (i = 0; i <= KEY_ID_MAX; i++)
	{
		this->bRegisterKey[i] = true;
		this->nKeyDelay[i] = 0;
		this->nKeyRepeat[i] = 0;
	}
}

void CWin_UnRegisterAllKey(CWindow* this)
{
	int i = 0;
	for (i = 0; i <= KEY_ID_MAX; i++)
	{
		this->bRegisterKey[i] = false;
		this->nKeyDelay[i] = 0;
		this->nKeyRepeat[i] = 0;
	}
}

void CWin_RegisterKey(CWindow* this, DS_U8 nKeyCode, bool bState, int nDelay, int nRepeat)
{
	this->bRegisterKey[nKeyCode] = bState;
	if (nDelay < 10 || nRepeat < 10)
	{
		this->nKeyDelay[nKeyCode] = 0;
		this->nKeyRepeat[nKeyCode] = 0;
	}
	this->nKeyDelay[nKeyCode] = nDelay/10;
	this->nKeyRepeat[nKeyCode] = nRepeat/10;
}

bool CWin_IsRegisterKey(CWindow* this, DS_U8 nKeyCode)
{
	return this->bRegisterKey[nKeyCode];
}

void CWin_SetWinName(CWindow* this, const char* strName)
{
	strcpy(this->strWinName, strName);
}

OSD_PIXEL_T *CWin_GetImgBuff(CWindow* this)
{
	return this->imgBuff;
}

void CWin_SetVisible(CWindow* this, bool bValue)
{
	this->bVisible = bValue;
	this->UpdateScreen(this);
}

void CWin_Move(CWindow* this, int x, int y)
{
	if (this->rect.x == x && this->rect.y == y) return;
	this->UpdateScreen(this);
	this->rect.x = x;
	this->rect.y = y;
	this->UpdateScreen(this);
}

void CWin_UpdateScreen(CWindow* this)
{
	this->UpdateScreenEx(this, 0, 0, this->rect.w, this->rect.h);
}

void CWin_UpdateScreenEx(CWindow* this, int x, int y, int w, int h)
{
	DST_RECT rectTemp;
	rectTemp.x = this->rect.x + x;
	rectTemp.y = this->rect.y + y;
	rectTemp.w = w;
	rectTemp.h = h;
	DST_AddUpdateRegion(rectTemp);
}

void CWin_DrawPixel(CWindow* this, int x, int y, OSD_PIXEL_T color)
{
	if (this->imgBuff == 0) return;
	if (x < 0) return;
	if (y < 0) return;
	if (x > this->rect.w) return;
	if (y > this->rect.h) return;
	*((this->imgBuff) + (y * (this->rect.w)) + x) = color;
}

void CWin_DrawBox32(CWindow* this, int x, int y, int w, int h, OSD_PIXEL_T color)
{
	if (this->imgBuff == 0) return;
	if (w == 0 || h == 0) return;
	OSD_PIXEL_T* des = (this->imgBuff) + ((this->rect.w)*y+x);
	int hh = h;
	while (hh--)
	{
		int ww = w;
		while (ww--) *des++ = color;
		des += ((this->rect.w) - w);
	}
	this->UpdateScreenEx(this, x,y,w,h);
}

//   16Ʈ 32 Ʈ ̹
void CWin_DrawImage4(CWindow* this, int x, int y, DS_U8 *image, bool bProcessTransparent)
{
	DS_U16 nWidth = image[1] * 256 + image[2];
	DS_U16 nHeight = image[3] * 256 + image[4];

	if (x+nWidth > (this->rect.w)) return;
	if (y+nHeight > (this-> rect.h)) return;

	this->UpdateScreenEx(this, x, y, nWidth, nHeight);

	if (bProcessTransparent == true)
	{
		int yy = nHeight;
		OSD_PIXEL_T *tmpSrc = (OSD_PIXEL_T *)& image[8];
		OSD_PIXEL_T *tmpDes = (this->imgBuff) + y * (this->rect.w) + x;
		int nStep = (this->rect.w)-nWidth;
		while (yy--)
		{
			int xx = nWidth;
			while (xx--)
			{
				OSD_PIXEL_T max = (sizeof(OSD_PIXEL_T) == 2) ? 0x0F : 0xFF;
	 			OSD_PIXEL_T sa,sr,sg,sb;
				DST_GetColor(*tmpSrc, &sa, &sr, &sg, &sb);
				OSD_PIXEL_T da,dr,dg,db;
				DST_GetColor(*tmpDes, &da, &dr, &dg, &db);

				if (sa != 0) //  ƴ 츸 ׸.
				{
					if (sa == max || da == 0) // ҽ ̰ų  ΰ
					{
					 	*tmpDes = *tmpSrc;
					}
					else // 
					{
						// http://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending
						OSD_PIXEL_T t = (da * (max-sa) + (max/2)) / max;
						OSD_PIXEL_T a = sa + t;
						if (a > max) a = max;
						OSD_PIXEL_T r = ((sr * sa + dr * t) + (a/2)) / a;
						OSD_PIXEL_T g = ((sg * sa + dg * t) + (a/2)) / a;
						OSD_PIXEL_T b = ((sb * sa + db * t) + (a/2)) / a;
						*tmpDes = DST_SetColor(a, r, g, b);
					}
				}
				tmpSrc++;
				tmpDes++;
			}
			tmpDes += nStep;
		}
	}
	else
	{
		int yy = nHeight;
		OSD_PIXEL_T *tmpSrc = (OSD_PIXEL_T *)& image[image[0]==2? 6:8];
		OSD_PIXEL_T *tmpDes = (this->imgBuff) + y * (this->rect.w) + x;
		while (yy--)
		{
			memcpy(tmpDes, tmpSrc, sizeof(OSD_PIXEL_T) * nWidth);
			tmpSrc += nWidth;
			tmpDes += (this->rect.w);
		}
	}
}

void CWin_DrawImage5(CWindow* this, int x, int y, DS_U8 *image, bool bProcessTransparent)
{
	DS_U16 nWidth = image[1] * 256 + image[2];
	DS_U16 nHeight = image[3] * 256 + image[4];

	if (x+nWidth > (this->rect.w)) return;
	if (y+nHeight > (this->rect.h)) return;

	this->UpdateScreenEx(this, x, y, nWidth, nHeight);
	
	DS_U16 nPallette = image[6] * 256 + image[7];
	DS_U32 *pPallette = (DS_U32*)&image[8];
	//DST_Printf("nPallette = %d\n", nPallette);
	DS_U32* pDes = (DS_U32*)(this->imgBuff) + y * (this->rect.w) + x;
	if (bProcessTransparent == true)
	{
		OSD_PIXEL_T max = (sizeof(OSD_PIXEL_T) == 2) ? 0x0F : 0xFF;
		if (nPallette > 256)
		{
			DS_U16* pSrc = (DS_U16*)&image[8 + nPallette*4];
			int yy = 0;
			for (yy = 0; yy < nHeight; yy++)
			{
				DS_U32* pDes1 = pDes;
				int xx = 0;
				for (xx =0; xx < nWidth; xx++)
				{
					OSD_PIXEL_T c = pPallette[*pSrc];
		 			OSD_PIXEL_T sa,sr,sg,sb;
					DST_GetColor(c, &sa, &sr, &sg, &sb);
					OSD_PIXEL_T da,dr,dg,db;
					DST_GetColor(*pDes1, &da, &dr, &dg, &db);
	
					if (sa != 0) //  ƴ 츸 ׸.
					{
						if (sa == max || da == 0) // ҽ ̰ų  ΰ
						{
						 	*pDes1 = c;
						}
						else // 
						{
							// http://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending
							OSD_PIXEL_T t = (da * (max-sa) + (max/2)) / max;
							OSD_PIXEL_T a = sa + t;
							if (a > max) a = max;
							OSD_PIXEL_T r = ((sr * sa + dr * t) + (a/2)) / a;
							OSD_PIXEL_T g = ((sg * sa + dg * t) + (a/2)) / a;
							OSD_PIXEL_T b = ((sb * sa + db * t) + (a/2)) / a;
							*pDes1 = DST_SetColor(a, r, g, b);
						}
					}
					pSrc++;
					pDes1++;
				}
				pDes += (this->rect.w);
			}
		}
		else if (nPallette > 1)
		{
			DS_U8* pSrc = (DS_U8*)&image[8 + nPallette*4];
			int yy = 0;
			for (yy = 0; yy < nHeight; yy++)
			{
				DS_U32* pDes1 = pDes;
				int xx = 0;
				for (xx =0; xx < nWidth; xx++)
				{
					OSD_PIXEL_T c = pPallette[*pSrc];
		 			OSD_PIXEL_T sa,sr,sg,sb;
					DST_GetColor(c, &sa, &sr, &sg, &sb);
					OSD_PIXEL_T da,dr,dg,db;
					DST_GetColor(*pDes1, &da, &dr, &dg, &db);
	
					if (sa != 0) //  ƴ 츸 ׸.
					{
						if (sa == max || da == 0) // ҽ ̰ų  ΰ
						{
						 	*pDes1 = c;
						}
						else // 
						{
							// http://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending
							OSD_PIXEL_T t = (da * (max-sa) + (max/2)) / max;
							OSD_PIXEL_T a = sa + t;
							if (a > max) a = max;
							OSD_PIXEL_T r = ((sr * sa + dr * t) + (a/2)) / a;
							OSD_PIXEL_T g = ((sg * sa + dg * t) + (a/2)) / a;
							OSD_PIXEL_T b = ((sb * sa + db * t) + (a/2)) / a;
							*pDes1 = DST_SetColor(a, r, g, b);
						}
					}
					pSrc++;
					pDes1++;
				}
				pDes += (this->rect.w);
			}
		}
		else //  
		{
			OSD_PIXEL_T c = pPallette[0];
 			OSD_PIXEL_T sa,sr,sg,sb;
			DST_GetColor(c, &sa, &sr, &sg, &sb);
			int yy = 0;
			for (yy = 0; yy < nHeight; yy++)
			{
				DS_U32* pDes1 = pDes;
				int xx = 0;
				for (xx =0; xx < nWidth; xx++)
				{
					OSD_PIXEL_T da,dr,dg,db;
					DST_GetColor(*pDes1, &da, &dr, &dg, &db);
					if (sa != 0) //  ƴ 츸 ׸.
					{
						if (sa == max || da == 0) // ҽ ̰ų  ΰ
						{
						 	*pDes1 = c;
						}
						else // 
						{
							// http://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending
							OSD_PIXEL_T t = (da * (max-sa) + (max/2)) / max;
							OSD_PIXEL_T a = sa + t;
							if (a > max) a = max;
							OSD_PIXEL_T r = ((sr * sa + dr * t) + (a/2)) / a;
							OSD_PIXEL_T g = ((sg * sa + dg * t) + (a/2)) / a;
							OSD_PIXEL_T b = ((sb * sa + db * t) + (a/2)) / a;
							*pDes1 = DST_SetColor(a, r, g, b);
						}
					}
					pDes1++;
				}
				pDes += (this->rect.w);
			}
		}
	}
	else
	{
		if (nPallette > 256)
		{
			DS_U16* pSrc = (DS_U16*)&image[8 + nPallette*4];
			int yy= 0;
			for (yy = 0; yy < nHeight; yy++)
			{
				DS_U32* pDes1 = pDes;
				int xx = 0;
				for (xx =0; xx < nWidth; xx++)
				{
					*pDes1 = pPallette[*pSrc];
					pSrc++;
					pDes1++;
				}
				pDes += (this->rect.w);
			}
		}
		else if (nPallette > 1)
		{
			DS_U8* pSrc = (DS_U8*)&image[8 + nPallette*4];
			int yy =0;
			for (yy = 0; yy < nHeight; yy++)
			{
				DS_U32* pDes1 = pDes;
				int xx = 0;
				for (xx =0; xx < nWidth; xx++)
				{
					*pDes1 = pPallette[*pSrc];
					pSrc++;
					pDes1++;
				}
				pDes += (this->rect.w);
			}
		}
		else // ȷƮ  1 
		{
			T();
			this->DrawBox32(this, x, y, nWidth, nHeight, pPallette[0]);
		}
	}
}

#if OSD_PIXEL_BPP==16
// 256  ȷƮ  16Ʈ ̹
void CWin_DrawImage6(CWindow* this, int x, int y, DS_U8 *image, bool bProcessTransparent)
{
	DS_U16 nWidth = image[1] * 256 + image[2];
	DS_U16 nHeight = image[3] * 256 + image[4];

	if (x+nWidth > (this->rect.w)) return;
	if (y+nHeight > (this->rect.h)) return;

	this->UpdateScreenEx(this, x, y, nWidth, nHeight);
	
	DS_U16 nPallette = image[5]+1;
	OSD_PIXEL_T *pPallette = (DS_U16*)&image[6];
	//DST_Printf("nPallette = %d\n", nPallette);
	DS_U8* pSrc = (DS_U8*)&image[6 + nPallette*2];
	OSD_PIXEL_T* pDes = (this->imgBuff) + y * (this->rect.w) + x;
	if (bProcessTransparent == true)
	{
		OSD_PIXEL_T max = (sizeof(OSD_PIXEL_T) == 2) ? 0x0F : 0xFF;
		if (nPallette <= 16)
		{
			bool bUpper = true;
			int yy = 0;
			for (yy = 0; yy < nHeight; yy++)
			{
				OSD_PIXEL_T* pDes1 = pDes;
				int xx = 0;
				for (xx =0; xx < nWidth; xx++)
				{
					OSD_PIXEL_T c = 0;
					if (bUpper)
					{
						c = pPallette[(*pSrc>>4)&0x0F];
						bUpper = false;
					}
					else
					{
						c = pPallette[(*pSrc)&0x0F];
						pSrc++;
						bUpper = true;
					}
		 			OSD_PIXEL_T sa,sr,sg,sb;
					DST_GetColor(c, &sa, &sr, &sg, &sb);
					OSD_PIXEL_T da,dr,dg,db;
					DST_GetColor(*pDes1, &da, &dr, &dg, &db);
	
					if (sa != 0) //  ƴ 츸 ׸.
					{
						if (sa == max || da == 0) // ҽ ̰ų  ΰ
						{
						 	*pDes1 = c;
						}
						else // 
						{
							// http://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending
							OSD_PIXEL_T t = (da * (max-sa) + (max/2)) / max;
							OSD_PIXEL_T a = sa + t;
							if (a > max) a = max;
							OSD_PIXEL_T r = ((sr * sa + dr * t) + (a/2)) / a;
							OSD_PIXEL_T g = ((sg * sa + dg * t) + (a/2)) / a;
							OSD_PIXEL_T b = ((sb * sa + db * t) + (a/2)) / a;
							*pDes1 = DST_SetColor(a, r, g, b);
						}
					}
					//pSrc++;
					pDes1++;
				}
				pDes += (this->rect.w);
			}
		}
		else
		{
			int yy=0;
			for (yy = 0; yy < nHeight; yy++)
			{
				OSD_PIXEL_T* pDes1 = pDes;
				int xx = 0;
				for (xx =0; xx < nWidth; xx++)
				{
					OSD_PIXEL_T c = pPallette[*pSrc];
		 			OSD_PIXEL_T sa,sr,sg,sb;
					DST_GetColor(c, &sa, &sr, &sg, &sb);
					OSD_PIXEL_T da,dr,dg,db;
					DST_GetColor(*pDes1, &da, &dr, &dg, &db);
	
					if (sa != 0) //  ƴ 츸 ׸.
					{
						if (sa == max || da == 0) // ҽ ̰ų  ΰ
						{
						 	*pDes1 = c;
						}
						else // 
						{
							// http://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending
							OSD_PIXEL_T t = (da * (max-sa) + (max/2)) / max;
							OSD_PIXEL_T a = sa + t;
							if (a > max) a = max;
							OSD_PIXEL_T r = ((sr * sa + dr * t) + (a/2)) / a;
							OSD_PIXEL_T g = ((sg * sa + dg * t) + (a/2)) / a;
							OSD_PIXEL_T b = ((sb * sa + db * t) + (a/2)) / a;
							*pDes1 = DST_SetColor(a, r, g, b);
						}
					}
					pSrc++;
					pDes1++;
				}
				pDes += (this->rect.w);
			}		
		}
	}
	else
	{
		if (nPallette <= 16)
		{
			bool bUpper = true;
			int yy=0;
			for (yy = 0; yy < nHeight; yy++)
			{
				OSD_PIXEL_T* pDes1 = pDes;
				int xx = 0;
				for (xx =0; xx < nWidth; xx++)
				{
					if (bUpper)
					{
						*pDes1 = pPallette[(*pSrc>>4)&0x0F];
						bUpper = false;
					}
					else
					{
						*pDes1 = pPallette[(*pSrc)&0x0F];
						pSrc++;
						bUpper = true;
					}
					pDes1++;
				}
				pDes += (this->rect.w);
			}
		}
		else
		{
			int yy = 0;
			for (yy = 0; yy < nHeight; yy++)
			{
				OSD_PIXEL_T* pDes1 = pDes;
				int xx = 0;
				for (xx =0; xx < nWidth; xx++)
				{
					*pDes1 = pPallette[*pSrc];
					pSrc++;
					pDes1++;
				}
				pDes += (this->rect.w);
			}
		}
	}
}
#endif

void CWin_DrawImage(CWindow* this, int x, int y, DS_U8 *image, bool bProcessTransparent)
{
	if (image == 0) return;
	if (this->imgBuff == 0) return;
		
	switch (image[0])
	{
		case 2:
		case 4:
			CWin_DrawImage4(this, x,y,image, bProcessTransparent);
			break;
		case 5:
			CWin_DrawImage5(this, x,y,image, bProcessTransparent);
			break;
#if OSD_PIXEL_BPP==16
		case 6: //  16Ʈ ̹
			CWin_DrawImage6(this, x,y,image, bProcessTransparent);
			break;
#endif
		default:
			break;
	}	
}


void CWin_DrawText(CWindow* this, int start_x, int start_y, int width, int height, char *strText, CFont* font)
{
	if (strText == 0) return;
	if (strlen(strText) == 0) return;
	DS_U16* strText16 = (DS_U16*)DST_OS_Malloc((strlen(strText)+1) * sizeof(DS_U16));
	memset(strText16, 0,(strlen(strText)+1) * sizeof(DS_U16));
	unsigned i = 0;
	for (i= 0; i < strlen(strText); i++) strText16[i] = (DS_U16)(DS_U8)strText[i];
	this->DrawTextUni(this, start_x, start_y, width, height, strText16, font);
	DST_OS_Free(&strText16);
}

void CWin_DrawTextUTF8(CWindow* this, int start_x, int start_y, int width, int height, DS_U8* strText, CFont* font)
{
	if (strText == 0) return;
	int nLen = 0;
	int i = 0;
	for (i = 0; i < 4096; i++) // 4096Ϸ ѵ
	{
		if (strText[i] == 0) break;
		nLen++;
	}
//	DST_Printf("nLen = %d\n", nLen);
	if (nLen == 0) return;
	DS_U32 *strText32 = DST_UTF82Uni(strText); // ȣ ʿ ޸ 
	if (strText32 == 0) return;
	this->DrawText32(this, start_x, start_y,width,  height, strText32, font);
	//DST_OS_Free(&strText32);
//	T();
}

void CWin_DrawTextUni(CWindow* this, int start_x, int start_y, int width, int height, DS_U16* strText, CFont* font)
{
	// ڿ ̸ Ѵ.
	if (strText == 0) return;
	int nStrLen = 0;
	int i = 0;
	for (i = 0; i < 4096; i++) // 4096Ϸ ѵ
	{
		if (strText[i] == 0) break;
		nStrLen++;
	}
	if (nStrLen == 0) return;
	DS_U32* strText32 = (DS_U32*)DST_OS_Malloc((nStrLen+1) * sizeof(DS_U32));
	memset(strText32, 0, (nStrLen+1) * sizeof(DS_U32));
	// int i=0;
	for (i = 0; i < nStrLen; i++) strText32[i] = (DS_U32)strText[i];
	this->DrawText32(this, start_x, start_y,width,  height, strText32, font);
	DST_OS_Free(&strText32);
}

void CWin_DrawText32(CWindow* this, int start_x, int start_y, int width, int height, DS_U32* strText, CFont* font)
{
	if (strText == 0) return;
	// ڿ ̸ Ѵ.
	int nStrLen = 0;
	int i = 0;
	for (i = 0; i < 4096; i++) // 4096Ϸ ѵ
	{
		if (strText[i] == 0) break;
		nStrLen++;
	}
	if (nStrLen == 0) return;
	
	if (this->GetImgBuff(this) == 0) return;
	if (width < 1) return;
	if (height < 1) return;
	if (start_x < 0) start_x = 0;
	if (start_y < 0) start_y = 0;
	if (width > this->rect.w) width = this->rect.w;
	if (height > this->rect.h) height = this->rect.h;
	if (start_x + width > this->rect.w) start_x = (this->rect.w)-width;
	if (start_y + height > this->rect.h) start_y = (this->rect.h)-height;

	// ڿ ؽƮ ڽ ũٸ ... ߰Ѵ.
	if (width < this->FontGetDot1Width(this)) return; //   ۾  ʴ´.
	
	static DS_U32 strBuff[4096];
	DS_U16 nBuffLen = 0;
	int iActualStringWidth = DST_GetTextWidth32(strText, nStrLen, this->FontGetSize(this));

	if (width >= iActualStringWidth)
	{
		memcpy(strBuff, strText, nStrLen * sizeof(DS_U32));
		nBuffLen = nStrLen;
	}
	else if (width >= this->FontGetDot3Width(this))
	{
		int i =1;
		for (i = 1; i < nStrLen; i++)
		{
			memcpy(strBuff, strText, i * sizeof(DS_U32));
			strBuff[i] = (DS_U32)'.';
			strBuff[i + 1] = (DS_U32)'.';
			strBuff[i + 2] = (DS_U32)'.';
			nBuffLen = i + 3;
			if (width < DST_GetTextWidth32(strBuff, nBuffLen, this->FontGetSize(this)))
			{
				strBuff[i - 1] = (DS_U32)'.';
				nBuffLen--;
				break;
			}
		}
	}
	else if (this->rect.w >= this->FontGetDot2Width(this))
	{
			strBuff[0] = (DS_U32)'.';
			strBuff[1] = (DS_U32)'.';
			nBuffLen = 2;
	}
	else
	{
			strBuff[0] = (DS_U32)'.';
			nBuffLen = 1;
	}

	int nWidth;

	// Align ó Ѵ.
	if (nBuffLen == nStrLen)
	    nWidth = iActualStringWidth;
	else
    	nWidth = DST_GetTextWidth32(strBuff, nBuffLen, this->FontGetSize(this));

  int nHeight = DST_GetTextHeight(this->FontGetSize(this));

  if (nWidth > width) width = nWidth;
  if (nHeight > height) 
  {
  	start_y = start_y - (nHeight - height) / 2;
  	if (start_y < 0) start_y =0;
  	height = nHeight;
  }
  if (width > this->rect.w) return;
  if (height > this->rect.h) return;
  int x_pos = start_x;
  int y_pos = start_y;
  switch (this->FontGetHorAlign(this))
	{
		case ALIGN_CENTER: x_pos = start_x + (width - nWidth) / 2; break;
		case ALIGN_RIGHT: x_pos = start_x + width - nWidth; break;
	}
	switch (this->FontGetVerAlign(this))
	{
		case ALIGN_MIDDLE: y_pos = start_y + (height - nHeight) / 2; break;
		case ALIGN_BOTTOM: y_pos = start_y + height - nHeight; break;
	}
	// ۾ ׻  
	OSD_PIXEL_T Color = this->FontGetColor(this);
	switch(sizeof(OSD_PIXEL_T))
	{
		case 2:
			Color |= 0xF000;
			break;
		case 4:
			Color |= 0xFF000000; // ۾ ׻  
			break;
	}
	DST_PrintText(this->GetImgBuff(this), this->rect.w, this->rect.h, x_pos, y_pos,
		strBuff, nBuffLen, this->FontGetSize(this), Color);
}

// 
void CWin_CWindow(CWindow* this, SWinEventMsg event)
{
	this->eventInit = event;
	this->rect.x = 0;
	this->rect.y = 0;
	this->rect.w = 0;
	this->rect.h = 0;
	sprintf(this->strWinName, "No name");
	this->UnRegisterAllKey(this);
	this->imgBuff = 0;
	this->bVisible = true;
	this->nWinState = 0;
	this->m_WinIDParent = (WinID)event.data[1];
	int i = 0;
	for (i =0; i < TIMER_ID_MAX; i++)
	{
		this->TimerTickCount[i] = 0;
		this->TimerInterval[i] = 0;
	}
	this->SetTimeOut(this, 100); //  ⺻ ŸӾƿ 30
	this->bTransparentWindow = true;
	this->bFocus = false;
//	SetPallette(DST_GetPallette(1));
	
	this->FontFont(this,  15, DST_COLOR_BLACK, ALIGN_CENTER, ALIGN_MIDDLE); // Ʈ ʱȭ
}

//Ҹ
void CWin_Destructor(CWindow* this)
{
	if (this->imgBuff) DST_OS_Free(&this->imgBuff);
	this->imgBuff = 0;
	this->UpdateScreen(this);
}

void CWin_SetTimeOut(CWindow* this, int nSecond)
{
	this->SetTimer(this, 0, nSecond * 1000);
}

DS_U32 CWin_GetTimeOut(CWindow* this)
{
	if (this->TimerInterval[0] == 0) return 0;
	return this->TimerInterval[0] / DST_OS_GetTicksPerSecond();
}

void CWin_SetTimer(CWindow* this, char nID, int ms)
{
	this->ResetTimer(this, nID);
	if (ms >= 1 && ms <= 9) ms = 10; // 10ms  ð   
	this->TimerInterval[(int)nID] = ms * DST_OS_GetTicksPerSecond()/1000;
}

void CWin_ResetTimer(CWindow* this, char nID)
{
	this->TimerTickCount[(int)nID] = DST_OS_GetTickCount();
}

void CWin_KillTimer(CWindow* this, char nID)
{
	this->TimerTickCount[(int)nID] = 0;
}

bool CWin_ProcessTimer(CWindow* this)
{
	char i = 0;
	for (i =0; i < TIMER_ID_MAX; i++)
	{
		if (i == 0) // ڽ 찡 ִٸ ڱ ڽ ŸӾƿ  ȴ.
		{
			int j=0;
			for (j = 0; j < WIN_ID_MAX; j++)
			{
				CWindow *pWin = DST_GetWin((WinID)j);
				if (pWin == 0) continue;
				if (pWin->GetParentWinID(pWin) != this->GetWinID(this)) continue;
				this->TimerTickCount[0] = DST_OS_GetTickCount();
				break;
			}
		}
		if (this->TimerTickCount[(int)i]== 0) continue;
		if (this->TimerInterval[(int)i]== 0) continue;
		if (DST_OS_GetTickCount() < this->TimerTickCount[(int)i]) this->TimerTickCount[(int)i] = DST_OS_GetTickCount();
		if (this->TimerTickCount[(int)i] + this->TimerInterval[(int)i] > DST_OS_GetTickCount()) continue;
		this->DoOnTimer(this, i);
		return true;
	}
	return false;
}

void CWin_CloseParents(CWindow* this, CWindow* pWin)
{
	CWindow *pWinParent = DST_GetWin(pWin->GetParentWinID(pWin));
	if (pWinParent)
	{
		this->CloseParents(this, pWinParent);
	}
	pWin->Close(pWin);
}

void CWin_DoOnTimer(CWindow* this, char nID)
{
	if (nID == 0) //0 Ÿ̸Ӵ  Ÿ ƿ 뵵 Ѵ.
	{
		this->CloseParents(this, this);
	}
	else
	{
		this->OnTimer(this, nID);
		if (this->TimerTickCount[(int)nID] != 0) // KillTimer  Ÿ̸Ӹ  ʾҴٸ ½Ų.
		{
			this->ResetTimer(this, nID);
		}
	}
}

void CWin_SetParentWinID(CWindow* this, WinID nID)
{
	this->m_WinIDParent = nID;
}

WinID CWin_GetParentWinID(CWindow* this)
{
	return this->m_WinIDParent;
}

WinID CWin_GetWinID(CWindow* this)
{
	return (WinID)(this->eventInit.data[0]);
}

void CWin_DoFocus(CWindow* this, bool bVal)
{
	this->bFocus = bVal;
	this->Focus(this, bVal);
}

void CWin_SetSize(CWindow* this, int x, int y, int w, int h)
{
	this->rect.x = x;
	this->rect.y = y;
	this->rect.w = w;
	this->rect.h = h;
}

int CWin_GetState(CWindow* this)
{
	return this->nWinState;
}

void CWin_SetState(CWindow* this, int n)
{
	this->nWinState = n;
}

void CWin_DoOnMessage(CWindow* this, SWinEventMsg event)
{
	return this->OnMessage(this, event);
}

void CWin_DoShow(CWindow* this)
{
	if (this->rect.w == 0) return;
	if (this->rect.h == 0) return;
	if (this->imgBuff != 0) DST_OS_Free(&this->imgBuff);
	this->imgBuff = (OSD_PIXEL_T*)DST_OS_Malloc(sizeof(OSD_PIXEL_T) * ((this->rect.w) * (this->rect.h)));
	memset(this->imgBuff, 0, (this->rect.w) * (this->rect.h)*sizeof(OSD_PIXEL_T));
	this->bVisible = true;
	this->Show(this);
	this->UpdateScreen(this);
}

bool CWin_GetVisible(CWindow* this)
{
	return this->bVisible;
}

void CWin_FocusToParent(CWindow* this)
{
	this->FocusToChild(this, this->GetParentWinID(this));
}

void CWin_FocusToChild(CWindow* this, WinID nID)
{
	CWindow *pWin = DST_GetWin(nID);
	if (pWin == 0) return;
	this->DoFocus(this, false);
	pWin->DoFocus(pWin, true);
}

void CWin_setFontStyle(CWindow* this, DS_U8 size, DS_U32 color, DS_U8 ver_align, DS_U8 hor_align)
{
	this->FontSetHorAlign(this, hor_align);
	this->FontSetVerAlign(this, ver_align);
	this->FontSetSize(this, size);
	this->FontSetColor(this, CONV32_16(color));
}

void CWin_SetTransparent(CWindow* this, bool bValue)
{
	this->bTransparentWindow = bValue;
}

bool CWin_GetTransparent(CWindow* this)
{
	return this->bTransparentWindow;
}

void CWin_OnMessage(CWindow* this, SWinEventMsg event)
{
	
}

void CWin_Show(CWindow* this)
{
	
}

void CWin_ShowWindow(CWindow* this, WinID id)
{
	
}

	// Hide
void CWin_Hide(CWindow* this, WinID id)
{
	
}

void CWin_Focus(CWindow* this, bool bFocus)
{
	
}

	// ׸
DST_RECT CWin_GetSize(CWindow* this)
{
	return this->rect;
}

DS_U32 CWin_GetKeyDelay(CWindow* this, DS_U8 KeyCode)
{
	return this->nKeyDelay[KeyCode];
}

DS_U32 CWin_GetKeyRepeat(CWindow* this, DS_U8 KeyCode)
{
	return this->nKeyRepeat[KeyCode];
}

void CWin_KeyInput(CWindow* this, DS_U8 key, bool bRepeat)
{
	
}
	
void CWin_OnTimer(CWindow* this, char nID)
{
	
}

// ⺻ 츦 Ѵ.
CWindow* NewCWindow(SWinEventMsg event)
{
	CWindow* pWin= (CWindow *)DST_OS_Calloc(sizeof(CWindow), 1);
	pWin->FontFont = CFont_CFont; 
	pWin->FontSetSize = CFont_SetSize;
	pWin->FontGetDot1Width = CFont_GetDot1Width;
	pWin->FontGetDot2Width = CFont_GetDot2Width;
	pWin->FontGetDot3Width = CFont_GetDot3Width;
	pWin->FontGetSize = CFont_GetSize;
	pWin->FontSetColor = CFont_SetColor;
	pWin->FontGetColor = CFont_GetColor;
	pWin->FontSetHorAlign = CFont_SetHorAlign;
	pWin->FontGetHorAlign = CFont_GetHorAlign;
	pWin->FontSetVerAlign = CFont_SetVerAlign;
	pWin->FontGetVerAlign = CFont_GetVerAlign;
	
	pWin->Constructor = CWin_CWindow;
//	pWin->Destructor = CWin_Destructor;  // CWindow ڽ  Ҹ
	pWin->DestructorMother = CWin_Destructor; // CWindow  Ҹ 
	pWin->SetParentWinID = CWin_SetParentWinID;
	pWin->GetParentWinID = CWin_GetParentWinID;
	pWin->GetWinID = CWin_GetWinID;
	pWin->SetSize = CWin_SetSize;
	pWin->GetState = CWin_GetState;
	pWin->SetState = CWin_SetState;
	pWin->SetWinName = CWin_SetWinName;
	pWin->SetTransparent = CWin_SetTransparent;
	pWin->GetTransparent = CWin_GetTransparent;
	pWin->DoOnMessage = CWin_DoOnMessage;
	pWin->OnMessage = CWin_OnMessage;
	pWin->DoShow = CWin_DoShow;
	pWin->Show = CWin_Show;
	pWin->ShowWindow = CWin_ShowWindow;
	pWin->Hide = CWin_Hide;
	pWin->Close = CWin_Close;
	pWin->CloseParents = CWin_CloseParents;
	pWin->SetVisible = CWin_SetVisible;
	pWin->GetVisible = CWin_GetVisible;
	pWin->Move = CWin_Move;
	pWin->FocusToParent = CWin_FocusToParent;
	pWin->FocusToChild = CWin_FocusToChild;
	pWin->DoFocus = CWin_DoFocus;
	pWin->Focus = CWin_Focus;
	pWin->GetSize = CWin_GetSize;
	pWin->GetImgBuff = CWin_GetImgBuff;
	pWin->UpdateScreen = CWin_UpdateScreen;
	pWin->UpdateScreenEx = CWin_UpdateScreenEx;
	pWin->DrawPixel = CWin_DrawPixel;
	pWin->DrawBox32 = CWin_DrawBox32;
	pWin->DrawImage = CWin_DrawImage;
//	pWin->DrawImage4 = CWin_DrawImage4;
//	pWin->DrawImage5 = CWin_DrawImage5;
//	pWin->DrawImage6 = CWin_DrawImage6;
	pWin->setFontStyle = CWin_setFontStyle;
	pWin->DrawText = CWin_DrawText;
	pWin->DrawTextUTF8 = CWin_DrawTextUTF8;
	pWin->DrawTextUni = CWin_DrawTextUni;
	pWin->DrawText32 = CWin_DrawText32;
	pWin->RegisterAllKey = CWin_RegisterAllKey;
	pWin->UnRegisterAllKey = CWin_UnRegisterAllKey;
//	pWin->RegisterAllNumKey = CWin_RegisterAllNumKey;
//	pWin->UnRegisterAllNumKey = CWin_UnRegisterAllNumKey;
	pWin->RegisterKey = CWin_RegisterKey;
	pWin->IsRegisterKey = CWin_IsRegisterKey;
	pWin->GetKeyDelay = CWin_GetKeyDelay;
	pWin->GetKeyRepeat = CWin_GetKeyRepeat;
	pWin->KeyInput = CWin_KeyInput;
	pWin->SetTimeOut = CWin_SetTimeOut;
	pWin->GetTimeOut = CWin_GetTimeOut;
	pWin->SetTimer = CWin_SetTimer;
	pWin->ResetTimer = CWin_ResetTimer;
	pWin->KillTimer = CWin_KillTimer;
	pWin->ProcessTimer = CWin_ProcessTimer;
	pWin->DoOnTimer = CWin_DoOnTimer;
	pWin->OnTimer = CWin_OnTimer; 
	
	//  ȣ
	pWin->Constructor(pWin, event);
	return pWin;
}

// Ҹ ȣ
void DeleteCWindow(CWindow*pWin)
{
	if (pWin == 0) return;
	if (pWin->Destructor) pWin->Destructor(pWin);
	if (pWin->DestructorMother) pWin->DestructorMother(pWin);
	DST_OS_Free(&pWin);
}
