/********************************************************************
* makeSymTbl.c
*  - symbol.txt -> DMW_SymTbl.c
*
*  Copyright (c)2004 Digital STREAM Tech, Inc.
*  All Rights Reserved
*
*  $Id: makeSymTbl.c,v 1.1 2011/07/08 03:12:19 megakiss Exp $
*
*********************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
/* symbol types */
#define SYM_UNDF        0x0     /* undefined */
#define SYM_LOCAL       0x0     /* local */
#define SYM_GLOBAL      0x1     /* global (external) (ORed) */
#define SYM_ABS         0x2     /* absolute */
#define SYM_TEXT        0x4     /* text */
#define SYM_DATA        0x6     /* data */
#define SYM_BSS         0x8     /* bss */
#define SYM_COMM        0x12    /* common symbol */

#define MAX_EXCEPT_LIST 10000
static char exclude_list[MAX_EXCEPT_LIST][256];

static char* GetExceptionFileName(char* strFileName)
{
	char strBuff[1024];
	int i = strlen(strFileName);
	static char strExceptionFileName[1024];

	sprintf(strBuff, "%s", strFileName);
	for (; i >= 0; i--)
	{
		if (strBuff[i] == '/') break;
		strBuff[i] = 0;
	}
	sprintf(strExceptionFileName, "%s" "exclude_list.txt", strBuff);
	return strExceptionFileName;
}

const char * ConvertSymType(char * type)
{
	switch (type[0])
	{
		case 'T':
			return "SYM_GLOBAL|SYM_TEXT";
		case 'D':
			return "SYM_GLOBAL|SYM_DATA";
		case 'A':
			return "SYM_GLOBAL|SYM_ABS";
		case 'B':
			return "SYM_GLOBAL|SYM_BSS";
		case 'C':
			return "SYM_GLOBAL|SYM_COMM";
	}
	return "SYM_UNDF";
}

int get_line_num_of_file(FILE *fp)
{
	int c;
	long cnt=0;
	while ((c=getc(fp))!=EOF) if (c=='\n') cnt++;
	rewind(fp);
	printf("%ld lines\n",cnt);
	return cnt;
}

int make_header(FILE *out_fp)
{
//	fprintf(out_fp,"/********************************************************************\n");
//	fprintf(out_fp,"* DMW_SymTbl.c\n");
//	fprintf(out_fp,"*  - This file is automatically generated at compile time.\n");
//	fprintf(out_fp,"*    Do not Edit manually!!!\n");
//	fprintf(out_fp,"*\n");
//	fprintf(out_fp,"*  Copyright (c)2004 Digital STREAM Tech, Inc.\n");
//	fprintf(out_fp,"*  All Rights Reserved\n");
//	fprintf(out_fp,"*\n");
//	fprintf(out_fp,"*  $Id: makeSymTbl.c,v 1.1 2011/07/08 03:12:19 megakiss Exp $\n");
//	fprintf(out_fp,"*\n");
//	fprintf(out_fp,"*********************************************************************/\n");
//	fprintf(out_fp,"\n\n");
	fprintf(out_fp,"#include \"DMW_SymTbl.h\"\n");
	return 0;
}

int make_tail(FILE *out_fp)
{
	fprintf(out_fp,"\n\n");
//	fprintf(out_fp,"/*************************************************************\n");
//	fprintf(out_fp,"*************************************************************/\n");
	return 0;

}
int check_inlucde_dot_in_symbol(char *string)
{
	int ret=0;
	register char *s,*t;
	s=string;
	if(*s==0)
		return 0;
	t=s+strlen(s) -1;
	while(t>s){
		if((*t)=='.'||(*t)=='~'){
			ret=1;
		//	printf("[INFO] found . string=%s\n",string);
		   	break;
		}
		t--;
	}
	return ret;
}
//string is input/output
void get_demangle_symbol(char *string)
{
	register char *s,*t;
	s=string;
	if(*s==0)
		return ;
	t=s+strlen(s)-1;
	while(t>s){
		if((*t)==':'){
			(*t)='_';
		}
		if((*t)=='('){
			(*t)='\0';
		}
		t--;
	}
	return ;
//	return s;
}

int main(int argc, char *argv[])
{
	printf("%d", argc);
	FILE *out_fp;
	FILE *in_fp;
	char address[200],type[2],symbolname[200];
	char *symbol;
	int line_num;
	int tem_line_num;
	int i, k, flag;

	int exclude_list_count = 0;
	FILE *exclude_fp;

	in_fp=fopen(argv[1]/*IN_NM_FILE_NAME*/,"r");
	out_fp=fopen(argv[2]/*(OUT_SYMBOL_TABLE_FILE_NAME*/,"w");
	if(in_fp==NULL){
		printf("[Error] Can't open  symbol input file \n");
		return -1;
	}
	if(out_fp==NULL){
		printf("[Error] Can't open symbol output file \n");
		return -1;
	}

	make_header(out_fp);


	//  Ʈ Ѵ.
	exclude_fp = fopen(GetExceptionFileName(argv[0]), "rt");
	while (1)
	{
		if (fscanf(exclude_fp, "%s", exclude_list[exclude_list_count]) < 1) break;
		exclude_list_count++;
		if (exclude_list_count >= MAX_EXCEPT_LIST) break;
	}
	fclose(exclude_fp);
	printf("found %d exclude lists\n", exclude_list_count);
	//⿡  .
	line_num=get_line_num_of_file(in_fp);
	tem_line_num=line_num;

	for(i=0;i<line_num;i++){
		fscanf(in_fp,"%s %s %s",address,type,symbolname);
		flag = 0;
#ifdef USE_CYGWIN
        symbol = &symbolname[1];
#else
        symbol = symbolname;
#endif

		// ڿȿ __ ̳ $$ ִٸ 
		// 2010.6.24 megakiss
		{
			int nloop = 0;
			if (symbol[nloop] == '_') flag = 1;
			if (symbol[nloop] == 'p'&& symbol[nloop+1] == 'z' && symbol[nloop+2] == '_') flag = 1;
			if (symbol[nloop] == 'F'&& symbol[nloop+1] == 'C' && symbol[nloop+2] == '_') flag = 1;
			if (symbol[nloop] == 'F'&& symbol[nloop+1] == 'T' && symbol[nloop+2] == '_') flag = 1;
			for (nloop =0; nloop < strlen(symbol) - 1; nloop++)
			{
				if (symbol[nloop] == '@') flag = 1;
				if (symbol[nloop] == '_' && symbol[nloop+1] == '_') flag = 1;
				if (symbol[nloop] == '$' && symbol[nloop+1] == '$') flag = 1;
				if (symbol[nloop] == '3'&& symbol[nloop+1] == '2' && symbol[nloop+2] == '0') flag = 1;
				if (flag == 1) break;
			}
			if (flag)
			{
				printf("%s removed\n", symbol);
			}
			else
			{
				//printf("%s pass\n", symbol);
			}
			if (flag) continue;
		}

		for (k=0; k < exclude_list_count; k++) {
			if ( strcmp(symbol, exclude_list[k]) == 0 ) {
				flag = 1;
				break;
			}
		}
		if ( flag )
			continue;

		//fprintf(out_fp,"extern %s;\n",symbol);
		if(!check_inlucde_dot_in_symbol(symbol)){
			fprintf(out_fp,"extern int %s;\n",symbol);
		}
	}
  	rewind(in_fp);

	fprintf(out_fp,"DMW_SYMBOL_T DMW_SymbolTbl[]={\n");
	for(i=0;i<line_num;i++){
		fscanf(in_fp,"%s %s %s",address,type,symbolname);
		flag = 0;
#ifdef USE_CYGWIN
        symbol = &symbolname[1];
#else
        symbol = symbolname;
#endif

		// ڿȿ __ ̳ $$ ִٸ 
		// 2010.6.24 megakiss
		{
			int nloop = 0;
			if (symbol[nloop] == '_') flag = 1;
			if (symbol[nloop] == 'p'&& symbol[nloop+1] == 'z' && symbol[nloop+2] == '_') flag = 1;
			if (symbol[nloop] == 'F'&& symbol[nloop+1] == 'C' && symbol[nloop+2] == '_') flag = 1;
			if (symbol[nloop] == 'F'&& symbol[nloop+1] == 'T' && symbol[nloop+2] == '_') flag = 1;
			for (nloop =0; nloop < strlen(symbol) - 1; nloop++)
			{
				if (symbol[nloop] == '@') flag = 1;
				if (symbol[nloop] == '_' && symbol[nloop+1] == '_') flag = 1;
				if (symbol[nloop] == '$' && symbol[nloop+1] == '$') flag = 1;
				if (symbol[nloop] == '3'&& symbol[nloop+1] == '2' && symbol[nloop+2] == '0') flag = 1;
				if (flag == 1) break;
			}
			if (flag)
			{
				printf("%s removed\n", symbol);
			}
			else
			{
				//printf("%s pass\n", symbol);
			}
			if (flag) continue;
		}

		for (k=0; k < exclude_list_count; k++) {
			if ( strcmp(symbol, exclude_list[k]) == 0 ) {
				flag = 1;
				break;
			}
		}
		if ( flag )
			continue;

		if(check_inlucde_dot_in_symbol(symbol)){
			if(tem_line_num>0)
				tem_line_num--;
		}else{
			fprintf(out_fp,"\t{\"%s\", (char*) &%s , %s},\n",symbol,symbol,ConvertSymType(type));
		}
	}
	//  ڸ ־ش.
	line_num +=1; //null
	line_num = line_num -tem_line_num;
	fprintf(out_fp,"\t{(char*) 0, (char*) 0, 0},\n");
	fprintf(out_fp,"};\n");
	fprintf(out_fp,"unsigned int DMW_SymbolTblSize = %d;\n\n",line_num);
	make_tail(out_fp);

	fclose(in_fp);
	fclose(out_fp);
	return 0;
}
/*************************************************************
*Change Logs:
*	$Log: makeSymTbl.c,v $
*	Revision 1.1  2011/07/08 03:12:19  megakiss
*	*** empty log message ***
*	
*	Revision 1.4.4.5  2010/08/30 23:55:02  megakiss
*	*** empty log message ***
*	
*	Revision 1.4.4.4  2010/06/29 05:03:11  megakiss
*	*** empty log message ***
*
*	Revision 1.4.4.3  2010/06/24 01:52:53  megakiss
*	*** empty log message ***
*
*	Revision 1.4.4.2  2010/03/18 08:28:06  megakiss
*	*** empty log message ***
*
*	Revision 1.4.4.1  2010/03/18 06:41:20  megakiss
*	*** empty log message ***
*
*	Revision 1.4  2009/07/07 08:13:19  kjkam
*	- ADS   
*
*	Revision 1.3  2009/03/11 23:01:32  hwatk
*	Cygwin main()  segmentation fault  
*	   --> "__xxx symbol export ."
*
*	Revision 1.2  2009/02/23 06:43:59  hwatk
*	libc ߰ø  makeSymTbl .
*
*	Revision 1.1.1.1  2009/01/15 08:04:43  hwatk
*	BASE DSTMW Initial
*
*	Revision 1.1  2007/02/23 14:01:10  hwatk
*	V0_10
*
*	Revision 1.3  2006/08/04 11:55:20  hwatk
*	MW
*	   - Autoscan ߿ VCT/PAT/PMT ÿ ޴  . (DMW_USE_CHANNEL_TABLES)
*	   - QAM Autodetection . (USE_QAM_AUTODETECTION)
*	   - Analog Autoscan Full Search ϵ .
*	   - Autoscan  Cancel  ǵ . (DMW_SCAN_USE_CANCEL)
*
*	Revision 1.2  2006/02/14 05:48:37  hwatk
*	*** empty log message ***
*
*	Revision 1.1  2005/12/30 02:01:17  leon
*	 - position change
*
*	Revision 1.1  2005/12/21 00:43:31  megakiss
*	*** empty log message ***
*
*	Revision 1.3  2005/07/15 01:13:18  megakiss
*	2005 7 15
*
*	EA  - ׽Ʈ ʿ
*	ڱȫ  ݿ - ڼ   ʿ
*	  ޽ 
*
*	Revision 1.4  2005/02/17 07:29:13  megakiss
*	  ޽ 
*
*	Revision 1.3  2004/11/26 01:45:09  yzyeo
*	fix array size bug
*
*	Revision 1.2  2004/10/26 00:07:39  leon
*	- standalone  target shell ߰  fix.
*
*	Revision 1.4  2004/10/23 09:35:24  hwatk
*	Do not add exit, abort symbol.
*
*	Revision 1.3  2004/08/17 18:01:52  leon
*	- c++ (SABIN-app)
*
*	Revision 1.2  2004/08/16 07:55:37  leon
*	-add comment
*
*
*************************************************************/

