#define _MODEL_NAME_ "Newcon3Kr"
#ifdef _GET_SW_VERSION_
// 1000 ڸ 
//  100 ڸ ̳
//    10 1 ڸ ġ
// 1.0.0   1000
// 1.1.1   1101
#define _SW_VERSION_ (0900)
#include <stdio.h>
int main(int argc, char* argv[])
{
	if (argc > 1)
	{
		printf("%s\n",  _MODEL_NAME_);
	}
	else
	{
		printf("%d\n",  _SW_VERSION_);
	}
	return 0;
}
#else // _GET_SW_VERSION_
#include "DST_HostInterface.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"
#include "DST_WinManagerTask.h"
#include "DST_WinManager.h"
#include "DST_UserInterface.h"
#include "DST_DB.h"
#include "DST_DB_Engine.h"

void DST_CCManagerInit(void);
void DST_LoadFlash(DS_U8 Version);
void DST_SimpleTask(void);

// new delete overloading
//void* operator new (size_t size) { return DST_OS_Malloc(size); }
//void* operator new[ ] (size_t size) { return DST_OS_Malloc(size); }
//void operator delete (void* p) { DST_OS_Free(&p); }
//void operator delete[ ] (void* p) {	DST_OS_Free(&p); }

const char *DST_GetVendorInfo(void)
{
	return "DST";
}

const char *DST_GetModelName(void)
{
	return _MODEL_NAME_;
}

static char strVersionText[16] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
char* DST_GetAppShortVersion()
{
	if (strlen(strVersionText) == 0)
	{
		sprintf(strVersionText, "%d.%d.%d", _SW_VERSION_/1000, (_SW_VERSION_%1000)/100, (_SW_VERSION_%1000)%100);
	}
	return strVersionText;
}

int DST_GetAppShortVersionNumber()
{
	return _SW_VERSION_;
}

/*extern "C" */void Print_All_MemUnit(void);
void CT_ChMapUpdate(void);

/*extern "C" */void ram_start()
{
#ifndef DSTAR
	m_report();
#endif
	DHL_SYS_Initialize(); // Flash ޸   DST_DB_Open  ȣؾ 
	DST_Printf("\n");
	DST_Printf("--------------------------------------------------\n");
	DST_Printf("           Model : %s\n", DST_GetModelName());
	DST_Printf("           SW Version : %s \n", DST_GetAppShortVersion());
	DST_Printf("           Compile Time : %s %s\n", __DATE__, __TIME__);
	DST_Printf("           Vendor Info: %s \n", DST_GetVendorInfo());
#if DESIGN_TYPE == 1
	DST_Printf("           DESIGN_TYPE : BLACK\n");
#else
	DST_Printf("           DESIGN_TYPE : BLUE\n");
#endif
	DST_Printf("--------------------------------------------------\n");
	DST_Printf("\n");
	DST_DB_Open();
	if (DST_EEPROM_GetNeedReset() == 1) 
	{
		DST_Factory_Reset();
	}
	CT_ChMapUpdate();
	DHL_INFO_SetLastPowerState(true);
	DST_UI_SetCh34(DST_UI_GetCh34()); // TV/CVBS  
	DST_WinManagerInit(); //  ޴ ʱȭ
	DST_DB_TuneFirstChannel();
	DST_SimpleTask();
	DST_CCManagerInit();
	DST_UI_SetVolume(DST_EEPROM_GetVolume());
	while (1)
	{
		DST_OS_Delay(5000);
		DS_U32 hour = 0, min = 0, sec = 0;
		DST_OS_GetRunTime(&hour, &min, &sec);
		DST_Printf("Current Time = %02d:%02d:%02d\n", (int)hour, (int)min, (int)sec);
//		DST_OS_PrintMemUnit();
#ifndef DSTAR
		// m_report();
#endif
	}
}

#ifdef DSTAR
int main()
{
	ram_start();
	return 0;
}
#endif

#endif // _GET_SW_VERSION_
