/*
	DHL_SYS_Impl.h
*/


#ifndef __DHL_SYS_IMPL_H__
#define __DHL_SYS_IMPL_H__

#include "DHL_Types.h"
#include "DHL_SYS.h"


//------------------------------------------
//  GPIO list. 
//
/*
	00: shared with UART RX
	01: shared with UART TX

	03: LED green. (cannot control RED color)
	
	04: channel down button
	05: channel up button
	
	//06: menu button
	//07: select button

	08: audio mute (dst own)
	
	11: ch 3/4 switch select

	29: loop-through or ch 3/4 out
	30: flash write protect (active low)
	
	14~25: used as boot strap pins.

	note:
		power button is directly connected to Wake-up module.
		LED control


BKTODO: DHL_SYS_Config.h  ǿ ؼ ϳ  .
*/

#define GPIO_LED_GREEN 		9
#define GPIO_LED_RED			4
#define GPIO_CH_DN   			5
#define GPIO_CH_UP   			6
#define GPIO_AUDIO_MUTE 	118  /* 0: mute audio. 1: unmute.  default is mute by pull down. */
#define GPIO_CH34_SW_IN   11  /* 0: ch3, 1: ch4  ==> BKTODO: NVM ű (޴  Է ؼ ó)*/
#define GPIO_PATH_CONTROL 29  /* 0: loop-through, 1: CH 3/4. default is pull-down.  BKTODO: */
#define GPIO_FLASH_WP  30  /* flash write protect. default is pull-down. */


//------------------------------------------
//  GPIO config flags..

// I/O direction
#define DHL_GPIO_OUTPUT  0x0
#define DHL_GPIO_INPUT   0x1
#define DHL_GPIO_IO_MASK 0x1

// interrupt. if not set, interrupt is disabled.
#define DHL_GPIO_RISING_EDGE 0x10
#define DHL_GPIO_FALLING_EDGE 0x20
#define DHL_GPIO_BOTH_EDGE 0x30
#define DHL_GPIO_EDGE_MASK 0x30



//------------------------------------------
//  callback type and it's state param

#define eDHL_SYS_CB_POWER (eDHL_SYS_CB_BUTTON+33) // 33 is beyond gpio number. it is safe.
	// state:
	//  no meaning. it notifies that power button is just pressed.
	
#define eDHL_SYS_CB_CHUP  (eDHL_SYS_CB_BUTTON+GPIO_CH_UP)
#define eDHL_SYS_CB_CHDN  (eDHL_SYS_CB_BUTTON+GPIO_CH_DN)
	// state: 
	// 0: it is first key.
	// 1: it is repeat key.

#define eDHL_SYS_CB_RFM   (eDHL_SYS_CB_SWITCH+0)
	// state: 
	// value of gpio GPIO_CH34_SW_IN



//------------------------------------------

#define DHL_BOOTCMD_MAGIC  0xB64925DA

#define DHL_BOOTCMD_DOWNLOAD  0x1
	// parameter: none
	// meaning: go into download mode

#define DHL_BOOTCMD_FUPDATE 0x2
	// parameter: none
	// meaning: go into flash update mode


//------------------------------------------


//void dhl_sys_gpio_config(UINT32 num, UINT32 flag, int value);

int dhl_sys_gpio_rw(UINT32 num, int bData, BOOL bWrite);

//void dhl_sys_set_red_led(int bOn);

int dhl_sys_read_power_btn(void);


void dhl_sys_reset(int boot_cmd);

void dhl_sys_standby(void);


UINT32 dhl_sys_get_clock_freq(int type);

UINT32 dhl_sys_get_cpu_tick(void);

UINT32 dhl_sys_cpu_ticks_per_ms(void);

#define dhl_sys_cpu_tick_gap_ms(tick_new, tick_old) \
	(((tick_new) - (tick_old)) / dhl_sys_cpu_ticks_per_ms())


// cafrii comment!
// this api should be used with care!!
UINT32 dhl_sys_get_ms_tick(void);


void dhl_sys_config_vdac(BOOL bEnable);

void dhl_sys_enable_watchdog(BOOL bEnable, UINT32 period);

void dhl_sys_register_callback(void (*cb)(int type, UINT32, UINT32), UINT32 userparam);
void dhl_sys_notify_callback(int type, UINT32 state);

void dhl_sys_init(void);

#if 0 // Remocin Test
void dhl_sys_delay562_5us(int nCount);
#endif 

#endif /* __DHL_SYS_IMPL_H__ */


