#define _MODEL_NAME_ "Newcon3Kr"
#ifdef _GET_SW_VERSION_
// 1000 ڸ 
//  100 ڸ ̳
//    10 1 ڸ ġ
// 1.0.0   1000
// 1.1.1   1101
#define _SW_VERSION_ (1000)
#include <stdio.h>
int main(int argc, char* argv[])
{
	if (argc > 1)
	{
		printf("%s\n",  _MODEL_NAME_);
	}
	else
	{
		printf("%d\n",  _SW_VERSION_);
	}
	return 0;
}
#else // _GET_SW_VERSION_
#include "DST_nec_ir_sender.h"

void DST_CCManagerInit(void);
void DST_LoadFlash(DS_U8 Version);
//void DST_SimpleTask(void);

// new delete overloading
//void* operator new (size_t size) { return DST_OS_Malloc(size); }
//void* operator new[ ] (size_t size) { return DST_OS_Malloc(size); }
//void operator delete (void* p) { DST_OS_Free(&p); }
//void operator delete[ ] (void* p) {	DST_OS_Free(&p); }

const char *DST_GetVendorInfo(void)
{
	return "DST";
}

const char *DST_GetModelName(void)
{
	return _MODEL_NAME_;
}

static char strVersionText[16] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
char* DST_GetAppShortVersion()
{
	if (strlen(strVersionText) == 0)
	{
		sprintf(strVersionText, "%d.%d.%d", _SW_VERSION_/1000, (_SW_VERSION_%1000)/100, (_SW_VERSION_%1000)%100);
	}
	return strVersionText;
}

int DST_GetAppShortVersionNumber()
{
	return _SW_VERSION_;
}

static unsigned int g_ir_code = 0;
static void IRCallback(unsigned int code, unsigned int repeat)
{
	int i = 0;
	unsigned int _code = 0;
	for (i = 0; i < 32; i++) // Ʈ 
	{
		_code |= ((code >> i) & 0x1) << (31-i);
	}
	g_ir_code = _code;
	unsigned int g_ir_repeat = (repeat == 85) ? 0 : 1;	
	DST_Printf("g_ir_code = 0x%X\n", g_ir_code);
}

static void SaveFlash(DS_U8* flash, unsigned int ir_code, unsigned int duration)
{
	memset(flash, 0, 16);
	flash[0] = 0xCA;
	flash[1] = 0xFE;
	flash[2] = 0xBA;
	flash[3] = 0xBE;
	flash[4] = 0x00;
	flash[5] = (ir_code >> 24) & 0xFF;
	flash[6] = (ir_code >> 16) & 0xFF;
	flash[7] = (ir_code >> 8) & 0xFF;
	flash[8] = (ir_code >> 0) & 0xFF;
	flash[9] = duration & 0xFF;
	DHL_Flash_Write(FLASH_CH_MAP_POS, 16, flash);
	DST_Printf("SaveFlash ir_code = 0x%X    duration = %d\n", ir_code, duration);
}
/*extern "C" */void Print_All_MemUnit(void);
void CT_ChMapUpdate(void);

/*extern "C" */void ram_start()
{
#ifndef DSTAR
	m_report();
#endif
	DHL_SYS_Initialize(); // Flash ޸   DST_DB_Open  ȣؾ 
	DST_Printf("\n");
	DST_Printf("--------------------------------------------------\n");
	DST_Printf("           Model : %s\n", DST_GetModelName());
	DST_Printf("           SW Version : %s \n", DST_GetAppShortVersion());
	DST_Printf("           Compile Time : %s %s\n", __DATE__, __TIME__);
	DST_Printf("           Vendor Info: %s \n", DST_GetVendorInfo());
#if DESIGN_TYPE == 1
	DST_Printf("           DESIGN_TYPE : BLACK\n");
#else
	DST_Printf("           DESIGN_TYPE : BLUE\n");
#endif
	DST_Printf("--------------------------------------------------\n");
	DST_Printf("\n");
//	DST_DB_Open();
//	if (DST_EEPROM_GetNeedReset() == 1)
//	{
//		DST_Factory_Reset();
//	}
//	CT_ChMapUpdate();
//	DHL_INFO_SetLastPowerState(true);
//	DST_UI_SetCh34(DST_UI_GetCh34()); // TV/CVBS  
//	DST_WinManagerInit(); //  ޴ ʱȭ
//	DST_DB_TuneFirstChannel();
//	DST_SimpleTask();
//	DST_CCManagerInit();
//	DST_UI_SetVolume(DST_EEPROM_GetVolume());
	IR_Open(IRCallback);
	unsigned int ir_code = 0xFC030820;
	unsigned int duration = 3;
	
	DS_U8* flash = DHL_Flash_Read(FLASH_CH_MAP_POS, 16);
	if (flash[0] == 0xCA && flash[1] == 0xFE && flash[2] == 0xBA && flash[3] == 0xBE && flash[4] == 0x00)
	{
		ir_code = flash[5] * 0x1000000 + flash[6] * 0x10000 + flash[7] * 0x100 + flash[8];
		duration = flash[9];
		DST_Printf("FLASH READ ir_code = 0x%X    duration = %d\n", ir_code, duration);
	}
	else
	{
		DST_Printf("FLASH READ FAIL!! . SAVE DEFAULT VALUE ir_code = 0x%X    duration = %d\n", ir_code, duration);
		SaveFlash(flash, ir_code, duration);
	}
	
	unsigned int loop_count = 0;
	while (1)
	{
		DST_OS_Delay(10);
		if (g_ir_code == 0xFF003411) // POWER KEYPAD
		{
			g_ir_code = 0;
			int i = 0;
			for (i=0; i < 500; i++) // 5  Ű н
			{
				DST_OS_Delay(10);
				if (g_ir_code == 0xFF003411) g_ir_code = 0; // POWER
				if (g_ir_code == 0xF7083411) g_ir_code = 0; // CH+
				if (g_ir_code == 0xF6093411) g_ir_code = 0; // CH-
				if (g_ir_code == 0) continue;
				ir_code = g_ir_code;
				DST_Printf("ir_code = 0x%X\n", ir_code);
				// FLASH  
				g_ir_code = 0;
				SaveFlash(flash, ir_code, duration);
				break;
			}
			continue;
		}
		if (g_ir_code == 0xF7083411) // CH+
		{
			duration++;
			if (duration > 15) duration = 15;
			DST_Printf("duration = %d\n", duration);
			g_ir_code = 0;
			SaveFlash(flash, ir_code, duration);
		}
		if (g_ir_code == 0xF6093411) // CH-
		{
			duration--;
			if (duration < 1) duration = 1;
			DST_Printf("duration = %d\n", duration);	
			g_ir_code  = 0;
			SaveFlash(flash, ir_code, duration);
		}
		if (duration > 15) duration = 15;
		if (duration < 1) duration = 1;	
		g_ir_code = 0;
		//DS_U32 hour = 0, min = 0, sec = 0;
		//DST_OS_GetRunTime(&hour, &min, &sec);
		//DST_Printf("Current Time = %02d:%02d:%02d\n", (int)hour, (int)min, (int)sec);
		//		DST_OS_PrintMemUnit();
 		//ir_code = 0xFC030820;
 		if (loop_count == 0) 
 		{
 			DST_NEC_IR_Send(ir_code & 0xFF, (ir_code >>8) & 0xFF, (ir_code>>16) & 0xFF); // CMB  Mute Ű
 			
 			DS_U32 hour = 0, min = 0, sec = 0;
 			DST_OS_GetRunTime(&hour, &min, &sec);
 			DST_Printf("Current Time = %02d:%02d:%02d\n", (int)hour, (int)min, (int)sec);
 		}
 		loop_count++;
 	 	if (loop_count > duration * 100) loop_count = 0;
#ifndef DSTAR
		// m_report();
#endif
	}
}

#ifdef DSTAR
int main()
{
	ram_start();
	return 0;
}
#endif

#endif // _GET_SW_VERSION_
